/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resources used to host your game servers. A compute resource can be managed Amazon GameLift Amazon EC2 instances or
 * your own resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Compute implements SdkPojo, Serializable, ToCopyableBuilder<Compute.Builder, Compute> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(Compute::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(Compute::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> COMPUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeName").getter(getter(Compute::computeName)).setter(setter(Builder::computeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeName").build()).build();

    private static final SdkField<String> COMPUTE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeArn").getter(getter(Compute::computeArn)).setter(setter(Builder::computeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeArn").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(Compute::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsName").getter(getter(Compute::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()).build();

    private static final SdkField<String> COMPUTE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeStatus").getter(getter(Compute::computeStatusAsString)).setter(setter(Builder::computeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatus").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(Compute::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Compute::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(Compute::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Compute::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> GAME_LIFT_SERVICE_SDK_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GameLiftServiceSdkEndpoint")
            .getter(getter(Compute::gameLiftServiceSdkEndpoint))
            .setter(setter(Builder::gameLiftServiceSdkEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameLiftServiceSdkEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, COMPUTE_NAME_FIELD, COMPUTE_ARN_FIELD, IP_ADDRESS_FIELD, DNS_NAME_FIELD, COMPUTE_STATUS_FIELD,
            LOCATION_FIELD, CREATION_TIME_FIELD, OPERATING_SYSTEM_FIELD, TYPE_FIELD, GAME_LIFT_SERVICE_SDK_ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final String fleetArn;

    private final String computeName;

    private final String computeArn;

    private final String ipAddress;

    private final String dnsName;

    private final String computeStatus;

    private final String location;

    private final Instant creationTime;

    private final String operatingSystem;

    private final String type;

    private final String gameLiftServiceSdkEndpoint;

    private Compute(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.computeName = builder.computeName;
        this.computeArn = builder.computeArn;
        this.ipAddress = builder.ipAddress;
        this.dnsName = builder.dnsName;
        this.computeStatus = builder.computeStatus;
        this.location = builder.location;
        this.creationTime = builder.creationTime;
        this.operatingSystem = builder.operatingSystem;
        this.type = builder.type;
        this.gameLiftServiceSdkEndpoint = builder.gameLiftServiceSdkEndpoint;
    }

    /**
     * <p>
     * A unique identifier for the fleet that the compute is registered to.
     * </p>
     * 
     * @return A unique identifier for the fleet that the compute is registered to.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet that the compute is registered to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet that the compute is registered to.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * A descriptive label that is associated with the compute resource registered to your fleet.
     * </p>
     * 
     * @return A descriptive label that is associated with the compute resource registered to your fleet.
     */
    public final String computeName() {
        return computeName;
    }

    /**
     * <p>
     * The ARN that is assigned to the compute resource and uniquely identifies it. ARNs are unique across locations.
     * </p>
     * 
     * @return The ARN that is assigned to the compute resource and uniquely identifies it. ARNs are unique across
     *         locations.
     */
    public final String computeArn() {
        return computeArn;
    }

    /**
     * <p>
     * The IP address of the compute resource. Amazon GameLift requires the DNS name or IP address to manage your
     * compute resource.
     * </p>
     * 
     * @return The IP address of the compute resource. Amazon GameLift requires the DNS name or IP address to manage
     *         your compute resource.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The DNS name of the compute resource. Amazon GameLift requires the DNS name or IP address to manage your compute
     * resource.
     * </p>
     * 
     * @return The DNS name of the compute resource. Amazon GameLift requires the DNS name or IP address to manage your
     *         compute resource.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeStatus}
     * will return {@link ComputeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeStatusAsString}.
     * </p>
     * 
     * @return Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game sessions.
     * @see ComputeStatus
     */
    public final ComputeStatus computeStatus() {
        return ComputeStatus.fromValue(computeStatus);
    }

    /**
     * <p>
     * Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeStatus}
     * will return {@link ComputeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeStatusAsString}.
     * </p>
     * 
     * @return Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game sessions.
     * @see ComputeStatus
     */
    public final String computeStatusAsString() {
        return computeStatus;
    }

    /**
     * <p>
     * The name of the custom location you added to the fleet that this compute resource resides in.
     * </p>
     * 
     * @return The name of the custom location you added to the fleet that this compute resource resides in.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     * milliseconds (for example <code>"1469498468.057"</code>).
     * </p>
     * 
     * @return A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     *         milliseconds (for example <code>"1469498468.057"</code>).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The type of operating system on your compute resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The type of operating system on your compute resource.
     * @see OperatingSystem
     */
    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The type of operating system on your compute resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The type of operating system on your compute resource.
     * @see OperatingSystem
     */
    public final String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * <p>
     * The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use managed
     * Amazon EC2 instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use
     *         managed Amazon EC2 instances.
     * @see EC2InstanceType
     */
    public final EC2InstanceType type() {
        return EC2InstanceType.fromValue(type);
    }

    /**
     * <p>
     * The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use managed
     * Amazon EC2 instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use
     *         managed Amazon EC2 instances.
     * @see EC2InstanceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The endpoint connection details of the Amazon GameLift SDK endpoint that your game server connects to.
     * </p>
     * 
     * @return The endpoint connection details of the Amazon GameLift SDK endpoint that your game server connects to.
     */
    public final String gameLiftServiceSdkEndpoint() {
        return gameLiftServiceSdkEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(computeName());
        hashCode = 31 * hashCode + Objects.hashCode(computeArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(computeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gameLiftServiceSdkEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compute)) {
            return false;
        }
        Compute other = (Compute) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && Objects.equals(computeName(), other.computeName()) && Objects.equals(computeArn(), other.computeArn())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(computeStatusAsString(), other.computeStatusAsString())
                && Objects.equals(location(), other.location()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(gameLiftServiceSdkEndpoint(), other.gameLiftServiceSdkEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Compute").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("ComputeName", computeName()).add("ComputeArn", computeArn()).add("IpAddress", ipAddress())
                .add("DnsName", dnsName()).add("ComputeStatus", computeStatusAsString()).add("Location", location())
                .add("CreationTime", creationTime()).add("OperatingSystem", operatingSystemAsString())
                .add("Type", typeAsString()).add("GameLiftServiceSdkEndpoint", gameLiftServiceSdkEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "ComputeName":
            return Optional.ofNullable(clazz.cast(computeName()));
        case "ComputeArn":
            return Optional.ofNullable(clazz.cast(computeArn()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "ComputeStatus":
            return Optional.ofNullable(clazz.cast(computeStatusAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "GameLiftServiceSdkEndpoint":
            return Optional.ofNullable(clazz.cast(gameLiftServiceSdkEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Compute, T> g) {
        return obj -> g.apply((Compute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Compute> {
        /**
         * <p>
         * A unique identifier for the fleet that the compute is registered to.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet that the compute is registered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet that the compute is registered to.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (ARN) of the fleet that the compute is registered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * A descriptive label that is associated with the compute resource registered to your fleet.
         * </p>
         * 
         * @param computeName
         *        A descriptive label that is associated with the compute resource registered to your fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeName(String computeName);

        /**
         * <p>
         * The ARN that is assigned to the compute resource and uniquely identifies it. ARNs are unique across
         * locations.
         * </p>
         * 
         * @param computeArn
         *        The ARN that is assigned to the compute resource and uniquely identifies it. ARNs are unique across
         *        locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeArn(String computeArn);

        /**
         * <p>
         * The IP address of the compute resource. Amazon GameLift requires the DNS name or IP address to manage your
         * compute resource.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the compute resource. Amazon GameLift requires the DNS name or IP address to manage
         *        your compute resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The DNS name of the compute resource. Amazon GameLift requires the DNS name or IP address to manage your
         * compute resource.
         * </p>
         * 
         * @param dnsName
         *        The DNS name of the compute resource. Amazon GameLift requires the DNS name or IP address to manage
         *        your compute resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game sessions.
         * </p>
         * 
         * @param computeStatus
         *        Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game
         *        sessions.
         * @see ComputeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeStatus
         */
        Builder computeStatus(String computeStatus);

        /**
         * <p>
         * Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game sessions.
         * </p>
         * 
         * @param computeStatus
         *        Current status of the compute. A compute must have an <code>ACTIVE</code> status to host game
         *        sessions.
         * @see ComputeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeStatus
         */
        Builder computeStatus(ComputeStatus computeStatus);

        /**
         * <p>
         * The name of the custom location you added to the fleet that this compute resource resides in.
         * </p>
         * 
         * @param location
         *        The name of the custom location you added to the fleet that this compute resource resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
         * milliseconds (for example <code>"1469498468.057"</code>).
         * </p>
         * 
         * @param creationTime
         *        A time stamp indicating when this data object was created. Format is a number expressed in Unix time
         *        as milliseconds (for example <code>"1469498468.057"</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The type of operating system on your compute resource.
         * </p>
         * 
         * @param operatingSystem
         *        The type of operating system on your compute resource.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The type of operating system on your compute resource.
         * </p>
         * 
         * @param operatingSystem
         *        The type of operating system on your compute resource.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use managed
         * Amazon EC2 instances.
         * </p>
         * 
         * @param type
         *        The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use
         *        managed Amazon EC2 instances.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder type(String type);

        /**
         * <p>
         * The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use managed
         * Amazon EC2 instances.
         * </p>
         * 
         * @param type
         *        The compute type that the fleet uses. A fleet can use Anywhere compute resources that you own, or use
         *        managed Amazon EC2 instances.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder type(EC2InstanceType type);

        /**
         * <p>
         * The endpoint connection details of the Amazon GameLift SDK endpoint that your game server connects to.
         * </p>
         * 
         * @param gameLiftServiceSdkEndpoint
         *        The endpoint connection details of the Amazon GameLift SDK endpoint that your game server connects to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameLiftServiceSdkEndpoint(String gameLiftServiceSdkEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private String computeName;

        private String computeArn;

        private String ipAddress;

        private String dnsName;

        private String computeStatus;

        private String location;

        private Instant creationTime;

        private String operatingSystem;

        private String type;

        private String gameLiftServiceSdkEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(Compute model) {
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            computeName(model.computeName);
            computeArn(model.computeArn);
            ipAddress(model.ipAddress);
            dnsName(model.dnsName);
            computeStatus(model.computeStatus);
            location(model.location);
            creationTime(model.creationTime);
            operatingSystem(model.operatingSystem);
            type(model.type);
            gameLiftServiceSdkEndpoint(model.gameLiftServiceSdkEndpoint);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getComputeName() {
            return computeName;
        }

        public final void setComputeName(String computeName) {
            this.computeName = computeName;
        }

        @Override
        public final Builder computeName(String computeName) {
            this.computeName = computeName;
            return this;
        }

        public final String getComputeArn() {
            return computeArn;
        }

        public final void setComputeArn(String computeArn) {
            this.computeArn = computeArn;
        }

        @Override
        public final Builder computeArn(String computeArn) {
            this.computeArn = computeArn;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getComputeStatus() {
            return computeStatus;
        }

        public final void setComputeStatus(String computeStatus) {
            this.computeStatus = computeStatus;
        }

        @Override
        public final Builder computeStatus(String computeStatus) {
            this.computeStatus = computeStatus;
            return this;
        }

        @Override
        public final Builder computeStatus(ComputeStatus computeStatus) {
            this.computeStatus(computeStatus == null ? null : computeStatus.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EC2InstanceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getGameLiftServiceSdkEndpoint() {
            return gameLiftServiceSdkEndpoint;
        }

        public final void setGameLiftServiceSdkEndpoint(String gameLiftServiceSdkEndpoint) {
            this.gameLiftServiceSdkEndpoint = gameLiftServiceSdkEndpoint;
        }

        @Override
        public final Builder gameLiftServiceSdkEndpoint(String gameLiftServiceSdkEndpoint) {
            this.gameLiftServiceSdkEndpoint = gameLiftServiceSdkEndpoint;
            return this;
        }

        @Override
        public Compute build() {
            return new Compute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
