/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchResponse;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.ConflictException;
import software.amazon.awssdk.services.gamelift.model.CreateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.CreateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.CreateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.CreateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreateLocationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateLocationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.CreateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteLocationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest;
import software.amazon.awssdk.services.gamelift.model.DeregisterComputeResponse;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeComputeRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.gamelift.model.FleetCapacityExceededException;
import software.amazon.awssdk.services.gamelift.model.GameLiftException;
import software.amazon.awssdk.services.gamelift.model.GameSessionFullException;
import software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse;
import software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenRequest;
import software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse;
import software.amazon.awssdk.services.gamelift.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.gamelift.model.InternalServiceException;
import software.amazon.awssdk.services.gamelift.model.InvalidFleetStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidGameSessionStatusException;
import software.amazon.awssdk.services.gamelift.model.InvalidRequestException;
import software.amazon.awssdk.services.gamelift.model.LimitExceededException;
import software.amazon.awssdk.services.gamelift.model.ListAliasesRequest;
import software.amazon.awssdk.services.gamelift.model.ListAliasesResponse;
import software.amazon.awssdk.services.gamelift.model.ListBuildsRequest;
import software.amazon.awssdk.services.gamelift.model.ListBuildsResponse;
import software.amazon.awssdk.services.gamelift.model.ListComputeRequest;
import software.amazon.awssdk.services.gamelift.model.ListComputeResponse;
import software.amazon.awssdk.services.gamelift.model.ListFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServersRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServersResponse;
import software.amazon.awssdk.services.gamelift.model.ListLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.ListLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.ListScriptsRequest;
import software.amazon.awssdk.services.gamelift.model.ListScriptsResponse;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gamelift.model.NotFoundException;
import software.amazon.awssdk.services.gamelift.model.OutOfCapacityException;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest;
import software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsRequest;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.TagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.TagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.TaggingFailedException;
import software.amazon.awssdk.services.gamelift.model.TerminalRoutingStrategyException;
import software.amazon.awssdk.services.gamelift.model.UnauthorizedException;
import software.amazon.awssdk.services.gamelift.model.UnsupportedRegionException;
import software.amazon.awssdk.services.gamelift.model.UntagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.UntagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsIterable;
import software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListComputeIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListGameServersIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListLocationsIterable;
import software.amazon.awssdk.services.gamelift.paginators.ListScriptsIterable;
import software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsIterable;

/**
 * Service client for accessing Amazon GameLift. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon GameLift provides solutions for hosting session-based multiplayer game servers in the cloud, including tools
 * for deploying, operating, and scaling game servers. Built on Amazon Web Services global computing infrastructure,
 * GameLift helps you deliver high-performance, high-reliability, low-cost game servers while dynamically scaling your
 * resource usage to meet player demand.
 * </p>
 * <p>
 * <b>About Amazon GameLift solutions</b>
 * </p>
 * <p>
 * Get more information on these Amazon GameLift solutions in the <a
 * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/">Amazon GameLift Developer Guide</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon GameLift managed hosting -- Amazon GameLift offers a fully managed service to set up and maintain computing
 * machines for hosting, manage game session and player session life cycle, and handle security, storage, and
 * performance tracking. You can use automatic scaling tools to balance player demand and hosting costs, configure your
 * game session management to minimize player latency, and add FlexMatch for matchmaking.
 * </p>
 * </li>
 * <li>
 * <p>
 * Managed hosting with Realtime Servers -- With Amazon GameLift Realtime Servers, you can quickly configure and set up
 * ready-to-go game servers for your game. Realtime Servers provides a game server framework with core Amazon GameLift
 * infrastructure already built in. Then use the full range of Amazon GameLift managed hosting features, including
 * FlexMatch, for your game.
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon GameLift FleetIQ -- Use Amazon GameLift FleetIQ as a standalone service while hosting your games using EC2
 * instances and Auto Scaling groups. Amazon GameLift FleetIQ provides optimizations for game hosting, including
 * boosting the viability of low-cost Spot Instances gaming. For a complete solution, pair the Amazon GameLift FleetIQ
 * and FlexMatch standalone services.
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon GameLift FlexMatch -- Add matchmaking to your game hosting solution. FlexMatch is a customizable matchmaking
 * service for multiplayer games. Use FlexMatch as integrated with Amazon GameLift managed hosting or incorporate
 * FlexMatch as a standalone service into your own hosting solution.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>About this API Reference</b>
 * </p>
 * <p>
 * This reference guide describes the low-level service API for Amazon GameLift. With each topic in this guide, you can
 * find links to language-specific SDK guides and the Amazon Web Services CLI reference. Useful links:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html">Amazon GameLift API
 * operations listed by tasks</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-components.html"> Amazon GameLift tools
 * and resources</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GameLiftClient extends AwsClient {
    String SERVICE_NAME = "gamelift";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "gamelift";

    /**
     * <p>
     * Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may
     * require player acceptance; if so, then matches built with that configuration cannot be completed unless all
     * players accept the proposed match within a specified time limit.
     * </p>
     * <p>
     * When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status
     * <code>REQUIRES_ACCEPTANCE</code>. This is a trigger for your game to get acceptance from all players in the
     * ticket. Acceptances are only valid for tickets when they are in this status; all other acceptances result in an
     * error.
     * </p>
     * <p>
     * To register acceptance, specify the ticket ID, a response, and one or more players. Once all players have
     * registered acceptance, the matchmaking tickets advance to status <code>PLACING</code>, where a new game session
     * is created for the match.
     * </p>
     * <p>
     * If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed
     * match is dropped. The matchmaking tickets are then handled in one of two ways: For tickets where one or more
     * players rejected the match or failed to respond, the ticket status is set to <code>CANCELLED</code>, and
     * processing is terminated. For tickets where players have accepted or not yet responded, the ticket status is
     * returned to <code>SEARCHING</code> to find a new match. A new matchmaking request for these players can be
     * submitted as needed.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> FlexMatch events</a>
     * (reference)
     * </p>
     *
     * @param acceptMatchRequest
     * @return Result of the AcceptMatch operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.AcceptMatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch" target="_top">AWS API
     *      Documentation</a>
     */
    default AcceptMatchResponse acceptMatch(AcceptMatchRequest acceptMatchRequest) throws InvalidRequestException,
            NotFoundException, InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may
     * require player acceptance; if so, then matches built with that configuration cannot be completed unless all
     * players accept the proposed match within a specified time limit.
     * </p>
     * <p>
     * When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status
     * <code>REQUIRES_ACCEPTANCE</code>. This is a trigger for your game to get acceptance from all players in the
     * ticket. Acceptances are only valid for tickets when they are in this status; all other acceptances result in an
     * error.
     * </p>
     * <p>
     * To register acceptance, specify the ticket ID, a response, and one or more players. Once all players have
     * registered acceptance, the matchmaking tickets advance to status <code>PLACING</code>, where a new game session
     * is created for the match.
     * </p>
     * <p>
     * If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed
     * match is dropped. The matchmaking tickets are then handled in one of two ways: For tickets where one or more
     * players rejected the match or failed to respond, the ticket status is set to <code>CANCELLED</code>, and
     * processing is terminated. For tickets where players have accepted or not yet responded, the ticket status is
     * returned to <code>SEARCHING</code> to find a new match. A new matchmaking request for these players can be
     * submitted as needed.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> FlexMatch events</a>
     * (reference)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptMatchRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptMatchRequest#builder()}
     * </p>
     *
     * @param acceptMatchRequest
     *        A {@link Consumer} that will call methods on {@link AcceptMatchInput.Builder} to create a request.
     * @return Result of the AcceptMatch operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.AcceptMatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch" target="_top">AWS API
     *      Documentation</a>
     */
    default AcceptMatchResponse acceptMatch(Consumer<AcceptMatchRequest.Builder> acceptMatchRequest)
            throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        return acceptMatch(AcceptMatchRequest.builder().applyMutation(acceptMatchRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Locates an available game server and temporarily reserves it to host gameplay and players. This operation is
     * called from a game client or client service (such as a matchmaker) to request hosting resources for a new game
     * session. In response, Amazon GameLift FleetIQ locates an available game server, places it in <code>CLAIMED</code>
     * status for 60 seconds, and returns connection information that players can use to connect to the game server.
     * </p>
     * <p>
     * To claim a game server, identify a game server group. You can also specify a game server ID, although this
     * approach bypasses Amazon GameLift FleetIQ placement optimization. Optionally, include game data to pass to the
     * game server at the start of a game session, such as a game map or player information. Add filter options to
     * further restrict how a game server is chosen, such as only allowing game servers on <code>ACTIVE</code> instances
     * to be claimed.
     * </p>
     * <p>
     * When a game server is successfully claimed, connection information is returned. A claimed game server's
     * utilization status remains <code>AVAILABLE</code> while the claim status is set to <code>CLAIMED</code> for up to
     * 60 seconds. This time period gives the game server time to update its status to <code>UTILIZED</code> after
     * players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed
     * status and is available to be claimed by another request. The claim time period is a fixed value and is not
     * configurable.
     * </p>
     * <p>
     * If you try to claim a specific game server, this request will fail in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the game server utilization status is <code>UTILIZED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server claim status is <code>CLAIMED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server is running on an instance in <code>DRAINING</code> status and the provided filter option does
     * not allow placing on <code>DRAINING</code> instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param claimGameServerRequest
     * @return Result of the ClaimGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws OutOfCapacityException
     *         The specified game server group has no available game servers to fulfill a <code>ClaimGameServer</code>
     *         request. Clients can retry such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ClaimGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimGameServerResponse claimGameServer(ClaimGameServerRequest claimGameServerRequest)
            throws InvalidRequestException, NotFoundException, ConflictException, OutOfCapacityException, UnauthorizedException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Locates an available game server and temporarily reserves it to host gameplay and players. This operation is
     * called from a game client or client service (such as a matchmaker) to request hosting resources for a new game
     * session. In response, Amazon GameLift FleetIQ locates an available game server, places it in <code>CLAIMED</code>
     * status for 60 seconds, and returns connection information that players can use to connect to the game server.
     * </p>
     * <p>
     * To claim a game server, identify a game server group. You can also specify a game server ID, although this
     * approach bypasses Amazon GameLift FleetIQ placement optimization. Optionally, include game data to pass to the
     * game server at the start of a game session, such as a game map or player information. Add filter options to
     * further restrict how a game server is chosen, such as only allowing game servers on <code>ACTIVE</code> instances
     * to be claimed.
     * </p>
     * <p>
     * When a game server is successfully claimed, connection information is returned. A claimed game server's
     * utilization status remains <code>AVAILABLE</code> while the claim status is set to <code>CLAIMED</code> for up to
     * 60 seconds. This time period gives the game server time to update its status to <code>UTILIZED</code> after
     * players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed
     * status and is available to be claimed by another request. The claim time period is a fixed value and is not
     * configurable.
     * </p>
     * <p>
     * If you try to claim a specific game server, this request will fail in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the game server utilization status is <code>UTILIZED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server claim status is <code>CLAIMED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server is running on an instance in <code>DRAINING</code> status and the provided filter option does
     * not allow placing on <code>DRAINING</code> instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimGameServerRequest.Builder} avoiding the need
     * to create one manually via {@link ClaimGameServerRequest#builder()}
     * </p>
     *
     * @param claimGameServerRequest
     *        A {@link Consumer} that will call methods on {@link ClaimGameServerInput.Builder} to create a request.
     * @return Result of the ClaimGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws OutOfCapacityException
     *         The specified game server group has no available game servers to fulfill a <code>ClaimGameServer</code>
     *         request. Clients can retry such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ClaimGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimGameServerResponse claimGameServer(Consumer<ClaimGameServerRequest.Builder> claimGameServerRequest)
            throws InvalidRequestException, NotFoundException, ConflictException, OutOfCapacityException, UnauthorizedException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return claimGameServer(ClaimGameServerRequest.builder().applyMutation(claimGameServerRequest).build());
    }

    /**
     * <p>
     * Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias
     * provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to
     * another, such as when updating your game build.
     * </p>
     * <p>
     * Amazon GameLift supports two types of routing strategies for aliases: simple and terminal. A simple alias points
     * to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to
     * an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you
     * want to direct players to an upgrade site.
     * </p>
     * <p>
     * To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can
     * point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned,
     * including an alias ID and an ARN. You can reassign an alias to another fleet by calling <code>UpdateAlias</code>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createAliasRequest
     * @return Result of the CreateAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws UnauthorizedException,
            InvalidRequestException, ConflictException, InternalServiceException, LimitExceededException, TaggingFailedException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias
     * provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to
     * another, such as when updating your game build.
     * </p>
     * <p>
     * Amazon GameLift supports two types of routing strategies for aliases: simple and terminal. A simple alias points
     * to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to
     * an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you
     * want to direct players to an upgrade site.
     * </p>
     * <p>
     * To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can
     * point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned,
     * including an alias ID and an ARN. You can reassign an alias to another fleet by calling <code>UpdateAlias</code>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateAliasInput.Builder} to create a request.
     * @return Result of the CreateAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest)
            throws UnauthorizedException, InvalidRequestException, ConflictException, InternalServiceException,
            LimitExceededException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon GameLift build resource for your game server binary files. Combine game server binaries into
     * a zip file for use with Amazon GameLift.
     * </p>
     * <important>
     * <p>
     * When setting up a new game build for Amazon GameLift, we recommend using the CLI command <b> <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html">upload-build</a> </b>. This
     * helper command combines two tasks: (1) it uploads your build files from a file directory to an Amazon GameLift
     * Amazon S3 location, and (2) it creates a new build resource.
     * </p>
     * </important>
     * <p>
     * You can use the <code>CreateBuild</code> operation in the following scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account
     * that you control. To use this option, you give Amazon GameLift access to the Amazon S3 bucket. With permissions
     * in place, specify a build name, operating system, and the Amazon S3 storage location of your game build.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your build files to a Amazon GameLift Amazon S3 location. To use this option, specify a build name and
     * operating system. This operation creates a new build resource and also returns an Amazon S3 location with
     * temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3
     * location. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html">Uploading Objects</a> in the
     * <i>Amazon S3 Developer Guide</i>. After you upload build files to the Amazon GameLift Amazon S3 location, you
     * can't update them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new build resource with a unique build ID and places it in
     * <code>INITIALIZED</code> status. A build must be in <code>READY</code> status before you can create fleets with
     * it.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">Uploading Your
     * Game</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in Amazon S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createBuildRequest
     * @return Result of the CreateBuild operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBuildResponse createBuild(CreateBuildRequest createBuildRequest) throws UnauthorizedException,
            InvalidRequestException, ConflictException, TaggingFailedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon GameLift build resource for your game server binary files. Combine game server binaries into
     * a zip file for use with Amazon GameLift.
     * </p>
     * <important>
     * <p>
     * When setting up a new game build for Amazon GameLift, we recommend using the CLI command <b> <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html">upload-build</a> </b>. This
     * helper command combines two tasks: (1) it uploads your build files from a file directory to an Amazon GameLift
     * Amazon S3 location, and (2) it creates a new build resource.
     * </p>
     * </important>
     * <p>
     * You can use the <code>CreateBuild</code> operation in the following scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account
     * that you control. To use this option, you give Amazon GameLift access to the Amazon S3 bucket. With permissions
     * in place, specify a build name, operating system, and the Amazon S3 storage location of your game build.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your build files to a Amazon GameLift Amazon S3 location. To use this option, specify a build name and
     * operating system. This operation creates a new build resource and also returns an Amazon S3 location with
     * temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3
     * location. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html">Uploading Objects</a> in the
     * <i>Amazon S3 Developer Guide</i>. After you upload build files to the Amazon GameLift Amazon S3 location, you
     * can't update them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new build resource with a unique build ID and places it in
     * <code>INITIALIZED</code> status. A build must be in <code>READY</code> status before you can create fleets with
     * it.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">Uploading Your
     * Game</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in Amazon S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBuildRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBuildRequest#builder()}
     * </p>
     *
     * @param createBuildRequest
     *        A {@link Consumer} that will call methods on {@link CreateBuildInput.Builder} to create a request.
     * @return Result of the CreateBuild operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBuildResponse createBuild(Consumer<CreateBuildRequest.Builder> createBuildRequest)
            throws UnauthorizedException, InvalidRequestException, ConflictException, TaggingFailedException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return createBuild(CreateBuildRequest.builder().applyMutation(createBuildRequest).build());
    }

    /**
     * <p>
     * Creates a fleet of Amazon Elastic Compute Cloud (Amazon EC2) instances to host your custom game server or
     * Realtime Servers. Use this operation to configure the computing resources for your fleet and provide instructions
     * for running game servers on each instance.
     * </p>
     * <p>
     * Most Amazon GameLift fleets can deploy instances to multiple locations, including the home Region (where the
     * fleet is created) and an optional set of remote locations. Fleets that are created in the following Amazon Web
     * Services Regions support multiple locations: us-east-1 (N. Virginia), us-west-2 (Oregon), eu-central-1
     * (Frankfurt), eu-west-1 (Ireland), ap-southeast-2 (Sydney), ap-northeast-1 (Tokyo), and ap-northeast-2 (Seoul).
     * Fleets that are created in other Amazon GameLift Regions can deploy instances in the fleet's home Region only.
     * All fleet instances use the same configuration regardless of location; however, you can adjust capacity settings
     * and turn auto-scaling on/off for each location.
     * </p>
     * <p>
     * To create a fleet, choose the hardware for your instances, specify a game server build or Realtime script to
     * deploy, and provide a runtime configuration to direct Amazon GameLift how to start and run game servers on each
     * instance in the fleet. Set permissions for inbound traffic to your game servers, and enable optional features as
     * needed. When creating a multi-location fleet, provide a list of additional remote locations.
     * </p>
     * <p>
     * If you need to debug your fleet, fetch logs, view performance metrics or other actions on the fleet, create the
     * development fleet with port 22/3389 open. As a best practice, we recommend opening ports for remote access only
     * when you need them and closing them when you're finished.
     * </p>
     * <p>
     * If successful, this operation creates a new Fleet resource and places it in <code>NEW</code> status, which
     * prompts Amazon GameLift to initiate the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation"
     * >Debug fleet creation issues</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a>
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InternalServiceException,
            NotFoundException, ConflictException, LimitExceededException, InvalidRequestException, UnauthorizedException,
            TaggingFailedException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet of Amazon Elastic Compute Cloud (Amazon EC2) instances to host your custom game server or
     * Realtime Servers. Use this operation to configure the computing resources for your fleet and provide instructions
     * for running game servers on each instance.
     * </p>
     * <p>
     * Most Amazon GameLift fleets can deploy instances to multiple locations, including the home Region (where the
     * fleet is created) and an optional set of remote locations. Fleets that are created in the following Amazon Web
     * Services Regions support multiple locations: us-east-1 (N. Virginia), us-west-2 (Oregon), eu-central-1
     * (Frankfurt), eu-west-1 (Ireland), ap-southeast-2 (Sydney), ap-northeast-1 (Tokyo), and ap-northeast-2 (Seoul).
     * Fleets that are created in other Amazon GameLift Regions can deploy instances in the fleet's home Region only.
     * All fleet instances use the same configuration regardless of location; however, you can adjust capacity settings
     * and turn auto-scaling on/off for each location.
     * </p>
     * <p>
     * To create a fleet, choose the hardware for your instances, specify a game server build or Realtime script to
     * deploy, and provide a runtime configuration to direct Amazon GameLift how to start and run game servers on each
     * instance in the fleet. Set permissions for inbound traffic to your game servers, and enable optional features as
     * needed. When creating a multi-location fleet, provide a list of additional remote locations.
     * </p>
     * <p>
     * If you need to debug your fleet, fetch logs, view performance metrics or other actions on the fleet, create the
     * development fleet with port 22/3389 open. As a best practice, we recommend opening ports for remote access only
     * when you need them and closing them when you're finished.
     * </p>
     * <p>
     * If successful, this operation creates a new Fleet resource and places it in <code>NEW</code> status, which
     * prompts Amazon GameLift to initiate the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation"
     * >Debug fleet creation issues</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetInput.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest)
            throws InternalServiceException, NotFoundException, ConflictException, LimitExceededException,
            InvalidRequestException, UnauthorizedException, TaggingFailedException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Adds remote locations to a fleet and begins populating the new locations with EC2 instances. The new instances
     * conform to the fleet's instance type, auto-scaling, and other configuration settings.
     * </p>
     * <note>
     * <p>
     * This operation cannot be used with fleets that don't support remote locations. Fleets can have multiple locations
     * only if they reside in Amazon Web Services Regions that support this feature and were created after the feature
     * was released in March 2021.
     * </p>
     * </note>
     * <p>
     * To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.
     * </p>
     * <p>
     * If successful, this operation returns the list of added locations with their status set to <code>NEW</code>.
     * Amazon GameLift initiates the process of starting an instance in each added location. You can track the status of
     * each new location by monitoring location creation events using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a>
     * </p>
     *
     * @param createFleetLocationsRequest
     * @return Result of the CreateFleetLocations operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidFleetStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the fleet. Resolve the conflict before retrying.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFleetLocationsResponse createFleetLocations(CreateFleetLocationsRequest createFleetLocationsRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            InvalidFleetStatusException, UnsupportedRegionException, ConflictException, LimitExceededException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds remote locations to a fleet and begins populating the new locations with EC2 instances. The new instances
     * conform to the fleet's instance type, auto-scaling, and other configuration settings.
     * </p>
     * <note>
     * <p>
     * This operation cannot be used with fleets that don't support remote locations. Fleets can have multiple locations
     * only if they reside in Amazon Web Services Regions that support this feature and were created after the feature
     * was released in March 2021.
     * </p>
     * </note>
     * <p>
     * To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.
     * </p>
     * <p>
     * If successful, this operation returns the list of added locations with their status set to <code>NEW</code>.
     * Amazon GameLift initiates the process of starting an instance in each added location. You can track the status of
     * each new location by monitoring location creation events using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFleetLocationsRequest#builder()}
     * </p>
     *
     * @param createFleetLocationsRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetLocationsInput.Builder} to create a
     *        request.
     * @return Result of the CreateFleetLocations operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidFleetStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the fleet. Resolve the conflict before retrying.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFleetLocationsResponse createFleetLocations(
            Consumer<CreateFleetLocationsRequest.Builder> createFleetLocationsRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, InvalidFleetStatusException,
            UnsupportedRegionException, ConflictException, LimitExceededException, AwsServiceException, SdkClientException,
            GameLiftException {
        return createFleetLocations(CreateFleetLocationsRequest.builder().applyMutation(createFleetLocationsRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a Amazon GameLift FleetIQ game server group for managing game hosting on a collection of Amazon Elastic
     * Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto Scaling
     * group in your Amazon Web Services account, and establishes a link between the two groups. You can view the status
     * of your game server groups in the Amazon GameLift console. Game server group metrics and events are emitted to
     * Amazon CloudWatch.
     * </p>
     * <p>
     * Before creating a new game server group, you must have the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud
     * instances with your game server build. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html"> Launching an Instance from
     * a Launch Template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An IAM role that extends limited access to your Amazon Web Services account to allow Amazon GameLift FleetIQ to
     * create and interact with the Auto Scaling group. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html">Create IAM roles
     * for cross-service interaction</a> in the <i>Amazon GameLift FleetIQ Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch
     * template, and provide a list of instance types that can be used in the group. You must also set initial maximum
     * and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target
     * tracking based on a Amazon GameLift FleetIQ metric.
     * </p>
     * <p>
     * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the
     * Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group,
     * including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling
     * group. Keep in mind that some Auto Scaling group properties are periodically updated by Amazon GameLift FleetIQ
     * as part of its balancing activities to optimize for availability and cost.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param createGameServerGroupRequest
     * @return Result of the CreateGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGameServerGroupResponse createGameServerGroup(CreateGameServerGroupRequest createGameServerGroupRequest)
            throws InvalidRequestException, ConflictException, UnauthorizedException, InternalServiceException,
            LimitExceededException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a Amazon GameLift FleetIQ game server group for managing game hosting on a collection of Amazon Elastic
     * Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto Scaling
     * group in your Amazon Web Services account, and establishes a link between the two groups. You can view the status
     * of your game server groups in the Amazon GameLift console. Game server group metrics and events are emitted to
     * Amazon CloudWatch.
     * </p>
     * <p>
     * Before creating a new game server group, you must have the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud
     * instances with your game server build. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html"> Launching an Instance from
     * a Launch Template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An IAM role that extends limited access to your Amazon Web Services account to allow Amazon GameLift FleetIQ to
     * create and interact with the Auto Scaling group. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html">Create IAM roles
     * for cross-service interaction</a> in the <i>Amazon GameLift FleetIQ Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch
     * template, and provide a list of instance types that can be used in the group. You must also set initial maximum
     * and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target
     * tracking based on a Amazon GameLift FleetIQ metric.
     * </p>
     * <p>
     * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the
     * Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group,
     * including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling
     * group. Keep in mind that some Auto Scaling group properties are periodically updated by Amazon GameLift FleetIQ
     * as part of its balancing activities to optimize for availability and cost.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameServerGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGameServerGroupRequest#builder()}
     * </p>
     *
     * @param createGameServerGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGameServerGroupInput.Builder} to create a
     *        request.
     * @return Result of the CreateGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGameServerGroupResponse createGameServerGroup(
            Consumer<CreateGameServerGroupRequest.Builder> createGameServerGroupRequest) throws InvalidRequestException,
            ConflictException, UnauthorizedException, InternalServiceException, LimitExceededException, AwsServiceException,
            SdkClientException, GameLiftException {
        return createGameServerGroup(CreateGameServerGroupRequest.builder().applyMutation(createGameServerGroupRequest).build());
    }

    /**
     * <p>
     * Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available
     * server process to start a game session and retrieves connection information for the new game session. As an
     * alternative, consider using the Amazon GameLift game session placement feature with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> , which uses FleetIQ algorithms and queues to optimize the placement process.
     * </p>
     * <p>
     * When creating a game session, you specify exactly where you want to place it and provide a set of game session
     * configuration settings. The fleet must be in <code>ACTIVE</code> status before a game session can be created in
     * it.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your
     * game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location
     * name, along with your game session configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a workflow is initiated to start a new game session. A <code>GameSession</code> object is returned
     * containing the game session configuration and status. When the status is <code>ACTIVE</code>, game session
     * connection information is provided and player sessions can be created for the game session. By default, newly
     * created game sessions are open to new players. You can restrict new player access by using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>
     * to change the game session's player session creation policy.
     * </p>
     * <p>
     * Game session logs are retained for all active game sessions for 14 days. To access the logs, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html"
     * >GetGameSessionLogUrl</a> to download the log files.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createGameSessionRequest
     * @return Result of the CreateGameSession operation returned by the service.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidFleetStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the fleet. Resolve the conflict before retrying.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws FleetCapacityExceededException
     *         The specified fleet has no available instances to fulfill a <code>CreateGameSession</code> request.
     *         Clients can retry such requests immediately or after a waiting period.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws IdempotentParameterMismatchException
     *         A game session with this custom ID string already exists in this fleet. Resolve this conflict before
     *         retrying this request.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateGameSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGameSessionResponse createGameSession(CreateGameSessionRequest createGameSessionRequest)
            throws ConflictException, InternalServiceException, UnauthorizedException, InvalidFleetStatusException,
            TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, FleetCapacityExceededException,
            LimitExceededException, IdempotentParameterMismatchException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available
     * server process to start a game session and retrieves connection information for the new game session. As an
     * alternative, consider using the Amazon GameLift game session placement feature with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> , which uses FleetIQ algorithms and queues to optimize the placement process.
     * </p>
     * <p>
     * When creating a game session, you specify exactly where you want to place it and provide a set of game session
     * configuration settings. The fleet must be in <code>ACTIVE</code> status before a game session can be created in
     * it.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your
     * game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location
     * name, along with your game session configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a workflow is initiated to start a new game session. A <code>GameSession</code> object is returned
     * containing the game session configuration and status. When the status is <code>ACTIVE</code>, game session
     * connection information is provided and player sessions can be created for the game session. By default, newly
     * created game sessions are open to new players. You can restrict new player access by using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>
     * to change the game session's player session creation policy.
     * </p>
     * <p>
     * Game session logs are retained for all active game sessions for 14 days. To access the logs, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html"
     * >GetGameSessionLogUrl</a> to download the log files.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameSessionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateGameSessionRequest#builder()}
     * </p>
     *
     * @param createGameSessionRequest
     *        A {@link Consumer} that will call methods on {@link CreateGameSessionInput.Builder} to create a request.
     * @return Result of the CreateGameSession operation returned by the service.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidFleetStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the fleet. Resolve the conflict before retrying.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws FleetCapacityExceededException
     *         The specified fleet has no available instances to fulfill a <code>CreateGameSession</code> request.
     *         Clients can retry such requests immediately or after a waiting period.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws IdempotentParameterMismatchException
     *         A game session with this custom ID string already exists in this fleet. Resolve this conflict before
     *         retrying this request.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateGameSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGameSessionResponse createGameSession(Consumer<CreateGameSessionRequest.Builder> createGameSessionRequest)
            throws ConflictException, InternalServiceException, UnauthorizedException, InvalidFleetStatusException,
            TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, FleetCapacityExceededException,
            LimitExceededException, IdempotentParameterMismatchException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return createGameSession(CreateGameSessionRequest.builder().applyMutation(createGameSessionRequest).build());
    }

    /**
     * <p>
     * Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to
     * determine the best placement locations and find an available game server there, then prompts the game server
     * process to start a new game session.
     * </p>
     * <p>
     * A game session queue is configured with a set of destinations (Amazon GameLift fleets or aliases), which
     * determine the locations where the queue can place new game sessions. These destinations can span multiple fleet
     * types (Spot and On-Demand), instance types, and Amazon Web Services Regions. If the queue includes multi-location
     * fleets, the queue is able to place game sessions in all of a fleet's remote locations. You can opt to filter out
     * individual locations if needed.
     * </p>
     * <p>
     * The queue configuration also determines how FleetIQ selects the best available placement for a new game session.
     * Before searching for an available game server, FleetIQ first prioritizes the queue's destinations and locations,
     * with the best placement locations on top. You can set up the queue to use the FleetIQ default prioritization or
     * provide an alternate set of priorities.
     * </p>
     * <p>
     * To create a new queue, provide a name, timeout value, and a list of destinations. Optionally, specify a sort
     * configuration and/or a filter, and define a set of latency cap policies. You can also include the ARN for an
     * Amazon Simple Notification Service (SNS) topic to receive notifications of game session placement activity.
     * Notifications using SNS or CloudWatch events is the preferred way to track placement activity.
     * </p>
     * <p>
     * If successful, a new <code>GameSessionQueue</code> object is returned with an assigned queue ARN. New game
     * session requests, which are submitted to queue with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> or <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html">StartMatchmaking</a>,
     * reference a queue's name or ARN.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html"> Design a game session
     * queue</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html"> Create a game session
     * queue</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">
     * CreateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html"
     * >DescribeGameSessionQueues</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html"
     * >UpdateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html"
     * >DeleteGameSessionQueue</a> | <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createGameSessionQueueRequest
     * @return Result of the CreateGameSessionQueue operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGameSessionQueueResponse createGameSessionQueue(CreateGameSessionQueueRequest createGameSessionQueueRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, LimitExceededException,
            NotFoundException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to
     * determine the best placement locations and find an available game server there, then prompts the game server
     * process to start a new game session.
     * </p>
     * <p>
     * A game session queue is configured with a set of destinations (Amazon GameLift fleets or aliases), which
     * determine the locations where the queue can place new game sessions. These destinations can span multiple fleet
     * types (Spot and On-Demand), instance types, and Amazon Web Services Regions. If the queue includes multi-location
     * fleets, the queue is able to place game sessions in all of a fleet's remote locations. You can opt to filter out
     * individual locations if needed.
     * </p>
     * <p>
     * The queue configuration also determines how FleetIQ selects the best available placement for a new game session.
     * Before searching for an available game server, FleetIQ first prioritizes the queue's destinations and locations,
     * with the best placement locations on top. You can set up the queue to use the FleetIQ default prioritization or
     * provide an alternate set of priorities.
     * </p>
     * <p>
     * To create a new queue, provide a name, timeout value, and a list of destinations. Optionally, specify a sort
     * configuration and/or a filter, and define a set of latency cap policies. You can also include the ARN for an
     * Amazon Simple Notification Service (SNS) topic to receive notifications of game session placement activity.
     * Notifications using SNS or CloudWatch events is the preferred way to track placement activity.
     * </p>
     * <p>
     * If successful, a new <code>GameSessionQueue</code> object is returned with an assigned queue ARN. New game
     * session requests, which are submitted to queue with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> or <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html">StartMatchmaking</a>,
     * reference a queue's name or ARN.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html"> Design a game session
     * queue</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html"> Create a game session
     * queue</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">
     * CreateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html"
     * >DescribeGameSessionQueues</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html"
     * >UpdateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html"
     * >DeleteGameSessionQueue</a> | <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameSessionQueueRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGameSessionQueueRequest#builder()}
     * </p>
     *
     * @param createGameSessionQueueRequest
     *        A {@link Consumer} that will call methods on {@link CreateGameSessionQueueInput.Builder} to create a
     *        request.
     * @return Result of the CreateGameSessionQueue operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGameSessionQueueResponse createGameSessionQueue(
            Consumer<CreateGameSessionQueueRequest.Builder> createGameSessionQueueRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, LimitExceededException, NotFoundException, TaggingFailedException,
            AwsServiceException, SdkClientException, GameLiftException {
        return createGameSessionQueue(CreateGameSessionQueueRequest.builder().applyMutation(createGameSessionQueueRequest)
                .build());
    }

    /**
     * <p>
     * Creates a custom location for use in an Anywhere fleet.
     * </p>
     *
     * @param createLocationRequest
     * @return Result of the CreateLocation operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLocationResponse createLocation(CreateLocationRequest createLocationRequest) throws UnauthorizedException,
            InvalidRequestException, LimitExceededException, ConflictException, TaggingFailedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom location for use in an Anywhere fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLocationRequest#builder()}
     * </p>
     *
     * @param createLocationRequest
     *        A {@link Consumer} that will call methods on {@link CreateLocationInput.Builder} to create a request.
     * @return Result of the CreateLocation operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLocationResponse createLocation(Consumer<CreateLocationRequest.Builder> createLocationRequest)
            throws UnauthorizedException, InvalidRequestException, LimitExceededException, ConflictException,
            TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return createLocation(CreateLocationRequest.builder().applyMutation(createLocationRequest).build());
    }

    /**
     * <p>
     * Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with Amazon
     * GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for
     * matching players and forming teams. If you're also using Amazon GameLift hosting, it defines how to start game
     * sessions for each match. Your matchmaking system can use multiple configurations to handle different game
     * scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes
     * consistent with that configuration.
     * </p>
     * <p>
     * To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode
     * (with or without Amazon GameLift hosting); a rule set that specifies how to evaluate players and find acceptable
     * matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When
     * using FlexMatch with Amazon GameLift hosting, you also need to identify the game session queue to use when
     * starting a game session for the match.
     * </p>
     * <p>
     * In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications.
     * Provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html"> Design a FlexMatch
     * matchmaker</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set up FlexMatch
     * event notification</a>
     * </p>
     *
     * @param createMatchmakingConfigurationRequest
     * @return Result of the CreateMatchmakingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMatchmakingConfigurationResponse createMatchmakingConfiguration(
            CreateMatchmakingConfigurationRequest createMatchmakingConfigurationRequest) throws InvalidRequestException,
            LimitExceededException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with Amazon
     * GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for
     * matching players and forming teams. If you're also using Amazon GameLift hosting, it defines how to start game
     * sessions for each match. Your matchmaking system can use multiple configurations to handle different game
     * scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes
     * consistent with that configuration.
     * </p>
     * <p>
     * To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode
     * (with or without Amazon GameLift hosting); a rule set that specifies how to evaluate players and find acceptable
     * matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When
     * using FlexMatch with Amazon GameLift hosting, you also need to identify the game session queue to use when
     * starting a game session for the match.
     * </p>
     * <p>
     * In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications.
     * Provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html"> Design a FlexMatch
     * matchmaker</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set up FlexMatch
     * event notification</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMatchmakingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMatchmakingConfigurationRequest#builder()}
     * </p>
     *
     * @param createMatchmakingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateMatchmakingConfigurationInput.Builder} to create
     *        a request.
     * @return Result of the CreateMatchmakingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMatchmakingConfigurationResponse createMatchmakingConfiguration(
            Consumer<CreateMatchmakingConfigurationRequest.Builder> createMatchmakingConfigurationRequest)
            throws InvalidRequestException, LimitExceededException, NotFoundException, InternalServiceException,
            UnsupportedRegionException, TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        return createMatchmakingConfiguration(CreateMatchmakingConfigurationRequest.builder()
                .applyMutation(createMatchmakingConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the
     * number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level
     * or character type.
     * </p>
     * <p>
     * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets
     * must be defined in the same Region as the matchmaking configuration they are used with.
     * </p>
     * <p>
     * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html"
     * >ValidateMatchmakingRuleSet</a> before creating a new rule set.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html">Design a
     * matchmaker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html">Matchmaking with
     * FlexMatch</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createMatchmakingRuleSetRequest
     * @return Result of the CreateMatchmakingRuleSet operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMatchmakingRuleSetResponse createMatchmakingRuleSet(
            CreateMatchmakingRuleSetRequest createMatchmakingRuleSetRequest) throws InvalidRequestException,
            LimitExceededException, InternalServiceException, UnsupportedRegionException, TaggingFailedException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the
     * number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level
     * or character type.
     * </p>
     * <p>
     * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets
     * must be defined in the same Region as the matchmaking configuration they are used with.
     * </p>
     * <p>
     * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html"
     * >ValidateMatchmakingRuleSet</a> before creating a new rule set.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html">Design a
     * matchmaker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html">Matchmaking with
     * FlexMatch</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMatchmakingRuleSetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMatchmakingRuleSetRequest#builder()}
     * </p>
     *
     * @param createMatchmakingRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateMatchmakingRuleSetInput.Builder} to create a
     *        request.
     * @return Result of the CreateMatchmakingRuleSet operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMatchmakingRuleSetResponse createMatchmakingRuleSet(
            Consumer<CreateMatchmakingRuleSetRequest.Builder> createMatchmakingRuleSetRequest) throws InvalidRequestException,
            LimitExceededException, InternalServiceException, UnsupportedRegionException, TaggingFailedException,
            AwsServiceException, SdkClientException, GameLiftException {
        return createMatchmakingRuleSet(CreateMatchmakingRuleSetRequest.builder().applyMutation(createMatchmakingRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Reserves an open player slot in a game session for a player. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. You can add a group of players to a game session with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html"
     * >CreatePlayerSessions</a> .
     * </p>
     * <p>
     * To create a player session, specify a game session ID, player ID, and optionally a set of player data.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for the player and a new <code>PlayerSessions</code> object
     * is returned with a player session ID. The player references the player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createPlayerSessionRequest
     * @return Result of the CreatePlayerSession operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidGameSessionStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the game instance. Resolve the conflict before retrying.
     * @throws GameSessionFullException
     *         The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreatePlayerSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePlayerSessionResponse createPlayerSession(CreatePlayerSessionRequest createPlayerSessionRequest)
            throws InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException,
            TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reserves an open player slot in a game session for a player. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. You can add a group of players to a game session with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html"
     * >CreatePlayerSessions</a> .
     * </p>
     * <p>
     * To create a player session, specify a game session ID, player ID, and optionally a set of player data.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for the player and a new <code>PlayerSessions</code> object
     * is returned with a player session ID. The player references the player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlayerSessionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlayerSessionRequest#builder()}
     * </p>
     *
     * @param createPlayerSessionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlayerSessionInput.Builder} to create a request.
     * @return Result of the CreatePlayerSession operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidGameSessionStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the game instance. Resolve the conflict before retrying.
     * @throws GameSessionFullException
     *         The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreatePlayerSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePlayerSessionResponse createPlayerSession(
            Consumer<CreatePlayerSessionRequest.Builder> createPlayerSessionRequest) throws InternalServiceException,
            UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException, TerminalRoutingStrategyException,
            InvalidRequestException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        return createPlayerSession(CreatePlayerSessionRequest.builder().applyMutation(createPlayerSessionRequest).build());
    }

    /**
     * <p>
     * Reserves open slots in a game session for a group of players. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. To add a single player to a game session, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html"
     * >CreatePlayerSession</a>
     * </p>
     * <p>
     * To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of
     * player data for each player ID.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for each player, and new <code>PlayerSession</code> objects
     * are returned with player session IDs. Each player references their player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createPlayerSessionsRequest
     * @return Result of the CreatePlayerSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidGameSessionStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the game instance. Resolve the conflict before retrying.
     * @throws GameSessionFullException
     *         The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreatePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePlayerSessionsResponse createPlayerSessions(CreatePlayerSessionsRequest createPlayerSessionsRequest)
            throws InternalServiceException, UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException,
            TerminalRoutingStrategyException, InvalidRequestException, NotFoundException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reserves open slots in a game session for a group of players. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. To add a single player to a game session, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html"
     * >CreatePlayerSession</a>
     * </p>
     * <p>
     * To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of
     * player data for each player ID.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for each player, and new <code>PlayerSession</code> objects
     * are returned with player session IDs. Each player references their player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlayerSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlayerSessionsRequest#builder()}
     * </p>
     *
     * @param createPlayerSessionsRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlayerSessionsInput.Builder} to create a
     *        request.
     * @return Result of the CreatePlayerSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidGameSessionStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the game instance. Resolve the conflict before retrying.
     * @throws GameSessionFullException
     *         The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreatePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePlayerSessionsResponse createPlayerSessions(
            Consumer<CreatePlayerSessionsRequest.Builder> createPlayerSessionsRequest) throws InternalServiceException,
            UnauthorizedException, InvalidGameSessionStatusException, GameSessionFullException, TerminalRoutingStrategyException,
            InvalidRequestException, NotFoundException, AwsServiceException, SdkClientException, GameLiftException {
        return createPlayerSessions(CreatePlayerSessionsRequest.builder().applyMutation(createPlayerSessionsRequest).build());
    }

    /**
     * <p>
     * Creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide
     * configuration settings and optional custom game logic for your game. The script is deployed when you create a
     * Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.
     * </p>
     * <p>
     * To create a new script record, specify a script name and provide the script file(s). The script files and all
     * dependencies must be zipped into a single file. You can pull the zip file from either of these locations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A locally available directory. Use the <i>ZipFile</i> parameter for this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the
     * <i>StorageLocation</i> parameter for this option. You'll need to have an Identity Access Management (IAM) role
     * that allows the Amazon GameLift service to access your S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the call is successful, a new script record is created with a unique script ID. If the script file is provided
     * as a local file, the file is uploaded to an Amazon GameLift-owned S3 bucket and the script record's storage
     * location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift accesses the
     * file at this storage location as needed for deployment.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set Up a Role for
     * Amazon GameLift Access</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createScriptRequest
     * @return Result of the CreateScript operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateScriptResponse createScript(CreateScriptRequest createScriptRequest) throws UnauthorizedException,
            InvalidRequestException, ConflictException, TaggingFailedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide
     * configuration settings and optional custom game logic for your game. The script is deployed when you create a
     * Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.
     * </p>
     * <p>
     * To create a new script record, specify a script name and provide the script file(s). The script files and all
     * dependencies must be zipped into a single file. You can pull the zip file from either of these locations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A locally available directory. Use the <i>ZipFile</i> parameter for this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the
     * <i>StorageLocation</i> parameter for this option. You'll need to have an Identity Access Management (IAM) role
     * that allows the Amazon GameLift service to access your S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the call is successful, a new script record is created with a unique script ID. If the script file is provided
     * as a local file, the file is uploaded to an Amazon GameLift-owned S3 bucket and the script record's storage
     * location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift accesses the
     * file at this storage location as needed for deployment.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set Up a Role for
     * Amazon GameLift Access</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScriptRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScriptRequest#builder()}
     * </p>
     *
     * @param createScriptRequest
     *        A {@link Consumer} that will call methods on {@link CreateScriptInput.Builder} to create a request.
     * @return Result of the CreateScript operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateScriptResponse createScript(Consumer<CreateScriptRequest.Builder> createScriptRequest)
            throws UnauthorizedException, InvalidRequestException, ConflictException, TaggingFailedException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return createScript(CreateScriptRequest.builder().applyMutation(createScriptRequest).build());
    }

    /**
     * <p>
     * Requests authorization to create or delete a peer connection between the VPC for your Amazon GameLift fleet and a
     * virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers on your
     * fleet to communicate directly with other Amazon Web Services resources. After you've received authorization, use
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html">
     * CreateVpcPeeringConnection</a> to establish the peering connection. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the
     * account that you use to manage your Amazon GameLift fleets. You cannot peer with VPCs that are in different
     * Regions.
     * </p>
     * <p>
     * To request authorization to create a connection, call this operation from the Amazon Web Services account with
     * the VPC that you want to peer to your Amazon GameLift fleet. For example, to enable your game servers to retrieve
     * data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following values:
     * (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that you use
     * to manage Amazon GameLift. If successful, VPC peering is authorized for the specified VPC.
     * </p>
     * <p>
     * To request authorization to delete a connection, call this operation from the Amazon Web Services account with
     * the VPC that is peered with your Amazon GameLift fleet. Identify the following values: (1) VPC ID that you want
     * to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to manage Amazon
     * GameLift.
     * </p>
     * <p>
     * The authorization remains valid for 24 hours unless it is canceled. You must create or delete the peering
     * connection while the authorization is valid.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createVpcPeeringAuthorizationRequest
     * @return Result of the CreateVpcPeeringAuthorization operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcPeeringAuthorizationResponse createVpcPeeringAuthorization(
            CreateVpcPeeringAuthorizationRequest createVpcPeeringAuthorizationRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests authorization to create or delete a peer connection between the VPC for your Amazon GameLift fleet and a
     * virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers on your
     * fleet to communicate directly with other Amazon Web Services resources. After you've received authorization, use
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html">
     * CreateVpcPeeringConnection</a> to establish the peering connection. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the
     * account that you use to manage your Amazon GameLift fleets. You cannot peer with VPCs that are in different
     * Regions.
     * </p>
     * <p>
     * To request authorization to create a connection, call this operation from the Amazon Web Services account with
     * the VPC that you want to peer to your Amazon GameLift fleet. For example, to enable your game servers to retrieve
     * data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following values:
     * (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that you use
     * to manage Amazon GameLift. If successful, VPC peering is authorized for the specified VPC.
     * </p>
     * <p>
     * To request authorization to delete a connection, call this operation from the Amazon Web Services account with
     * the VPC that is peered with your Amazon GameLift fleet. Identify the following values: (1) VPC ID that you want
     * to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to manage Amazon
     * GameLift.
     * </p>
     * <p>
     * The authorization remains valid for 24 hours unless it is canceled. You must create or delete the peering
     * connection while the authorization is valid.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcPeeringAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVpcPeeringAuthorizationRequest#builder()}
     * </p>
     *
     * @param createVpcPeeringAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcPeeringAuthorizationInput.Builder} to create
     *        a request.
     * @return Result of the CreateVpcPeeringAuthorization operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcPeeringAuthorizationResponse createVpcPeeringAuthorization(
            Consumer<CreateVpcPeeringAuthorizationRequest.Builder> createVpcPeeringAuthorizationRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return createVpcPeeringAuthorization(CreateVpcPeeringAuthorizationRequest.builder()
                .applyMutation(createVpcPeeringAuthorizationRequest).build());
    }

    /**
     * <p>
     * Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with
     * the VPC for your Amazon GameLift fleet. VPC peering enables the game servers on your fleet to communicate
     * directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that
     * you have access to, including the account that you use to manage your Amazon GameLift fleets. You cannot peer
     * with VPCs that are in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * Before calling this operation to establish the peering connection, you first need to use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a> and identify the VPC you want to peer with. Once the authorization for the
     * specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks
     * necessary to peer the two VPCs, including acceptance, updating routing tables, etc.
     * </p>
     * <p>
     * To establish the connection, call this operation from the Amazon Web Services account that is used to manage the
     * Amazon GameLift fleets. Identify the following values: (1) The ID of the fleet you want to be enable a VPC
     * peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3) The
     * ID of the VPC you want to peer with. This operation is asynchronous. If successful, a connection request is
     * created. You can use continuous polling to track the request's status using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html"
     * >DescribeVpcPeeringConnections</a> , or by monitoring fleet events for success or failure using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a> .
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return Result of the CreateVpcPeeringConnection operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcPeeringConnectionResponse createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with
     * the VPC for your Amazon GameLift fleet. VPC peering enables the game servers on your fleet to communicate
     * directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that
     * you have access to, including the account that you use to manage your Amazon GameLift fleets. You cannot peer
     * with VPCs that are in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * Before calling this operation to establish the peering connection, you first need to use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a> and identify the VPC you want to peer with. Once the authorization for the
     * specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks
     * necessary to peer the two VPCs, including acceptance, updating routing tables, etc.
     * </p>
     * <p>
     * To establish the connection, call this operation from the Amazon Web Services account that is used to manage the
     * Amazon GameLift fleets. Identify the following values: (1) The ID of the fleet you want to be enable a VPC
     * peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3) The
     * ID of the VPC you want to peer with. This operation is asynchronous. If successful, a connection request is
     * created. You can use continuous polling to track the request's status using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html"
     * >DescribeVpcPeeringConnections</a> , or by monitoring fleet events for success or failure using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a> .
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcPeeringConnectionInput.Builder} to create a
     *        request.
     * @return Result of the CreateVpcPeeringConnection operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcPeeringConnectionResponse createVpcPeeringConnection(
            Consumer<CreateVpcPeeringConnectionRequest.Builder> createVpcPeeringConnectionRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return createVpcPeeringConnection(CreateVpcPeeringConnectionRequest.builder()
                .applyMutation(createVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server
     * process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteAliasRequest
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws UnauthorizedException,
            NotFoundException, InvalidRequestException, TaggingFailedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server
     * process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAliasInput.Builder} to create a request.
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest)
            throws UnauthorizedException, NotFoundException, InvalidRequestException, TaggingFailedException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a
     * build does not affect the status of any active fleets using the build, but you can no longer create new fleets
     * with the deleted build.
     * </p>
     * <p>
     * To delete a build, specify the build ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteBuildRequest
     * @return Result of the DeleteBuild operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBuildResponse deleteBuild(DeleteBuildRequest deleteBuildRequest) throws UnauthorizedException,
            NotFoundException, InternalServiceException, TaggingFailedException, InvalidRequestException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a
     * build does not affect the status of any active fleets using the build, but you can no longer create new fleets
     * with the deleted build.
     * </p>
     * <p>
     * To delete a build, specify the build ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBuildRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBuildRequest#builder()}
     * </p>
     *
     * @param deleteBuildRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBuildInput.Builder} to create a request.
     * @return Result of the DeleteBuild operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBuildResponse deleteBuild(Consumer<DeleteBuildRequest.Builder> deleteBuildRequest)
            throws UnauthorizedException, NotFoundException, InternalServiceException, TaggingFailedException,
            InvalidRequestException, AwsServiceException, SdkClientException, GameLiftException {
        return deleteBuild(DeleteBuildRequest.builder().applyMutation(deleteBuildRequest).build());
    }

    /**
     * <p>
     * Deletes all resources and information related a fleet. Any current fleet instances, including those in remote
     * locations, are shut down. You don't need to call <code>DeleteFleetLocations</code> separately.
     * </p>
     * <note>
     * <p>
     * If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24
     * hours) by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a>. You do not need to explicitly delete the VPC peering connection.
     * </p>
     * </note>
     * <p>
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process the fleet status is changed
     * to <code>DELETING</code>. When completed, the status switches to <code>TERMINATED</code> and the fleet event
     * <code>FLEET_DELETED</code> is sent.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidFleetStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the fleet. Resolve the conflict before retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws NotFoundException,
            InternalServiceException, InvalidFleetStatusException, UnauthorizedException, InvalidRequestException,
            TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all resources and information related a fleet. Any current fleet instances, including those in remote
     * locations, are shut down. You don't need to call <code>DeleteFleetLocations</code> separately.
     * </p>
     * <note>
     * <p>
     * If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24
     * hours) by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a>. You do not need to explicitly delete the VPC peering connection.
     * </p>
     * </note>
     * <p>
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process the fleet status is changed
     * to <code>DELETING</code>. When completed, the status switches to <code>TERMINATED</code> and the fleet event
     * <code>FLEET_DELETED</code> is sent.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetInput.Builder} to create a request.
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidFleetStatusException
     *         The requested operation would cause a conflict with the current state of a resource associated with the
     *         request and/or the fleet. Resolve the conflict before retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) throws NotFoundException,
            InternalServiceException, InvalidFleetStatusException, UnauthorizedException, InvalidRequestException,
            TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Removes locations from a multi-location fleet. When deleting a location, all game server process and all
     * instances that are still active in the location are shut down.
     * </p>
     * <p>
     * To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.
     * </p>
     * <p>
     * If successful, GameLift sets the location status to <code>DELETING</code>, and begins to shut down existing
     * server processes and terminate instances in each location being deleted. When completed, the location status
     * changes to <code>TERMINATED</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param deleteFleetLocationsRequest
     * @return Result of the DeleteFleetLocations operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFleetLocationsResponse deleteFleetLocations(DeleteFleetLocationsRequest deleteFleetLocationsRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes locations from a multi-location fleet. When deleting a location, all game server process and all
     * instances that are still active in the location are shut down.
     * </p>
     * <p>
     * To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.
     * </p>
     * <p>
     * If successful, GameLift sets the location status to <code>DELETING</code>, and begins to shut down existing
     * server processes and terminate instances in each location being deleted. When completed, the location status
     * changes to <code>TERMINATED</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFleetLocationsRequest#builder()}
     * </p>
     *
     * @param deleteFleetLocationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetLocationsInput.Builder} to create a
     *        request.
     * @return Result of the DeleteFleetLocations operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFleetLocationsResponse deleteFleetLocations(
            Consumer<DeleteFleetLocationsRequest.Builder> deleteFleetLocationsRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return deleteFleetLocations(DeleteFleetLocationsRequest.builder().applyMutation(deleteFleetLocationsRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Terminates a game server group and permanently deletes the game server group record. You have several options for
     * how these resources are impacted when deleting the game server group. Depending on the type of delete operation
     * selected, this operation might affect these resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The game server group
     * </p>
     * </li>
     * <li>
     * <p>
     * The corresponding Auto Scaling group
     * </p>
     * </li>
     * <li>
     * <p>
     * All game servers that are currently running in the group
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a game server group, identify the game server group to delete and specify the type of delete operation
     * to initiate. Game server groups can only be deleted if they are in <code>ACTIVE</code> or <code>ERROR</code>
     * status.
     * </p>
     * <p>
     * If the delete request is successful, a series of operations are kicked off. The game server group status is
     * changed to <code>DELETE_SCHEDULED</code>, which prevents new game servers from being registered and stops
     * automatic scaling activity. Once all game servers in the game server group are deregistered, Amazon GameLift
     * FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is placed in
     * <code>ERROR</code> status.
     * </p>
     * <p>
     * Amazon GameLift FleetIQ emits delete events to Amazon CloudWatch.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param deleteGameServerGroupRequest
     * @return Result of the DeleteGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGameServerGroupResponse deleteGameServerGroup(DeleteGameServerGroupRequest deleteGameServerGroupRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Terminates a game server group and permanently deletes the game server group record. You have several options for
     * how these resources are impacted when deleting the game server group. Depending on the type of delete operation
     * selected, this operation might affect these resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The game server group
     * </p>
     * </li>
     * <li>
     * <p>
     * The corresponding Auto Scaling group
     * </p>
     * </li>
     * <li>
     * <p>
     * All game servers that are currently running in the group
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a game server group, identify the game server group to delete and specify the type of delete operation
     * to initiate. Game server groups can only be deleted if they are in <code>ACTIVE</code> or <code>ERROR</code>
     * status.
     * </p>
     * <p>
     * If the delete request is successful, a series of operations are kicked off. The game server group status is
     * changed to <code>DELETE_SCHEDULED</code>, which prevents new game servers from being registered and stops
     * automatic scaling activity. Once all game servers in the game server group are deregistered, Amazon GameLift
     * FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is placed in
     * <code>ERROR</code> status.
     * </p>
     * <p>
     * Amazon GameLift FleetIQ emits delete events to Amazon CloudWatch.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGameServerGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGameServerGroupRequest#builder()}
     * </p>
     *
     * @param deleteGameServerGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGameServerGroupInput.Builder} to create a
     *        request.
     * @return Result of the DeleteGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGameServerGroupResponse deleteGameServerGroup(
            Consumer<DeleteGameServerGroupRequest.Builder> deleteGameServerGroupRequest) throws InvalidRequestException,
            NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return deleteGameServerGroup(DeleteGameServerGroupRequest.builder().applyMutation(deleteGameServerGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a game session queue. Once a queue is successfully deleted, unfulfilled <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> requests that reference the queue will fail. To delete a queue, specify the queue
     * name.
     * </p>
     *
     * @param deleteGameSessionQueueRequest
     * @return Result of the DeleteGameSessionQueue operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGameSessionQueueResponse deleteGameSessionQueue(DeleteGameSessionQueueRequest deleteGameSessionQueueRequest)
            throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException,
            TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a game session queue. Once a queue is successfully deleted, unfulfilled <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> requests that reference the queue will fail. To delete a queue, specify the queue
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGameSessionQueueRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGameSessionQueueRequest#builder()}
     * </p>
     *
     * @param deleteGameSessionQueueRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGameSessionQueueInput.Builder} to create a
     *        request.
     * @return Result of the DeleteGameSessionQueue operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGameSessionQueueResponse deleteGameSessionQueue(
            Consumer<DeleteGameSessionQueueRequest.Builder> deleteGameSessionQueueRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, TaggingFailedException, AwsServiceException,
            SdkClientException, GameLiftException {
        return deleteGameSessionQueue(DeleteGameSessionQueueRequest.builder().applyMutation(deleteGameSessionQueueRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom location.
     * </p>
     * <p>
     * Before deleting a custom location, review any fleets currently using the custom location and deregister the
     * location if it is in use. For more information see, <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html">DeregisterCompute</a>.
     * </p>
     *
     * @param deleteLocationRequest
     * @return Result of the DeleteLocation operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLocationResponse deleteLocation(DeleteLocationRequest deleteLocationRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom location.
     * </p>
     * <p>
     * Before deleting a custom location, review any fleets currently using the custom location and deregister the
     * location if it is in use. For more information see, <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html">DeregisterCompute</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLocationRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLocationRequest#builder()}
     * </p>
     *
     * @param deleteLocationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLocationInput.Builder} to create a request.
     * @return Result of the DeleteLocation operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLocationResponse deleteLocation(Consumer<DeleteLocationRequest.Builder> deleteLocationRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return deleteLocation(DeleteLocationRequest.builder().applyMutation(deleteLocationRequest).build());
    }

    /**
     * <p>
     * Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A
     * matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.
     * </p>
     *
     * @param deleteMatchmakingConfigurationRequest
     * @return Result of the DeleteMatchmakingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMatchmakingConfigurationResponse deleteMatchmakingConfiguration(
            DeleteMatchmakingConfigurationRequest deleteMatchmakingConfigurationRequest) throws InvalidRequestException,
            NotFoundException, InternalServiceException, UnsupportedRegionException, TaggingFailedException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A
     * matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMatchmakingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMatchmakingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteMatchmakingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMatchmakingConfigurationInput.Builder} to create
     *        a request.
     * @return Result of the DeleteMatchmakingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMatchmakingConfigurationResponse deleteMatchmakingConfiguration(
            Consumer<DeleteMatchmakingConfigurationRequest.Builder> deleteMatchmakingConfigurationRequest)
            throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            TaggingFailedException, AwsServiceException, SdkClientException, GameLiftException {
        return deleteMatchmakingConfiguration(DeleteMatchmakingConfigurationRequest.builder()
                .applyMutation(deleteMatchmakingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be
     * deleted if they are currently being used by a matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteMatchmakingRuleSetRequest
     * @return Result of the DeleteMatchmakingRuleSet operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMatchmakingRuleSetResponse deleteMatchmakingRuleSet(
            DeleteMatchmakingRuleSetRequest deleteMatchmakingRuleSetRequest) throws InvalidRequestException,
            InternalServiceException, UnsupportedRegionException, NotFoundException, TaggingFailedException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be
     * deleted if they are currently being used by a matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMatchmakingRuleSetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMatchmakingRuleSetRequest#builder()}
     * </p>
     *
     * @param deleteMatchmakingRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMatchmakingRuleSetInput.Builder} to create a
     *        request.
     * @return Result of the DeleteMatchmakingRuleSet operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMatchmakingRuleSetResponse deleteMatchmakingRuleSet(
            Consumer<DeleteMatchmakingRuleSetRequest.Builder> deleteMatchmakingRuleSetRequest) throws InvalidRequestException,
            InternalServiceException, UnsupportedRegionException, NotFoundException, TaggingFailedException, AwsServiceException,
            SdkClientException, GameLiftException {
        return deleteMatchmakingRuleSet(DeleteMatchmakingRuleSetRequest.builder().applyMutation(deleteMatchmakingRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and Amazon GameLift removes all
     * record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated
     * with.
     * </p>
     * <p>
     * To temporarily suspend scaling policies, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html">StopFleetActions</a>.
     * This operation suspends all policies for the fleet.
     * </p>
     *
     * @param deleteScalingPolicyRequest
     * @return Result of the DeleteScalingPolicy operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteScalingPolicyResponse deleteScalingPolicy(DeleteScalingPolicyRequest deleteScalingPolicyRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and Amazon GameLift removes all
     * record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated
     * with.
     * </p>
     * <p>
     * To temporarily suspend scaling policies, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html">StopFleetActions</a>.
     * This operation suspends all policies for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScalingPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScalingPolicyRequest#builder()}
     * </p>
     *
     * @param deleteScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScalingPolicyInput.Builder} to create a request.
     * @return Result of the DeleteScalingPolicy operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteScalingPolicyResponse deleteScalingPolicy(
            Consumer<DeleteScalingPolicyRequest.Builder> deleteScalingPolicyRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, AwsServiceException, SdkClientException,
            GameLiftException {
        return deleteScalingPolicy(DeleteScalingPolicyRequest.builder().applyMutation(deleteScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded,
     * they are also deleted (files stored in an S3 bucket are not deleted).
     * </p>
     * <p>
     * To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are
     * deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script
     * record no longer exists, the instance will go into an error state and be unable to host game sessions.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteScriptRequest
     * @return Result of the DeleteScript operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScript" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScriptResponse deleteScript(DeleteScriptRequest deleteScriptRequest) throws InvalidRequestException,
            UnauthorizedException, NotFoundException, TaggingFailedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded,
     * they are also deleted (files stored in an S3 bucket are not deleted).
     * </p>
     * <p>
     * To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are
     * deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script
     * record no longer exists, the instance will go into an error state and be unable to host game sessions.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScriptRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScriptRequest#builder()}
     * </p>
     *
     * @param deleteScriptRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScriptInput.Builder} to create a request.
     * @return Result of the DeleteScript operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScript" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScriptResponse deleteScript(Consumer<DeleteScriptRequest.Builder> deleteScriptRequest)
            throws InvalidRequestException, UnauthorizedException, NotFoundException, TaggingFailedException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return deleteScript(DeleteScriptRequest.builder().applyMutation(deleteScriptRequest).build());
    }

    /**
     * <p>
     * Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering
     * connection, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html"
     * >DeleteVpcPeeringConnection</a>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteVpcPeeringAuthorizationRequest
     * @return Result of the DeleteVpcPeeringAuthorization operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcPeeringAuthorizationResponse deleteVpcPeeringAuthorization(
            DeleteVpcPeeringAuthorizationRequest deleteVpcPeeringAuthorizationRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering
     * connection, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html"
     * >DeleteVpcPeeringConnection</a>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcPeeringAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVpcPeeringAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteVpcPeeringAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcPeeringAuthorizationInput.Builder} to create
     *        a request.
     * @return Result of the DeleteVpcPeeringAuthorization operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcPeeringAuthorizationResponse deleteVpcPeeringAuthorization(
            Consumer<DeleteVpcPeeringAuthorizationRequest.Builder> deleteVpcPeeringAuthorizationRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return deleteVpcPeeringAuthorization(DeleteVpcPeeringAuthorizationRequest.builder()
                .applyMutation(deleteVpcPeeringAuthorizationRequest).build());
    }

    /**
     * <p>
     * Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC
     * peering connection that you want to delete..
     * </p>
     * <p>
     * Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Identify the connection to delete by the connection ID and fleet ID. If
     * successful, the connection is removed.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     * @return Result of the DeleteVpcPeeringConnection operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC
     * peering connection that you want to delete..
     * </p>
     * <p>
     * Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Identify the connection to delete by the connection ID and fleet ID. If
     * successful, the connection is removed.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcPeeringConnectionInput.Builder} to create a
     *        request.
     * @return Result of the DeleteVpcPeeringConnection operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnection(
            Consumer<DeleteVpcPeeringConnectionRequest.Builder> deleteVpcPeeringConnectionRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest.builder()
                .applyMutation(deleteVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Removes a compute resource from the specified fleet. Deregister your compute resources before you delete the
     * compute.
     * </p>
     *
     * @param deregisterComputeRequest
     * @return Result of the DeregisterCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeregisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterCompute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterComputeResponse deregisterCompute(DeregisterComputeRequest deregisterComputeRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a compute resource from the specified fleet. Deregister your compute resources before you delete the
     * compute.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterComputeRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterComputeRequest#builder()}
     * </p>
     *
     * @param deregisterComputeRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterComputeInput.Builder} to create a request.
     * @return Result of the DeregisterCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeregisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterCompute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterComputeResponse deregisterCompute(Consumer<DeregisterComputeRequest.Builder> deregisterComputeRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return deregisterCompute(DeregisterComputeRequest.builder().applyMutation(deregisterComputeRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Removes the game server from a game server group. As a result of this operation, the deregistered game server can
     * no longer be claimed and will not be returned in a list of active game servers.
     * </p>
     * <p>
     * To deregister a game server, specify the game server group and game server ID. If successful, this operation
     * emits a CloudWatch event with termination timestamp and reason.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param deregisterGameServerRequest
     * @return Result of the DeregisterGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeregisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterGameServerResponse deregisterGameServer(DeregisterGameServerRequest deregisterGameServerRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Removes the game server from a game server group. As a result of this operation, the deregistered game server can
     * no longer be claimed and will not be returned in a list of active game servers.
     * </p>
     * <p>
     * To deregister a game server, specify the game server group and game server ID. If successful, this operation
     * emits a CloudWatch event with termination timestamp and reason.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterGameServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterGameServerRequest#builder()}
     * </p>
     *
     * @param deregisterGameServerRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterGameServerInput.Builder} to create a
     *        request.
     * @return Result of the DeregisterGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DeregisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterGameServerResponse deregisterGameServer(
            Consumer<DeregisterGameServerRequest.Builder> deregisterGameServerRequest) throws InvalidRequestException,
            NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return deregisterGameServer(DeregisterGameServerRequest.builder().applyMutation(deregisterGameServerRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's
     * target fleet ID only, use <code>ResolveAlias</code>.
     * </p>
     * <p>
     * To get alias properties, specify the alias ID. If successful, the requested alias record is returned.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeAliasRequest
     * @return Result of the DescribeAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAliasResponse describeAlias(DescribeAliasRequest describeAliasRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's
     * target fleet ID only, use <code>ResolveAlias</code>.
     * </p>
     * <p>
     * To get alias properties, specify the alias ID. If successful, the requested alias record is returned.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAliasRequest#builder()}
     * </p>
     *
     * @param describeAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAliasInput.Builder} to create a request.
     * @return Result of the DescribeAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAliasResponse describeAlias(Consumer<DescribeAliasRequest.Builder> describeAliasRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeAlias(DescribeAliasRequest.builder().applyMutation(describeAliasRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an
     * object containing the build properties is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeBuildRequest
     * @return Result of the DescribeBuild operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBuildResponse describeBuild(DescribeBuildRequest describeBuildRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an
     * object containing the build properties is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBuildRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBuildRequest#builder()}
     * </p>
     *
     * @param describeBuildRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBuildInput.Builder} to create a request.
     * @return Result of the DescribeBuild operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBuildResponse describeBuild(Consumer<DescribeBuildRequest.Builder> describeBuildRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeBuild(DescribeBuildRequest.builder().applyMutation(describeBuildRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for a compute resource. To request a compute resource specify the fleet ID and compute name.
     * If successful, Amazon GameLift returns an object containing the build properties.
     * </p>
     *
     * @param describeComputeRequest
     * @return Result of the DescribeCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeComputeResponse describeCompute(DescribeComputeRequest describeComputeRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for a compute resource. To request a compute resource specify the fleet ID and compute name.
     * If successful, Amazon GameLift returns an object containing the build properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComputeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeComputeRequest#builder()}
     * </p>
     *
     * @param describeComputeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeComputeInput.Builder} to create a request.
     * @return Result of the DescribeCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeComputeResponse describeCompute(Consumer<DescribeComputeRequest.Builder> describeComputeRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeCompute(DescribeComputeRequest.builder().applyMutation(describeComputeRequest).build());
    }

    /**
     * <p>
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance
     * limits control the number of instances, per instance type, per location, that your Amazon Web Services account
     * can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The
     * information returned includes the maximum number of instances allowed and your account's current usage across all
     * fleets. This information can affect your ability to scale your Amazon GameLift fleets. You can request a limit
     * increase for your account by using the <b>Service limits</b> page in the Amazon GameLift console.
     * </p>
     * <p>
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote
     * location. For remote locations, limits also differ based on the combination of home Region and remote location.
     * All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get
     * the limit for a remote location, you must also specify the location. For example, the following requests all
     * return different results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on
     * all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in
     * <code>ap-northeast-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to
     * <code>ca-central-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>eu-west-1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets
     * that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve
     * information for.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside
     * in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location.
     * Optionally, specify a single instance type to retrieve information for.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested
     * instance type.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @return Result of the DescribeEC2InstanceLimits operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeEC2InstanceLimits
     * @see #describeEC2InstanceLimits(DescribeEc2InstanceLimitsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEc2InstanceLimitsResponse describeEC2InstanceLimits() throws InvalidRequestException,
            InternalServiceException, UnauthorizedException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeEC2InstanceLimits(DescribeEc2InstanceLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance
     * limits control the number of instances, per instance type, per location, that your Amazon Web Services account
     * can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The
     * information returned includes the maximum number of instances allowed and your account's current usage across all
     * fleets. This information can affect your ability to scale your Amazon GameLift fleets. You can request a limit
     * increase for your account by using the <b>Service limits</b> page in the Amazon GameLift console.
     * </p>
     * <p>
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote
     * location. For remote locations, limits also differ based on the combination of home Region and remote location.
     * All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get
     * the limit for a remote location, you must also specify the location. For example, the following requests all
     * return different results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on
     * all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in
     * <code>ap-northeast-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to
     * <code>ca-central-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>eu-west-1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets
     * that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve
     * information for.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside
     * in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location.
     * Optionally, specify a single instance type to retrieve information for.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested
     * instance type.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeEc2InstanceLimitsRequest
     * @return Result of the DescribeEC2InstanceLimits operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeEC2InstanceLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEc2InstanceLimitsResponse describeEC2InstanceLimits(
            DescribeEc2InstanceLimitsRequest describeEc2InstanceLimitsRequest) throws InvalidRequestException,
            InternalServiceException, UnauthorizedException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance
     * limits control the number of instances, per instance type, per location, that your Amazon Web Services account
     * can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The
     * information returned includes the maximum number of instances allowed and your account's current usage across all
     * fleets. This information can affect your ability to scale your Amazon GameLift fleets. You can request a limit
     * increase for your account by using the <b>Service limits</b> page in the Amazon GameLift console.
     * </p>
     * <p>
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote
     * location. For remote locations, limits also differ based on the combination of home Region and remote location.
     * All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get
     * the limit for a remote location, you must also specify the location. For example, the following requests all
     * return different results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on
     * all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in
     * <code>ap-northeast-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to
     * <code>ca-central-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>eu-west-1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets
     * that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve
     * information for.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside
     * in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location.
     * Optionally, specify a single instance type to retrieve information for.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested
     * instance type.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEc2InstanceLimitsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEc2InstanceLimitsRequest#builder()}
     * </p>
     *
     * @param describeEc2InstanceLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEC2InstanceLimitsInput.Builder} to create a
     *        request.
     * @return Result of the DescribeEC2InstanceLimits operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeEC2InstanceLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEc2InstanceLimitsResponse describeEC2InstanceLimits(
            Consumer<DescribeEc2InstanceLimitsRequest.Builder> describeEc2InstanceLimitsRequest) throws InvalidRequestException,
            InternalServiceException, UnauthorizedException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeEC2InstanceLimits(DescribeEc2InstanceLimitsRequest.builder()
                .applyMutation(describeEc2InstanceLimitsRequest).build());
    }

    /**
     * <p>
     * Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all
     * instances in the fleet.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @return Result of the DescribeFleetAttributes operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetAttributes
     * @see #describeFleetAttributes(DescribeFleetAttributesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesResponse describeFleetAttributes() throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetAttributes(DescribeFleetAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all
     * instances in the fleet.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeFleetAttributesRequest
     * @return Result of the DescribeFleetAttributes operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesResponse describeFleetAttributes(DescribeFleetAttributesRequest describeFleetAttributesRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all
     * instances in the fleet.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetAttributesInput.Builder} to create a
     *        request.
     * @return Result of the DescribeFleetAttributes operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesResponse describeFleetAttributes(
            Consumer<DescribeFleetAttributesRequest.Builder> describeFleetAttributesRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetAttributes(DescribeFleetAttributesRequest.builder().applyMutation(describeFleetAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all
     * instances in the fleet.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client.describeFleetAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client
     *             .describeFleetAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client.describeFleetAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetAttributes
     * @see #describeFleetAttributesPaginator(DescribeFleetAttributesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesIterable describeFleetAttributesPaginator() throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetAttributesPaginator(DescribeFleetAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all
     * instances in the fleet.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client.describeFleetAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client
     *             .describeFleetAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client.describeFleetAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesIterable describeFleetAttributesPaginator(
            DescribeFleetAttributesRequest describeFleetAttributesRequest) throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all
     * instances in the fleet.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client.describeFleetAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client
     *             .describeFleetAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesIterable responses = client.describeFleetAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetAttributesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesIterable describeFleetAttributesPaginator(
            Consumer<DescribeFleetAttributesRequest.Builder> describeFleetAttributesRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetAttributesPaginator(DescribeFleetAttributesRequest.builder()
                .applyMutation(describeFleetAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. The data returned includes the current fleet
     * capacity (number of EC2 instances), and settings that can control how capacity scaling. For fleets with remote
     * locations, this operation retrieves data for the fleet's home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each FleetCapacity
     * object includes a <code>Location</code> property, which is set to the fleet's home Region. When a list of fleet
     * IDs is provided, attribute objects are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @return Result of the DescribeFleetCapacity operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetCapacity
     * @see #describeFleetCapacity(DescribeFleetCapacityRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityResponse describeFleetCapacity() throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetCapacity(DescribeFleetCapacityRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. The data returned includes the current fleet
     * capacity (number of EC2 instances), and settings that can control how capacity scaling. For fleets with remote
     * locations, this operation retrieves data for the fleet's home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each FleetCapacity
     * object includes a <code>Location</code> property, which is set to the fleet's home Region. When a list of fleet
     * IDs is provided, attribute objects are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetCapacityRequest
     * @return Result of the DescribeFleetCapacity operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityResponse describeFleetCapacity(DescribeFleetCapacityRequest describeFleetCapacityRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. The data returned includes the current fleet
     * capacity (number of EC2 instances), and settings that can control how capacity scaling. For fleets with remote
     * locations, this operation retrieves data for the fleet's home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each FleetCapacity
     * object includes a <code>Location</code> property, which is set to the fleet's home Region. When a list of fleet
     * IDs is provided, attribute objects are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetCapacityRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetCapacityRequest#builder()}
     * </p>
     *
     * @param describeFleetCapacityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetCapacityInput.Builder} to create a
     *        request.
     * @return Result of the DescribeFleetCapacity operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityResponse describeFleetCapacity(
            Consumer<DescribeFleetCapacityRequest.Builder> describeFleetCapacityRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetCapacity(DescribeFleetCapacityRequest.builder().applyMutation(describeFleetCapacityRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. The data returned includes the current fleet
     * capacity (number of EC2 instances), and settings that can control how capacity scaling. For fleets with remote
     * locations, this operation retrieves data for the fleet's home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each FleetCapacity
     * object includes a <code>Location</code> property, which is set to the fleet's home Region. When a list of fleet
     * IDs is provided, attribute objects are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client.describeFleetCapacityPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client
     *             .describeFleetCapacityPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client.describeFleetCapacityPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetCapacity
     * @see #describeFleetCapacityPaginator(DescribeFleetCapacityRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityIterable describeFleetCapacityPaginator() throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetCapacityPaginator(DescribeFleetCapacityRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. The data returned includes the current fleet
     * capacity (number of EC2 instances), and settings that can control how capacity scaling. For fleets with remote
     * locations, this operation retrieves data for the fleet's home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each FleetCapacity
     * object includes a <code>Location</code> property, which is set to the fleet's home Region. When a list of fleet
     * IDs is provided, attribute objects are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client.describeFleetCapacityPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client
     *             .describeFleetCapacityPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client.describeFleetCapacityPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetCapacityRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityIterable describeFleetCapacityPaginator(DescribeFleetCapacityRequest describeFleetCapacityRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. The data returned includes the current fleet
     * capacity (number of EC2 instances), and settings that can control how capacity scaling. For fleets with remote
     * locations, this operation retrieves data for the fleet's home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each FleetCapacity
     * object includes a <code>Location</code> property, which is set to the fleet's home Region. When a list of fleet
     * IDs is provided, attribute objects are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client.describeFleetCapacityPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client
     *             .describeFleetCapacityPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityIterable responses = client.describeFleetCapacityPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetCapacityRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetCapacityRequest#builder()}
     * </p>
     *
     * @param describeFleetCapacityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetCapacityInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityIterable describeFleetCapacityPaginator(
            Consumer<DescribeFleetCapacityRequest.Builder> describeFleetCapacityRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetCapacityPaginator(DescribeFleetCapacityRequest.builder().applyMutation(describeFleetCapacityRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet
     * creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated
     * by changes to status and capacity in remote locations.
     * </p>
     * <p>
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set
     * of sequential pages.
     * </p>
     * <p>
     * If successful, a collection of event log entries matching the request are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeFleetEventsRequest
     * @return Result of the DescribeFleetEvents operation returned by the service.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetEventsResponse describeFleetEvents(DescribeFleetEventsRequest describeFleetEventsRequest)
            throws NotFoundException, InternalServiceException, UnauthorizedException, InvalidRequestException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet
     * creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated
     * by changes to status and capacity in remote locations.
     * </p>
     * <p>
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set
     * of sequential pages.
     * </p>
     * <p>
     * If successful, a collection of event log entries matching the request are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetEventsRequest#builder()}
     * </p>
     *
     * @param describeFleetEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetEventsInput.Builder} to create a request.
     * @return Result of the DescribeFleetEvents operation returned by the service.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetEventsResponse describeFleetEvents(
            Consumer<DescribeFleetEventsRequest.Builder> describeFleetEventsRequest) throws NotFoundException,
            InternalServiceException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetEvents(DescribeFleetEventsRequest.builder().applyMutation(describeFleetEventsRequest).build());
    }

    /**
     * <p>
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet
     * creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated
     * by changes to status and capacity in remote locations.
     * </p>
     * <p>
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set
     * of sequential pages.
     * </p>
     * <p>
     * If successful, a collection of event log entries matching the request are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsIterable responses = client.describeFleetEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsIterable responses = client
     *             .describeFleetEventsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsIterable responses = client.describeFleetEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetEventsIterable describeFleetEventsPaginator(DescribeFleetEventsRequest describeFleetEventsRequest)
            throws NotFoundException, InternalServiceException, UnauthorizedException, InvalidRequestException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet
     * creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated
     * by changes to status and capacity in remote locations.
     * </p>
     * <p>
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set
     * of sequential pages.
     * </p>
     * <p>
     * If successful, a collection of event log entries matching the request are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsIterable responses = client.describeFleetEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsIterable responses = client
     *             .describeFleetEventsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsIterable responses = client.describeFleetEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetEventsRequest#builder()}
     * </p>
     *
     * @param describeFleetEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetEventsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetEventsIterable describeFleetEventsPaginator(
            Consumer<DescribeFleetEventsRequest.Builder> describeFleetEventsRequest) throws NotFoundException,
            InternalServiceException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetEventsPaginator(DescribeFleetEventsRequest.builder().applyMutation(describeFleetEventsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet
     * activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned
     * in the order that it is requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet
     * does not have a requested location, no information is returned. This operation does not return the home Region.
     * To get information on a fleet's home Region, call <code>DescribeFleetAttributes</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     * @return Result of the DescribeFleetLocationAttributes operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationAttributesResponse describeFleetLocationAttributes(
            DescribeFleetLocationAttributesRequest describeFleetLocationAttributesRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet
     * activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned
     * in the order that it is requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet
     * does not have a requested location, no information is returned. This operation does not return the home Region.
     * To get information on a fleet's home Region, call <code>DescribeFleetAttributes</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetLocationAttributesInput.Builder} to
     *        create a request.
     * @return Result of the DescribeFleetLocationAttributes operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationAttributesResponse describeFleetLocationAttributes(
            Consumer<DescribeFleetLocationAttributesRequest.Builder> describeFleetLocationAttributesRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetLocationAttributes(DescribeFleetLocationAttributesRequest.builder()
                .applyMutation(describeFleetLocationAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet
     * activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned
     * in the order that it is requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet
     * does not have a requested location, no information is returned. This operation does not return the home Region.
     * To get information on a fleet's home Region, call <code>DescribeFleetAttributes</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesIterable responses = client.describeFleetLocationAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesIterable responses = client
     *             .describeFleetLocationAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesIterable responses = client.describeFleetLocationAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationAttributesIterable describeFleetLocationAttributesPaginator(
            DescribeFleetLocationAttributesRequest describeFleetLocationAttributesRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet
     * activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned
     * in the order that it is requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet
     * does not have a requested location, no information is returned. This operation does not return the home Region.
     * To get information on a fleet's home Region, call <code>DescribeFleetAttributes</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesIterable responses = client.describeFleetLocationAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesIterable responses = client
     *             .describeFleetLocationAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesIterable responses = client.describeFleetLocationAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetLocationAttributesInput.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationAttributesIterable describeFleetLocationAttributesPaginator(
            Consumer<DescribeFleetLocationAttributesRequest.Builder> describeFleetLocationAttributesRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetLocationAttributesPaginator(DescribeFleetLocationAttributesRequest.builder()
                .applyMutation(describeFleetLocationAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity
     * (number of EC2 instances) and some scaling settings for the requested fleet location. Use this operation to
     * retrieve capacity information for a fleet's remote location or home Region (you can also retrieve home Region
     * capacity by calling <code>DescribeFleetCapacity</code>).
     * </p>
     * <p>
     * To retrieve capacity data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetLocationCapacityRequest
     * @return Result of the DescribeFleetLocationCapacity operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationCapacityResponse describeFleetLocationCapacity(
            DescribeFleetLocationCapacityRequest describeFleetLocationCapacityRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity
     * (number of EC2 instances) and some scaling settings for the requested fleet location. Use this operation to
     * retrieve capacity information for a fleet's remote location or home Region (you can also retrieve home Region
     * capacity by calling <code>DescribeFleetCapacity</code>).
     * </p>
     * <p>
     * To retrieve capacity data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationCapacityRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationCapacityRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationCapacityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetLocationCapacityInput.Builder} to create
     *        a request.
     * @return Result of the DescribeFleetLocationCapacity operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationCapacityResponse describeFleetLocationCapacity(
            Consumer<DescribeFleetLocationCapacityRequest.Builder> describeFleetLocationCapacityRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetLocationCapacity(DescribeFleetLocationCapacityRequest.builder()
                .applyMutation(describeFleetLocationCapacityRequest).build());
    }

    /**
     * <p>
     * Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting
     * activity at the requested location. Use this operation to retrieve utilization information for a fleet's remote
     * location or home Region (you can also retrieve home Region utilization by calling
     * <code>DescribeFleetUtilization</code>).
     * </p>
     * <p>
     * To retrieve utilization data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetUtilization</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetLocationUtilizationRequest
     * @return Result of the DescribeFleetLocationUtilization operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationUtilizationResponse describeFleetLocationUtilization(
            DescribeFleetLocationUtilizationRequest describeFleetLocationUtilizationRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting
     * activity at the requested location. Use this operation to retrieve utilization information for a fleet's remote
     * location or home Region (you can also retrieve home Region utilization by calling
     * <code>DescribeFleetUtilization</code>).
     * </p>
     * <p>
     * To retrieve utilization data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetUtilization</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationUtilizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationUtilizationRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationUtilizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetLocationUtilizationInput.Builder} to
     *        create a request.
     * @return Result of the DescribeFleetLocationUtilization operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetLocationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationUtilizationResponse describeFleetLocationUtilization(
            Consumer<DescribeFleetLocationUtilizationRequest.Builder> describeFleetLocationUtilizationRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetLocationUtilization(DescribeFleetLocationUtilizationRequest.builder()
                .applyMutation(describeFleetLocationUtilizationRequest).build());
    }

    /**
     * <p>
     * Retrieves a fleet's inbound connection permissions. Connection permissions specify the range of IP addresses and
     * port settings that incoming traffic can use to access server processes in the fleet. Game sessions that are
     * running on instances in the fleet must use connections that fall in this range.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve the inbound connection permissions for a fleet, identify the fleet's unique identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port
     * setting updates can take time to propagate across all locations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a set of <code>IpPermission</code> objects is returned for the requested fleet ID. When a location
     * is specified, a pending status is included. If the requested fleet has been deleted, the result set is empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeFleetPortSettingsRequest
     * @return Result of the DescribeFleetPortSettings operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetPortSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetPortSettingsResponse describeFleetPortSettings(
            DescribeFleetPortSettingsRequest describeFleetPortSettingsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a fleet's inbound connection permissions. Connection permissions specify the range of IP addresses and
     * port settings that incoming traffic can use to access server processes in the fleet. Game sessions that are
     * running on instances in the fleet must use connections that fall in this range.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve the inbound connection permissions for a fleet, identify the fleet's unique identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port
     * setting updates can take time to propagate across all locations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a set of <code>IpPermission</code> objects is returned for the requested fleet ID. When a location
     * is specified, a pending status is included. If the requested fleet has been deleted, the result set is empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetPortSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetPortSettingsRequest#builder()}
     * </p>
     *
     * @param describeFleetPortSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetPortSettingsInput.Builder} to create a
     *        request.
     * @return Result of the DescribeFleetPortSettings operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetPortSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetPortSettingsResponse describeFleetPortSettings(
            Consumer<DescribeFleetPortSettingsRequest.Builder> describeFleetPortSettingsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return describeFleetPortSettings(DescribeFleetPortSettingsRequest.builder()
                .applyMutation(describeFleetPortSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     *
     * @return Result of the DescribeFleetUtilization operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetUtilization
     * @see #describeFleetUtilization(DescribeFleetUtilizationRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationResponse describeFleetUtilization() throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        return describeFleetUtilization(DescribeFleetUtilizationRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     *
     * @param describeFleetUtilizationRequest
     * @return Result of the DescribeFleetUtilization operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationResponse describeFleetUtilization(
            DescribeFleetUtilizationRequest describeFleetUtilizationRequest) throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetUtilizationRequest#builder()}
     * </p>
     *
     * @param describeFleetUtilizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetUtilizationInput.Builder} to create a
     *        request.
     * @return Result of the DescribeFleetUtilization operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationResponse describeFleetUtilization(
            Consumer<DescribeFleetUtilizationRequest.Builder> describeFleetUtilizationRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetUtilization(DescribeFleetUtilizationRequest.builder().applyMutation(describeFleetUtilizationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client.describeFleetUtilizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client
     *             .describeFleetUtilizationPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client.describeFleetUtilizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetUtilization
     * @see #describeFleetUtilizationPaginator(DescribeFleetUtilizationRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationIterable describeFleetUtilizationPaginator() throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetUtilizationPaginator(DescribeFleetUtilizationRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client.describeFleetUtilizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client
     *             .describeFleetUtilizationPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client.describeFleetUtilizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetUtilizationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationIterable describeFleetUtilizationPaginator(
            DescribeFleetUtilizationRequest describeFleetUtilizationRequest) throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client.describeFleetUtilizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client
     *             .describeFleetUtilizationPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationIterable responses = client.describeFleetUtilizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetUtilizationRequest#builder()}
     * </p>
     *
     * @param describeFleetUtilizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetUtilizationInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationIterable describeFleetUtilizationPaginator(
            Consumer<DescribeFleetUtilizationRequest.Builder> describeFleetUtilizationRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeFleetUtilizationPaginator(DescribeFleetUtilizationRequest.builder()
                .applyMutation(describeFleetUtilizationRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information for a registered game server. Information includes game server status, health check info,
     * and the instance that the game server is running on.
     * </p>
     * <p>
     * To retrieve game server information, specify the game server ID. If successful, the requested game server object
     * is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerRequest
     * @return Result of the DescribeGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameServerResponse describeGameServer(DescribeGameServerRequest describeGameServerRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information for a registered game server. Information includes game server status, health check info,
     * and the instance that the game server is running on.
     * </p>
     * <p>
     * To retrieve game server information, specify the game server ID. If successful, the requested game server object
     * is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGameServerRequest#builder()}
     * </p>
     *
     * @param describeGameServerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameServerInput.Builder} to create a request.
     * @return Result of the DescribeGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameServerResponse describeGameServer(Consumer<DescribeGameServerRequest.Builder> describeGameServerRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeGameServer(DescribeGameServerRequest.builder().applyMutation(describeGameServerRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on a game server group. This operation returns only properties related to Amazon GameLift
     * FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template, auto
     * scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.
     * </p>
     * <p>
     * To get attributes for a game server group, provide a group name or ARN value. If successful, a
     * <code>GameServerGroup</code> object is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerGroupRequest
     * @return Result of the DescribeGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerGroupResponse describeGameServerGroup(DescribeGameServerGroupRequest describeGameServerGroupRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on a game server group. This operation returns only properties related to Amazon GameLift
     * FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template, auto
     * scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.
     * </p>
     * <p>
     * To get attributes for a game server group, provide a group name or ARN value. If successful, a
     * <code>GameServerGroup</code> object is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameServerGroupRequest#builder()}
     * </p>
     *
     * @param describeGameServerGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameServerGroupInput.Builder} to create a
     *        request.
     * @return Result of the DescribeGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerGroupResponse describeGameServerGroup(
            Consumer<DescribeGameServerGroupRequest.Builder> describeGameServerGroupRequest) throws InvalidRequestException,
            NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeGameServerGroup(DescribeGameServerGroupRequest.builder().applyMutation(describeGameServerGroupRequest)
                .build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift FleetIQ game server
     * group. Use this operation to detect when instances are active or not available to host new game servers.
     * </p>
     * <p>
     * To request status for all instances in the game server group, provide a game server group ID only. To request
     * status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination
     * parameters to retrieve results in sequential segments. If successful, a collection of
     * <code>GameServerInstance</code> objects is returned.
     * </p>
     * <p>
     * This operation is not designed to be called with every game server claim request; this practice can cause you to
     * exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your
     * cache no more than once every 10 seconds.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerInstancesRequest
     * @return Result of the DescribeGameServerInstances operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerInstancesResponse describeGameServerInstances(
            DescribeGameServerInstancesRequest describeGameServerInstancesRequest) throws InvalidRequestException,
            NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift FleetIQ game server
     * group. Use this operation to detect when instances are active or not available to host new game servers.
     * </p>
     * <p>
     * To request status for all instances in the game server group, provide a game server group ID only. To request
     * status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination
     * parameters to retrieve results in sequential segments. If successful, a collection of
     * <code>GameServerInstance</code> objects is returned.
     * </p>
     * <p>
     * This operation is not designed to be called with every game server claim request; this practice can cause you to
     * exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your
     * cache no more than once every 10 seconds.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGameServerInstancesRequest#builder()}
     * </p>
     *
     * @param describeGameServerInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameServerInstancesInput.Builder} to create a
     *        request.
     * @return Result of the DescribeGameServerInstances operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerInstancesResponse describeGameServerInstances(
            Consumer<DescribeGameServerInstancesRequest.Builder> describeGameServerInstancesRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeGameServerInstances(DescribeGameServerInstancesRequest.builder()
                .applyMutation(describeGameServerInstancesRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift FleetIQ game server
     * group. Use this operation to detect when instances are active or not available to host new game servers.
     * </p>
     * <p>
     * To request status for all instances in the game server group, provide a game server group ID only. To request
     * status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination
     * parameters to retrieve results in sequential segments. If successful, a collection of
     * <code>GameServerInstance</code> objects is returned.
     * </p>
     * <p>
     * This operation is not designed to be called with every game server claim request; this practice can cause you to
     * exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your
     * cache no more than once every 10 seconds.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesIterable responses = client.describeGameServerInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesIterable responses = client
     *             .describeGameServerInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesIterable responses = client.describeGameServerInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameServerInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerInstancesIterable describeGameServerInstancesPaginator(
            DescribeGameServerInstancesRequest describeGameServerInstancesRequest) throws InvalidRequestException,
            NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift FleetIQ game server
     * group. Use this operation to detect when instances are active or not available to host new game servers.
     * </p>
     * <p>
     * To request status for all instances in the game server group, provide a game server group ID only. To request
     * status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination
     * parameters to retrieve results in sequential segments. If successful, a collection of
     * <code>GameServerInstance</code> objects is returned.
     * </p>
     * <p>
     * This operation is not designed to be called with every game server claim request; this practice can cause you to
     * exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your
     * cache no more than once every 10 seconds.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesIterable responses = client.describeGameServerInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesIterable responses = client
     *             .describeGameServerInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesIterable responses = client.describeGameServerInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGameServerInstancesRequest#builder()}
     * </p>
     *
     * @param describeGameServerInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameServerInstancesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerInstancesIterable describeGameServerInstancesPaginator(
            Consumer<DescribeGameServerInstancesRequest.Builder> describeGameServerInstancesRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeGameServerInstancesPaginator(DescribeGameServerInstancesRequest.builder()
                .applyMutation(describeGameServerInstancesRequest).build());
    }

    /**
     * <p>
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one
     * or more game sessions in a specific fleet location. You can optionally filter the results by current game session
     * status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet
     * or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on a specific fleet location, provide a
     * fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region
     * or any remote location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for a specific game session, provide the game session ID. This approach looks for the game
     * session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the
     * request.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     * @return Result of the DescribeGameSessionDetails operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionDetailsResponse describeGameSessionDetails(
            DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one
     * or more game sessions in a specific fleet location. You can optionally filter the results by current game session
     * status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet
     * or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on a specific fleet location, provide a
     * fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region
     * or any remote location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for a specific game session, provide the game session ID. This approach looks for the game
     * session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the
     * request.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionDetailsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameSessionDetailsInput.Builder} to create a
     *        request.
     * @return Result of the DescribeGameSessionDetails operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionDetailsResponse describeGameSessionDetails(
            Consumer<DescribeGameSessionDetailsRequest.Builder> describeGameSessionDetailsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            TerminalRoutingStrategyException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeGameSessionDetails(DescribeGameSessionDetailsRequest.builder()
                .applyMutation(describeGameSessionDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one
     * or more game sessions in a specific fleet location. You can optionally filter the results by current game session
     * status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet
     * or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on a specific fleet location, provide a
     * fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region
     * or any remote location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for a specific game session, provide the game session ID. This approach looks for the game
     * session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the
     * request.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsIterable responses = client.describeGameSessionDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsIterable responses = client
     *             .describeGameSessionDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsIterable responses = client.describeGameSessionDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionDetailsIterable describeGameSessionDetailsPaginator(
            DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one
     * or more game sessions in a specific fleet location. You can optionally filter the results by current game session
     * status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet
     * or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on a specific fleet location, provide a
     * fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region
     * or any remote location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for a specific game session, provide the game session ID. This approach looks for the game
     * session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the
     * request.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsIterable responses = client.describeGameSessionDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsIterable responses = client
     *             .describeGameSessionDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsIterable responses = client.describeGameSessionDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionDetailsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameSessionDetailsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionDetailsIterable describeGameSessionDetailsPaginator(
            Consumer<DescribeGameSessionDetailsRequest.Builder> describeGameSessionDetailsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            TerminalRoutingStrategyException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeGameSessionDetailsPaginator(DescribeGameSessionDetailsRequest.builder()
                .applyMutation(describeGameSessionDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves information, including current status, about a game session placement request.
     * </p>
     * <p>
     * To get game session placement details, specify the placement ID.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessionPlacement</code> should only be used for games in development with low game session
     * usage.
     * </p>
     *
     * @param describeGameSessionPlacementRequest
     * @return Result of the DescribeGameSessionPlacement operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionPlacementResponse describeGameSessionPlacement(
            DescribeGameSessionPlacementRequest describeGameSessionPlacementRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information, including current status, about a game session placement request.
     * </p>
     * <p>
     * To get game session placement details, specify the placement ID.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessionPlacement</code> should only be used for games in development with low game session
     * usage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionPlacementRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGameSessionPlacementRequest#builder()}
     * </p>
     *
     * @param describeGameSessionPlacementRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameSessionPlacementInput.Builder} to create a
     *        request.
     * @return Result of the DescribeGameSessionPlacement operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionPlacementResponse describeGameSessionPlacement(
            Consumer<DescribeGameSessionPlacementRequest.Builder> describeGameSessionPlacementRequest)
            throws InternalServiceException, InvalidRequestException, NotFoundException, UnauthorizedException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeGameSessionPlacement(DescribeGameSessionPlacementRequest.builder()
                .applyMutation(describeGameSessionPlacementRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     *
     * @return Result of the DescribeGameSessionQueues operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionQueues
     * @see #describeGameSessionQueues(DescribeGameSessionQueuesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesResponse describeGameSessionQueues() throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeGameSessionQueues(DescribeGameSessionQueuesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     * @return Result of the DescribeGameSessionQueues operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesResponse describeGameSessionQueues(
            DescribeGameSessionQueuesRequest describeGameSessionQueuesRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionQueuesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionQueuesRequest#builder()}
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameSessionQueuesInput.Builder} to create a
     *        request.
     * @return Result of the DescribeGameSessionQueues operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesResponse describeGameSessionQueues(
            Consumer<DescribeGameSessionQueuesRequest.Builder> describeGameSessionQueuesRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeGameSessionQueues(DescribeGameSessionQueuesRequest.builder()
                .applyMutation(describeGameSessionQueuesRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client.describeGameSessionQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client
     *             .describeGameSessionQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client.describeGameSessionQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionQueues
     * @see #describeGameSessionQueuesPaginator(DescribeGameSessionQueuesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesIterable describeGameSessionQueuesPaginator() throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeGameSessionQueuesPaginator(DescribeGameSessionQueuesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client.describeGameSessionQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client
     *             .describeGameSessionQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client.describeGameSessionQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesIterable describeGameSessionQueuesPaginator(
            DescribeGameSessionQueuesRequest describeGameSessionQueuesRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client.describeGameSessionQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client
     *             .describeGameSessionQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesIterable responses = client.describeGameSessionQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionQueuesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionQueuesRequest#builder()}
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameSessionQueuesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesIterable describeGameSessionQueuesPaginator(
            Consumer<DescribeGameSessionQueuesRequest.Builder> describeGameSessionQueuesRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeGameSessionQueuesPaginator(DescribeGameSessionQueuesRequest.builder()
                .applyMutation(describeGameSessionQueuesRequest).build());
    }

    /**
     * <p>
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results
     * by current game session status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias
     * ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias
     * ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in
     * all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessions</code> should only be used for games in development with low game session usage.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeGameSessionsRequest
     * @return Result of the DescribeGameSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameSessionsResponse describeGameSessions(DescribeGameSessionsRequest describeGameSessionsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            TerminalRoutingStrategyException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results
     * by current game session status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias
     * ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias
     * ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in
     * all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessions</code> should only be used for games in development with low game session usage.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGameSessionsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameSessionsInput.Builder} to create a
     *        request.
     * @return Result of the DescribeGameSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameSessionsResponse describeGameSessions(
            Consumer<DescribeGameSessionsRequest.Builder> describeGameSessionsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeGameSessions(DescribeGameSessionsRequest.builder().applyMutation(describeGameSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results
     * by current game session status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias
     * ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias
     * ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in
     * all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessions</code> should only be used for games in development with low game session usage.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsIterable responses = client.describeGameSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsIterable responses = client
     *             .describeGameSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsIterable responses = client.describeGameSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameSessionsIterable describeGameSessionsPaginator(DescribeGameSessionsRequest describeGameSessionsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            TerminalRoutingStrategyException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results
     * by current game session status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias
     * ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias
     * ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in
     * all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessions</code> should only be used for games in development with low game session usage.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsIterable responses = client.describeGameSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsIterable responses = client
     *             .describeGameSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsIterable responses = client.describeGameSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGameSessionsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGameSessionsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameSessionsIterable describeGameSessionsPaginator(
            Consumer<DescribeGameSessionsRequest.Builder> describeGameSessionsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeGameSessionsPaginator(DescribeGameSessionsRequest.builder().applyMutation(describeGameSessionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a fleet's instances, including instance IDs, connection data, and status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's home Region, provide the fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's remote location, provide the fleet ID and
     * location name.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on a specific instance in a fleet, provide the fleet ID and instance ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, an <code>Instance</code> object is returned for each requested instance. Instances are not
     * returned in any particular order.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeInstancesRequest
     * @return Result of the DescribeInstances operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancesResponse describeInstances(DescribeInstancesRequest describeInstancesRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a fleet's instances, including instance IDs, connection data, and status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's home Region, provide the fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's remote location, provide the fleet ID and
     * location name.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on a specific instance in a fleet, provide the fleet ID and instance ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, an <code>Instance</code> object is returned for each requested instance. Instances are not
     * returned in any particular order.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstancesRequest#builder()}
     * </p>
     *
     * @param describeInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancesInput.Builder} to create a request.
     * @return Result of the DescribeInstances operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancesResponse describeInstances(Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeInstances(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a fleet's instances, including instance IDs, connection data, and status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's home Region, provide the fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's remote location, provide the fleet ID and
     * location name.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on a specific instance in a fleet, provide the fleet ID and instance ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, an <code>Instance</code> object is returned for each requested instance. Instances are not
     * returned in any particular order.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesIterable responses = client.describeInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesIterable responses = client
     *             .describeInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesIterable responses = client.describeInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancesIterable describeInstancesPaginator(DescribeInstancesRequest describeInstancesRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a fleet's instances, including instance IDs, connection data, and status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's home Region, provide the fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on all instances that are deployed to a fleet's remote location, provide the fleet ID and
     * location name.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on a specific instance in a fleet, provide the fleet ID and instance ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, an <code>Instance</code> object is returned for each requested instance. Instances are not
     * returned in any particular order.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesIterable responses = client.describeInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesIterable responses = client
     *             .describeInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesIterable responses = client.describeInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstancesRequest#builder()}
     * </p>
     *
     * @param describeInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancesIterable describeInstancesPaginator(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeInstancesPaginator(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * <p>
     * Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a
     * successful match is made--connection information for the resulting new game session.
     * </p>
     * <p>
     * To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket
     * object is returned for each requested ID that currently exists.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track matchmaking ticket status. This practice can
     * cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple
     * Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p/>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch
     * event notification</a>
     * </p>
     *
     * @param describeMatchmakingRequest
     * @return Result of the DescribeMatchmaking operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmaking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMatchmakingResponse describeMatchmaking(DescribeMatchmakingRequest describeMatchmakingRequest)
            throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a
     * successful match is made--connection information for the resulting new game session.
     * </p>
     * <p>
     * To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket
     * object is returned for each requested ID that currently exists.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track matchmaking ticket status. This practice can
     * cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple
     * Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p/>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch
     * event notification</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMatchmakingRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMatchmakingInput.Builder} to create a request.
     * @return Result of the DescribeMatchmaking operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmaking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMatchmakingResponse describeMatchmaking(
            Consumer<DescribeMatchmakingRequest.Builder> describeMatchmakingRequest) throws InvalidRequestException,
            InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeMatchmaking(DescribeMatchmakingRequest.builder().applyMutation(describeMatchmakingRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     *
     * @return Result of the DescribeMatchmakingConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingConfigurations
     * @see #describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsResponse describeMatchmakingConfigurations() throws InvalidRequestException,
            InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     * @return Result of the DescribeMatchmakingConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsResponse describeMatchmakingConfigurations(
            DescribeMatchmakingConfigurationsRequest describeMatchmakingConfigurationsRequest) throws InvalidRequestException,
            InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMatchmakingConfigurationsInput.Builder} to
     *        create a request.
     * @return Result of the DescribeMatchmakingConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsResponse describeMatchmakingConfigurations(
            Consumer<DescribeMatchmakingConfigurationsRequest.Builder> describeMatchmakingConfigurationsRequest)
            throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest.builder()
                .applyMutation(describeMatchmakingConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client.describeMatchmakingConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client
     *             .describeMatchmakingConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client.describeMatchmakingConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingConfigurations
     * @see #describeMatchmakingConfigurationsPaginator(DescribeMatchmakingConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsIterable describeMatchmakingConfigurationsPaginator()
            throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return describeMatchmakingConfigurationsPaginator(DescribeMatchmakingConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client.describeMatchmakingConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client
     *             .describeMatchmakingConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client.describeMatchmakingConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsIterable describeMatchmakingConfigurationsPaginator(
            DescribeMatchmakingConfigurationsRequest describeMatchmakingConfigurationsRequest) throws InvalidRequestException,
            InternalServiceException, UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client.describeMatchmakingConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client
     *             .describeMatchmakingConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsIterable responses = client.describeMatchmakingConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMatchmakingConfigurationsInput.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsIterable describeMatchmakingConfigurationsPaginator(
            Consumer<DescribeMatchmakingConfigurationsRequest.Builder> describeMatchmakingConfigurationsRequest)
            throws InvalidRequestException, InternalServiceException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return describeMatchmakingConfigurationsPaginator(DescribeMatchmakingConfigurationsRequest.builder()
                .applyMutation(describeMatchmakingConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @return Result of the DescribeMatchmakingRuleSets operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingRuleSets
     * @see #describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsResponse describeMatchmakingRuleSets() throws InvalidRequestException,
            InternalServiceException, NotFoundException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeMatchmakingRuleSetsRequest
     * @return Result of the DescribeMatchmakingRuleSets operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsResponse describeMatchmakingRuleSets(
            DescribeMatchmakingRuleSetsRequest describeMatchmakingRuleSetsRequest) throws InvalidRequestException,
            InternalServiceException, NotFoundException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingRuleSetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingRuleSetsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingRuleSetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMatchmakingRuleSetsInput.Builder} to create a
     *        request.
     * @return Result of the DescribeMatchmakingRuleSets operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsResponse describeMatchmakingRuleSets(
            Consumer<DescribeMatchmakingRuleSetsRequest.Builder> describeMatchmakingRuleSetsRequest)
            throws InvalidRequestException, InternalServiceException, NotFoundException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest.builder()
                .applyMutation(describeMatchmakingRuleSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client.describeMatchmakingRuleSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client
     *             .describeMatchmakingRuleSetsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client.describeMatchmakingRuleSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingRuleSets
     * @see #describeMatchmakingRuleSetsPaginator(DescribeMatchmakingRuleSetsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsIterable describeMatchmakingRuleSetsPaginator() throws InvalidRequestException,
            InternalServiceException, NotFoundException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeMatchmakingRuleSetsPaginator(DescribeMatchmakingRuleSetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client.describeMatchmakingRuleSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client
     *             .describeMatchmakingRuleSetsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client.describeMatchmakingRuleSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMatchmakingRuleSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsIterable describeMatchmakingRuleSetsPaginator(
            DescribeMatchmakingRuleSetsRequest describeMatchmakingRuleSetsRequest) throws InvalidRequestException,
            InternalServiceException, NotFoundException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client.describeMatchmakingRuleSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client
     *             .describeMatchmakingRuleSetsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsIterable responses = client.describeMatchmakingRuleSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingRuleSetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingRuleSetsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingRuleSetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMatchmakingRuleSetsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsIterable describeMatchmakingRuleSetsPaginator(
            Consumer<DescribeMatchmakingRuleSetsRequest.Builder> describeMatchmakingRuleSetsRequest)
            throws InvalidRequestException, InternalServiceException, NotFoundException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeMatchmakingRuleSetsPaginator(DescribeMatchmakingRuleSetsRequest.builder()
                .applyMutation(describeMatchmakingRuleSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for one or more player sessions.
     * </p>
     * <p>
     * This action can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a specific player session, provide the player session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions in a game session, provide the game session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions for a specific player, provide a player ID only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter
     * this request by player session status. Use the pagination parameters to retrieve results as a set of sequential
     * pages.
     * </p>
     * <p>
     * If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describePlayerSessionsRequest
     * @return Result of the DescribePlayerSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlayerSessionsResponse describePlayerSessions(DescribePlayerSessionsRequest describePlayerSessionsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for one or more player sessions.
     * </p>
     * <p>
     * This action can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a specific player session, provide the player session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions in a game session, provide the game session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions for a specific player, provide a player ID only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter
     * this request by player session status. Use the pagination parameters to retrieve results as a set of sequential
     * pages.
     * </p>
     * <p>
     * If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlayerSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePlayerSessionsRequest#builder()}
     * </p>
     *
     * @param describePlayerSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePlayerSessionsInput.Builder} to create a
     *        request.
     * @return Result of the DescribePlayerSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlayerSessionsResponse describePlayerSessions(
            Consumer<DescribePlayerSessionsRequest.Builder> describePlayerSessionsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describePlayerSessions(DescribePlayerSessionsRequest.builder().applyMutation(describePlayerSessionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves properties for one or more player sessions.
     * </p>
     * <p>
     * This action can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a specific player session, provide the player session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions in a game session, provide the game session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions for a specific player, provide a player ID only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter
     * this request by player session status. Use the pagination parameters to retrieve results as a set of sequential
     * pages.
     * </p>
     * <p>
     * If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsIterable responses = client.describePlayerSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsIterable responses = client
     *             .describePlayerSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsIterable responses = client.describePlayerSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePlayerSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlayerSessionsIterable describePlayerSessionsPaginator(
            DescribePlayerSessionsRequest describePlayerSessionsRequest) throws InternalServiceException, NotFoundException,
            InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for one or more player sessions.
     * </p>
     * <p>
     * This action can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a specific player session, provide the player session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions in a game session, provide the game session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions for a specific player, provide a player ID only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter
     * this request by player session status. Use the pagination parameters to retrieve results as a set of sequential
     * pages.
     * </p>
     * <p>
     * If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsIterable responses = client.describePlayerSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsIterable responses = client
     *             .describePlayerSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsIterable responses = client.describePlayerSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlayerSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePlayerSessionsRequest#builder()}
     * </p>
     *
     * @param describePlayerSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePlayerSessionsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlayerSessionsIterable describePlayerSessionsPaginator(
            Consumer<DescribePlayerSessionsRequest.Builder> describePlayerSessionsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describePlayerSessionsPaginator(DescribePlayerSessionsRequest.builder()
                .applyMutation(describePlayerSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a fleet's runtime configuration settings. The runtime configuration tells Amazon GameLift which server
     * processes to run (and how) on each instance in the fleet.
     * </p>
     * <p>
     * To get the runtime configuration that is currently in forces for a fleet, provide the fleet ID.
     * </p>
     * <p>
     * If successful, a <code>RuntimeConfiguration</code> object is returned for the requested fleet. If the requested
     * fleet has been deleted, the result set is empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html">Running multiple
     * processes on a fleet</a>
     * </p>
     *
     * @param describeRuntimeConfigurationRequest
     * @return Result of the DescribeRuntimeConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuntimeConfigurationResponse describeRuntimeConfiguration(
            DescribeRuntimeConfigurationRequest describeRuntimeConfigurationRequest) throws UnauthorizedException,
            NotFoundException, InternalServiceException, InvalidRequestException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a fleet's runtime configuration settings. The runtime configuration tells Amazon GameLift which server
     * processes to run (and how) on each instance in the fleet.
     * </p>
     * <p>
     * To get the runtime configuration that is currently in forces for a fleet, provide the fleet ID.
     * </p>
     * <p>
     * If successful, a <code>RuntimeConfiguration</code> object is returned for the requested fleet. If the requested
     * fleet has been deleted, the result set is empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html">Running multiple
     * processes on a fleet</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuntimeConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRuntimeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeRuntimeConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRuntimeConfigurationInput.Builder} to create a
     *        request.
     * @return Result of the DescribeRuntimeConfiguration operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuntimeConfigurationResponse describeRuntimeConfiguration(
            Consumer<DescribeRuntimeConfigurationRequest.Builder> describeRuntimeConfigurationRequest)
            throws UnauthorizedException, NotFoundException, InternalServiceException, InvalidRequestException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeRuntimeConfiguration(DescribeRuntimeConfigurationRequest.builder()
                .applyMutation(describeRuntimeConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves all scaling policies applied to a fleet.
     * </p>
     * <p>
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to
     * retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential
     * pages. If successful, set of <code>ScalingPolicy</code> objects is returned for the fleet.
     * </p>
     * <p>
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling
     * policies, which remains ACTIVE.
     * </p>
     *
     * @param describeScalingPoliciesRequest
     * @return Result of the DescribeScalingPolicies operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesResponse describeScalingPolicies(DescribeScalingPoliciesRequest describeScalingPoliciesRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all scaling policies applied to a fleet.
     * </p>
     * <p>
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to
     * retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential
     * pages. If successful, set of <code>ScalingPolicy</code> objects is returned for the fleet.
     * </p>
     * <p>
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling
     * policies, which remains ACTIVE.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingPoliciesRequest#builder()}
     * </p>
     *
     * @param describeScalingPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPoliciesInput.Builder} to create a
     *        request.
     * @return Result of the DescribeScalingPolicies operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesResponse describeScalingPolicies(
            Consumer<DescribeScalingPoliciesRequest.Builder> describeScalingPoliciesRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return describeScalingPolicies(DescribeScalingPoliciesRequest.builder().applyMutation(describeScalingPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all scaling policies applied to a fleet.
     * </p>
     * <p>
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to
     * retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential
     * pages. If successful, set of <code>ScalingPolicy</code> objects is returned for the fleet.
     * </p>
     * <p>
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling
     * policies, which remains ACTIVE.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesIterable responses = client.describeScalingPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesIterable responses = client
     *             .describeScalingPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesIterable responses = client.describeScalingPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalingPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesIterable describeScalingPoliciesPaginator(
            DescribeScalingPoliciesRequest describeScalingPoliciesRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all scaling policies applied to a fleet.
     * </p>
     * <p>
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to
     * retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential
     * pages. If successful, set of <code>ScalingPolicy</code> objects is returned for the fleet.
     * </p>
     * <p>
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling
     * policies, which remains ACTIVE.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesIterable responses = client.describeScalingPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesIterable responses = client
     *             .describeScalingPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesIterable responses = client.describeScalingPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingPoliciesRequest#builder()}
     * </p>
     *
     * @param describeScalingPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPoliciesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesIterable describeScalingPoliciesPaginator(
            Consumer<DescribeScalingPoliciesRequest.Builder> describeScalingPoliciesRequest) throws InternalServiceException,
            InvalidRequestException, UnauthorizedException, NotFoundException, UnsupportedRegionException, AwsServiceException,
            SdkClientException, GameLiftException {
        return describeScalingPoliciesPaginator(DescribeScalingPoliciesRequest.builder()
                .applyMutation(describeScalingPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for a Realtime script.
     * </p>
     * <p>
     * To request a script record, specify the script ID. If successful, an object containing the script properties is
     * returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeScriptRequest
     * @return Result of the DescribeScript operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScript" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScriptResponse describeScript(DescribeScriptRequest describeScriptRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, NotFoundException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for a Realtime script.
     * </p>
     * <p>
     * To request a script record, specify the script ID. If successful, an object containing the script properties is
     * returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScriptRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeScriptRequest#builder()}
     * </p>
     *
     * @param describeScriptRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScriptInput.Builder} to create a request.
     * @return Result of the DescribeScript operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScript" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScriptResponse describeScript(Consumer<DescribeScriptRequest.Builder> describeScriptRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, NotFoundException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeScript(DescribeScriptRequest.builder().applyMutation(describeScriptRequest).build());
    }

    /**
     * <p>
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation
     * returns all VPC peering authorizations and requests for peering. This includes those initiated and received by
     * this account.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return Result of the DescribeVpcPeeringAuthorizations operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeVpcPeeringAuthorizations
     * @see #describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcPeeringAuthorizationsResponse describeVpcPeeringAuthorizations() throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation
     * returns all VPC peering authorizations and requests for peering. This includes those initiated and received by
     * this account.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeVpcPeeringAuthorizationsRequest
     * @return Result of the DescribeVpcPeeringAuthorizations operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeVpcPeeringAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcPeeringAuthorizationsResponse describeVpcPeeringAuthorizations(
            DescribeVpcPeeringAuthorizationsRequest describeVpcPeeringAuthorizationsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation
     * returns all VPC peering authorizations and requests for peering. This includes those initiated and received by
     * this account.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcPeeringAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVpcPeeringAuthorizationsRequest#builder()}
     * </p>
     *
     * @param describeVpcPeeringAuthorizationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVpcPeeringAuthorizationsInput.Builder} to
     *        create a request.
     * @return Result of the DescribeVpcPeeringAuthorizations operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeVpcPeeringAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcPeeringAuthorizationsResponse describeVpcPeeringAuthorizations(
            Consumer<DescribeVpcPeeringAuthorizationsRequest.Builder> describeVpcPeeringAuthorizationsRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest.builder()
                .applyMutation(describeVpcPeeringAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or
     * for one specific fleet ID.
     * </p>
     * <p>
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection
     * records. If successful, the retrieved information includes both active and pending connections. Active
     * connections identify the IpV4 CIDR block that the VPC uses to connect.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return Result of the DescribeVpcPeeringConnections operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeVpcPeeringConnections
     * @see #describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcPeeringConnectionsResponse describeVpcPeeringConnections() throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or
     * for one specific fleet ID.
     * </p>
     * <p>
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection
     * records. If successful, the retrieved information includes both active and pending connections. Active
     * connections identify the IpV4 CIDR block that the VPC uses to connect.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeVpcPeeringConnectionsRequest
     * @return Result of the DescribeVpcPeeringConnections operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeVpcPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcPeeringConnectionsResponse describeVpcPeeringConnections(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or
     * for one specific fleet ID.
     * </p>
     * <p>
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection
     * records. If successful, the retrieved information includes both active and pending connections. Active
     * connections identify the IpV4 CIDR block that the VPC uses to connect.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcPeeringConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVpcPeeringConnectionsRequest#builder()}
     * </p>
     *
     * @param describeVpcPeeringConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVpcPeeringConnectionsInput.Builder} to create
     *        a request.
     * @return Result of the DescribeVpcPeeringConnections operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.DescribeVpcPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVpcPeeringConnectionsResponse describeVpcPeeringConnections(
            Consumer<DescribeVpcPeeringConnectionsRequest.Builder> describeVpcPeeringConnectionsRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest.builder()
                .applyMutation(describeVpcPeeringConnectionsRequest).build());
    }

    /**
     * <p>
     * Requests remote access to a fleet instance. Remote access is useful for debugging, gathering benchmarking data,
     * or observing activity in real time.
     * </p>
     * <p>
     * To remotely access an instance, you need credentials that match the operating system of the instance. For a
     * Windows instance, Amazon GameLift returns a user name and password as strings for use with a Windows Remote
     * Desktop client. For a Linux instance, Amazon GameLift returns a user name and RSA private key, also as strings,
     * for use with an SSH client. The private key must be saved in the proper format to a <code>.pem</code> file before
     * using. If you're making this request using the CLI, saving the secret can be handled as part of the
     * <code>GetInstanceAccess</code> request, as shown in one of the examples for this operation.
     * </p>
     * <p>
     * To request access to a specific instance, specify the IDs of both the instance and the fleet it belongs to.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     *
     * @param getComputeAccessRequest
     * @return Result of the GetComputeAccess operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetComputeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComputeAccessResponse getComputeAccess(GetComputeAccessRequest getComputeAccessRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests remote access to a fleet instance. Remote access is useful for debugging, gathering benchmarking data,
     * or observing activity in real time.
     * </p>
     * <p>
     * To remotely access an instance, you need credentials that match the operating system of the instance. For a
     * Windows instance, Amazon GameLift returns a user name and password as strings for use with a Windows Remote
     * Desktop client. For a Linux instance, Amazon GameLift returns a user name and RSA private key, also as strings,
     * for use with an SSH client. The private key must be saved in the proper format to a <code>.pem</code> file before
     * using. If you're making this request using the CLI, saving the secret can be handled as part of the
     * <code>GetInstanceAccess</code> request, as shown in one of the examples for this operation.
     * </p>
     * <p>
     * To request access to a specific instance, specify the IDs of both the instance and the fleet it belongs to.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComputeAccessRequest.Builder} avoiding the need
     * to create one manually via {@link GetComputeAccessRequest#builder()}
     * </p>
     *
     * @param getComputeAccessRequest
     *        A {@link Consumer} that will call methods on {@link GetComputeAccessInput.Builder} to create a request.
     * @return Result of the GetComputeAccess operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetComputeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComputeAccessResponse getComputeAccess(Consumer<GetComputeAccessRequest.Builder> getComputeAccessRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return getComputeAccess(GetComputeAccessRequest.builder().applyMutation(getComputeAccessRequest).build());
    }

    /**
     * <p>
     * Requests an authentication token from Amazon GameLift. The authentication token is used by your game server to
     * authenticate with Amazon GameLift. Each authentication token has an expiration time. To continue using the
     * compute resource to host your game server, regularly retrieve a new authorization token.
     * </p>
     *
     * @param getComputeAuthTokenRequest
     * @return Result of the GetComputeAuthToken operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetComputeAuthToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAuthToken" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComputeAuthTokenResponse getComputeAuthToken(GetComputeAuthTokenRequest getComputeAuthTokenRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests an authentication token from Amazon GameLift. The authentication token is used by your game server to
     * authenticate with Amazon GameLift. Each authentication token has an expiration time. To continue using the
     * compute resource to host your game server, regularly retrieve a new authorization token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComputeAuthTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetComputeAuthTokenRequest#builder()}
     * </p>
     *
     * @param getComputeAuthTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetComputeAuthTokenInput.Builder} to create a request.
     * @return Result of the GetComputeAuthToken operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetComputeAuthToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAuthToken" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComputeAuthTokenResponse getComputeAuthToken(
            Consumer<GetComputeAuthTokenRequest.Builder> getComputeAuthTokenRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return getComputeAuthToken(GetComputeAuthTokenRequest.builder().applyMutation(getComputeAuthTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves the location of stored game session logs for a specified game session on Amazon GameLift managed
     * fleets. When a game session is terminated, Amazon GameLift automatically stores the logs in Amazon S3 and retains
     * them for 14 days. Use this URL to download the logs.
     * </p>
     * <note>
     * <p>
     * See the <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">Amazon
     * Web Services Service Limits</a> page for maximum log file sizes. Log files that exceed this limit are not saved.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param getGameSessionLogUrlRequest
     * @return Result of the GetGameSessionLogUrl operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetGameSessionLogUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGameSessionLogUrlResponse getGameSessionLogUrl(GetGameSessionLogUrlRequest getGameSessionLogUrlRequest)
            throws InternalServiceException, NotFoundException, UnauthorizedException, InvalidRequestException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the location of stored game session logs for a specified game session on Amazon GameLift managed
     * fleets. When a game session is terminated, Amazon GameLift automatically stores the logs in Amazon S3 and retains
     * them for 14 days. Use this URL to download the logs.
     * </p>
     * <note>
     * <p>
     * See the <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">Amazon
     * Web Services Service Limits</a> page for maximum log file sizes. Log files that exceed this limit are not saved.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGameSessionLogUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetGameSessionLogUrlRequest#builder()}
     * </p>
     *
     * @param getGameSessionLogUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetGameSessionLogUrlInput.Builder} to create a
     *        request.
     * @return Result of the GetGameSessionLogUrl operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetGameSessionLogUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGameSessionLogUrlResponse getGameSessionLogUrl(
            Consumer<GetGameSessionLogUrlRequest.Builder> getGameSessionLogUrlRequest) throws InternalServiceException,
            NotFoundException, UnauthorizedException, InvalidRequestException, AwsServiceException, SdkClientException,
            GameLiftException {
        return getGameSessionLogUrl(GetGameSessionLogUrlRequest.builder().applyMutation(getGameSessionLogUrlRequest).build());
    }

    /**
     * <p>
     * Requests remote access to a fleet instance. Remote access is useful for debugging, gathering benchmarking data,
     * or observing activity in real time.
     * </p>
     * <p>
     * To remotely access an instance, you need credentials that match the operating system of the instance. For a
     * Windows instance, Amazon GameLift returns a user name and password as strings for use with a Windows Remote
     * Desktop client. For a Linux instance, Amazon GameLift returns a user name and RSA private key, also as strings,
     * for use with an SSH client. The private key must be saved in the proper format to a <code>.pem</code> file before
     * using. If you're making this request using the CLI, saving the secret can be handled as part of the
     * <code>GetInstanceAccess</code> request, as shown in one of the examples for this operation.
     * </p>
     * <p>
     * To request access to a specific instance, specify the IDs of both the instance and the fleet it belongs to. You
     * can retrieve a fleet's instance IDs by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html">DescribeInstances</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param getInstanceAccessRequest
     * @return Result of the GetInstanceAccess operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetInstanceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceAccessResponse getInstanceAccess(GetInstanceAccessRequest getInstanceAccessRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests remote access to a fleet instance. Remote access is useful for debugging, gathering benchmarking data,
     * or observing activity in real time.
     * </p>
     * <p>
     * To remotely access an instance, you need credentials that match the operating system of the instance. For a
     * Windows instance, Amazon GameLift returns a user name and password as strings for use with a Windows Remote
     * Desktop client. For a Linux instance, Amazon GameLift returns a user name and RSA private key, also as strings,
     * for use with an SSH client. The private key must be saved in the proper format to a <code>.pem</code> file before
     * using. If you're making this request using the CLI, saving the secret can be handled as part of the
     * <code>GetInstanceAccess</code> request, as shown in one of the examples for this operation.
     * </p>
     * <p>
     * To request access to a specific instance, specify the IDs of both the instance and the fleet it belongs to. You
     * can retrieve a fleet's instance IDs by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html">DescribeInstances</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access
     * Fleet Instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet
     * Issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceAccessRequest.Builder} avoiding the need
     * to create one manually via {@link GetInstanceAccessRequest#builder()}
     * </p>
     *
     * @param getInstanceAccessRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceAccessInput.Builder} to create a request.
     * @return Result of the GetInstanceAccess operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.GetInstanceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceAccessResponse getInstanceAccess(Consumer<GetInstanceAccessRequest.Builder> getInstanceAccessRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return getInstanceAccess(GetInstanceAccessRequest.builder().applyMutation(getInstanceAccessRequest).build());
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return Result of the ListAliases operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListAliases
     * @see #listAliases(ListAliasesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases() throws UnauthorizedException, InvalidRequestException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return listAliases(ListAliasesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAliasesInput.Builder} to create a request.
     * @return Result of the ListAliases operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListAliases
     * @see #listAliasesPaginator(ListAliasesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator() throws UnauthorizedException, InvalidRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return listAliasesPaginator(ListAliasesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAliasesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listAliasesPaginator(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return Result of the ListBuilds operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListBuilds
     * @see #listBuilds(ListBuildsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsResponse listBuilds() throws UnauthorizedException, InvalidRequestException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return listBuilds(ListBuildsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listBuildsRequest
     * @return Result of the ListBuilds operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsResponse listBuilds(ListBuildsRequest listBuildsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBuildsRequest#builder()}
     * </p>
     *
     * @param listBuildsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildsInput.Builder} to create a request.
     * @return Result of the ListBuilds operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsResponse listBuilds(Consumer<ListBuildsRequest.Builder> listBuildsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return listBuilds(ListBuildsRequest.builder().applyMutation(listBuildsRequest).build());
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListBuildsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListBuilds
     * @see #listBuildsPaginator(ListBuildsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsIterable listBuildsPaginator() throws UnauthorizedException, InvalidRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return listBuildsPaginator(ListBuildsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListBuildsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)} operation.</b>
     * </p>
     *
     * @param listBuildsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsIterable listBuildsPaginator(ListBuildsRequest listBuildsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListBuildsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsIterable responses = client.listBuildsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBuildsRequest#builder()}
     * </p>
     *
     * @param listBuildsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsIterable listBuildsPaginator(Consumer<ListBuildsRequest.Builder> listBuildsRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listBuildsPaginator(ListBuildsRequest.builder().applyMutation(listBuildsRequest).build());
    }

    /**
     * <p>
     * Retrieves all compute resources registered to a fleet in your Amazon Web Services account. You can filter the
     * result set by location.
     * </p>
     *
     * @param listComputeRequest
     * @return Result of the ListCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputeResponse listCompute(ListComputeRequest listComputeRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all compute resources registered to a fleet in your Amazon Web Services account. You can filter the
     * result set by location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComputeRequest.Builder} avoiding the need to
     * create one manually via {@link ListComputeRequest#builder()}
     * </p>
     *
     * @param listComputeRequest
     *        A {@link Consumer} that will call methods on {@link ListComputeInput.Builder} to create a request.
     * @return Result of the ListCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputeResponse listCompute(Consumer<ListComputeRequest.Builder> listComputeRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listCompute(ListComputeRequest.builder().applyMutation(listComputeRequest).build());
    }

    /**
     * <p>
     * Retrieves all compute resources registered to a fleet in your Amazon Web Services account. You can filter the
     * result set by location.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputeIterable responses = client.listComputePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListComputeIterable responses = client.listComputePaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListComputeResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputeIterable responses = client.listComputePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)} operation.</b>
     * </p>
     *
     * @param listComputeRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputeIterable listComputePaginator(ListComputeRequest listComputeRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all compute resources registered to a fleet in your Amazon Web Services account. You can filter the
     * result set by location.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputeIterable responses = client.listComputePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListComputeIterable responses = client.listComputePaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListComputeResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputeIterable responses = client.listComputePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComputeRequest.Builder} avoiding the need to
     * create one manually via {@link ListComputeRequest#builder()}
     * </p>
     *
     * @param listComputeRequest
     *        A {@link Consumer} that will call methods on {@link ListComputeInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputeIterable listComputePaginator(Consumer<ListComputeRequest.Builder> listComputeRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listComputePaginator(ListComputeRequest.builder().applyMutation(listComputeRequest).build());
    }

    /**
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can call this operation to get
     * fleets in a previously selected default Region (see <a
     * href="https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html"
     * >https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html</a>or specify a Region in your
     * request. You can filter the result set to find only those fleets that are deployed with a specific build or
     * script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific custom game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a list of fleet IDs that match the request parameters is returned. A NextToken value is also
     * returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet resources are not listed in a particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @return Result of the ListFleets operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListFleets
     * @see #listFleets(ListFleetsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets() throws InternalServiceException, NotFoundException, InvalidRequestException,
            UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        return listFleets(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can call this operation to get
     * fleets in a previously selected default Region (see <a
     * href="https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html"
     * >https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html</a>or specify a Region in your
     * request. You can filter the result set to find only those fleets that are deployed with a specific build or
     * script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific custom game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a list of fleet IDs that match the request parameters is returned. A NextToken value is also
     * returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet resources are not listed in a particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param listFleetsRequest
     * @return Result of the ListFleets operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can call this operation to get
     * fleets in a previously selected default Region (see <a
     * href="https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html"
     * >https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html</a>or specify a Region in your
     * request. You can filter the result set to find only those fleets that are deployed with a specific build or
     * script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific custom game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a list of fleet IDs that match the request parameters is returned. A NextToken value is also
     * returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet resources are not listed in a particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsInput.Builder} to create a request.
     * @return Result of the ListFleets operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can call this operation to get
     * fleets in a previously selected default Region (see <a
     * href="https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html"
     * >https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html</a>or specify a Region in your
     * request. You can filter the result set to find only those fleets that are deployed with a specific build or
     * script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific custom game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a list of fleet IDs that match the request parameters is returned. A NextToken value is also
     * returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet resources are not listed in a particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListFleets
     * @see #listFleetsPaginator(ListFleetsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator() throws InternalServiceException, NotFoundException, InvalidRequestException,
            UnauthorizedException, AwsServiceException, SdkClientException, GameLiftException {
        return listFleetsPaginator(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can call this operation to get
     * fleets in a previously selected default Region (see <a
     * href="https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html"
     * >https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html</a>or specify a Region in your
     * request. You can filter the result set to find only those fleets that are deployed with a specific build or
     * script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific custom game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a list of fleet IDs that match the request parameters is returned. A NextToken value is also
     * returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet resources are not listed in a particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(ListFleetsRequest listFleetsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can call this operation to get
     * fleets in a previously selected default Region (see <a
     * href="https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html"
     * >https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html</a>or specify a Region in your
     * request. You can filter the result set to find only those fleets that are deployed with a specific build or
     * script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific custom game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a list of fleet IDs that match the request parameters is returned. A NextToken value is also
     * returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet resources are not listed in a particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            AwsServiceException, SdkClientException, GameLiftException {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Lists a game server groups.
     * </p>
     *
     * @param listGameServerGroupsRequest
     * @return Result of the ListGameServerGroups operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGameServerGroupsResponse listGameServerGroups(ListGameServerGroupsRequest listGameServerGroupsRequest)
            throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists a game server groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServerGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGameServerGroupsRequest#builder()}
     * </p>
     *
     * @param listGameServerGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGameServerGroupsInput.Builder} to create a
     *        request.
     * @return Result of the ListGameServerGroups operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGameServerGroupsResponse listGameServerGroups(
            Consumer<ListGameServerGroupsRequest.Builder> listGameServerGroupsRequest) throws InvalidRequestException,
            UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return listGameServerGroups(ListGameServerGroupsRequest.builder().applyMutation(listGameServerGroupsRequest).build());
    }

    /**
     * <p>
     * Lists a game server groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsIterable responses = client.listGameServerGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsIterable responses = client
     *             .listGameServerGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsIterable responses = client.listGameServerGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGameServerGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGameServerGroupsIterable listGameServerGroupsPaginator(ListGameServerGroupsRequest listGameServerGroupsRequest)
            throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists a game server groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsIterable responses = client.listGameServerGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsIterable responses = client
     *             .listGameServerGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsIterable responses = client.listGameServerGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServerGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGameServerGroupsRequest#builder()}
     * </p>
     *
     * @param listGameServerGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGameServerGroupsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGameServerGroupsIterable listGameServerGroupsPaginator(
            Consumer<ListGameServerGroupsRequest.Builder> listGameServerGroupsRequest) throws InvalidRequestException,
            UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return listGameServerGroupsPaginator(ListGameServerGroupsRequest.builder().applyMutation(listGameServerGroupsRequest)
                .build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt
     * to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential
     * segments.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param listGameServersRequest
     * @return Result of the ListGameServers operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGameServersResponse listGameServers(ListGameServersRequest listGameServersRequest)
            throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt
     * to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential
     * segments.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGameServersRequest#builder()}
     * </p>
     *
     * @param listGameServersRequest
     *        A {@link Consumer} that will call methods on {@link ListGameServersInput.Builder} to create a request.
     * @return Result of the ListGameServers operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGameServersResponse listGameServers(Consumer<ListGameServersRequest.Builder> listGameServersRequest)
            throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listGameServers(ListGameServersRequest.builder().applyMutation(listGameServersRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt
     * to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential
     * segments.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersIterable responses = client.listGameServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListGameServersIterable responses = client
     *             .listGameServersPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListGameServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersIterable responses = client.listGameServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation.</b>
     * </p>
     *
     * @param listGameServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGameServersIterable listGameServersPaginator(ListGameServersRequest listGameServersRequest)
            throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt
     * to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential
     * segments.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersIterable responses = client.listGameServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListGameServersIterable responses = client
     *             .listGameServersPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListGameServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersIterable responses = client.listGameServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGameServersRequest#builder()}
     * </p>
     *
     * @param listGameServersRequest
     *        A {@link Consumer} that will call methods on {@link ListGameServersInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGameServersIterable listGameServersPaginator(Consumer<ListGameServersRequest.Builder> listGameServersRequest)
            throws InvalidRequestException, UnauthorizedException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listGameServersPaginator(ListGameServersRequest.builder().applyMutation(listGameServersRequest).build());
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services locations.
     * </p>
     *
     * @param listLocationsRequest
     * @return Result of the ListLocations operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsResponse listLocations(ListLocationsRequest listLocationsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services locations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLocationsInput.Builder} to create a request.
     * @return Result of the ListLocations operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsResponse listLocations(Consumer<ListLocationsRequest.Builder> listLocationsRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listLocations(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services locations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)} operation.</b>
     * </p>
     *
     * @param listLocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsIterable listLocationsPaginator(ListLocationsRequest listLocationsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services locations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsIterable responses = client.listLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLocationsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsIterable listLocationsPaginator(Consumer<ListLocationsRequest.Builder> listLocationsRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listLocationsPaginator(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in
     * use.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listScriptsRequest
     * @return Result of the ListScripts operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScriptsResponse listScripts(ListScriptsRequest listScriptsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in
     * use.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScriptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListScriptsRequest#builder()}
     * </p>
     *
     * @param listScriptsRequest
     *        A {@link Consumer} that will call methods on {@link ListScriptsInput.Builder} to create a request.
     * @return Result of the ListScripts operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScriptsResponse listScripts(Consumer<ListScriptsRequest.Builder> listScriptsRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listScripts(ListScriptsRequest.builder().applyMutation(listScriptsRequest).build());
    }

    /**
     * <p>
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in
     * use.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsIterable responses = client.listScriptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListScriptsIterable responses = client.listScriptsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListScriptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsIterable responses = client.listScriptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)} operation.</b>
     * </p>
     *
     * @param listScriptsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScriptsIterable listScriptsPaginator(ListScriptsRequest listScriptsRequest) throws UnauthorizedException,
            InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in
     * use.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsIterable responses = client.listScriptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.ListScriptsIterable responses = client.listScriptsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.ListScriptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsIterable responses = client.listScriptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScriptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListScriptsRequest#builder()}
     * </p>
     *
     * @param listScriptsRequest
     *        A {@link Consumer} that will call methods on {@link ListScriptsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScriptsIterable listScriptsPaginator(Consumer<ListScriptsRequest.Builder> listScriptsRequest)
            throws UnauthorizedException, InvalidRequestException, InternalServiceException, AwsServiceException,
            SdkClientException, GameLiftException {
        return listScriptsPaginator(ListScriptsRequest.builder().applyMutation(listScriptsRequest).build());
    }

    /**
     * <p>
     * Retrieves all tags assigned to a Amazon GameLift resource. Use resource tags to organize Amazon Web Services
     * resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon
     * GameLift resources that support tagging.
     * </p>
     * <p>
     * To list tags for a resource, specify the unique ARN value for the resource.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws NotFoundException, InvalidRequestException, TaggingFailedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all tags assigned to a Amazon GameLift resource. Use resource tags to organize Amazon Web Services
     * resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon
     * GameLift resources that support tagging.
     * </p>
     * <p>
     * To list tags for a resource, specify the unique ARN value for the resource.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws TaggingFailedException
     *         The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag
     *         limit may have been exceeded. Resolve the issue before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws NotFoundException,
            InvalidRequestException, TaggingFailedException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet's
     * hosting capacity to meet player demand. An active scaling policy instructs Amazon GameLift to track a fleet
     * metric and automatically change the fleet's capacity when a certain threshold is reached. There are two types of
     * scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently manage fleet
     * scaling; this option is the most commonly used. Use rule-based policies when you need to exert fine-grained
     * control over auto-scaling.
     * </p>
     * <p>
     * Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based
     * policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple
     * auto-scaling policies can have unintended consequences.
     * </p>
     * <p>
     * Learn more about how to work with auto-scaling in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html">Set Up Fleet Automatic
     * Scaling</a>.
     * </p>
     * <p>
     * <b>Target-based policy</b>
     * </p>
     * <p>
     * A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a
     * fleet's hosting capacity is ready to host game sessions but is not currently in use. This is the fleet's buffer;
     * it measures the additional player demand that the fleet could handle at current capacity. With a target-based
     * policy, you set your ideal buffer size and leave it to Amazon GameLift to take whatever action is needed to
     * maintain that target.
     * </p>
     * <p>
     * For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous
     * game sessions. This policy tells Amazon GameLift to take action whenever the fleet's available capacity falls
     * below or rises above 10 game sessions. Amazon GameLift will start new instances or stop unused instances in order
     * to return to the 10% buffer.
     * </p>
     * <p>
     * To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased".
     * Specify the metric to track (PercentAvailableGameSessions) and reference a <code>TargetConfiguration</code>
     * object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is
     * returned. The scaling policy is automatically in force as soon as it's successfully created. If the fleet's
     * auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are
     * restarted.
     * </p>
     * <p>
     * <b>Rule-based policy</b>
     * </p>
     * <p>
     * A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to
     * initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each
     * policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of
     * action.
     * </p>
     * <p>
     * For example, a policy may make the following statement:
     * "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."
     * </p>
     * <p>
     * A policy's rule statement has the following structure:
     * </p>
     * <p>
     * If <code>[MetricName]</code> is <code>[ComparisonOperator]</code> <code>[Threshold]</code> for
     * <code>[EvaluationPeriods]</code> minutes, then <code>[ScalingAdjustmentType]</code> to/by
     * <code>[ScalingAdjustment]</code>.
     * </p>
     * <p>
     * To implement the example, the rule statement would look like this:
     * </p>
     * <p>
     * If <code>[PercentIdleInstances]</code> is <code>[GreaterThanThreshold]</code> <code>[20]</code> for
     * <code>[15]</code> minutes, then <code>[PercentChangeInCapacity]</code> to/by <code>[10]</code>.
     * </p>
     * <p>
     * To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type
     * to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy
     * name is returned. Scaling policies are automatically in force as soon as they're successfully created. If the
     * fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions
     * are restarted.
     * </p>
     *
     * @param putScalingPolicyRequest
     * @return Result of the PutScalingPolicy operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet's
     * hosting capacity to meet player demand. An active scaling policy instructs Amazon GameLift to track a fleet
     * metric and automatically change the fleet's capacity when a certain threshold is reached. There are two types of
     * scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently manage fleet
     * scaling; this option is the most commonly used. Use rule-based policies when you need to exert fine-grained
     * control over auto-scaling.
     * </p>
     * <p>
     * Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based
     * policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple
     * auto-scaling policies can have unintended consequences.
     * </p>
     * <p>
     * Learn more about how to work with auto-scaling in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html">Set Up Fleet Automatic
     * Scaling</a>.
     * </p>
     * <p>
     * <b>Target-based policy</b>
     * </p>
     * <p>
     * A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a
     * fleet's hosting capacity is ready to host game sessions but is not currently in use. This is the fleet's buffer;
     * it measures the additional player demand that the fleet could handle at current capacity. With a target-based
     * policy, you set your ideal buffer size and leave it to Amazon GameLift to take whatever action is needed to
     * maintain that target.
     * </p>
     * <p>
     * For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous
     * game sessions. This policy tells Amazon GameLift to take action whenever the fleet's available capacity falls
     * below or rises above 10 game sessions. Amazon GameLift will start new instances or stop unused instances in order
     * to return to the 10% buffer.
     * </p>
     * <p>
     * To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased".
     * Specify the metric to track (PercentAvailableGameSessions) and reference a <code>TargetConfiguration</code>
     * object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is
     * returned. The scaling policy is automatically in force as soon as it's successfully created. If the fleet's
     * auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are
     * restarted.
     * </p>
     * <p>
     * <b>Rule-based policy</b>
     * </p>
     * <p>
     * A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to
     * initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each
     * policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of
     * action.
     * </p>
     * <p>
     * For example, a policy may make the following statement:
     * "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."
     * </p>
     * <p>
     * A policy's rule statement has the following structure:
     * </p>
     * <p>
     * If <code>[MetricName]</code> is <code>[ComparisonOperator]</code> <code>[Threshold]</code> for
     * <code>[EvaluationPeriods]</code> minutes, then <code>[ScalingAdjustmentType]</code> to/by
     * <code>[ScalingAdjustment]</code>.
     * </p>
     * <p>
     * To implement the example, the rule statement would look like this:
     * </p>
     * <p>
     * If <code>[PercentIdleInstances]</code> is <code>[GreaterThanThreshold]</code> <code>[20]</code> for
     * <code>[15]</code> minutes, then <code>[PercentChangeInCapacity]</code> to/by <code>[10]</code>.
     * </p>
     * <p>
     * To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type
     * to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy
     * name is returned. Scaling policies are automatically in force as soon as they're successfully created. If the
     * fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions
     * are restarted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScalingPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutScalingPolicyInput.Builder} to create a request.
     * @return Result of the PutScalingPolicy operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutScalingPolicyResponse putScalingPolicy(Consumer<PutScalingPolicyRequest.Builder> putScalingPolicyRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            AwsServiceException, SdkClientException, GameLiftException {
        return putScalingPolicy(PutScalingPolicyRequest.builder().applyMutation(putScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Registers your compute resources in a fleet you previously created. After you register a compute to your fleet,
     * you can monitor and manage your compute using Amazon GameLift. The operation returns the compute resource
     * containing SDK endpoint you can use to connect your game server to Amazon GameLift.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param registerComputeRequest
     * @return Result of the RegisterCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.RegisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterComputeResponse registerCompute(RegisterComputeRequest registerComputeRequest) throws UnauthorizedException,
            InvalidRequestException, ConflictException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers your compute resources in a fleet you previously created. After you register a compute to your fleet,
     * you can monitor and manage your compute using Amazon GameLift. The operation returns the compute resource
     * containing SDK endpoint you can use to connect your game server to Amazon GameLift.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterComputeRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterComputeRequest#builder()}
     * </p>
     *
     * @param registerComputeRequest
     *        A {@link Consumer} that will call methods on {@link RegisterComputeInput.Builder} to create a request.
     * @return Result of the RegisterCompute operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.RegisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterComputeResponse registerCompute(Consumer<RegisterComputeRequest.Builder> registerComputeRequest)
            throws UnauthorizedException, InvalidRequestException, ConflictException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        return registerCompute(RegisterComputeRequest.builder().applyMutation(registerComputeRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a new game server resource and notifies Amazon GameLift FleetIQ that the game server is ready to host
     * gameplay and players. This operation is called by a game server process that is running on an instance in a game
     * server group. Registering game servers enables Amazon GameLift FleetIQ to track available game servers and
     * enables game clients and services to claim a game server for a new game session.
     * </p>
     * <p>
     * To register a game server, identify the game server group and instance where the game server is running, and
     * provide a unique identifier for the game server. You can also include connection and game server data.
     * </p>
     * <p>
     * Once a game server is successfully registered, it is put in status <code>AVAILABLE</code>. A request to register
     * a game server may fail if the instance it is running on is in the process of shutting down as part of instance
     * balancing or scale-down activity.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param registerGameServerRequest
     * @return Result of the RegisterGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.RegisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterGameServerResponse registerGameServer(RegisterGameServerRequest registerGameServerRequest)
            throws InvalidRequestException, ConflictException, UnauthorizedException, LimitExceededException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a new game server resource and notifies Amazon GameLift FleetIQ that the game server is ready to host
     * gameplay and players. This operation is called by a game server process that is running on an instance in a game
     * server group. Registering game servers enables Amazon GameLift FleetIQ to track available game servers and
     * enables game clients and services to claim a game server for a new game session.
     * </p>
     * <p>
     * To register a game server, identify the game server group and instance where the game server is running, and
     * provide a unique identifier for the game server. You can also include connection and game server data.
     * </p>
     * <p>
     * Once a game server is successfully registered, it is put in status <code>AVAILABLE</code>. A request to register
     * a game server may fail if the instance it is running on is in the process of shutting down as part of instance
     * balancing or scale-down activity.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterGameServerRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterGameServerRequest#builder()}
     * </p>
     *
     * @param registerGameServerRequest
     *        A {@link Consumer} that will call methods on {@link RegisterGameServerInput.Builder} to create a request.
     * @return Result of the RegisterGameServer operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.</p>
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws LimitExceededException
     *         The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue
     *         before retrying.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.RegisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterGameServerResponse registerGameServer(Consumer<RegisterGameServerRequest.Builder> registerGameServerRequest)
            throws InvalidRequestException, ConflictException, UnauthorizedException, LimitExceededException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return registerGameServer(RegisterGameServerRequest.builder().applyMutation(registerGameServerRequest).build());
    }

    /**
     * <p>
     * Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon GameLift's
     * Amazon S3. This is done as part of the build creation process; see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html">GameSession</a>.
     * </p>
     * <p>
     * To request new credentials, specify the build ID as returned with an initial <code>CreateBuild</code> request. If
     * successful, a new set of credentials are returned, along with the S3 storage location associated with the build
     * ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param requestUploadCredentialsRequest
     * @return Result of the RequestUploadCredentials operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.RequestUploadCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestUploadCredentialsResponse requestUploadCredentials(
            RequestUploadCredentialsRequest requestUploadCredentialsRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon GameLift's
     * Amazon S3. This is done as part of the build creation process; see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html">GameSession</a>.
     * </p>
     * <p>
     * To request new credentials, specify the build ID as returned with an initial <code>CreateBuild</code> request. If
     * successful, a new set of credentials are returned, along with the S3 storage location associated with the build
     * ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestUploadCredentialsRequest.Builder} avoiding
     * the need to create one manually via {@link RequestUploadCredentialsRequest#builder()}
     * </p>
     *
     * @param requestUploadCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link RequestUploadCredentialsInput.Builder} to create a
     *        request.
     * @return Result of the RequestUploadCredentials operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.RequestUploadCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestUploadCredentialsResponse requestUploadCredentials(
            Consumer<RequestUploadCredentialsRequest.Builder> requestUploadCredentialsRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return requestUploadCredentials(RequestUploadCredentialsRequest.builder().applyMutation(requestUploadCredentialsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the fleet ID that an alias is currently pointing to.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param resolveAliasRequest
     * @return Result of the ResolveAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ResolveAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default ResolveAliasResponse resolveAlias(ResolveAliasRequest resolveAliasRequest) throws UnauthorizedException,
            InvalidRequestException, NotFoundException, TerminalRoutingStrategyException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the fleet ID that an alias is currently pointing to.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveAliasRequest.Builder} avoiding the need to
     * create one manually via {@link ResolveAliasRequest#builder()}
     * </p>
     *
     * @param resolveAliasRequest
     *        A {@link Consumer} that will call methods on {@link ResolveAliasInput.Builder} to create a request.
     * @return Result of the ResolveAlias operation returned by the service.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ResolveAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default ResolveAliasResponse resolveAlias(Consumer<ResolveAliasRequest.Builder> resolveAliasRequest)
            throws UnauthorizedException, InvalidRequestException, NotFoundException, TerminalRoutingStrategyException,
            InternalServiceException, AwsServiceException, SdkClientException, GameLiftException {
        return resolveAlias(ResolveAliasRequest.builder().applyMutation(resolveAliasRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Reinstates activity on a game server group after it has been suspended. A game server group might be suspended by
     * the <a href="gamelift/latest/apireference/API_SuspendGameServerGroup.html">SuspendGameServerGroup</a> operation,
     * or it might be suspended involuntarily due to a configuration problem. In the second case, you can manually
     * resume activity on the group once the configuration problem has been resolved. Refer to the game server group
     * status and status reason for more information on why group activity is suspended.
     * </p>
     * <p>
     * To resume activity, specify a game server group ARN and the type of activity to be resumed. If successful, a
     * <code>GameServerGroup</code> object is returned showing that the resumed activity is no longer listed in
     * <code>SuspendedActions</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param resumeGameServerGroupRequest
     * @return Result of the ResumeGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ResumeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResumeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeGameServerGroupResponse resumeGameServerGroup(ResumeGameServerGroupRequest resumeGameServerGroupRequest)
            throws InvalidRequestException, NotFoundException, UnauthorizedException, InternalServiceException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Reinstates activity on a game server group after it has been suspended. A game server group might be suspended by
     * the <a href="gamelift/latest/apireference/API_SuspendGameServerGroup.html">SuspendGameServerGroup</a> operation,
     * or it might be suspended involuntarily due to a configuration problem. In the second case, you can manually
     * resume activity on the group once the configuration problem has been resolved. Refer to the game server group
     * status and status reason for more information on why group activity is suspended.
     * </p>
     * <p>
     * To resume activity, specify a game server group ARN and the type of activity to be resumed. If successful, a
     * <code>GameServerGroup</code> object is returned showing that the resumed activity is no longer listed in
     * <code>SuspendedActions</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeGameServerGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ResumeGameServerGroupRequest#builder()}
     * </p>
     *
     * @param resumeGameServerGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResumeGameServerGroupInput.Builder} to create a
     *        request.
     * @return Result of the ResumeGameServerGroup operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.ResumeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResumeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeGameServerGroupResponse resumeGameServerGroup(
            Consumer<ResumeGameServerGroupRequest.Builder> resumeGameServerGroupRequest) throws InvalidRequestException,
            NotFoundException, UnauthorizedException, InternalServiceException, AwsServiceException, SdkClientException,
            GameLiftException {
        return resumeGameServerGroup(ResumeGameServerGroupRequest.builder().applyMutation(resumeGameServerGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling game
     * session status with <code>DescribeGameSessions</code> should only be used for games in development with low game
     * session usage.
     * </p>
     * <p>
     * When searching for game sessions, you specify exactly where you want to search and provide a search filter
     * expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a
     * fleet's locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID.
     * This approach returns game sessions in the fleet's home Region and all remote locations that fit the search
     * criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID
     * and a location name. For location, you can specify a fleet's home Region or any remote location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * Search finds game sessions that are in <code>ACTIVE</code> status only. To retrieve information on game sessions
     * in other statuses, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html"
     * >DescribeGameSessions</a> .
     * </p>
     * <p>
     * You can search or sort by the following game session attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>gameSessionId</b> -- A unique identifier for the game session. You can use either a <code>GameSessionId</code>
     * or <code>GameSessionArn</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionName</b> -- Name assigned to a game session. Game session names do not need to be unique to a game
     * session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionProperties</b> -- Custom data defined in a game session's <code>GameProperty</code> parameter.
     * <code>GameProperty</code> values are stored as key:value pairs; the filter expression must indicate the key and a
     * string to search the data values for. For example, to search for game sessions with custom data containing the
     * key:value pair "gameMode:brawl", specify the following: <code>gameSessionProperties.gameMode = "brawl"</code>.
     * All custom data values are searched as strings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>maximumSessions</b> -- Maximum number of player sessions allowed for a game session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>creationTimeMillis</b> -- Value indicating when a game session was created. It is expressed in Unix time as
     * milliseconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>playerSessionCount</b> -- Number of players currently connected to a game session. This value changes rapidly
     * as players join the session or drop out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>hasAvailablePlayerSessions</b> -- Boolean value indicating whether a game session has reached its maximum
     * number of players. It is highly recommended that all search requests include this filter attribute to optimize
     * search performance and return only sessions that players can join.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Returned values for <code>playerSessionCount</code> and <code>hasAvailablePlayerSessions</code> change quickly as
     * players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh
     * search results often, and handle sessions that fill up before a player can join.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param searchGameSessionsRequest
     * @return Result of the SearchGameSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.SearchGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGameSessionsResponse searchGameSessions(SearchGameSessionsRequest searchGameSessionsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            TerminalRoutingStrategyException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling game
     * session status with <code>DescribeGameSessions</code> should only be used for games in development with low game
     * session usage.
     * </p>
     * <p>
     * When searching for game sessions, you specify exactly where you want to search and provide a search filter
     * expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a
     * fleet's locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID.
     * This approach returns game sessions in the fleet's home Region and all remote locations that fit the search
     * criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID
     * and a location name. For location, you can specify a fleet's home Region or any remote location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * Search finds game sessions that are in <code>ACTIVE</code> status only. To retrieve information on game sessions
     * in other statuses, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html"
     * >DescribeGameSessions</a> .
     * </p>
     * <p>
     * You can search or sort by the following game session attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>gameSessionId</b> -- A unique identifier for the game session. You can use either a <code>GameSessionId</code>
     * or <code>GameSessionArn</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionName</b> -- Name assigned to a game session. Game session names do not need to be unique to a game
     * session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionProperties</b> -- Custom data defined in a game session's <code>GameProperty</code> parameter.
     * <code>GameProperty</code> values are stored as key:value pairs; the filter expression must indicate the key and a
     * string to search the data values for. For example, to search for game sessions with custom data containing the
     * key:value pair "gameMode:brawl", specify the following: <code>gameSessionProperties.gameMode = "brawl"</code>.
     * All custom data values are searched as strings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>maximumSessions</b> -- Maximum number of player sessions allowed for a game session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>creationTimeMillis</b> -- Value indicating when a game session was created. It is expressed in Unix time as
     * milliseconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>playerSessionCount</b> -- Number of players currently connected to a game session. This value changes rapidly
     * as players join the session or drop out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>hasAvailablePlayerSessions</b> -- Boolean value indicating whether a game session has reached its maximum
     * number of players. It is highly recommended that all search requests include this filter attribute to optimize
     * search performance and return only sessions that players can join.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Returned values for <code>playerSessionCount</code> and <code>hasAvailablePlayerSessions</code> change quickly as
     * players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh
     * search results often, and handle sessions that fill up before a player can join.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGameSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchGameSessionsRequest#builder()}
     * </p>
     *
     * @param searchGameSessionsRequest
     *        A {@link Consumer} that will call methods on {@link SearchGameSessionsInput.Builder} to create a request.
     * @return Result of the SearchGameSessions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.SearchGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGameSessionsResponse searchGameSessions(Consumer<SearchGameSessionsRequest.Builder> searchGameSessionsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            TerminalRoutingStrategyException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        return searchGameSessions(SearchGameSessionsRequest.builder().applyMutation(searchGameSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling game
     * session status with <code>DescribeGameSessions</code> should only be used for games in development with low game
     * session usage.
     * </p>
     * <p>
     * When searching for game sessions, you specify exactly where you want to search and provide a search filter
     * expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a
     * fleet's locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID.
     * This approach returns game sessions in the fleet's home Region and all remote locations that fit the search
     * criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID
     * and a location name. For location, you can specify a fleet's home Region or any remote location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * Search finds game sessions that are in <code>ACTIVE</code> status only. To retrieve information on game sessions
     * in other statuses, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html"
     * >DescribeGameSessions</a> .
     * </p>
     * <p>
     * You can search or sort by the following game session attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>gameSessionId</b> -- A unique identifier for the game session. You can use either a <code>GameSessionId</code>
     * or <code>GameSessionArn</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionName</b> -- Name assigned to a game session. Game session names do not need to be unique to a game
     * session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionProperties</b> -- Custom data defined in a game session's <code>GameProperty</code> parameter.
     * <code>GameProperty</code> values are stored as key:value pairs; the filter expression must indicate the key and a
     * string to search the data values for. For example, to search for game sessions with custom data containing the
     * key:value pair "gameMode:brawl", specify the following: <code>gameSessionProperties.gameMode = "brawl"</code>.
     * All custom data values are searched as strings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>maximumSessions</b> -- Maximum number of player sessions allowed for a game session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>creationTimeMillis</b> -- Value indicating when a game session was created. It is expressed in Unix time as
     * milliseconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>playerSessionCount</b> -- Number of players currently connected to a game session. This value changes rapidly
     * as players join the session or drop out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>hasAvailablePlayerSessions</b> -- Boolean value indicating whether a game session has reached its maximum
     * number of players. It is highly recommended that all search requests include this filter attribute to optimize
     * search performance and return only sessions that players can join.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Returned values for <code>playerSessionCount</code> and <code>hasAvailablePlayerSessions</code> change quickly as
     * players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh
     * search results often, and handle sessions that fill up before a player can join.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchGameSessions(software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsIterable responses = client.searchGameSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsIterable responses = client
     *             .searchGameSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsIterable responses = client.searchGameSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGameSessions(software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchGameSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.SearchGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGameSessionsIterable searchGameSessionsPaginator(SearchGameSessionsRequest searchGameSessionsRequest)
            throws InternalServiceException, NotFoundException, InvalidRequestException, UnauthorizedException,
            TerminalRoutingStrategyException, UnsupportedRegionException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling game
     * session status with <code>DescribeGameSessions</code> should only be used for games in development with low game
     * session usage.
     * </p>
     * <p>
     * When searching for game sessions, you specify exactly where you want to search and provide a search filter
     * expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a
     * fleet's locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID.
     * This approach returns game sessions in the fleet's home Region and all remote locations that fit the search
     * criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID
     * and a location name. For location, you can specify a fleet's home Region or any remote location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * Search finds game sessions that are in <code>ACTIVE</code> status only. To retrieve information on game sessions
     * in other statuses, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html"
     * >DescribeGameSessions</a> .
     * </p>
     * <p>
     * You can search or sort by the following game session attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>gameSessionId</b> -- A unique identifier for the game session. You can use either a <code>GameSessionId</code>
     * or <code>GameSessionArn</code> value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionName</b> -- Name assigned to a game session. Game session names do not need to be unique to a game
     * session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>gameSessionProperties</b> -- Custom data defined in a game session's <code>GameProperty</code> parameter.
     * <code>GameProperty</code> values are stored as key:value pairs; the filter expression must indicate the key and a
     * string to search the data values for. For example, to search for game sessions with custom data containing the
     * key:value pair "gameMode:brawl", specify the following: <code>gameSessionProperties.gameMode = "brawl"</code>.
     * All custom data values are searched as strings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>maximumSessions</b> -- Maximum number of player sessions allowed for a game session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>creationTimeMillis</b> -- Value indicating when a game session was created. It is expressed in Unix time as
     * milliseconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>playerSessionCount</b> -- Number of players currently connected to a game session. This value changes rapidly
     * as players join the session or drop out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>hasAvailablePlayerSessions</b> -- Boolean value indicating whether a game session has reached its maximum
     * number of players. It is highly recommended that all search requests include this filter attribute to optimize
     * search performance and return only sessions that players can join.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Returned values for <code>playerSessionCount</code> and <code>hasAvailablePlayerSessions</code> change quickly as
     * players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh
     * search results often, and handle sessions that fill up before a player can join.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchGameSessions(software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsIterable responses = client.searchGameSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsIterable responses = client
     *             .searchGameSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsIterable responses = client.searchGameSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGameSessions(software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGameSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchGameSessionsRequest#builder()}
     * </p>
     *
     * @param searchGameSessionsRequest
     *        A {@link Consumer} that will call methods on {@link SearchGameSessionsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws TerminalRoutingStrategyException
     *         The service is unable to resolve the routing for a particular alias because it has a terminal
     *         <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message
     *         defined in the routing strategy itself. Such requests should only be retried if the routing strategy for
     *         the specified alias is modified.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.SearchGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGameSessionsIterable searchGameSessionsPaginator(
            Consumer<SearchGameSessionsRequest.Builder> searchGameSessionsRequest) throws InternalServiceException,
            NotFoundException, InvalidRequestException, UnauthorizedException, TerminalRoutingStrategyException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return searchGameSessionsPaginator(SearchGameSessionsRequest.builder().applyMutation(searchGameSessionsRequest).build());
    }

    /**
     * <p>
     * Resumes certain types of activity on fleet instances that were suspended with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html">StopFleetActions</a>.
     * For multi-location fleets, fleet actions are managed separately for each location. Currently, this operation is
     * used to restart a fleet's auto-scaling activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To restart actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to resume.
     * </p>
     * </li>
     * <li>
     * <p>
     * To restart actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and
     * the type of actions to resume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, Amazon GameLift once again initiates scaling events as triggered by the fleet's scaling policies.
     * If actions on the fleet location were never stopped, this operation will have no effect.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param startFleetActionsRequest
     * @return Result of the StartFleetActions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartFleetActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartFleetActions" target="_top">AWS
     *      API Documentation</a>
     */
    default StartFleetActionsResponse startFleetActions(StartFleetActionsRequest startFleetActionsRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resumes certain types of activity on fleet instances that were suspended with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html">StopFleetActions</a>.
     * For multi-location fleets, fleet actions are managed separately for each location. Currently, this operation is
     * used to restart a fleet's auto-scaling activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To restart actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to resume.
     * </p>
     * </li>
     * <li>
     * <p>
     * To restart actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and
     * the type of actions to resume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, Amazon GameLift once again initiates scaling events as triggered by the fleet's scaling policies.
     * If actions on the fleet location were never stopped, this operation will have no effect.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFleetActionsRequest.Builder} avoiding the need
     * to create one manually via {@link StartFleetActionsRequest#builder()}
     * </p>
     *
     * @param startFleetActionsRequest
     *        A {@link Consumer} that will call methods on {@link StartFleetActionsInput.Builder} to create a request.
     * @return Result of the StartFleetActions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartFleetActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartFleetActions" target="_top">AWS
     *      API Documentation</a>
     */
    default StartFleetActionsResponse startFleetActions(Consumer<StartFleetActionsRequest.Builder> startFleetActionsRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return startFleetActions(StartFleetActionsRequest.builder().applyMutation(startFleetActionsRequest).build());
    }

    /**
     * <p>
     * Places a request for a new game session in a queue. When processing a placement request, Amazon GameLift searches
     * for available resources on the queue's destinations, scanning each until it finds resources or the placement
     * request times out.
     * </p>
     * <p>
     * A game session placement request can also request player sessions. When a new game session is successfully
     * created, Amazon GameLift creates a player session for each player included in the request.
     * </p>
     * <p>
     * When placing a game session, by default Amazon GameLift tries each fleet in the order they are listed in the
     * queue configuration. Ideally, a queue's destinations are listed in preference order.
     * </p>
     * <p>
     * Alternatively, when requesting a game session with players, you can also provide latency data for each player in
     * relevant Regions. Latency data indicates the performance lag a player experiences when connected to a fleet in
     * the Region. Amazon GameLift uses latency data to reorder the list of destinations to place the game session in a
     * Region with minimal lag. If latency data is provided for multiple players, Amazon GameLift calculates each
     * Region's average lag for all players and reorders to get the best game play across all players.
     * </p>
     * <p>
     * To place a new game session request, specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The queue name and a set of game session properties and settings
     * </p>
     * </li>
     * <li>
     * <p>
     * A unique ID (such as a UUID) for the placement. You use this ID to track the status of the placement request
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) A set of player data and a unique player ID for each player that you are joining to the new game
     * session (player data is optional, but if you include it, you must also provide a unique ID for each player)
     * </p>
     * </li>
     * <li>
     * <p>
     * Latency data for all players (if you want to optimize game play for the players)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a new game session placement is created.
     * </p>
     * <p>
     * To track the status of a placement request, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html"
     * >DescribeGameSessionPlacement</a> and check the request's status. If the status is <code>FULFILLED</code>, a new
     * game session has been created and a game session ARN and Region are referenced. If the placement request times
     * out, you can resubmit the request or retry it with a different queue.
     * </p>
     *
     * @param startGameSessionPlacementRequest
     * @return Result of the StartGameSessionPlacement operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default StartGameSessionPlacementResponse startGameSessionPlacement(
            StartGameSessionPlacementRequest startGameSessionPlacementRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Places a request for a new game session in a queue. When processing a placement request, Amazon GameLift searches
     * for available resources on the queue's destinations, scanning each until it finds resources or the placement
     * request times out.
     * </p>
     * <p>
     * A game session placement request can also request player sessions. When a new game session is successfully
     * created, Amazon GameLift creates a player session for each player included in the request.
     * </p>
     * <p>
     * When placing a game session, by default Amazon GameLift tries each fleet in the order they are listed in the
     * queue configuration. Ideally, a queue's destinations are listed in preference order.
     * </p>
     * <p>
     * Alternatively, when requesting a game session with players, you can also provide latency data for each player in
     * relevant Regions. Latency data indicates the performance lag a player experiences when connected to a fleet in
     * the Region. Amazon GameLift uses latency data to reorder the list of destinations to place the game session in a
     * Region with minimal lag. If latency data is provided for multiple players, Amazon GameLift calculates each
     * Region's average lag for all players and reorders to get the best game play across all players.
     * </p>
     * <p>
     * To place a new game session request, specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The queue name and a set of game session properties and settings
     * </p>
     * </li>
     * <li>
     * <p>
     * A unique ID (such as a UUID) for the placement. You use this ID to track the status of the placement request
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) A set of player data and a unique player ID for each player that you are joining to the new game
     * session (player data is optional, but if you include it, you must also provide a unique ID for each player)
     * </p>
     * </li>
     * <li>
     * <p>
     * Latency data for all players (if you want to optimize game play for the players)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a new game session placement is created.
     * </p>
     * <p>
     * To track the status of a placement request, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html"
     * >DescribeGameSessionPlacement</a> and check the request's status. If the status is <code>FULFILLED</code>, a new
     * game session has been created and a game session ARN and Region are referenced. If the placement request times
     * out, you can resubmit the request or retry it with a different queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartGameSessionPlacementRequest.Builder} avoiding
     * the need to create one manually via {@link StartGameSessionPlacementRequest#builder()}
     * </p>
     *
     * @param startGameSessionPlacementRequest
     *        A {@link Consumer} that will call methods on {@link StartGameSessionPlacementInput.Builder} to create a
     *        request.
     * @return Result of the StartGameSessionPlacement operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default StartGameSessionPlacementResponse startGameSessionPlacement(
            Consumer<StartGameSessionPlacementRequest.Builder> startGameSessionPlacementRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return startGameSessionPlacement(StartGameSessionPlacementRequest.builder()
                .applyMutation(startGameSessionPlacementRequest).build());
    }

    /**
     * <p>
     * Finds new players to fill open slots in currently running game sessions. The backfill match process is
     * essentially identical to the process of forming new matches. Backfill requests use the same matchmaker that was
     * used to make the original match, and they provide matchmaking data for all players currently in the game session.
     * FlexMatch uses this information to select new players so that backfilled match continues to meet the original
     * match requirements.
     * </p>
     * <p>
     * When using FlexMatch with Amazon GameLift managed hosting, you can request a backfill match from a client service
     * by calling this operation with a <code>GameSessions</code> ID. You also have the option of making backfill
     * requests directly from your game server. In response to a request, FlexMatch creates player sessions for the new
     * players, updates the <code>GameSession</code> resource, and sends updated matchmaking data to the game server.
     * You can request a backfill match at any point after a game session is started. Each game session can have only
     * one active backfill request at a time; a subsequent request automatically replaces the earlier request.
     * </p>
     * <p>
     * When using FlexMatch as a standalone component, request a backfill match by calling this operation without a game
     * session identifier. As with newly formed matches, matchmaking results are returned in a matchmaking event so that
     * your game can update the game session that is being backfilled.
     * </p>
     * <p>
     * To request a backfill match, specify a unique ticket ID, the original matchmaking configuration, and matchmaking
     * data for all current players in the game session being backfilled. Optionally, specify the
     * <code>GameSession</code> ARN. If successful, a match backfill ticket is created and returned with status set to
     * QUEUED. Track the status of backfill tickets using the same method for tracking tickets for new matches.
     * </p>
     * <p>
     * Only game sessions created by FlexMatch are supported for match backfill.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill existing games
     * with FlexMatch</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> Matchmaking events</a>
     * (reference)
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html"> How Amazon GameLift
     * FlexMatch works</a>
     * </p>
     *
     * @param startMatchBackfillRequest
     * @return Result of the StartMatchBackfill operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartMatchBackfill
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchBackfill" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMatchBackfillResponse startMatchBackfill(StartMatchBackfillRequest startMatchBackfillRequest)
            throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finds new players to fill open slots in currently running game sessions. The backfill match process is
     * essentially identical to the process of forming new matches. Backfill requests use the same matchmaker that was
     * used to make the original match, and they provide matchmaking data for all players currently in the game session.
     * FlexMatch uses this information to select new players so that backfilled match continues to meet the original
     * match requirements.
     * </p>
     * <p>
     * When using FlexMatch with Amazon GameLift managed hosting, you can request a backfill match from a client service
     * by calling this operation with a <code>GameSessions</code> ID. You also have the option of making backfill
     * requests directly from your game server. In response to a request, FlexMatch creates player sessions for the new
     * players, updates the <code>GameSession</code> resource, and sends updated matchmaking data to the game server.
     * You can request a backfill match at any point after a game session is started. Each game session can have only
     * one active backfill request at a time; a subsequent request automatically replaces the earlier request.
     * </p>
     * <p>
     * When using FlexMatch as a standalone component, request a backfill match by calling this operation without a game
     * session identifier. As with newly formed matches, matchmaking results are returned in a matchmaking event so that
     * your game can update the game session that is being backfilled.
     * </p>
     * <p>
     * To request a backfill match, specify a unique ticket ID, the original matchmaking configuration, and matchmaking
     * data for all current players in the game session being backfilled. Optionally, specify the
     * <code>GameSession</code> ARN. If successful, a match backfill ticket is created and returned with status set to
     * QUEUED. Track the status of backfill tickets using the same method for tracking tickets for new matches.
     * </p>
     * <p>
     * Only game sessions created by FlexMatch are supported for match backfill.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill existing games
     * with FlexMatch</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> Matchmaking events</a>
     * (reference)
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html"> How Amazon GameLift
     * FlexMatch works</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMatchBackfillRequest.Builder} avoiding the
     * need to create one manually via {@link StartMatchBackfillRequest#builder()}
     * </p>
     *
     * @param startMatchBackfillRequest
     *        A {@link Consumer} that will call methods on {@link StartMatchBackfillInput.Builder} to create a request.
     * @return Result of the StartMatchBackfill operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartMatchBackfill
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchBackfill" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMatchBackfillResponse startMatchBackfill(Consumer<StartMatchBackfillRequest.Builder> startMatchBackfillRequest)
            throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        return startMatchBackfill(StartMatchBackfillRequest.builder().applyMutation(startMatchBackfillRequest).build());
    }

    /**
     * <p>
     * Uses FlexMatch to create a game match for a group of players based on custom matchmaking rules. With games that
     * use Amazon GameLift managed hosting, this operation also triggers Amazon GameLift to find hosting resources and
     * start a new game session for the new match. Each matchmaking request includes information on one or more players
     * and specifies the FlexMatch matchmaker to use. When a request is for multiple players, FlexMatch attempts to
     * build a match that includes all players in the request, placing them in the same team and finding additional
     * players as needed to fill the match.
     * </p>
     * <p>
     * To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration, and include the players to
     * be matched. You must also include any player attributes that are required by the matchmaking configuration's rule
     * set. If successful, a matchmaking ticket is returned with status set to <code>QUEUED</code>.
     * </p>
     * <p>
     * Track matchmaking events to respond as needed and acquire game session connection information for successfully
     * completed matches. Ticket status updates are tracked using event notification through Amazon Simple Notification
     * Service, which is defined in the matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch
     * event notification</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html"> How Amazon GameLift
     * FlexMatch works</a>
     * </p>
     *
     * @param startMatchmakingRequest
     * @return Result of the StartMatchmaking operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartMatchmaking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchmaking" target="_top">AWS API
     *      Documentation</a>
     */
    default StartMatchmakingResponse startMatchmaking(StartMatchmakingRequest startMatchmakingRequest)
            throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uses FlexMatch to create a game match for a group of players based on custom matchmaking rules. With games that
     * use Amazon GameLift managed hosting, this operation also triggers Amazon GameLift to find hosting resources and
     * start a new game session for the new match. Each matchmaking request includes information on one or more players
     * and specifies the FlexMatch matchmaker to use. When a request is for multiple players, FlexMatch attempts to
     * build a match that includes all players in the request, placing them in the same team and finding additional
     * players as needed to fill the match.
     * </p>
     * <p>
     * To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration, and include the players to
     * be matched. You must also include any player attributes that are required by the matchmaking configuration's rule
     * set. If successful, a matchmaking ticket is returned with status set to <code>QUEUED</code>.
     * </p>
     * <p>
     * Track matchmaking events to respond as needed and acquire game session connection information for successfully
     * completed matches. Ticket status updates are tracked using event notification through Amazon Simple Notification
     * Service, which is defined in the matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch
     * event notification</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html"> How Amazon GameLift
     * FlexMatch works</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMatchmakingRequest.Builder} avoiding the need
     * to create one manually via {@link StartMatchmakingRequest#builder()}
     * </p>
     *
     * @param startMatchmakingRequest
     *        A {@link Consumer} that will call methods on {@link StartMatchmakingInput.Builder} to create a request.
     * @return Result of the StartMatchmaking operation returned by the service.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StartMatchmaking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchmaking" target="_top">AWS API
     *      Documentation</a>
     */
    default StartMatchmakingResponse startMatchmaking(Consumer<StartMatchmakingRequest.Builder> startMatchmakingRequest)
            throws InvalidRequestException, NotFoundException, InternalServiceException, UnsupportedRegionException,
            AwsServiceException, SdkClientException, GameLiftException {
        return startMatchmaking(StartMatchmakingRequest.builder().applyMutation(startMatchmakingRequest).build());
    }

    /**
     * <p>
     * Suspends certain types of activity in a fleet location. Currently, this operation is used to stop auto-scaling
     * activity. For multi-location fleets, fleet actions are managed separately for each location.
     * </p>
     * <p>
     * Stopping fleet actions has several potential purposes. It allows you to temporarily stop auto-scaling activity
     * but retain your scaling policies for use in the future. For multi-location fleets, you can set up fleet-wide
     * auto-scaling, and then opt out of it for certain locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To stop actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to suspend.
     * </p>
     * </li>
     * <li>
     * <p>
     * To stop actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the
     * type of actions to suspend.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, Amazon GameLift no longer initiates scaling events except in response to manual changes using <a
     * href
     * ="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     *
     * @param stopFleetActionsRequest
     * @return Result of the StopFleetActions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StopFleetActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopFleetActions" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFleetActionsResponse stopFleetActions(StopFleetActionsRequest stopFleetActionsRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends certain types of activity in a fleet location. Currently, this operation is used to stop auto-scaling
     * activity. For multi-location fleets, fleet actions are managed separately for each location.
     * </p>
     * <p>
     * Stopping fleet actions has several potential purposes. It allows you to temporarily stop auto-scaling activity
     * but retain your scaling policies for use in the future. For multi-location fleets, you can set up fleet-wide
     * auto-scaling, and then opt out of it for certain locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To stop actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to suspend.
     * </p>
     * </li>
     * <li>
     * <p>
     * To stop actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the
     * type of actions to suspend.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, Amazon GameLift no longer initiates scaling events except in response to manual changes using <a
     * href
     * ="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFleetActionsRequest.Builder} avoiding the need
     * to create one manually via {@link StopFleetActionsRequest#builder()}
     * </p>
     *
     * @param stopFleetActionsRequest
     *        A {@link Consumer} that will call methods on {@link StopFleetActionsInput.Builder} to create a request.
     * @return Result of the StopFleetActions operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnsupportedRegionException
     *         The requested operation is not supported in the Region specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StopFleetActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopFleetActions" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFleetActionsResponse stopFleetActions(Consumer<StopFleetActionsRequest.Builder> stopFleetActionsRequest)
            throws InternalServiceException, InvalidRequestException, UnauthorizedException, NotFoundException,
            UnsupportedRegionException, AwsServiceException, SdkClientException, GameLiftException {
        return stopFleetActions(StopFleetActionsRequest.builder().applyMutation(stopFleetActionsRequest).build());
    }

    /**
     * <p>
     * Cancels a game session placement that is in <code>PENDING</code> status. To stop a placement, provide the
     * placement ID values. If successful, the placement is moved to <code>CANCELLED</code> status.
     * </p>
     *
     * @param stopGameSessionPlacementRequest
     * @return Result of the StopGameSessionPlacement operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StopGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default StopGameSessionPlacementResponse stopGameSessionPlacement(
            StopGameSessionPlacementRequest stopGameSessionPlacementRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a game session placement that is in <code>PENDING</code> status. To stop a placement, provide the
     * placement ID values. If successful, the placement is moved to <code>CANCELLED</code> status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopGameSessionPlacementRequest.Builder} avoiding
     * the need to create one manually via {@link StopGameSessionPlacementRequest#builder()}
     * </p>
     *
     * @param stopGameSessionPlacementRequest
     *        A {@link Consumer} that will call methods on {@link StopGameSessionPlacementInput.Builder} to create a
     *        request.
     * @return Result of the StopGameSessionPlacement operation returned by the service.
     * @throws InternalServiceException
     *         The service encountered an unrecoverable internal failure while processing the request. Clients can retry
     *         such requests immediately or after a waiting period.
     * @throws InvalidRequestException
     *         One or more parameter values in the request are invalid. Correct the invalid parameter values before
     *         retrying.
     * @throws NotFoundException
     *         THe requested resources was not found. The resource was either not created yet or deleted.
     * @throws UnauthorizedException
     *         The client failed authentication. Clients should not retry such requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameLiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameLiftClient.StopGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default StopGameSessionPlacementResponse stopGameSessionPlacement(
            Consumer<StopGameSessionPlacementRequest.Builder> stopGameSessionPlacementRequest) throws InternalServiceException,
            InvalidRequestException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException,
            GameLiftException {
        return stopGameSessionPlacement(StopGameSessionPlacementRequest.builder().applyMutation(stopGameSessionPlacementRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a matchmaking ticket or match backfill ticket that is currently being processed. To stop the matchmaking
     * operation, specify the ticket ID. If successful, work on the ticket is stopped, and the ticket status is changed
     * to <code>CANCELLED</code>.
     * </p>
     * <p>
     * This call is also used to turn off automatic backfill for an individual game session. This is for game sessions
     * that are created with a matchmaking configuration that has automatic backfill enabled. The ticket ID is included
     * in the <code>MatchmakerData</code> of an updated game session object, which is provided to the game server.
     * </p>
     * <note>
     * <p>
     * If the operation is successful, the service sends back an empty JSON struct with the HTTP 200 response (not 