/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.gamelift.DefaultGameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.DefaultGameLiftBaseClientBuilder;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClientBuilder;
import software.amazon.awssdk.services.gamelift.GameLiftServiceClientConfiguration;
import software.amazon.awssdk.services.gamelift.endpoints.GameLiftEndpointProvider;

@SdkInternalApi
final class DefaultGameLiftAsyncClientBuilder
extends DefaultGameLiftBaseClientBuilder<GameLiftAsyncClientBuilder, GameLiftAsyncClient>
implements GameLiftAsyncClientBuilder {
    DefaultGameLiftAsyncClientBuilder() {
    }

    @Override
    public DefaultGameLiftAsyncClientBuilder endpointProvider(GameLiftEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GameLiftAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGameLiftAsyncClientBuilder.validateClientOptions(clientConfiguration);
        GameLiftServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGameLiftAsyncClient client = new DefaultGameLiftAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GameLiftServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GameLiftServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

