/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PriorityType {
    LATENCY("LATENCY"),
    COST("COST"),
    DESTINATION("DESTINATION"),
    LOCATION("LOCATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PriorityType> VALUE_MAP;
    private final String value;

    private PriorityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PriorityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PriorityType> knownValues() {
        EnumSet<PriorityType> knownValues = EnumSet.allOf(PriorityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PriorityType.class, PriorityType::toString);
    }
}

