/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Current resource utilization statistics in a specified fleet or location. The location value might refer to a fleet's
 * remote location or its home Region.
 * </p>
 * <p>
 * <b>Related actions</b>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetUtilization.Builder, FleetUtilization> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(FleetUtilization::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(FleetUtilization::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<Integer> ACTIVE_SERVER_PROCESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("ActiveServerProcessCount")
            .getter(getter(FleetUtilization::activeServerProcessCount)).setter(setter(Builder::activeServerProcessCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveServerProcessCount").build())
            .build();

    private static final SdkField<Integer> ACTIVE_GAME_SESSION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveGameSessionCount").getter(getter(FleetUtilization::activeGameSessionCount))
            .setter(setter(Builder::activeGameSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveGameSessionCount").build())
            .build();

    private static final SdkField<Integer> CURRENT_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CurrentPlayerSessionCount")
            .getter(getter(FleetUtilization::currentPlayerSessionCount)).setter(setter(Builder::currentPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPlayerSessionCount").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount")
            .getter(getter(FleetUtilization::maximumPlayerSessionCount)).setter(setter(Builder::maximumPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build())
            .build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(FleetUtilization::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, ACTIVE_SERVER_PROCESS_COUNT_FIELD, ACTIVE_GAME_SESSION_COUNT_FIELD,
            CURRENT_PLAYER_SESSION_COUNT_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final String fleetArn;

    private final Integer activeServerProcessCount;

    private final Integer activeGameSessionCount;

    private final Integer currentPlayerSessionCount;

    private final Integer maximumPlayerSessionCount;

    private final String location;

    private FleetUtilization(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.activeServerProcessCount = builder.activeServerProcessCount;
        this.activeGameSessionCount = builder.activeGameSessionCount;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.location = builder.location;
    }

    /**
     * <p>
     * A unique identifier for the fleet associated with the location.
     * </p>
     * 
     * @return A unique identifier for the fleet associated with the location.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * that is assigned to a Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all
     * Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
     *         <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The number of server processes in <code>ACTIVE</code> status that are currently running across all instances in
     * the fleet location.
     * </p>
     * 
     * @return The number of server processes in <code>ACTIVE</code> status that are currently running across all
     *         instances in the fleet location.
     */
    public final Integer activeServerProcessCount() {
        return activeServerProcessCount;
    }

    /**
     * <p>
     * The number of active game sessions that are currently being hosted across all instances in the fleet location.
     * </p>
     * 
     * @return The number of active game sessions that are currently being hosted across all instances in the fleet
     *         location.
     */
    public final Integer activeGameSessionCount() {
        return activeGameSessionCount;
    }

    /**
     * <p>
     * The number of active player sessions that are currently being hosted across all instances in the fleet location.
     * </p>
     * 
     * @return The number of active player sessions that are currently being hosted across all instances in the fleet
     *         location.
     */
    public final Integer currentPlayerSessionCount() {
        return currentPlayerSessionCount;
    }

    /**
     * <p>
     * The maximum number of players allowed across all game sessions that are currently being hosted across all
     * instances in the fleet location.
     * </p>
     * 
     * @return The maximum number of players allowed across all game sessions that are currently being hosted across all
     *         instances in the fleet location.
     */
    public final Integer maximumPlayerSessionCount() {
        return maximumPlayerSessionCount;
    }

    /**
     * <p>
     * The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region code, such
     * as <code>us-west-2</code>.
     * </p>
     * 
     * @return The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region
     *         code, such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(activeServerProcessCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeGameSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(currentPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetUtilization)) {
            return false;
        }
        FleetUtilization other = (FleetUtilization) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && Objects.equals(activeServerProcessCount(), other.activeServerProcessCount())
                && Objects.equals(activeGameSessionCount(), other.activeGameSessionCount())
                && Objects.equals(currentPlayerSessionCount(), other.currentPlayerSessionCount())
                && Objects.equals(maximumPlayerSessionCount(), other.maximumPlayerSessionCount())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetUtilization").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("ActiveServerProcessCount", activeServerProcessCount())
                .add("ActiveGameSessionCount", activeGameSessionCount())
                .add("CurrentPlayerSessionCount", currentPlayerSessionCount())
                .add("MaximumPlayerSessionCount", maximumPlayerSessionCount()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "ActiveServerProcessCount":
            return Optional.ofNullable(clazz.cast(activeServerProcessCount()));
        case "ActiveGameSessionCount":
            return Optional.ofNullable(clazz.cast(activeGameSessionCount()));
        case "CurrentPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(currentPlayerSessionCount()));
        case "MaximumPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(maximumPlayerSessionCount()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetUtilization, T> g) {
        return obj -> g.apply((FleetUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetUtilization> {
        /**
         * <p>
         * A unique identifier for the fleet associated with the location.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet associated with the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         * <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions.
         *        Format is
         *        <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The number of server processes in <code>ACTIVE</code> status that are currently running across all instances
         * in the fleet location.
         * </p>
         * 
         * @param activeServerProcessCount
         *        The number of server processes in <code>ACTIVE</code> status that are currently running across all
         *        instances in the fleet location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeServerProcessCount(Integer activeServerProcessCount);

        /**
         * <p>
         * The number of active game sessions that are currently being hosted across all instances in the fleet
         * location.
         * </p>
         * 
         * @param activeGameSessionCount
         *        The number of active game sessions that are currently being hosted across all instances in the fleet
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeGameSessionCount(Integer activeGameSessionCount);

        /**
         * <p>
         * The number of active player sessions that are currently being hosted across all instances in the fleet
         * location.
         * </p>
         * 
         * @param currentPlayerSessionCount
         *        The number of active player sessions that are currently being hosted across all instances in the fleet
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPlayerSessionCount(Integer currentPlayerSessionCount);

        /**
         * <p>
         * The maximum number of players allowed across all game sessions that are currently being hosted across all
         * instances in the fleet location.
         * </p>
         * 
         * @param maximumPlayerSessionCount
         *        The maximum number of players allowed across all game sessions that are currently being hosted across
         *        all instances in the fleet location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount);

        /**
         * <p>
         * The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region code,
         * such as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region
         *        code, such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private Integer activeServerProcessCount;

        private Integer activeGameSessionCount;

        private Integer currentPlayerSessionCount;

        private Integer maximumPlayerSessionCount;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetUtilization model) {
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            activeServerProcessCount(model.activeServerProcessCount);
            activeGameSessionCount(model.activeGameSessionCount);
            currentPlayerSessionCount(model.currentPlayerSessionCount);
            maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            location(model.location);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final Integer getActiveServerProcessCount() {
            return activeServerProcessCount;
        }

        public final void setActiveServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
        }

        @Override
        public final Builder activeServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
            return this;
        }

        public final Integer getActiveGameSessionCount() {
            return activeGameSessionCount;
        }

        public final void setActiveGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
        }

        @Override
        public final Builder activeGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
            return this;
        }

        public final Integer getCurrentPlayerSessionCount() {
            return currentPlayerSessionCount;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return maximumPlayerSessionCount;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public FleetUtilization build() {
            return new FleetUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
