/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComputeAuthTokenRequest extends GameLiftRequest implements
        ToCopyableBuilder<GetComputeAuthTokenRequest.Builder, GetComputeAuthTokenRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(GetComputeAuthTokenRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> COMPUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeName").getter(getter(GetComputeAuthTokenRequest::computeName))
            .setter(setter(Builder::computeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            COMPUTE_NAME_FIELD));

    private final String fleetId;

    private final String computeName;

    private GetComputeAuthTokenRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.computeName = builder.computeName;
    }

    /**
     * <p>
     * A unique identifier for the fleet that the compute is registered to.
     * </p>
     * 
     * @return A unique identifier for the fleet that the compute is registered to.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The name of the compute resource you are requesting the authentication token for. For an Anywhere fleet compute,
     * use the registered compute name. For an EC2 fleet instance, use the instance ID. For a container fleet, use the
     * compute name (for example, <code>a123b456c789012d3e4567f8a901b23c/1a234b56-7cd8-9e0f-a1b2-c34d567ef8a9</code>) or
     * the compute ARN.
     * </p>
     * 
     * @return The name of the compute resource you are requesting the authentication token for. For an Anywhere fleet
     *         compute, use the registered compute name. For an EC2 fleet instance, use the instance ID. For a container
     *         fleet, use the compute name (for example,
     *         <code>a123b456c789012d3e4567f8a901b23c/1a234b56-7cd8-9e0f-a1b2-c34d567ef8a9</code>) or the compute ARN.
     */
    public final String computeName() {
        return computeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(computeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComputeAuthTokenRequest)) {
            return false;
        }
        GetComputeAuthTokenRequest other = (GetComputeAuthTokenRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(computeName(), other.computeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComputeAuthTokenRequest").add("FleetId", fleetId()).add("ComputeName", computeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "ComputeName":
            return Optional.ofNullable(clazz.cast(computeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComputeAuthTokenRequest, T> g) {
        return obj -> g.apply((GetComputeAuthTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetComputeAuthTokenRequest> {
        /**
         * <p>
         * A unique identifier for the fleet that the compute is registered to.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet that the compute is registered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The name of the compute resource you are requesting the authentication token for. For an Anywhere fleet
         * compute, use the registered compute name. For an EC2 fleet instance, use the instance ID. For a container
         * fleet, use the compute name (for example,
         * <code>a123b456c789012d3e4567f8a901b23c/1a234b56-7cd8-9e0f-a1b2-c34d567ef8a9</code>) or the compute ARN.
         * </p>
         * 
         * @param computeName
         *        The name of the compute resource you are requesting the authentication token for. For an Anywhere
         *        fleet compute, use the registered compute name. For an EC2 fleet instance, use the instance ID. For a
         *        container fleet, use the compute name (for example,
         *        <code>a123b456c789012d3e4567f8a901b23c/1a234b56-7cd8-9e0f-a1b2-c34d567ef8a9</code>) or the compute
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeName(String computeName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String computeName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComputeAuthTokenRequest model) {
            super(model);
            fleetId(model.fleetId);
            computeName(model.computeName);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getComputeName() {
            return computeName;
        }

        public final void setComputeName(String computeName) {
            this.computeName = computeName;
        }

        @Override
        public final Builder computeName(String computeName) {
            this.computeName = computeName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComputeAuthTokenRequest build() {
            return new GetComputeAuthTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
