/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerGroupDefinitionRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateContainerGroupDefinitionRequest.Builder, CreateContainerGroupDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateContainerGroupDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchedulingStrategy").getter(getter(CreateContainerGroupDefinitionRequest::schedulingStrategyAsString))
            .setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulingStrategy").build())
            .build();

    private static final SdkField<Integer> TOTAL_MEMORY_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalMemoryLimit").getter(getter(CreateContainerGroupDefinitionRequest::totalMemoryLimit))
            .setter(setter(Builder::totalMemoryLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMemoryLimit").build()).build();

    private static final SdkField<Integer> TOTAL_CPU_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCpuLimit").getter(getter(CreateContainerGroupDefinitionRequest::totalCpuLimit))
            .setter(setter(Builder::totalCpuLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCpuLimit").build()).build();

    private static final SdkField<List<ContainerDefinitionInput>> CONTAINER_DEFINITIONS_FIELD = SdkField
            .<List<ContainerDefinitionInput>> builder(MarshallingType.LIST)
            .memberName("ContainerDefinitions")
            .getter(getter(CreateContainerGroupDefinitionRequest::containerDefinitions))
            .setter(setter(Builder::containerDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerDefinitionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerDefinitionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(CreateContainerGroupDefinitionRequest::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateContainerGroupDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SCHEDULING_STRATEGY_FIELD, TOTAL_MEMORY_LIMIT_FIELD, TOTAL_CPU_LIMIT_FIELD, CONTAINER_DEFINITIONS_FIELD,
            OPERATING_SYSTEM_FIELD, TAGS_FIELD));

    private final String name;

    private final String schedulingStrategy;

    private final Integer totalMemoryLimit;

    private final Integer totalCpuLimit;

    private final List<ContainerDefinitionInput> containerDefinitions;

    private final String operatingSystem;

    private final List<Tag> tags;

    private CreateContainerGroupDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.totalMemoryLimit = builder.totalMemoryLimit;
        this.totalCpuLimit = builder.totalCpuLimit;
        this.containerDefinitions = builder.containerDefinitions;
        this.operatingSystem = builder.operatingSystem;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web
     * Services Region.
     * </p>
     * 
     * @return A descriptive identifier for the container group definition. The name value must be unique in an Amazon
     *         Web Services Region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The method for deploying the container group across fleet instances. A replica container group might have
     * multiple copies on each fleet instance. A daemon container group has one copy per fleet instance. Default value
     * is <code>REPLICA</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link ContainerSchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The method for deploying the container group across fleet instances. A replica container group might have
     *         multiple copies on each fleet instance. A daemon container group has one copy per fleet instance. Default
     *         value is <code>REPLICA</code>.
     * @see ContainerSchedulingStrategy
     */
    public final ContainerSchedulingStrategy schedulingStrategy() {
        return ContainerSchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The method for deploying the container group across fleet instances. A replica container group might have
     * multiple copies on each fleet instance. A daemon container group has one copy per fleet instance. Default value
     * is <code>REPLICA</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link ContainerSchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The method for deploying the container group across fleet instances. A replica container group might have
     *         multiple copies on each fleet instance. A daemon container group has one copy per fleet instance. Default
     *         value is <code>REPLICA</code>.
     * @see ContainerSchedulingStrategy
     */
    public final String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    /**
     * <p>
     * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share this
     * memory. If you specify memory limits for individual containers, set this parameter based on the following
     * guidelines. The value must be (1) greater than the sum of the soft memory limits for all containers in the group,
     * and (2) greater than any individual container's hard memory limit.
     * </p>
     * 
     * @return The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group
     *         share this memory. If you specify memory limits for individual containers, set this parameter based on
     *         the following guidelines. The value must be (1) greater than the sum of the soft memory limits for all
     *         containers in the group, and (2) greater than any individual container's hard memory limit.
     */
    public final Integer totalMemoryLimit() {
        return totalMemoryLimit;
    }

    /**
     * <p>
     * The maximum amount of CPU units to allocate to the container group. Set this parameter to an integer value in CPU
     * units (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory. If you specify CPU
     * limits for individual containers, set this parameter based on the following guidelines. The value must be equal
     * to or greater than the sum of the CPU limits for all containers in the group.
     * </p>
     * 
     * @return The maximum amount of CPU units to allocate to the container group. Set this parameter to an integer
     *         value in CPU units (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory. If
     *         you specify CPU limits for individual containers, set this parameter based on the following guidelines.
     *         The value must be equal to or greater than the sum of the CPU limits for all containers in the group.
     */
    public final Integer totalCpuLimit() {
        return totalCpuLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerDefinitions() {
        return containerDefinitions != null && !(containerDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Definitions for all containers in this group. Each container definition identifies the container image and
     * specifies configuration settings for the container. See the <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html"> Container fleet
     * design guide</a> for container guidelines.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerDefinitions} method.
     * </p>
     * 
     * @return Definitions for all containers in this group. Each container definition identifies the container image
     *         and specifies configuration settings for the container. See the <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html"> Container
     *         fleet design guide</a> for container guidelines.
     */
    public final List<ContainerDefinitionInput> containerDefinitions() {
        return containerDefinitions;
    }

    /**
     * <p>
     * The platform that is used by containers in the container group definition. All containers in a group must run on
     * the same operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link ContainerOperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The platform that is used by containers in the container group definition. All containers in a group must
     *         run on the same operating system.
     * @see ContainerOperatingSystem
     */
    public final ContainerOperatingSystem operatingSystem() {
        return ContainerOperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The platform that is used by containers in the container group definition. All containers in a group must run on
     * the same operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link ContainerOperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The platform that is used by containers in the container group definition. All containers in a group must
     *         run on the same operating system.
     * @see ContainerOperatingSystem
     */
    public final String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the container group definition resource. Tags are developer-defined key-value
     * pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost
     * allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
     * Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of labels to assign to the container group definition resource. Tags are developer-defined
     *         key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access
     *         management and cost allocation. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
     *         Resources</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalMemoryLimit());
        hashCode = 31 * hashCode + Objects.hashCode(totalCpuLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerDefinitions() ? containerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerGroupDefinitionRequest)) {
            return false;
        }
        CreateContainerGroupDefinitionRequest other = (CreateContainerGroupDefinitionRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString())
                && Objects.equals(totalMemoryLimit(), other.totalMemoryLimit())
                && Objects.equals(totalCpuLimit(), other.totalCpuLimit())
                && hasContainerDefinitions() == other.hasContainerDefinitions()
                && Objects.equals(containerDefinitions(), other.containerDefinitions())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContainerGroupDefinitionRequest").add("Name", name())
                .add("SchedulingStrategy", schedulingStrategyAsString()).add("TotalMemoryLimit", totalMemoryLimit())
                .add("TotalCpuLimit", totalCpuLimit())
                .add("ContainerDefinitions", hasContainerDefinitions() ? containerDefinitions() : null)
                .add("OperatingSystem", operatingSystemAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SchedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        case "TotalMemoryLimit":
            return Optional.ofNullable(clazz.cast(totalMemoryLimit()));
        case "TotalCpuLimit":
            return Optional.ofNullable(clazz.cast(totalCpuLimit()));
        case "ContainerDefinitions":
            return Optional.ofNullable(clazz.cast(containerDefinitions()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerGroupDefinitionRequest, T> g) {
        return obj -> g.apply((CreateContainerGroupDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateContainerGroupDefinitionRequest> {
        /**
         * <p>
         * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web
         * Services Region.
         * </p>
         * 
         * @param name
         *        A descriptive identifier for the container group definition. The name value must be unique in an
         *        Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The method for deploying the container group across fleet instances. A replica container group might have
         * multiple copies on each fleet instance. A daemon container group has one copy per fleet instance. Default
         * value is <code>REPLICA</code>.
         * </p>
         * 
         * @param schedulingStrategy
         *        The method for deploying the container group across fleet instances. A replica container group might
         *        have multiple copies on each fleet instance. A daemon container group has one copy per fleet instance.
         *        Default value is <code>REPLICA</code>.
         * @see ContainerSchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerSchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The method for deploying the container group across fleet instances. A replica container group might have
         * multiple copies on each fleet instance. A daemon container group has one copy per fleet instance. Default
         * value is <code>REPLICA</code>.
         * </p>
         * 
         * @param schedulingStrategy
         *        The method for deploying the container group across fleet instances. A replica container group might
         *        have multiple copies on each fleet instance. A daemon container group has one copy per fleet instance.
         *        Default value is <code>REPLICA</code>.
         * @see ContainerSchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerSchedulingStrategy
         */
        Builder schedulingStrategy(ContainerSchedulingStrategy schedulingStrategy);

        /**
         * <p>
         * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share
         * this memory. If you specify memory limits for individual containers, set this parameter based on the
         * following guidelines. The value must be (1) greater than the sum of the soft memory limits for all containers
         * in the group, and (2) greater than any individual container's hard memory limit.
         * </p>
         * 
         * @param totalMemoryLimit
         *        The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group
         *        share this memory. If you specify memory limits for individual containers, set this parameter based on
         *        the following guidelines. The value must be (1) greater than the sum of the soft memory limits for all
         *        containers in the group, and (2) greater than any individual container's hard memory limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMemoryLimit(Integer totalMemoryLimit);

        /**
         * <p>
         * The maximum amount of CPU units to allocate to the container group. Set this parameter to an integer value in
         * CPU units (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory. If you specify
         * CPU limits for individual containers, set this parameter based on the following guidelines. The value must be
         * equal to or greater than the sum of the CPU limits for all containers in the group.
         * </p>
         * 
         * @param totalCpuLimit
         *        The maximum amount of CPU units to allocate to the container group. Set this parameter to an integer
         *        value in CPU units (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory.
         *        If you specify CPU limits for individual containers, set this parameter based on the following
         *        guidelines. The value must be equal to or greater than the sum of the CPU limits for all containers in
         *        the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCpuLimit(Integer totalCpuLimit);

        /**
         * <p>
         * Definitions for all containers in this group. Each container definition identifies the container image and
         * specifies configuration settings for the container. See the <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html"> Container
         * fleet design guide</a> for container guidelines.
         * </p>
         * 
         * @param containerDefinitions
         *        Definitions for all containers in this group. Each container definition identifies the container image
         *        and specifies configuration settings for the container. See the <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html">
         *        Container fleet design guide</a> for container guidelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDefinitions(Collection<ContainerDefinitionInput> containerDefinitions);

        /**
         * <p>
         * Definitions for all containers in this group. Each container definition identifies the container image and
         * specifies configuration settings for the container. See the <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html"> Container
         * fleet design guide</a> for container guidelines.
         * </p>
         * 
         * @param containerDefinitions
         *        Definitions for all containers in this group. Each container definition identifies the container image
         *        and specifies configuration settings for the container. See the <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html">
         *        Container fleet design guide</a> for container guidelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDefinitions(ContainerDefinitionInput... containerDefinitions);

        /**
         * <p>
         * Definitions for all containers in this group. Each container definition identifies the container image and
         * specifies configuration settings for the container. See the <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html"> Container
         * fleet design guide</a> for container guidelines.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerDefinitionInput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerDefinitionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerDefinitionInput.Builder#build()} is called
         * immediately and its result is passed to {@link #containerDefinitions(List<ContainerDefinitionInput>)}.
         * 
         * @param containerDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.ContainerDefinitionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerDefinitions(java.util.Collection<ContainerDefinitionInput>)
         */
        Builder containerDefinitions(Consumer<ContainerDefinitionInput.Builder>... containerDefinitions);

        /**
         * <p>
         * The platform that is used by containers in the container group definition. All containers in a group must run
         * on the same operating system.
         * </p>
         * 
         * @param operatingSystem
         *        The platform that is used by containers in the container group definition. All containers in a group
         *        must run on the same operating system.
         * @see ContainerOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerOperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The platform that is used by containers in the container group definition. All containers in a group must run
         * on the same operating system.
         * </p>
         * 
         * @param operatingSystem
         *        The platform that is used by containers in the container group definition. All containers in a group
         *        must run on the same operating system.
         * @see ContainerOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerOperatingSystem
         */
        Builder operatingSystem(ContainerOperatingSystem operatingSystem);

        /**
         * <p>
         * A list of labels to assign to the container group definition resource. Tags are developer-defined key-value
         * pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost
         * allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the container group definition resource. Tags are developer-defined
         *        key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access
         *        management and cost allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the container group definition resource. Tags are developer-defined key-value
         * pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost
         * allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the container group definition resource. Tags are developer-defined
         *        key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access
         *        management and cost allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the container group definition resource. Tags are developer-defined key-value
         * pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost
         * allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.gamelift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private String schedulingStrategy;

        private Integer totalMemoryLimit;

        private Integer totalCpuLimit;

        private List<ContainerDefinitionInput> containerDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String operatingSystem;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerGroupDefinitionRequest model) {
            super(model);
            name(model.name);
            schedulingStrategy(model.schedulingStrategy);
            totalMemoryLimit(model.totalMemoryLimit);
            totalCpuLimit(model.totalCpuLimit);
            containerDefinitions(model.containerDefinitions);
            operatingSystem(model.operatingSystem);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSchedulingStrategy() {
            return schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(ContainerSchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final Integer getTotalMemoryLimit() {
            return totalMemoryLimit;
        }

        public final void setTotalMemoryLimit(Integer totalMemoryLimit) {
            this.totalMemoryLimit = totalMemoryLimit;
        }

        @Override
        public final Builder totalMemoryLimit(Integer totalMemoryLimit) {
            this.totalMemoryLimit = totalMemoryLimit;
            return this;
        }

        public final Integer getTotalCpuLimit() {
            return totalCpuLimit;
        }

        public final void setTotalCpuLimit(Integer totalCpuLimit) {
            this.totalCpuLimit = totalCpuLimit;
        }

        @Override
        public final Builder totalCpuLimit(Integer totalCpuLimit) {
            this.totalCpuLimit = totalCpuLimit;
            return this;
        }

        public final List<ContainerDefinitionInput.Builder> getContainerDefinitions() {
            List<ContainerDefinitionInput.Builder> result = ContainerDefinitionInputListCopier
                    .copyToBuilder(this.containerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerDefinitions(Collection<ContainerDefinitionInput.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionInputListCopier.copyFromBuilder(containerDefinitions);
        }

        @Override
        public final Builder containerDefinitions(Collection<ContainerDefinitionInput> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionInputListCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(ContainerDefinitionInput... containerDefinitions) {
            containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<ContainerDefinitionInput.Builder>... containerDefinitions) {
            containerDefinitions(Stream.of(containerDefinitions)
                    .map(c -> ContainerDefinitionInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(ContainerOperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerGroupDefinitionRequest build() {
            return new CreateContainerGroupDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
