/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</b>
 * </p>
 * <p>
 * The properties of a container group that is deployed to a container fleet.
 * </p>
 * <p>
 * <b>Part of:</b> <a>ContainerGroupsAttributes</a>
 * </p>
 * <p>
 * <b>Returned by:</b> <a>DescribeFleetAttributes</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerGroupDefinitionProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerGroupDefinitionProperty.Builder, ContainerGroupDefinitionProperty> {
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchedulingStrategy").getter(getter(ContainerGroupDefinitionProperty::schedulingStrategyAsString))
            .setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulingStrategy").build())
            .build();

    private static final SdkField<String> CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContainerGroupDefinitionName")
            .getter(getter(ContainerGroupDefinitionProperty::containerGroupDefinitionName))
            .setter(setter(Builder::containerGroupDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULING_STRATEGY_FIELD,
            CONTAINER_GROUP_DEFINITION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String schedulingStrategy;

    private final String containerGroupDefinitionName;

    private ContainerGroupDefinitionProperty(BuilderImpl builder) {
        this.schedulingStrategy = builder.schedulingStrategy;
        this.containerGroupDefinitionName = builder.containerGroupDefinitionName;
    }

    /**
     * <p>
     * The method for scheduling and maintaining copies of the container group across a container fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link ContainerSchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The method for scheduling and maintaining copies of the container group across a container fleet.
     * @see ContainerSchedulingStrategy
     */
    public final ContainerSchedulingStrategy schedulingStrategy() {
        return ContainerSchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The method for scheduling and maintaining copies of the container group across a container fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link ContainerSchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The method for scheduling and maintaining copies of the container group across a container fleet.
     * @see ContainerSchedulingStrategy
     */
    public final String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    /**
     * <p>
     * The unique identifier for the container group definition.
     * </p>
     * 
     * @return The unique identifier for the container group definition.
     */
    public final String containerGroupDefinitionName() {
        return containerGroupDefinitionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(containerGroupDefinitionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupDefinitionProperty)) {
            return false;
        }
        ContainerGroupDefinitionProperty other = (ContainerGroupDefinitionProperty) obj;
        return Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString())
                && Objects.equals(containerGroupDefinitionName(), other.containerGroupDefinitionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerGroupDefinitionProperty").add("SchedulingStrategy", schedulingStrategyAsString())
                .add("ContainerGroupDefinitionName", containerGroupDefinitionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        case "ContainerGroupDefinitionName":
            return Optional.ofNullable(clazz.cast(containerGroupDefinitionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupDefinitionProperty, T> g) {
        return obj -> g.apply((ContainerGroupDefinitionProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerGroupDefinitionProperty> {
        /**
         * <p>
         * The method for scheduling and maintaining copies of the container group across a container fleet.
         * </p>
         * 
         * @param schedulingStrategy
         *        The method for scheduling and maintaining copies of the container group across a container fleet.
         * @see ContainerSchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerSchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The method for scheduling and maintaining copies of the container group across a container fleet.
         * </p>
         * 
         * @param schedulingStrategy
         *        The method for scheduling and maintaining copies of the container group across a container fleet.
         * @see ContainerSchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerSchedulingStrategy
         */
        Builder schedulingStrategy(ContainerSchedulingStrategy schedulingStrategy);

        /**
         * <p>
         * The unique identifier for the container group definition.
         * </p>
         * 
         * @param containerGroupDefinitionName
         *        The unique identifier for the container group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitionName(String containerGroupDefinitionName);
    }

    static final class BuilderImpl implements Builder {
        private String schedulingStrategy;

        private String containerGroupDefinitionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupDefinitionProperty model) {
            schedulingStrategy(model.schedulingStrategy);
            containerGroupDefinitionName(model.containerGroupDefinitionName);
        }

        public final String getSchedulingStrategy() {
            return schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(ContainerSchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final String getContainerGroupDefinitionName() {
            return containerGroupDefinitionName;
        }

        public final void setContainerGroupDefinitionName(String containerGroupDefinitionName) {
            this.containerGroupDefinitionName = containerGroupDefinitionName;
        }

        @Override
        public final Builder containerGroupDefinitionName(String containerGroupDefinitionName) {
            this.containerGroupDefinitionName = containerGroupDefinitionName;
            return this;
        }

        @Override
        public ContainerGroupDefinitionProperty build() {
            return new ContainerGroupDefinitionProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
