/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ConnectionPortRange;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionPropertiesListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionProperty;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupsPerInstance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerGroupsAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerGroupsAttributes> {
    private static final SdkField<List<ContainerGroupDefinitionProperty>> CONTAINER_GROUP_DEFINITION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerGroupDefinitionProperties").getter(ContainerGroupsAttributes.getter(ContainerGroupsAttributes::containerGroupDefinitionProperties)).setter(ContainerGroupsAttributes.setter(Builder::containerGroupDefinitionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerGroupDefinitionProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectionPortRange> CONNECTION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionPortRange").getter(ContainerGroupsAttributes.getter(ContainerGroupsAttributes::connectionPortRange)).setter(ContainerGroupsAttributes.setter(Builder::connectionPortRange)).constructor(ConnectionPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPortRange").build()}).build();
    private static final SdkField<ContainerGroupsPerInstance> CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerGroupsPerInstance").getter(ContainerGroupsAttributes.getter(ContainerGroupsAttributes::containerGroupsPerInstance)).setter(ContainerGroupsAttributes.setter(Builder::containerGroupsPerInstance)).constructor(ContainerGroupsPerInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupsPerInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_GROUP_DEFINITION_PROPERTIES_FIELD, CONNECTION_PORT_RANGE_FIELD, CONTAINER_GROUPS_PER_INSTANCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties;
    private final ConnectionPortRange connectionPortRange;
    private final ContainerGroupsPerInstance containerGroupsPerInstance;

    private ContainerGroupsAttributes(BuilderImpl builder) {
        this.containerGroupDefinitionProperties = builder.containerGroupDefinitionProperties;
        this.connectionPortRange = builder.connectionPortRange;
        this.containerGroupsPerInstance = builder.containerGroupsPerInstance;
    }

    public final boolean hasContainerGroupDefinitionProperties() {
        return this.containerGroupDefinitionProperties != null && !(this.containerGroupDefinitionProperties instanceof SdkAutoConstructList);
    }

    public final List<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties() {
        return this.containerGroupDefinitionProperties;
    }

    public final ConnectionPortRange connectionPortRange() {
        return this.connectionPortRange;
    }

    public final ContainerGroupsPerInstance containerGroupsPerInstance() {
        return this.containerGroupsPerInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerGroupDefinitionProperties() ? this.containerGroupDefinitionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerGroupsPerInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupsAttributes)) {
            return false;
        }
        ContainerGroupsAttributes other = (ContainerGroupsAttributes)obj;
        return this.hasContainerGroupDefinitionProperties() == other.hasContainerGroupDefinitionProperties() && Objects.equals(this.containerGroupDefinitionProperties(), other.containerGroupDefinitionProperties()) && Objects.equals(this.connectionPortRange(), other.connectionPortRange()) && Objects.equals(this.containerGroupsPerInstance(), other.containerGroupsPerInstance());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerGroupsAttributes").add("ContainerGroupDefinitionProperties", this.hasContainerGroupDefinitionProperties() ? this.containerGroupDefinitionProperties() : null).add("ConnectionPortRange", (Object)this.connectionPortRange()).add("ContainerGroupsPerInstance", (Object)this.containerGroupsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerGroupDefinitionProperties": {
                return Optional.ofNullable(clazz.cast(this.containerGroupDefinitionProperties()));
            }
            case "ConnectionPortRange": {
                return Optional.ofNullable(clazz.cast(this.connectionPortRange()));
            }
            case "ContainerGroupsPerInstance": {
                return Optional.ofNullable(clazz.cast(this.containerGroupsPerInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupsAttributes, T> g) {
        return obj -> g.apply((ContainerGroupsAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties = DefaultSdkAutoConstructList.getInstance();
        private ConnectionPortRange connectionPortRange;
        private ContainerGroupsPerInstance containerGroupsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupsAttributes model) {
            this.containerGroupDefinitionProperties(model.containerGroupDefinitionProperties);
            this.connectionPortRange(model.connectionPortRange);
            this.containerGroupsPerInstance(model.containerGroupsPerInstance);
        }

        public final List<ContainerGroupDefinitionProperty.Builder> getContainerGroupDefinitionProperties() {
            List<ContainerGroupDefinitionProperty.Builder> result = ContainerGroupDefinitionPropertiesListCopier.copyToBuilder(this.containerGroupDefinitionProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerGroupDefinitionProperties(Collection<ContainerGroupDefinitionProperty.BuilderImpl> containerGroupDefinitionProperties) {
            this.containerGroupDefinitionProperties = ContainerGroupDefinitionPropertiesListCopier.copyFromBuilder(containerGroupDefinitionProperties);
        }

        @Override
        public final Builder containerGroupDefinitionProperties(Collection<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties) {
            this.containerGroupDefinitionProperties = ContainerGroupDefinitionPropertiesListCopier.copy(containerGroupDefinitionProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitionProperties(ContainerGroupDefinitionProperty ... containerGroupDefinitionProperties) {
            this.containerGroupDefinitionProperties(Arrays.asList(containerGroupDefinitionProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitionProperties(Consumer<ContainerGroupDefinitionProperty.Builder> ... containerGroupDefinitionProperties) {
            this.containerGroupDefinitionProperties(Stream.of(containerGroupDefinitionProperties).map(c -> (ContainerGroupDefinitionProperty)((ContainerGroupDefinitionProperty.Builder)ContainerGroupDefinitionProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConnectionPortRange.Builder getConnectionPortRange() {
            return this.connectionPortRange != null ? this.connectionPortRange.toBuilder() : null;
        }

        public final void setConnectionPortRange(ConnectionPortRange.BuilderImpl connectionPortRange) {
            this.connectionPortRange = connectionPortRange != null ? connectionPortRange.build() : null;
        }

        @Override
        public final Builder connectionPortRange(ConnectionPortRange connectionPortRange) {
            this.connectionPortRange = connectionPortRange;
            return this;
        }

        public final ContainerGroupsPerInstance.Builder getContainerGroupsPerInstance() {
            return this.containerGroupsPerInstance != null ? this.containerGroupsPerInstance.toBuilder() : null;
        }

        public final void setContainerGroupsPerInstance(ContainerGroupsPerInstance.BuilderImpl containerGroupsPerInstance) {
            this.containerGroupsPerInstance = containerGroupsPerInstance != null ? containerGroupsPerInstance.build() : null;
        }

        @Override
        public final Builder containerGroupsPerInstance(ContainerGroupsPerInstance containerGroupsPerInstance) {
            this.containerGroupsPerInstance = containerGroupsPerInstance;
            return this;
        }

        public ContainerGroupsAttributes build() {
            return new ContainerGroupsAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerGroupsAttributes> {
        public Builder containerGroupDefinitionProperties(Collection<ContainerGroupDefinitionProperty> var1);

        public Builder containerGroupDefinitionProperties(ContainerGroupDefinitionProperty ... var1);

        public Builder containerGroupDefinitionProperties(Consumer<ContainerGroupDefinitionProperty.Builder> ... var1);

        public Builder connectionPortRange(ConnectionPortRange var1);

        default public Builder connectionPortRange(Consumer<ConnectionPortRange.Builder> connectionPortRange) {
            return this.connectionPortRange((ConnectionPortRange)((ConnectionPortRange.Builder)ConnectionPortRange.builder().applyMutation(connectionPortRange)).build());
        }

        public Builder containerGroupsPerInstance(ContainerGroupsPerInstance var1);

        default public Builder containerGroupsPerInstance(Consumer<ContainerGroupsPerInstance.Builder> containerGroupsPerInstance) {
            return this.containerGroupsPerInstance((ContainerGroupsPerInstance)((ContainerGroupsPerInstance.Builder)ContainerGroupsPerInstance.builder().applyMutation(containerGroupsPerInstance)).build());
        }
    }
}

