/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.BalancingStrategy;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupAutoScalingPolicy;
import software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.InstanceDefinition;
import software.amazon.awssdk.services.gamelift.model.InstanceDefinitionsCopier;
import software.amazon.awssdk.services.gamelift.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.gamelift.model.Tag;
import software.amazon.awssdk.services.gamelift.model.TagListCopier;
import software.amazon.awssdk.services.gamelift.model.VpcSubnetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGameServerGroupRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupName").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::gameServerGroupName)).setter(CreateGameServerGroupRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::roleArn)).setter(CreateGameServerGroupRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSize").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::minSize)).setter(CreateGameServerGroupRequest.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSize").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::maxSize)).setter(CreateGameServerGroupRequest.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::launchTemplate)).setter(CreateGameServerGroupRequest.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()}).build();
    private static final SdkField<List<InstanceDefinition>> INSTANCE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceDefinitions").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::instanceDefinitions)).setter(CreateGameServerGroupRequest.setter(Builder::instanceDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GameServerGroupAutoScalingPolicy> AUTO_SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoScalingPolicy").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::autoScalingPolicy)).setter(CreateGameServerGroupRequest.setter(Builder::autoScalingPolicy)).constructor(GameServerGroupAutoScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()}).build();
    private static final SdkField<String> BALANCING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BalancingStrategy").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::balancingStrategyAsString)).setter(CreateGameServerGroupRequest.setter(Builder::balancingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BalancingStrategy").build()}).build();
    private static final SdkField<String> GAME_SERVER_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerProtectionPolicy").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::gameServerProtectionPolicyAsString)).setter(CreateGameServerGroupRequest.setter(Builder::gameServerProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerProtectionPolicy").build()}).build();
    private static final SdkField<List<String>> VPC_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSubnets").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::vpcSubnets)).setter(CreateGameServerGroupRequest.setter(Builder::vpcSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateGameServerGroupRequest.getter(CreateGameServerGroupRequest::tags)).setter(CreateGameServerGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, ROLE_ARN_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, LAUNCH_TEMPLATE_FIELD, INSTANCE_DEFINITIONS_FIELD, AUTO_SCALING_POLICY_FIELD, BALANCING_STRATEGY_FIELD, GAME_SERVER_PROTECTION_POLICY_FIELD, VPC_SUBNETS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("MinSize", MIN_SIZE_FIELD);
            this.put("MaxSize", MAX_SIZE_FIELD);
            this.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
            this.put("InstanceDefinitions", INSTANCE_DEFINITIONS_FIELD);
            this.put("AutoScalingPolicy", AUTO_SCALING_POLICY_FIELD);
            this.put("BalancingStrategy", BALANCING_STRATEGY_FIELD);
            this.put("GameServerProtectionPolicy", GAME_SERVER_PROTECTION_POLICY_FIELD);
            this.put("VpcSubnets", VPC_SUBNETS_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String gameServerGroupName;
    private final String roleArn;
    private final Integer minSize;
    private final Integer maxSize;
    private final LaunchTemplateSpecification launchTemplate;
    private final List<InstanceDefinition> instanceDefinitions;
    private final GameServerGroupAutoScalingPolicy autoScalingPolicy;
    private final String balancingStrategy;
    private final String gameServerProtectionPolicy;
    private final List<String> vpcSubnets;
    private final List<Tag> tags;

    private CreateGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.roleArn = builder.roleArn;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.launchTemplate = builder.launchTemplate;
        this.instanceDefinitions = builder.instanceDefinitions;
        this.autoScalingPolicy = builder.autoScalingPolicy;
        this.balancingStrategy = builder.balancingStrategy;
        this.gameServerProtectionPolicy = builder.gameServerProtectionPolicy;
        this.vpcSubnets = builder.vpcSubnets;
        this.tags = builder.tags;
    }

    public final String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final Integer maxSize() {
        return this.maxSize;
    }

    public final LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final boolean hasInstanceDefinitions() {
        return this.instanceDefinitions != null && !(this.instanceDefinitions instanceof SdkAutoConstructList);
    }

    public final List<InstanceDefinition> instanceDefinitions() {
        return this.instanceDefinitions;
    }

    public final GameServerGroupAutoScalingPolicy autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public final BalancingStrategy balancingStrategy() {
        return BalancingStrategy.fromValue(this.balancingStrategy);
    }

    public final String balancingStrategyAsString() {
        return this.balancingStrategy;
    }

    public final GameServerProtectionPolicy gameServerProtectionPolicy() {
        return GameServerProtectionPolicy.fromValue(this.gameServerProtectionPolicy);
    }

    public final String gameServerProtectionPolicyAsString() {
        return this.gameServerProtectionPolicy;
    }

    public final boolean hasVpcSubnets() {
        return this.vpcSubnets != null && !(this.vpcSubnets instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSubnets() {
        return this.vpcSubnets;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceDefinitions() ? this.instanceDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.balancingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSubnets() ? this.vpcSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameServerGroupRequest)) {
            return false;
        }
        CreateGameServerGroupRequest other = (CreateGameServerGroupRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && this.hasInstanceDefinitions() == other.hasInstanceDefinitions() && Objects.equals(this.instanceDefinitions(), other.instanceDefinitions()) && Objects.equals(this.autoScalingPolicy(), other.autoScalingPolicy()) && Objects.equals(this.balancingStrategyAsString(), other.balancingStrategyAsString()) && Objects.equals(this.gameServerProtectionPolicyAsString(), other.gameServerProtectionPolicyAsString()) && this.hasVpcSubnets() == other.hasVpcSubnets() && Objects.equals(this.vpcSubnets(), other.vpcSubnets()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGameServerGroupRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("RoleArn", (Object)this.roleArn()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("LaunchTemplate", (Object)this.launchTemplate()).add("InstanceDefinitions", this.hasInstanceDefinitions() ? this.instanceDefinitions() : null).add("AutoScalingPolicy", (Object)this.autoScalingPolicy()).add("BalancingStrategy", (Object)this.balancingStrategyAsString()).add("GameServerProtectionPolicy", (Object)this.gameServerProtectionPolicyAsString()).add("VpcSubnets", this.hasVpcSubnets() ? this.vpcSubnets() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "InstanceDefinitions": {
                return Optional.ofNullable(clazz.cast(this.instanceDefinitions()));
            }
            case "AutoScalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoScalingPolicy()));
            }
            case "BalancingStrategy": {
                return Optional.ofNullable(clazz.cast(this.balancingStrategyAsString()));
            }
            case "GameServerProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.gameServerProtectionPolicyAsString()));
            }
            case "VpcSubnets": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnets()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameServerGroupRequest, T> g) {
        return obj -> g.apply((CreateGameServerGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String roleArn;
        private Integer minSize;
        private Integer maxSize;
        private LaunchTemplateSpecification launchTemplate;
        private List<InstanceDefinition> instanceDefinitions = DefaultSdkAutoConstructList.getInstance();
        private GameServerGroupAutoScalingPolicy autoScalingPolicy;
        private String balancingStrategy;
        private String gameServerProtectionPolicy;
        private List<String> vpcSubnets = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameServerGroupRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.roleArn(model.roleArn);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.launchTemplate(model.launchTemplate);
            this.instanceDefinitions(model.instanceDefinitions);
            this.autoScalingPolicy(model.autoScalingPolicy);
            this.balancingStrategy(model.balancingStrategy);
            this.gameServerProtectionPolicy(model.gameServerProtectionPolicy);
            this.vpcSubnets(model.vpcSubnets);
            this.tags(model.tags);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final List<InstanceDefinition.Builder> getInstanceDefinitions() {
            List<InstanceDefinition.Builder> result = InstanceDefinitionsCopier.copyToBuilder(this.instanceDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceDefinitions(Collection<InstanceDefinition.BuilderImpl> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copyFromBuilder(instanceDefinitions);
        }

        @Override
        public final Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copy(instanceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(InstanceDefinition ... instanceDefinitions) {
            this.instanceDefinitions(Arrays.asList(instanceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(Consumer<InstanceDefinition.Builder> ... instanceDefinitions) {
            this.instanceDefinitions(Stream.of(instanceDefinitions).map(c -> (InstanceDefinition)((InstanceDefinition.Builder)InstanceDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GameServerGroupAutoScalingPolicy.Builder getAutoScalingPolicy() {
            return this.autoScalingPolicy != null ? this.autoScalingPolicy.toBuilder() : null;
        }

        public final void setAutoScalingPolicy(GameServerGroupAutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        @Override
        public final Builder autoScalingPolicy(GameServerGroupAutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final String getBalancingStrategy() {
            return this.balancingStrategy;
        }

        public final void setBalancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
        }

        @Override
        public final Builder balancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
            return this;
        }

        @Override
        public final Builder balancingStrategy(BalancingStrategy balancingStrategy) {
            this.balancingStrategy(balancingStrategy == null ? null : balancingStrategy.toString());
            return this;
        }

        public final String getGameServerProtectionPolicy() {
            return this.gameServerProtectionPolicy;
        }

        public final void setGameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
        }

        @Override
        public final Builder gameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
            return this;
        }

        @Override
        public final Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy(gameServerProtectionPolicy == null ? null : gameServerProtectionPolicy.toString());
            return this;
        }

        public final Collection<String> getVpcSubnets() {
            if (this.vpcSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSubnets;
        }

        public final void setVpcSubnets(Collection<String> vpcSubnets) {
            this.vpcSubnets = VpcSubnetsCopier.copy(vpcSubnets);
        }

        @Override
        public final Builder vpcSubnets(Collection<String> vpcSubnets) {
            this.vpcSubnets = VpcSubnetsCopier.copy(vpcSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnets(String ... vpcSubnets) {
            this.vpcSubnets(Arrays.asList(vpcSubnets));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameServerGroupRequest build() {
            return new CreateGameServerGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGameServerGroupRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder roleArn(String var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder instanceDefinitions(Collection<InstanceDefinition> var1);

        public Builder instanceDefinitions(InstanceDefinition ... var1);

        public Builder instanceDefinitions(Consumer<InstanceDefinition.Builder> ... var1);

        public Builder autoScalingPolicy(GameServerGroupAutoScalingPolicy var1);

        default public Builder autoScalingPolicy(Consumer<GameServerGroupAutoScalingPolicy.Builder> autoScalingPolicy) {
            return this.autoScalingPolicy((GameServerGroupAutoScalingPolicy)((GameServerGroupAutoScalingPolicy.Builder)GameServerGroupAutoScalingPolicy.builder().applyMutation(autoScalingPolicy)).build());
        }

        public Builder balancingStrategy(String var1);

        public Builder balancingStrategy(BalancingStrategy var1);

        public Builder gameServerProtectionPolicy(String var1);

        public Builder gameServerProtectionPolicy(GameServerProtectionPolicy var1);

        public Builder vpcSubnets(Collection<String> var1);

        public Builder vpcSubnets(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

