/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession;
import software.amazon.awssdk.services.gamelift.model.DesiredPlayerSessionListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatency;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartGameSessionPlacementRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, StartGameSessionPlacementRequest> {
    private static final SdkField<String> PLACEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementId").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::placementId)).setter(StartGameSessionPlacementRequest.setter(Builder::placementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementId").build()}).build();
    private static final SdkField<String> GAME_SESSION_QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionQueueName").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::gameSessionQueueName)).setter(StartGameSessionPlacementRequest.setter(Builder::gameSessionQueueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueueName").build()}).build();
    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameProperties").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::gameProperties)).setter(StartGameSessionPlacementRequest.setter(Builder::gameProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::maximumPlayerSessionCount)).setter(StartGameSessionPlacementRequest.setter(Builder::maximumPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build()}).build();
    private static final SdkField<String> GAME_SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionName").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::gameSessionName)).setter(StartGameSessionPlacementRequest.setter(Builder::gameSessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionName").build()}).build();
    private static final SdkField<List<PlayerLatency>> PLAYER_LATENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlayerLatencies").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::playerLatencies)).setter(StartGameSessionPlacementRequest.setter(Builder::playerLatencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerLatencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlayerLatency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DesiredPlayerSession>> DESIRED_PLAYER_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DesiredPlayerSessions").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::desiredPlayerSessions)).setter(StartGameSessionPlacementRequest.setter(Builder::desiredPlayerSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredPlayerSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DesiredPlayerSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionData").getter(StartGameSessionPlacementRequest.getter(StartGameSessionPlacementRequest::gameSessionData)).setter(StartGameSessionPlacementRequest.setter(Builder::gameSessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_ID_FIELD, GAME_SESSION_QUEUE_NAME_FIELD, GAME_PROPERTIES_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, GAME_SESSION_NAME_FIELD, PLAYER_LATENCIES_FIELD, DESIRED_PLAYER_SESSIONS_FIELD, GAME_SESSION_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PlacementId", PLACEMENT_ID_FIELD);
            this.put("GameSessionQueueName", GAME_SESSION_QUEUE_NAME_FIELD);
            this.put("GameProperties", GAME_PROPERTIES_FIELD);
            this.put("MaximumPlayerSessionCount", MAXIMUM_PLAYER_SESSION_COUNT_FIELD);
            this.put("GameSessionName", GAME_SESSION_NAME_FIELD);
            this.put("PlayerLatencies", PLAYER_LATENCIES_FIELD);
            this.put("DesiredPlayerSessions", DESIRED_PLAYER_SESSIONS_FIELD);
            this.put("GameSessionData", GAME_SESSION_DATA_FIELD);
        }
    });
    private final String placementId;
    private final String gameSessionQueueName;
    private final List<GameProperty> gameProperties;
    private final Integer maximumPlayerSessionCount;
    private final String gameSessionName;
    private final List<PlayerLatency> playerLatencies;
    private final List<DesiredPlayerSession> desiredPlayerSessions;
    private final String gameSessionData;

    private StartGameSessionPlacementRequest(BuilderImpl builder) {
        super(builder);
        this.placementId = builder.placementId;
        this.gameSessionQueueName = builder.gameSessionQueueName;
        this.gameProperties = builder.gameProperties;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.gameSessionName = builder.gameSessionName;
        this.playerLatencies = builder.playerLatencies;
        this.desiredPlayerSessions = builder.desiredPlayerSessions;
        this.gameSessionData = builder.gameSessionData;
    }

    public final String placementId() {
        return this.placementId;
    }

    public final String gameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public final boolean hasGameProperties() {
        return this.gameProperties != null && !(this.gameProperties instanceof SdkAutoConstructList);
    }

    public final List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public final Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public final String gameSessionName() {
        return this.gameSessionName;
    }

    public final boolean hasPlayerLatencies() {
        return this.playerLatencies != null && !(this.playerLatencies instanceof SdkAutoConstructList);
    }

    public final List<PlayerLatency> playerLatencies() {
        return this.playerLatencies;
    }

    public final boolean hasDesiredPlayerSessions() {
        return this.desiredPlayerSessions != null && !(this.desiredPlayerSessions instanceof SdkAutoConstructList);
    }

    public final List<DesiredPlayerSession> desiredPlayerSessions() {
        return this.desiredPlayerSessions;
    }

    public final String gameSessionData() {
        return this.gameSessionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.placementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameProperties() ? this.gameProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlayerLatencies() ? this.playerLatencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDesiredPlayerSessions() ? this.desiredPlayerSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartGameSessionPlacementRequest)) {
            return false;
        }
        StartGameSessionPlacementRequest other = (StartGameSessionPlacementRequest)((Object)obj);
        return Objects.equals(this.placementId(), other.placementId()) && Objects.equals(this.gameSessionQueueName(), other.gameSessionQueueName()) && this.hasGameProperties() == other.hasGameProperties() && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.gameSessionName(), other.gameSessionName()) && this.hasPlayerLatencies() == other.hasPlayerLatencies() && Objects.equals(this.playerLatencies(), other.playerLatencies()) && this.hasDesiredPlayerSessions() == other.hasDesiredPlayerSessions() && Objects.equals(this.desiredPlayerSessions(), other.desiredPlayerSessions()) && Objects.equals(this.gameSessionData(), other.gameSessionData());
    }

    public final String toString() {
        return ToString.builder((String)"StartGameSessionPlacementRequest").add("PlacementId", (Object)this.placementId()).add("GameSessionQueueName", (Object)this.gameSessionQueueName()).add("GameProperties", this.hasGameProperties() ? this.gameProperties() : null).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("GameSessionName", (Object)this.gameSessionName()).add("PlayerLatencies", this.hasPlayerLatencies() ? this.playerLatencies() : null).add("DesiredPlayerSessions", this.hasDesiredPlayerSessions() ? this.desiredPlayerSessions() : null).add("GameSessionData", (Object)this.gameSessionData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementId": {
                return Optional.ofNullable(clazz.cast(this.placementId()));
            }
            case "GameSessionQueueName": {
                return Optional.ofNullable(clazz.cast(this.gameSessionQueueName()));
            }
            case "GameProperties": {
                return Optional.ofNullable(clazz.cast(this.gameProperties()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "GameSessionName": {
                return Optional.ofNullable(clazz.cast(this.gameSessionName()));
            }
            case "PlayerLatencies": {
                return Optional.ofNullable(clazz.cast(this.playerLatencies()));
            }
            case "DesiredPlayerSessions": {
                return Optional.ofNullable(clazz.cast(this.desiredPlayerSessions()));
            }
            case "GameSessionData": {
                return Optional.ofNullable(clazz.cast(this.gameSessionData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartGameSessionPlacementRequest, T> g) {
        return obj -> g.apply((StartGameSessionPlacementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String placementId;
        private String gameSessionQueueName;
        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumPlayerSessionCount;
        private String gameSessionName;
        private List<PlayerLatency> playerLatencies = DefaultSdkAutoConstructList.getInstance();
        private List<DesiredPlayerSession> desiredPlayerSessions = DefaultSdkAutoConstructList.getInstance();
        private String gameSessionData;

        private BuilderImpl() {
        }

        private BuilderImpl(StartGameSessionPlacementRequest model) {
            super(model);
            this.placementId(model.placementId);
            this.gameSessionQueueName(model.gameSessionQueueName);
            this.gameProperties(model.gameProperties);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.gameSessionName(model.gameSessionName);
            this.playerLatencies(model.playerLatencies);
            this.desiredPlayerSessions(model.desiredPlayerSessions);
            this.gameSessionData(model.gameSessionData);
        }

        public final String getPlacementId() {
            return this.placementId;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final String getGameSessionQueueName() {
            return this.gameSessionQueueName;
        }

        public final void setGameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
        }

        @Override
        public final Builder gameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final String getGameSessionName() {
            return this.gameSessionName;
        }

        public final void setGameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
        }

        @Override
        public final Builder gameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
            return this;
        }

        public final List<PlayerLatency.Builder> getPlayerLatencies() {
            List<PlayerLatency.Builder> result = PlayerLatencyListCopier.copyToBuilder(this.playerLatencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlayerLatencies(Collection<PlayerLatency.BuilderImpl> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copyFromBuilder(playerLatencies);
        }

        @Override
        public final Builder playerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(PlayerLatency ... playerLatencies) {
            this.playerLatencies(Arrays.asList(playerLatencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(Consumer<PlayerLatency.Builder> ... playerLatencies) {
            this.playerLatencies(Stream.of(playerLatencies).map(c -> (PlayerLatency)((PlayerLatency.Builder)PlayerLatency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DesiredPlayerSession.Builder> getDesiredPlayerSessions() {
            List<DesiredPlayerSession.Builder> result = DesiredPlayerSessionListCopier.copyToBuilder(this.desiredPlayerSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDesiredPlayerSessions(Collection<DesiredPlayerSession.BuilderImpl> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copyFromBuilder(desiredPlayerSessions);
        }

        @Override
        public final Builder desiredPlayerSessions(Collection<DesiredPlayerSession> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copy(desiredPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredPlayerSessions(DesiredPlayerSession ... desiredPlayerSessions) {
            this.desiredPlayerSessions(Arrays.asList(desiredPlayerSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredPlayerSessions(Consumer<DesiredPlayerSession.Builder> ... desiredPlayerSessions) {
            this.desiredPlayerSessions(Stream.of(desiredPlayerSessions).map(c -> (DesiredPlayerSession)((DesiredPlayerSession.Builder)DesiredPlayerSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartGameSessionPlacementRequest build() {
            return new StartGameSessionPlacementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartGameSessionPlacementRequest> {
        public Builder placementId(String var1);

        public Builder gameSessionQueueName(String var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder gameSessionName(String var1);

        public Builder playerLatencies(Collection<PlayerLatency> var1);

        public Builder playerLatencies(PlayerLatency ... var1);

        public Builder playerLatencies(Consumer<PlayerLatency.Builder> ... var1);

        public Builder desiredPlayerSessions(Collection<DesiredPlayerSession> var1);

        public Builder desiredPlayerSessions(DesiredPlayerSession ... var1);

        public Builder desiredPlayerSessions(Consumer<DesiredPlayerSession.Builder> ... var1);

        public Builder gameSessionData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

