/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetUtilizationRequest extends GameLiftRequest implements
        ToCopyableBuilder<DescribeFleetUtilizationRequest.Builder, DescribeFleetUtilizationRequest> {
    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFleetUtilizationRequest::fleetIds))
            .setter(setter(Builder::fleetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeFleetUtilizationRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetUtilizationRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_IDS_FIELD, LIMIT_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> fleetIds;

    private final Integer limit;

    private final String nextToken;

    private DescribeFleetUtilizationRequest(BuilderImpl builder) {
        super(builder);
        this.fleetIds = builder.fleetIds;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Unique identifier for a fleet(s) to retrieve utilization data for. To request utilization data for all fleets,
     * leave this parameter empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Unique identifier for a fleet(s) to retrieve utilization data for. To request utilization data for all
     *         fleets, leave this parameter empty.
     */
    public List<String> fleetIds() {
        return fleetIds;
    }

    /**
     * <p>
     * Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of
     * sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.
     * </p>
     * 
     * @return Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
     *         set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this action. To start at the beginning of the result set, do not specify a value. This parameter
     * is ignored when the request specifies one or a list of fleet IDs.
     * </p>
     * 
     * @return Token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this action. To start at the beginning of the result set, do not specify a value.
     *         This parameter is ignored when the request specifies one or a list of fleet IDs.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetIds());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetUtilizationRequest)) {
            return false;
        }
        DescribeFleetUtilizationRequest other = (DescribeFleetUtilizationRequest) obj;
        return Objects.equals(fleetIds(), other.fleetIds()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeFleetUtilizationRequest").add("FleetIds", fleetIds()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetIds":
            return Optional.ofNullable(clazz.cast(fleetIds()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetUtilizationRequest, T> g) {
        return obj -> g.apply((DescribeFleetUtilizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetUtilizationRequest> {
        /**
         * <p>
         * Unique identifier for a fleet(s) to retrieve utilization data for. To request utilization data for all
         * fleets, leave this parameter empty.
         * </p>
         * 
         * @param fleetIds
         *        Unique identifier for a fleet(s) to retrieve utilization data for. To request utilization data for all
         *        fleets, leave this parameter empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(Collection<String> fleetIds);

        /**
         * <p>
         * Unique identifier for a fleet(s) to retrieve utilization data for. To request utilization data for all
         * fleets, leave this parameter empty.
         * </p>
         * 
         * @param fleetIds
         *        Unique identifier for a fleet(s) to retrieve utilization data for. To request utilization data for all
         *        fleets, leave this parameter empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(String... fleetIds);

        /**
         * <p>
         * Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
         * of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.
         * </p>
         * 
         * @param limit
         *        Maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
         *        a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet
         *        IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Token that indicates the start of the next sequential page of results. Use the token that is returned with a
         * previous call to this action. To start at the beginning of the result set, do not specify a value. This
         * parameter is ignored when the request specifies one or a list of fleet IDs.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates the start of the next sequential page of results. Use the token that is returned
         *        with a previous call to this action. To start at the beginning of the result set, do not specify a
         *        value. This parameter is ignored when the request specifies one or a list of fleet IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetUtilizationRequest model) {
            super(model);
            fleetIds(model.fleetIds);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFleetIds() {
            return fleetIds;
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String... fleetIds) {
            fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFleetUtilizationRequest build() {
            return new DescribeFleetUtilizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
