/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetUtilizationResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetUtilizationResponse.Builder, DescribeFleetUtilizationResponse> {
    private static final SdkField<List<FleetUtilization>> FLEET_UTILIZATION_FIELD = SdkField
            .<List<FleetUtilization>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFleetUtilizationResponse::fleetUtilization))
            .setter(setter(Builder::fleetUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetUtilization").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetUtilization> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetUtilization::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetUtilizationResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_UTILIZATION_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FleetUtilization> fleetUtilization;

    private final String nextToken;

    private DescribeFleetUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.fleetUtilization = builder.fleetUtilization;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Collection of objects containing utilization information for each requested fleet ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Collection of objects containing utilization information for each requested fleet ID.
     */
    public List<FleetUtilization> fleetUtilization() {
        return fleetUtilization;
    }

    /**
     * <p>
     * Token that indicates where to resume retrieving results on the next call to this action. If no token is returned,
     * these results represent the end of the list.
     * </p>
     * 
     * @return Token that indicates where to resume retrieving results on the next call to this action. If no token is
     *         returned, these results represent the end of the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetUtilizationResponse)) {
            return false;
        }
        DescribeFleetUtilizationResponse other = (DescribeFleetUtilizationResponse) obj;
        return Objects.equals(fleetUtilization(), other.fleetUtilization()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeFleetUtilizationResponse").add("FleetUtilization", fleetUtilization())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetUtilization":
            return Optional.ofNullable(clazz.cast(fleetUtilization()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetUtilizationResponse, T> g) {
        return obj -> g.apply((DescribeFleetUtilizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetUtilizationResponse> {
        /**
         * <p>
         * Collection of objects containing utilization information for each requested fleet ID.
         * </p>
         * 
         * @param fleetUtilization
         *        Collection of objects containing utilization information for each requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetUtilization(Collection<FleetUtilization> fleetUtilization);

        /**
         * <p>
         * Collection of objects containing utilization information for each requested fleet ID.
         * </p>
         * 
         * @param fleetUtilization
         *        Collection of objects containing utilization information for each requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetUtilization(FleetUtilization... fleetUtilization);

        /**
         * <p>
         * Collection of objects containing utilization information for each requested fleet ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FleetUtilization>.Builder} avoiding the
         * need to create one manually via {@link List<FleetUtilization>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetUtilization>.Builder#build()} is called immediately and
         * its result is passed to {@link #fleetUtilization(List<FleetUtilization>)}.
         * 
         * @param fleetUtilization
         *        a consumer that will call methods on {@link List<FleetUtilization>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetUtilization(List<FleetUtilization>)
         */
        Builder fleetUtilization(Consumer<FleetUtilization.Builder>... fleetUtilization);

        /**
         * <p>
         * Token that indicates where to resume retrieving results on the next call to this action. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates where to resume retrieving results on the next call to this action. If no token
         *        is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<FleetUtilization> fleetUtilization = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetUtilizationResponse model) {
            super(model);
            fleetUtilization(model.fleetUtilization);
            nextToken(model.nextToken);
        }

        public final Collection<FleetUtilization.Builder> getFleetUtilization() {
            return fleetUtilization != null ? fleetUtilization.stream().map(FleetUtilization::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetUtilization(Collection<FleetUtilization> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copy(fleetUtilization);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetUtilization(FleetUtilization... fleetUtilization) {
            fleetUtilization(Arrays.asList(fleetUtilization));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetUtilization(Consumer<FleetUtilization.Builder>... fleetUtilization) {
            fleetUtilization(Stream.of(fleetUtilization).map(c -> FleetUtilization.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFleetUtilization(Collection<FleetUtilization.BuilderImpl> fleetUtilization) {
            this.fleetUtilization = FleetUtilizationListCopier.copyFromBuilder(fleetUtilization);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetUtilizationResponse build() {
            return new DescribeFleetUtilizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
