/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingPoliciesResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeScalingPoliciesResponse.Builder, DescribeScalingPoliciesResponse> {
    private static final SdkField<List<ScalingPolicy>> SCALING_POLICIES_FIELD = SdkField
            .<List<ScalingPolicy>> builder(MarshallingType.LIST)
            .getter(getter(DescribeScalingPoliciesResponse::scalingPolicies))
            .setter(setter(Builder::scalingPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScalingPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_POLICIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ScalingPolicy> scalingPolicies;

    private final String nextToken;

    private DescribeScalingPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPolicies = builder.scalingPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Collection of objects containing the scaling policies matching the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Collection of objects containing the scaling policies matching the request.
     */
    public List<ScalingPolicy> scalingPolicies() {
        return scalingPolicies;
    }

    /**
     * <p>
     * Token that indicates where to resume retrieving results on the next call to this action. If no token is returned,
     * these results represent the end of the list.
     * </p>
     * 
     * @return Token that indicates where to resume retrieving results on the next call to this action. If no token is
     *         returned, these results represent the end of the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalingPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPoliciesResponse)) {
            return false;
        }
        DescribeScalingPoliciesResponse other = (DescribeScalingPoliciesResponse) obj;
        return Objects.equals(scalingPolicies(), other.scalingPolicies()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeScalingPoliciesResponse").add("ScalingPolicies", scalingPolicies())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPolicies":
            return Optional.ofNullable(clazz.cast(scalingPolicies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeScalingPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScalingPoliciesResponse> {
        /**
         * <p>
         * Collection of objects containing the scaling policies matching the request.
         * </p>
         * 
         * @param scalingPolicies
         *        Collection of objects containing the scaling policies matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies);

        /**
         * <p>
         * Collection of objects containing the scaling policies matching the request.
         * </p>
         * 
         * @param scalingPolicies
         *        Collection of objects containing the scaling policies matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(ScalingPolicy... scalingPolicies);

        /**
         * <p>
         * Collection of objects containing the scaling policies matching the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScalingPolicy>.Builder} avoiding the need
         * to create one manually via {@link List<ScalingPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScalingPolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingPolicies(List<ScalingPolicy>)}.
         * 
         * @param scalingPolicies
         *        a consumer that will call methods on {@link List<ScalingPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingPolicies(List<ScalingPolicy>)
         */
        Builder scalingPolicies(Consumer<ScalingPolicy.Builder>... scalingPolicies);

        /**
         * <p>
         * Token that indicates where to resume retrieving results on the next call to this action. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates where to resume retrieving results on the next call to this action. If no token
         *        is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<ScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPoliciesResponse model) {
            super(model);
            scalingPolicies(model.scalingPolicies);
            nextToken(model.nextToken);
        }

        public final Collection<ScalingPolicy.Builder> getScalingPolicies() {
            return scalingPolicies != null ? scalingPolicies.stream().map(ScalingPolicy::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPolicyListCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy... scalingPolicies) {
            scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<ScalingPolicy.Builder>... scalingPolicies) {
            scalingPolicies(Stream.of(scalingPolicies).map(c -> ScalingPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPolicyListCopier.copyFromBuilder(scalingPolicies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingPoliciesResponse build() {
            return new DescribeScalingPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
