/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcPeeringAuthorizationsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeVpcPeeringAuthorizationsResponse.Builder, DescribeVpcPeeringAuthorizationsResponse> {
    private static final SdkField<List<VpcPeeringAuthorization>> VPC_PEERING_AUTHORIZATIONS_FIELD = SdkField
            .<List<VpcPeeringAuthorization>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVpcPeeringAuthorizationsResponse::vpcPeeringAuthorizations))
            .setter(setter(Builder::vpcPeeringAuthorizations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringAuthorizations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcPeeringAuthorization> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcPeeringAuthorization::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_PEERING_AUTHORIZATIONS_FIELD));

    private final List<VpcPeeringAuthorization> vpcPeeringAuthorizations;

    private DescribeVpcPeeringAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringAuthorizations = builder.vpcPeeringAuthorizations;
    }

    /**
     * <p>
     * Collection of objects that describe all valid VPC peering operations for the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Collection of objects that describe all valid VPC peering operations for the current AWS account.
     */
    public List<VpcPeeringAuthorization> vpcPeeringAuthorizations() {
        return vpcPeeringAuthorizations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringAuthorizations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringAuthorizationsResponse)) {
            return false;
        }
        DescribeVpcPeeringAuthorizationsResponse other = (DescribeVpcPeeringAuthorizationsResponse) obj;
        return Objects.equals(vpcPeeringAuthorizations(), other.vpcPeeringAuthorizations());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVpcPeeringAuthorizationsResponse")
                .add("VpcPeeringAuthorizations", vpcPeeringAuthorizations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringAuthorizations":
            return Optional.ofNullable(clazz.cast(vpcPeeringAuthorizations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcPeeringAuthorizationsResponse, T> g) {
        return obj -> g.apply((DescribeVpcPeeringAuthorizationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcPeeringAuthorizationsResponse> {
        /**
         * <p>
         * Collection of objects that describe all valid VPC peering operations for the current AWS account.
         * </p>
         * 
         * @param vpcPeeringAuthorizations
         *        Collection of objects that describe all valid VPC peering operations for the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringAuthorizations(Collection<VpcPeeringAuthorization> vpcPeeringAuthorizations);

        /**
         * <p>
         * Collection of objects that describe all valid VPC peering operations for the current AWS account.
         * </p>
         * 
         * @param vpcPeeringAuthorizations
         *        Collection of objects that describe all valid VPC peering operations for the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringAuthorizations(VpcPeeringAuthorization... vpcPeeringAuthorizations);

        /**
         * <p>
         * Collection of objects that describe all valid VPC peering operations for the current AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcPeeringAuthorization>.Builder} avoiding
         * the need to create one manually via {@link List<VpcPeeringAuthorization>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcPeeringAuthorization>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcPeeringAuthorizations(List<VpcPeeringAuthorization>)}.
         * 
         * @param vpcPeeringAuthorizations
         *        a consumer that will call methods on {@link List<VpcPeeringAuthorization>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeeringAuthorizations(List<VpcPeeringAuthorization>)
         */
        Builder vpcPeeringAuthorizations(Consumer<VpcPeeringAuthorization.Builder>... vpcPeeringAuthorizations);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<VpcPeeringAuthorization> vpcPeeringAuthorizations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringAuthorizationsResponse model) {
            super(model);
            vpcPeeringAuthorizations(model.vpcPeeringAuthorizations);
        }

        public final Collection<VpcPeeringAuthorization.Builder> getVpcPeeringAuthorizations() {
            return vpcPeeringAuthorizations != null ? vpcPeeringAuthorizations.stream().map(VpcPeeringAuthorization::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcPeeringAuthorizations(Collection<VpcPeeringAuthorization> vpcPeeringAuthorizations) {
            this.vpcPeeringAuthorizations = VpcPeeringAuthorizationListCopier.copy(vpcPeeringAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringAuthorizations(VpcPeeringAuthorization... vpcPeeringAuthorizations) {
            vpcPeeringAuthorizations(Arrays.asList(vpcPeeringAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringAuthorizations(Consumer<VpcPeeringAuthorization.Builder>... vpcPeeringAuthorizations) {
            vpcPeeringAuthorizations(Stream.of(vpcPeeringAuthorizations)
                    .map(c -> VpcPeeringAuthorization.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcPeeringAuthorizations(Collection<VpcPeeringAuthorization.BuilderImpl> vpcPeeringAuthorizations) {
            this.vpcPeeringAuthorizations = VpcPeeringAuthorizationListCopier.copyFromBuilder(vpcPeeringAuthorizations);
        }

        @Override
        public DescribeVpcPeeringAuthorizationsResponse build() {
            return new DescribeVpcPeeringAuthorizationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
