/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Current status of fleet utilization, including the number of game and player sessions being hosted.
 * </p>
 * <p>
 * Fleet-related operations include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListFleets</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Describe fleets:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DescribeFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetCapacity</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetPortSettings</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetUtilization</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeRuntimeConfiguration</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeEC2InstanceLimits</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetEvents</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Update fleets:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>UpdateFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateFleetCapacity</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateFleetPortSettings</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateRuntimeConfiguration</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Manage fleet actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>StartFleetActions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StopFleetActions</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetUtilization.Builder, FleetUtilization> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetUtilization::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<Integer> ACTIVE_SERVER_PROCESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(FleetUtilization::activeServerProcessCount))
            .setter(setter(Builder::activeServerProcessCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveServerProcessCount").build())
            .build();

    private static final SdkField<Integer> ACTIVE_GAME_SESSION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(FleetUtilization::activeGameSessionCount)).setter(setter(Builder::activeGameSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveGameSessionCount").build())
            .build();

    private static final SdkField<Integer> CURRENT_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(FleetUtilization::currentPlayerSessionCount))
            .setter(setter(Builder::currentPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPlayerSessionCount").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(FleetUtilization::maximumPlayerSessionCount))
            .setter(setter(Builder::maximumPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            ACTIVE_SERVER_PROCESS_COUNT_FIELD, ACTIVE_GAME_SESSION_COUNT_FIELD, CURRENT_PLAYER_SESSION_COUNT_FIELD,
            MAXIMUM_PLAYER_SESSION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final Integer activeServerProcessCount;

    private final Integer activeGameSessionCount;

    private final Integer currentPlayerSessionCount;

    private final Integer maximumPlayerSessionCount;

    private FleetUtilization(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.activeServerProcessCount = builder.activeServerProcessCount;
        this.activeGameSessionCount = builder.activeGameSessionCount;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
    }

    /**
     * <p>
     * Unique identifier for a fleet.
     * </p>
     * 
     * @return Unique identifier for a fleet.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Number of server processes in an <code>ACTIVE</code> status currently running across all instances in the fleet
     * </p>
     * 
     * @return Number of server processes in an <code>ACTIVE</code> status currently running across all instances in the
     *         fleet
     */
    public Integer activeServerProcessCount() {
        return activeServerProcessCount;
    }

    /**
     * <p>
     * Number of active game sessions currently being hosted on all instances in the fleet.
     * </p>
     * 
     * @return Number of active game sessions currently being hosted on all instances in the fleet.
     */
    public Integer activeGameSessionCount() {
        return activeGameSessionCount;
    }

    /**
     * <p>
     * Number of active player sessions currently being hosted on all instances in the fleet.
     * </p>
     * 
     * @return Number of active player sessions currently being hosted on all instances in the fleet.
     */
    public Integer currentPlayerSessionCount() {
        return currentPlayerSessionCount;
    }

    /**
     * <p>
     * Maximum players allowed across all game sessions currently being hosted on all instances in the fleet.
     * </p>
     * 
     * @return Maximum players allowed across all game sessions currently being hosted on all instances in the fleet.
     */
    public Integer maximumPlayerSessionCount() {
        return maximumPlayerSessionCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(activeServerProcessCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeGameSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(currentPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPlayerSessionCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetUtilization)) {
            return false;
        }
        FleetUtilization other = (FleetUtilization) obj;
        return Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(activeServerProcessCount(), other.activeServerProcessCount())
                && Objects.equals(activeGameSessionCount(), other.activeGameSessionCount())
                && Objects.equals(currentPlayerSessionCount(), other.currentPlayerSessionCount())
                && Objects.equals(maximumPlayerSessionCount(), other.maximumPlayerSessionCount());
    }

    @Override
    public String toString() {
        return ToString.builder("FleetUtilization").add("FleetId", fleetId())
                .add("ActiveServerProcessCount", activeServerProcessCount())
                .add("ActiveGameSessionCount", activeGameSessionCount())
                .add("CurrentPlayerSessionCount", currentPlayerSessionCount())
                .add("MaximumPlayerSessionCount", maximumPlayerSessionCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "ActiveServerProcessCount":
            return Optional.ofNullable(clazz.cast(activeServerProcessCount()));
        case "ActiveGameSessionCount":
            return Optional.ofNullable(clazz.cast(activeGameSessionCount()));
        case "CurrentPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(currentPlayerSessionCount()));
        case "MaximumPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(maximumPlayerSessionCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetUtilization, T> g) {
        return obj -> g.apply((FleetUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetUtilization> {
        /**
         * <p>
         * Unique identifier for a fleet.
         * </p>
         * 
         * @param fleetId
         *        Unique identifier for a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Number of server processes in an <code>ACTIVE</code> status currently running across all instances in the
         * fleet
         * </p>
         * 
         * @param activeServerProcessCount
         *        Number of server processes in an <code>ACTIVE</code> status currently running across all instances in
         *        the fleet
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeServerProcessCount(Integer activeServerProcessCount);

        /**
         * <p>
         * Number of active game sessions currently being hosted on all instances in the fleet.
         * </p>
         * 
         * @param activeGameSessionCount
         *        Number of active game sessions currently being hosted on all instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeGameSessionCount(Integer activeGameSessionCount);

        /**
         * <p>
         * Number of active player sessions currently being hosted on all instances in the fleet.
         * </p>
         * 
         * @param currentPlayerSessionCount
         *        Number of active player sessions currently being hosted on all instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPlayerSessionCount(Integer currentPlayerSessionCount);

        /**
         * <p>
         * Maximum players allowed across all game sessions currently being hosted on all instances in the fleet.
         * </p>
         * 
         * @param maximumPlayerSessionCount
         *        Maximum players allowed across all game sessions currently being hosted on all instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount);
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private Integer activeServerProcessCount;

        private Integer activeGameSessionCount;

        private Integer currentPlayerSessionCount;

        private Integer maximumPlayerSessionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetUtilization model) {
            fleetId(model.fleetId);
            activeServerProcessCount(model.activeServerProcessCount);
            activeGameSessionCount(model.activeGameSessionCount);
            currentPlayerSessionCount(model.currentPlayerSessionCount);
            maximumPlayerSessionCount(model.maximumPlayerSessionCount);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getActiveServerProcessCount() {
            return activeServerProcessCount;
        }

        @Override
        public final Builder activeServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
            return this;
        }

        public final void setActiveServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
        }

        public final Integer getActiveGameSessionCount() {
            return activeGameSessionCount;
        }

        @Override
        public final Builder activeGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
            return this;
        }

        public final void setActiveGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
        }

        public final Integer getCurrentPlayerSessionCount() {
            return currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public FleetUtilization build() {
            return new FleetUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
