/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMatchBackfillResponse extends GameLiftResponse implements
        ToCopyableBuilder<StartMatchBackfillResponse.Builder, StartMatchBackfillResponse> {
    private static final SdkField<MatchmakingTicket> MATCHMAKING_TICKET_FIELD = SdkField
            .<MatchmakingTicket> builder(MarshallingType.SDK_POJO).getter(getter(StartMatchBackfillResponse::matchmakingTicket))
            .setter(setter(Builder::matchmakingTicket)).constructor(MatchmakingTicket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchmakingTicket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHMAKING_TICKET_FIELD));

    private final MatchmakingTicket matchmakingTicket;

    private StartMatchBackfillResponse(BuilderImpl builder) {
        super(builder);
        this.matchmakingTicket = builder.matchmakingTicket;
    }

    /**
     * <p>
     * Ticket representing the backfill matchmaking request. This object includes the information in the request, ticket
     * status, and match results as generated during the matchmaking process.
     * </p>
     * 
     * @return Ticket representing the backfill matchmaking request. This object includes the information in the
     *         request, ticket status, and match results as generated during the matchmaking process.
     */
    public MatchmakingTicket matchmakingTicket() {
        return matchmakingTicket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchmakingTicket());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMatchBackfillResponse)) {
            return false;
        }
        StartMatchBackfillResponse other = (StartMatchBackfillResponse) obj;
        return Objects.equals(matchmakingTicket(), other.matchmakingTicket());
    }

    @Override
    public String toString() {
        return ToString.builder("StartMatchBackfillResponse").add("MatchmakingTicket", matchmakingTicket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchmakingTicket":
            return Optional.ofNullable(clazz.cast(matchmakingTicket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMatchBackfillResponse, T> g) {
        return obj -> g.apply((StartMatchBackfillResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartMatchBackfillResponse> {
        /**
         * <p>
         * Ticket representing the backfill matchmaking request. This object includes the information in the request,
         * ticket status, and match results as generated during the matchmaking process.
         * </p>
         * 
         * @param matchmakingTicket
         *        Ticket representing the backfill matchmaking request. This object includes the information in the
         *        request, ticket status, and match results as generated during the matchmaking process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchmakingTicket(MatchmakingTicket matchmakingTicket);

        /**
         * <p>
         * Ticket representing the backfill matchmaking request. This object includes the information in the request,
         * ticket status, and match results as generated during the matchmaking process.
         * </p>
         * This is a convenience that creates an instance of the {@link MatchmakingTicket.Builder} avoiding the need to
         * create one manually via {@link MatchmakingTicket#builder()}.
         *
         * When the {@link Consumer} completes, {@link MatchmakingTicket.Builder#build()} is called immediately and its
         * result is passed to {@link #matchmakingTicket(MatchmakingTicket)}.
         * 
         * @param matchmakingTicket
         *        a consumer that will call methods on {@link MatchmakingTicket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchmakingTicket(MatchmakingTicket)
         */
        default Builder matchmakingTicket(Consumer<MatchmakingTicket.Builder> matchmakingTicket) {
            return matchmakingTicket(MatchmakingTicket.builder().applyMutation(matchmakingTicket).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private MatchmakingTicket matchmakingTicket;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMatchBackfillResponse model) {
            super(model);
            matchmakingTicket(model.matchmakingTicket);
        }

        public final MatchmakingTicket.Builder getMatchmakingTicket() {
            return matchmakingTicket != null ? matchmakingTicket.toBuilder() : null;
        }

        @Override
        public final Builder matchmakingTicket(MatchmakingTicket matchmakingTicket) {
            this.matchmakingTicket = matchmakingTicket;
            return this;
        }

        public final void setMatchmakingTicket(MatchmakingTicket.BuilderImpl matchmakingTicket) {
            this.matchmakingTicket = matchmakingTicket != null ? matchmakingTicket.build() : null;
        }

        @Override
        public StartMatchBackfillResponse build() {
            return new StartMatchBackfillResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
