/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBuildResponse extends GameLiftResponse implements
        ToCopyableBuilder<UpdateBuildResponse.Builder, UpdateBuildResponse> {
    private static final SdkField<Build> BUILD_FIELD = SdkField.<Build> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateBuildResponse::build)).setter(setter(Builder::build)).constructor(Build::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Build").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_FIELD));

    private final Build build;

    private UpdateBuildResponse(BuilderImpl builder) {
        super(builder);
        this.build = builder.build;
    }

    /**
     * <p>
     * Object that contains the updated build record.
     * </p>
     * 
     * @return Object that contains the updated build record.
     */
    public Build build() {
        return build;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(build());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBuildResponse)) {
            return false;
        }
        UpdateBuildResponse other = (UpdateBuildResponse) obj;
        return Objects.equals(build(), other.build());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateBuildResponse").add("Build", build()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Build":
            return Optional.ofNullable(clazz.cast(build()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBuildResponse, T> g) {
        return obj -> g.apply((UpdateBuildResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBuildResponse> {
        /**
         * <p>
         * Object that contains the updated build record.
         * </p>
         * 
         * @param build
         *        Object that contains the updated build record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder build(Build build);

        /**
         * <p>
         * Object that contains the updated build record.
         * </p>
         * This is a convenience that creates an instance of the {@link Build.Builder} avoiding the need to create one
         * manually via {@link Build#builder()}.
         *
         * When the {@link Consumer} completes, {@link Build.Builder#build()} is called immediately and its result is
         * passed to {@link #build(Build)}.
         * 
         * @param build
         *        a consumer that will call methods on {@link Build.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #build(Build)
         */
        default Builder build(Consumer<Build.Builder> build) {
            return build(Build.builder().applyMutation(build).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Build build;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBuildResponse model) {
            super(model);
            build(model.build);
        }

        public final Build.Builder getBuild() {
            return build != null ? build.toBuilder() : null;
        }

        @Override
        public final Builder build(Build build) {
            this.build = build;
            return this;
        }

        public final void setBuild(Build.BuilderImpl build) {
            this.build = build != null ? build.build() : null;
        }

        @Override
        public UpdateBuildResponse build() {
            return new UpdateBuildResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
