/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMatchmakingConfigurationResponse extends GameLiftResponse implements
        ToCopyableBuilder<UpdateMatchmakingConfigurationResponse.Builder, UpdateMatchmakingConfigurationResponse> {
    private static final SdkField<MatchmakingConfiguration> CONFIGURATION_FIELD = SdkField
            .<MatchmakingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateMatchmakingConfigurationResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(MatchmakingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private final MatchmakingConfiguration configuration;

    private UpdateMatchmakingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * Object that describes the updated matchmaking configuration.
     * </p>
     * 
     * @return Object that describes the updated matchmaking configuration.
     */
    public MatchmakingConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMatchmakingConfigurationResponse)) {
            return false;
        }
        UpdateMatchmakingConfigurationResponse other = (UpdateMatchmakingConfigurationResponse) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateMatchmakingConfigurationResponse").add("Configuration", configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMatchmakingConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateMatchmakingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMatchmakingConfigurationResponse> {
        /**
         * <p>
         * Object that describes the updated matchmaking configuration.
         * </p>
         * 
         * @param configuration
         *        Object that describes the updated matchmaking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(MatchmakingConfiguration configuration);

        /**
         * <p>
         * Object that describes the updated matchmaking configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link MatchmakingConfiguration.Builder} avoiding the
         * need to create one manually via {@link MatchmakingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MatchmakingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(MatchmakingConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link MatchmakingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(MatchmakingConfiguration)
         */
        default Builder configuration(Consumer<MatchmakingConfiguration.Builder> configuration) {
            return configuration(MatchmakingConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private MatchmakingConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMatchmakingConfigurationResponse model) {
            super(model);
            configuration(model.configuration);
        }

        public final MatchmakingConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(MatchmakingConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(MatchmakingConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public UpdateMatchmakingConfigurationResponse build() {
            return new UpdateMatchmakingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
