/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateMatchmakingRuleSetRequest extends GameLiftRequest implements
        ToCopyableBuilder<ValidateMatchmakingRuleSetRequest.Builder, ValidateMatchmakingRuleSetRequest> {
    private static final SdkField<String> RULE_SET_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ValidateMatchmakingRuleSetRequest::ruleSetBody)).setter(setter(Builder::ruleSetBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_BODY_FIELD));

    private final String ruleSetBody;

    private ValidateMatchmakingRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetBody = builder.ruleSetBody;
    }

    /**
     * <p>
     * Collection of matchmaking rules to validate, formatted as a JSON string.
     * </p>
     * 
     * @return Collection of matchmaking rules to validate, formatted as a JSON string.
     */
    public String ruleSetBody() {
        return ruleSetBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetBody());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateMatchmakingRuleSetRequest)) {
            return false;
        }
        ValidateMatchmakingRuleSetRequest other = (ValidateMatchmakingRuleSetRequest) obj;
        return Objects.equals(ruleSetBody(), other.ruleSetBody());
    }

    @Override
    public String toString() {
        return ToString.builder("ValidateMatchmakingRuleSetRequest").add("RuleSetBody", ruleSetBody()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetBody":
            return Optional.ofNullable(clazz.cast(ruleSetBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateMatchmakingRuleSetRequest, T> g) {
        return obj -> g.apply((ValidateMatchmakingRuleSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateMatchmakingRuleSetRequest> {
        /**
         * <p>
         * Collection of matchmaking rules to validate, formatted as a JSON string.
         * </p>
         * 
         * @param ruleSetBody
         *        Collection of matchmaking rules to validate, formatted as a JSON string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetBody(String ruleSetBody);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String ruleSetBody;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateMatchmakingRuleSetRequest model) {
            super(model);
            ruleSetBody(model.ruleSetBody);
        }

        public final String getRuleSetBody() {
            return ruleSetBody;
        }

        @Override
        public final Builder ruleSetBody(String ruleSetBody) {
            this.ruleSetBody = ruleSetBody;
            return this;
        }

        public final void setRuleSetBody(String ruleSetBody) {
            this.ruleSetBody = ruleSetBody;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateMatchmakingRuleSetRequest build() {
            return new ValidateMatchmakingRuleSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
