/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an authorization for a VPC peering connection between the VPC for an Amazon GameLift fleet and another VPC
 * on an account you have access to. This authorization must exist and be valid for the peering connection to be
 * established. Authorizations are valid for 24 hours after they are issued.
 * </p>
 * <p>
 * VPC peering connection operations include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateVpcPeeringAuthorization</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeVpcPeeringAuthorizations</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteVpcPeeringAuthorization</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateVpcPeeringConnection</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeVpcPeeringConnections</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteVpcPeeringConnection</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcPeeringAuthorization implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcPeeringAuthorization.Builder, VpcPeeringAuthorization> {
    private static final SdkField<String> GAME_LIFT_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VpcPeeringAuthorization::gameLiftAwsAccountId)).setter(setter(Builder::gameLiftAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameLiftAwsAccountId").build())
            .build();

    private static final SdkField<String> PEER_VPC_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VpcPeeringAuthorization::peerVpcAwsAccountId)).setter(setter(Builder::peerVpcAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcAwsAccountId").build())
            .build();

    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VpcPeeringAuthorization::peerVpcId)).setter(setter(Builder::peerVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VpcPeeringAuthorization::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VpcPeeringAuthorization::expirationTime)).setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GAME_LIFT_AWS_ACCOUNT_ID_FIELD, PEER_VPC_AWS_ACCOUNT_ID_FIELD, PEER_VPC_ID_FIELD, CREATION_TIME_FIELD,
            EXPIRATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gameLiftAwsAccountId;

    private final String peerVpcAwsAccountId;

    private final String peerVpcId;

    private final Instant creationTime;

    private final Instant expirationTime;

    private VpcPeeringAuthorization(BuilderImpl builder) {
        this.gameLiftAwsAccountId = builder.gameLiftAwsAccountId;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
    }

    /**
     * <p>
     * Unique identifier for the AWS account that you use to manage your Amazon GameLift fleet. You can find your
     * Account ID in the AWS Management Console under account settings.
     * </p>
     * 
     * @return Unique identifier for the AWS account that you use to manage your Amazon GameLift fleet. You can find
     *         your Account ID in the AWS Management Console under account settings.
     */
    public String gameLiftAwsAccountId() {
        return gameLiftAwsAccountId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String peerVpcAwsAccountId() {
        return peerVpcAwsAccountId;
    }

    /**
     * <p>
     * Unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in the
     * same region where your fleet is deployed. To get VPC information, including IDs, use the Virtual Private Cloud
     * service tools, including the VPC Dashboard in the AWS Management Console.
     * </p>
     * 
     * @return Unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be
     *         in the same region where your fleet is deployed. To get VPC information, including IDs, use the Virtual
     *         Private Cloud service tools, including the VPC Dashboard in the AWS Management Console.
     */
    public String peerVpcId() {
        return peerVpcId;
    }

    /**
     * <p>
     * Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as
     * milliseconds (for example "1469498468.057").
     * </p>
     * 
     * @return Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as
     *         milliseconds (for example "1469498468.057").
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number expressed in
     * Unix time as milliseconds (for example "1469498468.057").
     * </p>
     * 
     * @return Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number
     *         expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    public Instant expirationTime() {
        return expirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gameLiftAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringAuthorization)) {
            return false;
        }
        VpcPeeringAuthorization other = (VpcPeeringAuthorization) obj;
        return Objects.equals(gameLiftAwsAccountId(), other.gameLiftAwsAccountId())
                && Objects.equals(peerVpcAwsAccountId(), other.peerVpcAwsAccountId())
                && Objects.equals(peerVpcId(), other.peerVpcId()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(expirationTime(), other.expirationTime());
    }

    @Override
    public String toString() {
        return ToString.builder("VpcPeeringAuthorization").add("GameLiftAwsAccountId", gameLiftAwsAccountId())
                .add("PeerVpcAwsAccountId", peerVpcAwsAccountId()).add("PeerVpcId", peerVpcId())
                .add("CreationTime", creationTime()).add("ExpirationTime", expirationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameLiftAwsAccountId":
            return Optional.ofNullable(clazz.cast(gameLiftAwsAccountId()));
        case "PeerVpcAwsAccountId":
            return Optional.ofNullable(clazz.cast(peerVpcAwsAccountId()));
        case "PeerVpcId":
            return Optional.ofNullable(clazz.cast(peerVpcId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringAuthorization, T> g) {
        return obj -> g.apply((VpcPeeringAuthorization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcPeeringAuthorization> {
        /**
         * <p>
         * Unique identifier for the AWS account that you use to manage your Amazon GameLift fleet. You can find your
         * Account ID in the AWS Management Console under account settings.
         * </p>
         * 
         * @param gameLiftAwsAccountId
         *        Unique identifier for the AWS account that you use to manage your Amazon GameLift fleet. You can find
         *        your Account ID in the AWS Management Console under account settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameLiftAwsAccountId(String gameLiftAwsAccountId);

        /**
         * <p/>
         * 
         * @param peerVpcAwsAccountId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcAwsAccountId(String peerVpcAwsAccountId);

        /**
         * <p>
         * Unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in
         * the same region where your fleet is deployed. To get VPC information, including IDs, use the Virtual Private
         * Cloud service tools, including the VPC Dashboard in the AWS Management Console.
         * </p>
         * 
         * @param peerVpcId
         *        Unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must
         *        be in the same region where your fleet is deployed. To get VPC information, including IDs, use the
         *        Virtual Private Cloud service tools, including the VPC Dashboard in the AWS Management Console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        /**
         * <p>
         * Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as
         * milliseconds (for example "1469498468.057").
         * </p>
         * 
         * @param creationTime
         *        Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as
         *        milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number expressed
         * in Unix time as milliseconds (for example "1469498468.057").
         * </p>
         * 
         * @param expirationTime
         *        Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number
         *        expressed in Unix time as milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);
    }

    static final class BuilderImpl implements Builder {
        private String gameLiftAwsAccountId;

        private String peerVpcAwsAccountId;

        private String peerVpcId;

        private Instant creationTime;

        private Instant expirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringAuthorization model) {
            gameLiftAwsAccountId(model.gameLiftAwsAccountId);
            peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            peerVpcId(model.peerVpcId);
            creationTime(model.creationTime);
            expirationTime(model.expirationTime);
        }

        public final String getGameLiftAwsAccountId() {
            return gameLiftAwsAccountId;
        }

        @Override
        public final Builder gameLiftAwsAccountId(String gameLiftAwsAccountId) {
            this.gameLiftAwsAccountId = gameLiftAwsAccountId;
            return this;
        }

        public final void setGameLiftAwsAccountId(String gameLiftAwsAccountId) {
            this.gameLiftAwsAccountId = gameLiftAwsAccountId;
        }

        public final String getPeerVpcAwsAccountId() {
            return peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public VpcPeeringAuthorization build() {
            return new VpcPeeringAuthorization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
