/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ConnectionPortRange;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetBillingType;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameSessionCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.services.gamelift.model.LocationConfiguration;
import software.amazon.awssdk.services.gamelift.model.LocationConfigurationListCopier;
import software.amazon.awssdk.services.gamelift.model.LogConfiguration;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.Tag;
import software.amazon.awssdk.services.gamelift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContainerFleetRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateContainerFleetRequest> {
    private static final SdkField<String> FLEET_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetRoleArn").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::fleetRoleArn)).setter(CreateContainerFleetRequest.setter(Builder::fleetRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetRoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::description)).setter(CreateContainerFleetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerContainerGroupDefinitionName").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::gameServerContainerGroupDefinitionName)).setter(CreateContainerFleetRequest.setter(Builder::gameServerContainerGroupDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerGroupDefinitionName").build()}).build();
    private static final SdkField<String> PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerInstanceContainerGroupDefinitionName").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::perInstanceContainerGroupDefinitionName)).setter(CreateContainerFleetRequest.setter(Builder::perInstanceContainerGroupDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerInstanceContainerGroupDefinitionName").build()}).build();
    private static final SdkField<ConnectionPortRange> INSTANCE_CONNECTION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceConnectionPortRange").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::instanceConnectionPortRange)).setter(CreateContainerFleetRequest.setter(Builder::instanceConnectionPortRange)).constructor(ConnectionPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectionPortRange").build()}).build();
    private static final SdkField<List<IpPermission>> INSTANCE_INBOUND_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceInboundPermissions").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::instanceInboundPermissions)).setter(CreateContainerFleetRequest.setter(Builder::instanceInboundPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInboundPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GameServerContainerGroupsPerInstance").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::gameServerContainerGroupsPerInstance)).setter(CreateContainerFleetRequest.setter(Builder::gameServerContainerGroupsPerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerGroupsPerInstance").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::instanceType)).setter(CreateContainerFleetRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> BILLING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingType").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::billingTypeAsString)).setter(CreateContainerFleetRequest.setter(Builder::billingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingType").build()}).build();
    private static final SdkField<List<LocationConfiguration>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locations").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::locations)).setter(CreateContainerFleetRequest.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricGroups").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::metricGroups)).setter(CreateContainerFleetRequest.setter(Builder::metricGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewGameSessionProtectionPolicy").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::newGameSessionProtectionPolicyAsString)).setter(CreateContainerFleetRequest.setter(Builder::newGameSessionProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy").build()}).build();
    private static final SdkField<GameSessionCreationLimitPolicy> GAME_SESSION_CREATION_LIMIT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GameSessionCreationLimitPolicy").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::gameSessionCreationLimitPolicy)).setter(CreateContainerFleetRequest.setter(Builder::gameSessionCreationLimitPolicy)).constructor(GameSessionCreationLimitPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionCreationLimitPolicy").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::logConfiguration)).setter(CreateContainerFleetRequest.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateContainerFleetRequest.getter(CreateContainerFleetRequest::tags)).setter(CreateContainerFleetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ROLE_ARN_FIELD, DESCRIPTION_FIELD, GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD, PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD, INSTANCE_CONNECTION_PORT_RANGE_FIELD, INSTANCE_INBOUND_PERMISSIONS_FIELD, GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD, INSTANCE_TYPE_FIELD, BILLING_TYPE_FIELD, LOCATIONS_FIELD, METRIC_GROUPS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, GAME_SESSION_CREATION_LIMIT_POLICY_FIELD, LOG_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateContainerFleetRequest.memberNameToFieldInitializer();
    private final String fleetRoleArn;
    private final String description;
    private final String gameServerContainerGroupDefinitionName;
    private final String perInstanceContainerGroupDefinitionName;
    private final ConnectionPortRange instanceConnectionPortRange;
    private final List<IpPermission> instanceInboundPermissions;
    private final Integer gameServerContainerGroupsPerInstance;
    private final String instanceType;
    private final String billingType;
    private final List<LocationConfiguration> locations;
    private final List<String> metricGroups;
    private final String newGameSessionProtectionPolicy;
    private final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;
    private final LogConfiguration logConfiguration;
    private final List<Tag> tags;

    private CreateContainerFleetRequest(BuilderImpl builder) {
        super(builder);
        this.fleetRoleArn = builder.fleetRoleArn;
        this.description = builder.description;
        this.gameServerContainerGroupDefinitionName = builder.gameServerContainerGroupDefinitionName;
        this.perInstanceContainerGroupDefinitionName = builder.perInstanceContainerGroupDefinitionName;
        this.instanceConnectionPortRange = builder.instanceConnectionPortRange;
        this.instanceInboundPermissions = builder.instanceInboundPermissions;
        this.gameServerContainerGroupsPerInstance = builder.gameServerContainerGroupsPerInstance;
        this.instanceType = builder.instanceType;
        this.billingType = builder.billingType;
        this.locations = builder.locations;
        this.metricGroups = builder.metricGroups;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.gameSessionCreationLimitPolicy = builder.gameSessionCreationLimitPolicy;
        this.logConfiguration = builder.logConfiguration;
        this.tags = builder.tags;
    }

    public final String fleetRoleArn() {
        return this.fleetRoleArn;
    }

    public final String description() {
        return this.description;
    }

    public final String gameServerContainerGroupDefinitionName() {
        return this.gameServerContainerGroupDefinitionName;
    }

    public final String perInstanceContainerGroupDefinitionName() {
        return this.perInstanceContainerGroupDefinitionName;
    }

    public final ConnectionPortRange instanceConnectionPortRange() {
        return this.instanceConnectionPortRange;
    }

    public final boolean hasInstanceInboundPermissions() {
        return this.instanceInboundPermissions != null && !(this.instanceInboundPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> instanceInboundPermissions() {
        return this.instanceInboundPermissions;
    }

    public final Integer gameServerContainerGroupsPerInstance() {
        return this.gameServerContainerGroupsPerInstance;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final ContainerFleetBillingType billingType() {
        return ContainerFleetBillingType.fromValue(this.billingType);
    }

    public final String billingTypeAsString() {
        return this.billingType;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<LocationConfiguration> locations() {
        return this.locations;
    }

    public final boolean hasMetricGroups() {
        return this.metricGroups != null && !(this.metricGroups instanceof SdkAutoConstructList);
    }

    public final List<String> metricGroups() {
        return this.metricGroups;
    }

    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public final String newGameSessionProtectionPolicyAsString() {
        return this.newGameSessionProtectionPolicy;
    }

    public final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy() {
        return this.gameSessionCreationLimitPolicy;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.perInstanceContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConnectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceInboundPermissions() ? this.instanceInboundPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerGroupsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricGroups() ? this.metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerFleetRequest)) {
            return false;
        }
        CreateContainerFleetRequest other = (CreateContainerFleetRequest)((Object)obj);
        return Objects.equals(this.fleetRoleArn(), other.fleetRoleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.gameServerContainerGroupDefinitionName(), other.gameServerContainerGroupDefinitionName()) && Objects.equals(this.perInstanceContainerGroupDefinitionName(), other.perInstanceContainerGroupDefinitionName()) && Objects.equals(this.instanceConnectionPortRange(), other.instanceConnectionPortRange()) && this.hasInstanceInboundPermissions() == other.hasInstanceInboundPermissions() && Objects.equals(this.instanceInboundPermissions(), other.instanceInboundPermissions()) && Objects.equals(this.gameServerContainerGroupsPerInstance(), other.gameServerContainerGroupsPerInstance()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.billingTypeAsString(), other.billingTypeAsString()) && this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations()) && this.hasMetricGroups() == other.hasMetricGroups() && Objects.equals(this.metricGroups(), other.metricGroups()) && Objects.equals(this.newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString()) && Objects.equals(this.gameSessionCreationLimitPolicy(), other.gameSessionCreationLimitPolicy()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContainerFleetRequest").add("FleetRoleArn", (Object)this.fleetRoleArn()).add("Description", (Object)this.description()).add("GameServerContainerGroupDefinitionName", (Object)this.gameServerContainerGroupDefinitionName()).add("PerInstanceContainerGroupDefinitionName", (Object)this.perInstanceContainerGroupDefinitionName()).add("InstanceConnectionPortRange", (Object)this.instanceConnectionPortRange()).add("InstanceInboundPermissions", this.hasInstanceInboundPermissions() ? this.instanceInboundPermissions() : null).add("GameServerContainerGroupsPerInstance", (Object)this.gameServerContainerGroupsPerInstance()).add("InstanceType", (Object)this.instanceType()).add("BillingType", (Object)this.billingTypeAsString()).add("Locations", this.hasLocations() ? this.locations() : null).add("MetricGroups", this.hasMetricGroups() ? this.metricGroups() : null).add("NewGameSessionProtectionPolicy", (Object)this.newGameSessionProtectionPolicyAsString()).add("GameSessionCreationLimitPolicy", (Object)this.gameSessionCreationLimitPolicy()).add("LogConfiguration", (Object)this.logConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetRoleArn": {
                return Optional.ofNullable(clazz.cast(this.fleetRoleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GameServerContainerGroupDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerGroupDefinitionName()));
            }
            case "PerInstanceContainerGroupDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.perInstanceContainerGroupDefinitionName()));
            }
            case "InstanceConnectionPortRange": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectionPortRange()));
            }
            case "InstanceInboundPermissions": {
                return Optional.ofNullable(clazz.cast(this.instanceInboundPermissions()));
            }
            case "GameServerContainerGroupsPerInstance": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerGroupsPerInstance()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "BillingType": {
                return Optional.ofNullable(clazz.cast(this.billingTypeAsString()));
            }
            case "Locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
            case "MetricGroups": {
                return Optional.ofNullable(clazz.cast(this.metricGroups()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.newGameSessionProtectionPolicyAsString()));
            }
            case "GameSessionCreationLimitPolicy": {
                return Optional.ofNullable(clazz.cast(this.gameSessionCreationLimitPolicy()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetRoleArn", FLEET_ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("GameServerContainerGroupDefinitionName", GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("PerInstanceContainerGroupDefinitionName", PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("InstanceConnectionPortRange", INSTANCE_CONNECTION_PORT_RANGE_FIELD);
        map.put("InstanceInboundPermissions", INSTANCE_INBOUND_PERMISSIONS_FIELD);
        map.put("GameServerContainerGroupsPerInstance", GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("BillingType", BILLING_TYPE_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        map.put("MetricGroups", METRIC_GROUPS_FIELD);
        map.put("NewGameSessionProtectionPolicy", NEW_GAME_SESSION_PROTECTION_POLICY_FIELD);
        map.put("GameSessionCreationLimitPolicy", GAME_SESSION_CREATION_LIMIT_POLICY_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerFleetRequest, T> g) {
        return obj -> g.apply((CreateContainerFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetRoleArn;
        private String description;
        private String gameServerContainerGroupDefinitionName;
        private String perInstanceContainerGroupDefinitionName;
        private ConnectionPortRange instanceConnectionPortRange;
        private List<IpPermission> instanceInboundPermissions = DefaultSdkAutoConstructList.getInstance();
        private Integer gameServerContainerGroupsPerInstance;
        private String instanceType;
        private String billingType;
        private List<LocationConfiguration> locations = DefaultSdkAutoConstructList.getInstance();
        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();
        private String newGameSessionProtectionPolicy;
        private GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;
        private LogConfiguration logConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerFleetRequest model) {
            super(model);
            this.fleetRoleArn(model.fleetRoleArn);
            this.description(model.description);
            this.gameServerContainerGroupDefinitionName(model.gameServerContainerGroupDefinitionName);
            this.perInstanceContainerGroupDefinitionName(model.perInstanceContainerGroupDefinitionName);
            this.instanceConnectionPortRange(model.instanceConnectionPortRange);
            this.instanceInboundPermissions(model.instanceInboundPermissions);
            this.gameServerContainerGroupsPerInstance(model.gameServerContainerGroupsPerInstance);
            this.instanceType(model.instanceType);
            this.billingType(model.billingType);
            this.locations(model.locations);
            this.metricGroups(model.metricGroups);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.gameSessionCreationLimitPolicy(model.gameSessionCreationLimitPolicy);
            this.logConfiguration(model.logConfiguration);
            this.tags(model.tags);
        }

        public final String getFleetRoleArn() {
            return this.fleetRoleArn;
        }

        public final void setFleetRoleArn(String fleetRoleArn) {
            this.fleetRoleArn = fleetRoleArn;
        }

        @Override
        public final Builder fleetRoleArn(String fleetRoleArn) {
            this.fleetRoleArn = fleetRoleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGameServerContainerGroupDefinitionName() {
            return this.gameServerContainerGroupDefinitionName;
        }

        public final void setGameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
        }

        @Override
        public final Builder gameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
            return this;
        }

        public final String getPerInstanceContainerGroupDefinitionName() {
            return this.perInstanceContainerGroupDefinitionName;
        }

        public final void setPerInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
        }

        @Override
        public final Builder perInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
            return this;
        }

        public final ConnectionPortRange.Builder getInstanceConnectionPortRange() {
            return this.instanceConnectionPortRange != null ? this.instanceConnectionPortRange.toBuilder() : null;
        }

        public final void setInstanceConnectionPortRange(ConnectionPortRange.BuilderImpl instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange != null ? instanceConnectionPortRange.build() : null;
        }

        @Override
        public final Builder instanceConnectionPortRange(ConnectionPortRange instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange;
            return this;
        }

        public final List<IpPermission.Builder> getInstanceInboundPermissions() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.instanceInboundPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInboundPermissions(Collection<IpPermission.BuilderImpl> instanceInboundPermissions) {
            this.instanceInboundPermissions = IpPermissionsListCopier.copyFromBuilder(instanceInboundPermissions);
        }

        @Override
        public final Builder instanceInboundPermissions(Collection<IpPermission> instanceInboundPermissions) {
            this.instanceInboundPermissions = IpPermissionsListCopier.copy(instanceInboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissions(IpPermission ... instanceInboundPermissions) {
            this.instanceInboundPermissions(Arrays.asList(instanceInboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissions(Consumer<IpPermission.Builder> ... instanceInboundPermissions) {
            this.instanceInboundPermissions(Stream.of(instanceInboundPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getGameServerContainerGroupsPerInstance() {
            return this.gameServerContainerGroupsPerInstance;
        }

        public final void setGameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
        }

        @Override
        public final Builder gameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getBillingType() {
            return this.billingType;
        }

        public final void setBillingType(String billingType) {
            this.billingType = billingType;
        }

        @Override
        public final Builder billingType(String billingType) {
            this.billingType = billingType;
            return this;
        }

        @Override
        public final Builder billingType(ContainerFleetBillingType billingType) {
            this.billingType(billingType == null ? null : billingType.toString());
            return this;
        }

        public final List<LocationConfiguration.Builder> getLocations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<LocationConfiguration.BuilderImpl> locations) {
            this.locations = LocationConfigurationListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<LocationConfiguration> locations) {
            this.locations = LocationConfigurationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationConfiguration ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationConfiguration.Builder> ... locations) {
            this.locations(Stream.of(locations).map(c -> (LocationConfiguration)((LocationConfiguration.Builder)LocationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (this.metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final GameSessionCreationLimitPolicy.Builder getGameSessionCreationLimitPolicy() {
            return this.gameSessionCreationLimitPolicy != null ? this.gameSessionCreationLimitPolicy.toBuilder() : null;
        }

        public final void setGameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy.BuilderImpl gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy != null ? gameSessionCreationLimitPolicy.build() : null;
        }

        @Override
        public final Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerFleetRequest build() {
            return new CreateContainerFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContainerFleetRequest> {
        public Builder fleetRoleArn(String var1);

        public Builder description(String var1);

        public Builder gameServerContainerGroupDefinitionName(String var1);

        public Builder perInstanceContainerGroupDefinitionName(String var1);

        public Builder instanceConnectionPortRange(ConnectionPortRange var1);

        default public Builder instanceConnectionPortRange(Consumer<ConnectionPortRange.Builder> instanceConnectionPortRange) {
            return this.instanceConnectionPortRange((ConnectionPortRange)((ConnectionPortRange.Builder)ConnectionPortRange.builder().applyMutation(instanceConnectionPortRange)).build());
        }

        public Builder instanceInboundPermissions(Collection<IpPermission> var1);

        public Builder instanceInboundPermissions(IpPermission ... var1);

        public Builder instanceInboundPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder gameServerContainerGroupsPerInstance(Integer var1);

        public Builder instanceType(String var1);

        public Builder billingType(String var1);

        public Builder billingType(ContainerFleetBillingType var1);

        public Builder locations(Collection<LocationConfiguration> var1);

        public Builder locations(LocationConfiguration ... var1);

        public Builder locations(Consumer<LocationConfiguration.Builder> ... var1);

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy var1);

        default public Builder gameSessionCreationLimitPolicy(Consumer<GameSessionCreationLimitPolicy.Builder> gameSessionCreationLimitPolicy) {
            return this.gameSessionCreationLimitPolicy((GameSessionCreationLimitPolicy)((GameSessionCreationLimitPolicy.Builder)GameSessionCreationLimitPolicy.builder().applyMutation(gameSessionCreationLimitPolicy)).build());
        }

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

