/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBuildResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateBuildResponse.Builder, CreateBuildResponse> {
    private static final SdkField<Build> BUILD_FIELD = SdkField.<Build> builder(MarshallingType.SDK_POJO).memberName("Build")
            .getter(getter(CreateBuildResponse::build)).setter(setter(Builder::build)).constructor(Build::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Build").build()).build();

    private static final SdkField<Credentials> UPLOAD_CREDENTIALS_FIELD = SdkField
            .<Credentials> builder(MarshallingType.SDK_POJO).memberName("UploadCredentials")
            .getter(getter(CreateBuildResponse::uploadCredentials)).setter(setter(Builder::uploadCredentials))
            .constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadCredentials").build()).build();

    private static final SdkField<S3Location> STORAGE_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLocation").getter(getter(CreateBuildResponse::storageLocation))
            .setter(setter(Builder::storageLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_FIELD,
            UPLOAD_CREDENTIALS_FIELD, STORAGE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Build build;

    private final Credentials uploadCredentials;

    private final S3Location storageLocation;

    private CreateBuildResponse(BuilderImpl builder) {
        super(builder);
        this.build = builder.build;
        this.uploadCredentials = builder.uploadCredentials;
        this.storageLocation = builder.storageLocation;
    }

    /**
     * <p>
     * The newly created build resource, including a unique build IDs and status.
     * </p>
     * 
     * @return The newly created build resource, including a unique build IDs and status.
     */
    public final Build build() {
        return build;
    }

    /**
     * <p>
     * This element is returned only when the operation is called without a storage location. It contains credentials to
     * use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have
     * a limited life span. To refresh these credentials, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html"
     * >RequestUploadCredentials</a>.
     * </p>
     * 
     * @return This element is returned only when the operation is called without a storage location. It contains
     *         credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon
     *         GameLift. Credentials have a limited life span. To refresh these credentials, call <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html"
     *         >RequestUploadCredentials</a>.
     */
    public final Credentials uploadCredentials() {
        return uploadCredentials;
    }

    /**
     * <p>
     * Amazon S3 location for your game build file, including bucket name and key.
     * </p>
     * 
     * @return Amazon S3 location for your game build file, including bucket name and key.
     */
    public final S3Location storageLocation() {
        return storageLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(build());
        hashCode = 31 * hashCode + Objects.hashCode(uploadCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBuildResponse)) {
            return false;
        }
        CreateBuildResponse other = (CreateBuildResponse) obj;
        return Objects.equals(build(), other.build()) && Objects.equals(uploadCredentials(), other.uploadCredentials())
                && Objects.equals(storageLocation(), other.storageLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBuildResponse").add("Build", build())
                .add("UploadCredentials", uploadCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StorageLocation", storageLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Build":
            return Optional.ofNullable(clazz.cast(build()));
        case "UploadCredentials":
            return Optional.ofNullable(clazz.cast(uploadCredentials()));
        case "StorageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Build", BUILD_FIELD);
        map.put("UploadCredentials", UPLOAD_CREDENTIALS_FIELD);
        map.put("StorageLocation", STORAGE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBuildResponse, T> g) {
        return obj -> g.apply((CreateBuildResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateBuildResponse> {
        /**
         * <p>
         * The newly created build resource, including a unique build IDs and status.
         * </p>
         * 
         * @param build
         *        The newly created build resource, including a unique build IDs and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder build(Build build);

        /**
         * <p>
         * The newly created build resource, including a unique build IDs and status.
         * </p>
         * This is a convenience method that creates an instance of the {@link Build.Builder} avoiding the need to
         * create one manually via {@link Build#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Build.Builder#build()} is called immediately and its result is
         * passed to {@link #build(Build)}.
         * 
         * @param build
         *        a consumer that will call methods on {@link Build.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #build(Build)
         */
        default Builder build(Consumer<Build.Builder> build) {
            return build(Build.builder().applyMutation(build).build());
        }

        /**
         * <p>
         * This element is returned only when the operation is called without a storage location. It contains
         * credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon
         * GameLift. Credentials have a limited life span. To refresh these credentials, call <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html"
         * >RequestUploadCredentials</a>.
         * </p>
         * 
         * @param uploadCredentials
         *        This element is returned only when the operation is called without a storage location. It contains
         *        credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon
         *        GameLift. Credentials have a limited life span. To refresh these credentials, call <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html"
         *        >RequestUploadCredentials</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadCredentials(Credentials uploadCredentials);

        /**
         * <p>
         * This element is returned only when the operation is called without a storage location. It contains
         * credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon
         * GameLift. Credentials have a limited life span. To refresh these credentials, call <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html"
         * >RequestUploadCredentials</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #uploadCredentials(Credentials)}.
         * 
         * @param uploadCredentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadCredentials(Credentials)
         */
        default Builder uploadCredentials(Consumer<Credentials.Builder> uploadCredentials) {
            return uploadCredentials(Credentials.builder().applyMutation(uploadCredentials).build());
        }

        /**
         * <p>
         * Amazon S3 location for your game build file, including bucket name and key.
         * </p>
         * 
         * @param storageLocation
         *        Amazon S3 location for your game build file, including bucket name and key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(S3Location storageLocation);

        /**
         * <p>
         * Amazon S3 location for your game build file, including bucket name and key.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #storageLocation(S3Location)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(S3Location)
         */
        default Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return storageLocation(S3Location.builder().applyMutation(storageLocation).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Build build;

        private Credentials uploadCredentials;

        private S3Location storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBuildResponse model) {
            super(model);
            build(model.build);
            uploadCredentials(model.uploadCredentials);
            storageLocation(model.storageLocation);
        }

        public final Build.Builder getBuild() {
            return build != null ? build.toBuilder() : null;
        }

        public final void setBuild(Build.BuilderImpl build) {
            this.build = build != null ? build.build() : null;
        }

        @Override
        public final Builder build(Build build) {
            this.build = build;
            return this;
        }

        public final Credentials.Builder getUploadCredentials() {
            return uploadCredentials != null ? uploadCredentials.toBuilder() : null;
        }

        public final void setUploadCredentials(Credentials.BuilderImpl uploadCredentials) {
            this.uploadCredentials = uploadCredentials != null ? uploadCredentials.build() : null;
        }

        @Override
        public final Builder uploadCredentials(Credentials uploadCredentials) {
            this.uploadCredentials = uploadCredentials;
            return this;
        }

        public final S3Location.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        @Override
        public CreateBuildResponse build() {
            return new CreateBuildResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
