/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetLocationsResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateFleetLocationsResponse.Builder, CreateFleetLocationsResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(CreateFleetLocationsResponse::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(CreateFleetLocationsResponse::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<List<LocationState>> LOCATION_STATES_FIELD = SdkField
            .<List<LocationState>> builder(MarshallingType.LIST)
            .memberName("LocationStates")
            .getter(getter(CreateFleetLocationsResponse::locationStates))
            .setter(setter(Builder::locationStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, LOCATION_STATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetId;

    private final String fleetArn;

    private final List<LocationState> locationStates;

    private CreateFleetLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.locationStates = builder.locationStates;
    }

    /**
     * <p>
     * A unique identifier for the fleet that was updated with new locations.
     * </p>
     * 
     * @return A unique identifier for the fleet that was updated with new locations.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * that is assigned to a Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all
     * Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
     *         <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocationStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocationStates() {
        return locationStates != null && !(locationStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The remote locations that are being added to the fleet, and the life-cycle status of each location. For new
     * locations, the status is set to <code>NEW</code>. During location creation, Amazon GameLift updates each
     * location's status as instances are deployed there and prepared for game hosting. This list does not include the
     * fleet home Region or any remote locations that were already added to the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocationStates} method.
     * </p>
     * 
     * @return The remote locations that are being added to the fleet, and the life-cycle status of each location. For
     *         new locations, the status is set to <code>NEW</code>. During location creation, Amazon GameLift updates
     *         each location's status as instances are deployed there and prepared for game hosting. This list does not
     *         include the fleet home Region or any remote locations that were already added to the fleet.
     */
    public final List<LocationState> locationStates() {
        return locationStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocationStates() ? locationStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetLocationsResponse)) {
            return false;
        }
        CreateFleetLocationsResponse other = (CreateFleetLocationsResponse) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && hasLocationStates() == other.hasLocationStates() && Objects.equals(locationStates(), other.locationStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetLocationsResponse").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("LocationStates", hasLocationStates() ? locationStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "LocationStates":
            return Optional.ofNullable(clazz.cast(locationStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("FleetArn", FLEET_ARN_FIELD);
        map.put("LocationStates", LOCATION_STATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetLocationsResponse, T> g) {
        return obj -> g.apply((CreateFleetLocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetLocationsResponse> {
        /**
         * <p>
         * A unique identifier for the fleet that was updated with new locations.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet that was updated with new locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         * <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions.
         *        Format is
         *        <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The remote locations that are being added to the fleet, and the life-cycle status of each location. For new
         * locations, the status is set to <code>NEW</code>. During location creation, Amazon GameLift updates each
         * location's status as instances are deployed there and prepared for game hosting. This list does not include
         * the fleet home Region or any remote locations that were already added to the fleet.
         * </p>
         * 
         * @param locationStates
         *        The remote locations that are being added to the fleet, and the life-cycle status of each location.
         *        For new locations, the status is set to <code>NEW</code>. During location creation, Amazon GameLift
         *        updates each location's status as instances are deployed there and prepared for game hosting. This
         *        list does not include the fleet home Region or any remote locations that were already added to the
         *        fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationStates(Collection<LocationState> locationStates);

        /**
         * <p>
         * The remote locations that are being added to the fleet, and the life-cycle status of each location. For new
         * locations, the status is set to <code>NEW</code>. During location creation, Amazon GameLift updates each
         * location's status as instances are deployed there and prepared for game hosting. This list does not include
         * the fleet home Region or any remote locations that were already added to the fleet.
         * </p>
         * 
         * @param locationStates
         *        The remote locations that are being added to the fleet, and the life-cycle status of each location.
         *        For new locations, the status is set to <code>NEW</code>. During location creation, Amazon GameLift
         *        updates each location's status as instances are deployed there and prepared for game hosting. This
         *        list does not include the fleet home Region or any remote locations that were already added to the
         *        fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationStates(LocationState... locationStates);

        /**
         * <p>
         * The remote locations that are being added to the fleet, and the life-cycle status of each location. For new
         * locations, the status is set to <code>NEW</code>. During location creation, Amazon GameLift updates each
         * location's status as instances are deployed there and prepared for game hosting. This list does not include
         * the fleet home Region or any remote locations that were already added to the fleet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.LocationState.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.LocationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.LocationState.Builder#build()} is called immediately
         * and its result is passed to {@link #locationStates(List<LocationState>)}.
         * 
         * @param locationStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.LocationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locationStates(java.util.Collection<LocationState>)
         */
        Builder locationStates(Consumer<LocationState.Builder>... locationStates);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private List<LocationState> locationStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetLocationsResponse model) {
            super(model);
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            locationStates(model.locationStates);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final List<LocationState.Builder> getLocationStates() {
            List<LocationState.Builder> result = LocationStateListCopier.copyToBuilder(this.locationStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationStates(Collection<LocationState.BuilderImpl> locationStates) {
            this.locationStates = LocationStateListCopier.copyFromBuilder(locationStates);
        }

        @Override
        public final Builder locationStates(Collection<LocationState> locationStates) {
            this.locationStates = LocationStateListCopier.copy(locationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(LocationState... locationStates) {
            locationStates(Arrays.asList(locationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(Consumer<LocationState.Builder>... locationStates) {
            locationStates(Stream.of(locationStates).map(c -> LocationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateFleetLocationsResponse build() {
            return new CreateFleetLocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
