/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEc2InstanceLimitsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeEc2InstanceLimitsResponse.Builder, DescribeEc2InstanceLimitsResponse> {
    private static final SdkField<List<EC2InstanceLimit>> EC2_INSTANCE_LIMITS_FIELD = SdkField
            .<List<EC2InstanceLimit>> builder(MarshallingType.LIST)
            .memberName("EC2InstanceLimits")
            .getter(getter(DescribeEc2InstanceLimitsResponse::ec2InstanceLimits))
            .setter(setter(Builder::ec2InstanceLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2InstanceLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2InstanceLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_LIMITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EC2InstanceLimit> ec2InstanceLimits;

    private DescribeEc2InstanceLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.ec2InstanceLimits = builder.ec2InstanceLimits;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2InstanceLimits property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2InstanceLimits() {
        return ec2InstanceLimits != null && !(ec2InstanceLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The maximum number of instances for the specified instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceLimits} method.
     * </p>
     * 
     * @return The maximum number of instances for the specified instance type.
     */
    public final List<EC2InstanceLimit> ec2InstanceLimits() {
        return ec2InstanceLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceLimits() ? ec2InstanceLimits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEc2InstanceLimitsResponse)) {
            return false;
        }
        DescribeEc2InstanceLimitsResponse other = (DescribeEc2InstanceLimitsResponse) obj;
        return hasEc2InstanceLimits() == other.hasEc2InstanceLimits()
                && Objects.equals(ec2InstanceLimits(), other.ec2InstanceLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEc2InstanceLimitsResponse")
                .add("EC2InstanceLimits", hasEc2InstanceLimits() ? ec2InstanceLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2InstanceLimits":
            return Optional.ofNullable(clazz.cast(ec2InstanceLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EC2InstanceLimits", EC2_INSTANCE_LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEc2InstanceLimitsResponse, T> g) {
        return obj -> g.apply((DescribeEc2InstanceLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEc2InstanceLimitsResponse> {
        /**
         * <p>
         * The maximum number of instances for the specified instance type.
         * </p>
         * 
         * @param ec2InstanceLimits
         *        The maximum number of instances for the specified instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceLimits(Collection<EC2InstanceLimit> ec2InstanceLimits);

        /**
         * <p>
         * The maximum number of instances for the specified instance type.
         * </p>
         * 
         * @param ec2InstanceLimits
         *        The maximum number of instances for the specified instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceLimits(EC2InstanceLimit... ec2InstanceLimits);

        /**
         * <p>
         * The maximum number of instances for the specified instance type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2InstanceLimits(List<EC2InstanceLimit>)}.
         * 
         * @param ec2InstanceLimits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceLimits(java.util.Collection<EC2InstanceLimit>)
         */
        Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder>... ec2InstanceLimits);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<EC2InstanceLimit> ec2InstanceLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEc2InstanceLimitsResponse model) {
            super(model);
            ec2InstanceLimits(model.ec2InstanceLimits);
        }

        public final List<EC2InstanceLimit.Builder> getEc2InstanceLimits() {
            List<EC2InstanceLimit.Builder> result = EC2InstanceLimitListCopier.copyToBuilder(this.ec2InstanceLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceLimits(Collection<EC2InstanceLimit.BuilderImpl> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copyFromBuilder(ec2InstanceLimits);
        }

        @Override
        public final Builder ec2InstanceLimits(Collection<EC2InstanceLimit> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copy(ec2InstanceLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceLimits(EC2InstanceLimit... ec2InstanceLimits) {
            ec2InstanceLimits(Arrays.asList(ec2InstanceLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder>... ec2InstanceLimits) {
            ec2InstanceLimits(Stream.of(ec2InstanceLimits).map(c -> EC2InstanceLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEc2InstanceLimitsResponse build() {
            return new DescribeEc2InstanceLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
