/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGameSessionLogUrlResponse extends GameLiftResponse implements
        ToCopyableBuilder<GetGameSessionLogUrlResponse.Builder, GetGameSessionLogUrlResponse> {
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreSignedUrl").getter(getter(GetGameSessionLogUrlResponse::preSignedUrl))
            .setter(setter(Builder::preSignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_SIGNED_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String preSignedUrl;

    private GetGameSessionLogUrlResponse(BuilderImpl builder) {
        super(builder);
        this.preSignedUrl = builder.preSignedUrl;
    }

    /**
     * <p>
     * Location of the requested game session logs, available for download. This URL is valid for 15 minutes, after
     * which S3 will reject any download request using this URL. You can request a new URL any time within the 14-day
     * period that the logs are retained.
     * </p>
     * 
     * @return Location of the requested game session logs, available for download. This URL is valid for 15 minutes,
     *         after which S3 will reject any download request using this URL. You can request a new URL any time within
     *         the 14-day period that the logs are retained.
     */
    public final String preSignedUrl() {
        return preSignedUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGameSessionLogUrlResponse)) {
            return false;
        }
        GetGameSessionLogUrlResponse other = (GetGameSessionLogUrlResponse) obj;
        return Objects.equals(preSignedUrl(), other.preSignedUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGameSessionLogUrlResponse").add("PreSignedUrl", preSignedUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreSignedUrl", PRE_SIGNED_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGameSessionLogUrlResponse, T> g) {
        return obj -> g.apply((GetGameSessionLogUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGameSessionLogUrlResponse> {
        /**
         * <p>
         * Location of the requested game session logs, available for download. This URL is valid for 15 minutes, after
         * which S3 will reject any download request using this URL. You can request a new URL any time within the
         * 14-day period that the logs are retained.
         * </p>
         * 
         * @param preSignedUrl
         *        Location of the requested game session logs, available for download. This URL is valid for 15 minutes,
         *        after which S3 will reject any download request using this URL. You can request a new URL any time
         *        within the 14-day period that the logs are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(String preSignedUrl);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private String preSignedUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGameSessionLogUrlResponse model) {
            super(model);
            preSignedUrl(model.preSignedUrl);
        }

        public final String getPreSignedUrl() {
            return preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        @Override
        public GetGameSessionLogUrlResponse build() {
            return new GetGameSessionLogUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
