/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceAccessResponse extends GameLiftResponse implements
        ToCopyableBuilder<GetInstanceAccessResponse.Builder, GetInstanceAccessResponse> {
    private static final SdkField<InstanceAccess> INSTANCE_ACCESS_FIELD = SdkField
            .<InstanceAccess> builder(MarshallingType.SDK_POJO).memberName("InstanceAccess")
            .getter(getter(GetInstanceAccessResponse::instanceAccess)).setter(setter(Builder::instanceAccess))
            .constructor(InstanceAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InstanceAccess instanceAccess;

    private GetInstanceAccessResponse(BuilderImpl builder) {
        super(builder);
        this.instanceAccess = builder.instanceAccess;
    }

    /**
     * <p>
     * The connection information for a fleet instance, including IP address and access credentials.
     * </p>
     * 
     * @return The connection information for a fleet instance, including IP address and access credentials.
     */
    public final InstanceAccess instanceAccess() {
        return instanceAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessResponse)) {
            return false;
        }
        GetInstanceAccessResponse other = (GetInstanceAccessResponse) obj;
        return Objects.equals(instanceAccess(), other.instanceAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceAccessResponse").add("InstanceAccess", instanceAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceAccess":
            return Optional.ofNullable(clazz.cast(instanceAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceAccess", INSTANCE_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceAccessResponse, T> g) {
        return obj -> g.apply((GetInstanceAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceAccessResponse> {
        /**
         * <p>
         * The connection information for a fleet instance, including IP address and access credentials.
         * </p>
         * 
         * @param instanceAccess
         *        The connection information for a fleet instance, including IP address and access credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAccess(InstanceAccess instanceAccess);

        /**
         * <p>
         * The connection information for a fleet instance, including IP address and access credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceAccess.Builder} avoiding the need
         * to create one manually via {@link InstanceAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceAccess(InstanceAccess)}.
         * 
         * @param instanceAccess
         *        a consumer that will call methods on {@link InstanceAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceAccess(InstanceAccess)
         */
        default Builder instanceAccess(Consumer<InstanceAccess.Builder> instanceAccess) {
            return instanceAccess(InstanceAccess.builder().applyMutation(instanceAccess).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private InstanceAccess instanceAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessResponse model) {
            super(model);
            instanceAccess(model.instanceAccess);
        }

        public final InstanceAccess.Builder getInstanceAccess() {
            return instanceAccess != null ? instanceAccess.toBuilder() : null;
        }

        public final void setInstanceAccess(InstanceAccess.BuilderImpl instanceAccess) {
            this.instanceAccess = instanceAccess != null ? instanceAccess.build() : null;
        }

        @Override
        public final Builder instanceAccess(InstanceAccess instanceAccess) {
            this.instanceAccess = instanceAccess;
            return this;
        }

        @Override
        public GetInstanceAccessResponse build() {
            return new GetInstanceAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
