/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFleetDeploymentsResponse extends GameLiftResponse implements
        ToCopyableBuilder<ListFleetDeploymentsResponse.Builder, ListFleetDeploymentsResponse> {
    private static final SdkField<List<FleetDeployment>> FLEET_DEPLOYMENTS_FIELD = SdkField
            .<List<FleetDeployment>> builder(MarshallingType.LIST)
            .memberName("FleetDeployments")
            .getter(getter(ListFleetDeploymentsResponse::fleetDeployments))
            .setter(setter(Builder::fleetDeployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetDeployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetDeployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetDeployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFleetDeploymentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_DEPLOYMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FleetDeployment> fleetDeployments;

    private final String nextToken;

    private ListFleetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetDeployments = builder.fleetDeployments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetDeployments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFleetDeployments() {
        return fleetDeployments != null && !(fleetDeployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested deployment information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetDeployments} method.
     * </p>
     * 
     * @return The requested deployment information.
     */
    public final List<FleetDeployment> fleetDeployments() {
        return fleetDeployments;
    }

    /**
     * <p>
     * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return A token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetDeployments() ? fleetDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetDeploymentsResponse)) {
            return false;
        }
        ListFleetDeploymentsResponse other = (ListFleetDeploymentsResponse) obj;
        return hasFleetDeployments() == other.hasFleetDeployments()
                && Objects.equals(fleetDeployments(), other.fleetDeployments()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFleetDeploymentsResponse")
                .add("FleetDeployments", hasFleetDeployments() ? fleetDeployments() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetDeployments":
            return Optional.ofNullable(clazz.cast(fleetDeployments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetDeployments", FLEET_DEPLOYMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFleetDeploymentsResponse, T> g) {
        return obj -> g.apply((ListFleetDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFleetDeploymentsResponse> {
        /**
         * <p>
         * The requested deployment information.
         * </p>
         * 
         * @param fleetDeployments
         *        The requested deployment information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetDeployments(Collection<FleetDeployment> fleetDeployments);

        /**
         * <p>
         * The requested deployment information.
         * </p>
         * 
         * @param fleetDeployments
         *        The requested deployment information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetDeployments(FleetDeployment... fleetDeployments);

        /**
         * <p>
         * The requested deployment information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.FleetDeployment.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.gamelift.model.FleetDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.FleetDeployment.Builder#build()} is called immediately
         * and its result is passed to {@link #fleetDeployments(List<FleetDeployment>)}.
         * 
         * @param fleetDeployments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.FleetDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetDeployments(java.util.Collection<FleetDeployment>)
         */
        Builder fleetDeployments(Consumer<FleetDeployment.Builder>... fleetDeployments);

        /**
         * <p>
         * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<FleetDeployment> fleetDeployments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetDeploymentsResponse model) {
            super(model);
            fleetDeployments(model.fleetDeployments);
            nextToken(model.nextToken);
        }

        public final List<FleetDeployment.Builder> getFleetDeployments() {
            List<FleetDeployment.Builder> result = FleetDeploymentsCopier.copyToBuilder(this.fleetDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetDeployments(Collection<FleetDeployment.BuilderImpl> fleetDeployments) {
            this.fleetDeployments = FleetDeploymentsCopier.copyFromBuilder(fleetDeployments);
        }

        @Override
        public final Builder fleetDeployments(Collection<FleetDeployment> fleetDeployments) {
            this.fleetDeployments = FleetDeploymentsCopier.copy(fleetDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetDeployments(FleetDeployment... fleetDeployments) {
            fleetDeployments(Arrays.asList(fleetDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetDeployments(Consumer<FleetDeployment.Builder>... fleetDeployments) {
            fleetDeployments(Stream.of(fleetDeployments).map(c -> FleetDeployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFleetDeploymentsResponse build() {
            return new ListFleetDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
