/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a multi-location container fleet, describes the progress of a deployment across all fleet locations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocationalDeployment implements SdkPojo, Serializable,
        ToCopyableBuilder<LocationalDeployment.Builder, LocationalDeployment> {
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(LocationalDeployment::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deploymentStatus;

    private LocationalDeployment(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
    }

    /**
     * <p>
     * The status of fleet deployment activity in the location.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> -- The deployment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> -- The deployment has completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> -- The deployment was cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of fleet deployment activity in the location. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> -- The deployment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> -- The deployment has completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> -- The deployment was cancelled.
     *         </p>
     *         </li>
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The status of fleet deployment activity in the location.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> -- The deployment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> -- The deployment has completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> -- The deployment was cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of fleet deployment activity in the location. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> -- The deployment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> -- The deployment has completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> -- The deployment was cancelled.
     *         </p>
     *         </li>
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationalDeployment)) {
            return false;
        }
        LocationalDeployment other = (LocationalDeployment) obj;
        return Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocationalDeployment").add("DeploymentStatus", deploymentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocationalDeployment, T> g) {
        return obj -> g.apply((LocationalDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocationalDeployment> {
        /**
         * <p>
         * The status of fleet deployment activity in the location.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> -- The deployment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> -- The deployment has completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> -- The deployment was cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStatus
         *        The status of fleet deployment activity in the location. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> -- The deployment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> -- The deployment has completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> -- The deployment was cancelled.
         *        </p>
         *        </li>
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The status of fleet deployment activity in the location.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> -- The deployment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> -- The deployment has completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> -- The deployment was cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStatus
         *        The status of fleet deployment activity in the location. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> -- The deployment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> -- The deployment has completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> -- The deployment was cancelled.
         *        </p>
         *        </li>
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationalDeployment model) {
            deploymentStatus(model.deploymentStatus);
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        @Override
        public LocationalDeployment build() {
            return new LocationalDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
