/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterComputeResponse extends GameLiftResponse implements
        ToCopyableBuilder<RegisterComputeResponse.Builder, RegisterComputeResponse> {
    private static final SdkField<Compute> COMPUTE_FIELD = SdkField.<Compute> builder(MarshallingType.SDK_POJO)
            .memberName("Compute").getter(getter(RegisterComputeResponse::compute)).setter(setter(Builder::compute))
            .constructor(Compute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Compute compute;

    private RegisterComputeResponse(BuilderImpl builder) {
        super(builder);
        this.compute = builder.compute;
    }

    /**
     * <p>
     * The details of the compute resource you registered.
     * </p>
     * 
     * @return The details of the compute resource you registered.
     */
    public final Compute compute() {
        return compute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterComputeResponse)) {
            return false;
        }
        RegisterComputeResponse other = (RegisterComputeResponse) obj;
        return Objects.equals(compute(), other.compute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterComputeResponse").add("Compute", compute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Compute":
            return Optional.ofNullable(clazz.cast(compute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Compute", COMPUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterComputeResponse, T> g) {
        return obj -> g.apply((RegisterComputeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterComputeResponse> {
        /**
         * <p>
         * The details of the compute resource you registered.
         * </p>
         * 
         * @param compute
         *        The details of the compute resource you registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compute(Compute compute);

        /**
         * <p>
         * The details of the compute resource you registered.
         * </p>
         * This is a convenience method that creates an instance of the {@link Compute.Builder} avoiding the need to
         * create one manually via {@link Compute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Compute.Builder#build()} is called immediately and its result is
         * passed to {@link #compute(Compute)}.
         * 
         * @param compute
         *        a consumer that will call methods on {@link Compute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compute(Compute)
         */
        default Builder compute(Consumer<Compute.Builder> compute) {
            return compute(Compute.builder().applyMutation(compute).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Compute compute;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterComputeResponse model) {
            super(model);
            compute(model.compute);
        }

        public final Compute.Builder getCompute() {
            return compute != null ? compute.toBuilder() : null;
        }

        public final void setCompute(Compute.BuilderImpl compute) {
            this.compute = compute != null ? compute.build() : null;
        }

        @Override
        public final Builder compute(Compute compute) {
            this.compute = compute;
            return this;
        }

        @Override
        public RegisterComputeResponse build() {
            return new RegisterComputeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
