/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterGameServerRequest extends GameLiftRequest implements
        ToCopyableBuilder<RegisterGameServerRequest.Builder, RegisterGameServerRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(RegisterGameServerRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerId").getter(getter(RegisterGameServerRequest::gameServerId))
            .setter(setter(Builder::gameServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(RegisterGameServerRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONNECTION_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionInfo").getter(getter(RegisterGameServerRequest::connectionInfo))
            .setter(setter(Builder::connectionInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionInfo").build()).build();

    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerData").getter(getter(RegisterGameServerRequest::gameServerData))
            .setter(setter(Builder::gameServerData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            GAME_SERVER_ID_FIELD, INSTANCE_ID_FIELD, CONNECTION_INFO_FIELD, GAME_SERVER_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gameServerGroupName;

    private final String gameServerId;

    private final String instanceId;

    private final String connectionInfo;

    private final String gameServerData;

    private RegisterGameServerRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerId = builder.gameServerId;
        this.instanceId = builder.instanceId;
        this.connectionInfo = builder.connectionInfo;
        this.gameServerData = builder.gameServerData;
    }

    /**
     * <p>
     * A unique identifier for the game server group where the game server is running.
     * </p>
     * 
     * @return A unique identifier for the game server group where the game server is running.
     */
    public final String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined and
     * must be unique across all game server groups in your Amazon Web Services account.
     * </p>
     * 
     * @return A custom string that uniquely identifies the game server to register. Game server IDs are
     *         developer-defined and must be unique across all game server groups in your Amazon Web Services account.
     */
    public final String gameServerId() {
        return gameServerId;
    }

    /**
     * <p>
     * The unique identifier for the instance where the game server is running. This ID is available in the instance
     * metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.
     * </p>
     * 
     * @return The unique identifier for the instance where the game server is running. This ID is available in the
     *         instance metadata. EC2 instance IDs use a 17-character format, for example:
     *         <code>i-1234567890abcdef0</code>.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Information that is needed to make inbound client connections to the game server. This might include the IP
     * address and port, DNS name, and other information.
     * </p>
     * 
     * @return Information that is needed to make inbound client connections to the game server. This might include the
     *         IP address and port, DNS name, and other information.
     */
    public final String connectionInfo() {
        return connectionInfo;
    }

    /**
     * <p>
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client
     * or service when it requests information on game servers.
     * </p>
     * 
     * @return A set of custom game server properties, formatted as a single string value. This data is passed to a game
     *         client or service when it requests information on game servers.
     */
    public final String gameServerData() {
        return gameServerData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterGameServerRequest)) {
            return false;
        }
        RegisterGameServerRequest other = (RegisterGameServerRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName())
                && Objects.equals(gameServerId(), other.gameServerId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(connectionInfo(), other.connectionInfo())
                && Objects.equals(gameServerData(), other.gameServerData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterGameServerRequest").add("GameServerGroupName", gameServerGroupName())
                .add("GameServerId", gameServerId()).add("InstanceId", instanceId()).add("ConnectionInfo", connectionInfo())
                .add("GameServerData", gameServerData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "GameServerId":
            return Optional.ofNullable(clazz.cast(gameServerId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ConnectionInfo":
            return Optional.ofNullable(clazz.cast(connectionInfo()));
        case "GameServerData":
            return Optional.ofNullable(clazz.cast(gameServerData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
        map.put("GameServerId", GAME_SERVER_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ConnectionInfo", CONNECTION_INFO_FIELD);
        map.put("GameServerData", GAME_SERVER_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterGameServerRequest, T> g) {
        return obj -> g.apply((RegisterGameServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterGameServerRequest> {
        /**
         * <p>
         * A unique identifier for the game server group where the game server is running.
         * </p>
         * 
         * @param gameServerGroupName
         *        A unique identifier for the game server group where the game server is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined
         * and must be unique across all game server groups in your Amazon Web Services account.
         * </p>
         * 
         * @param gameServerId
         *        A custom string that uniquely identifies the game server to register. Game server IDs are
         *        developer-defined and must be unique across all game server groups in your Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerId(String gameServerId);

        /**
         * <p>
         * The unique identifier for the instance where the game server is running. This ID is available in the instance
         * metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the instance where the game server is running. This ID is available in the
         *        instance metadata. EC2 instance IDs use a 17-character format, for example:
         *        <code>i-1234567890abcdef0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Information that is needed to make inbound client connections to the game server. This might include the IP
         * address and port, DNS name, and other information.
         * </p>
         * 
         * @param connectionInfo
         *        Information that is needed to make inbound client connections to the game server. This might include
         *        the IP address and port, DNS name, and other information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionInfo(String connectionInfo);

        /**
         * <p>
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game
         * client or service when it requests information on game servers.
         * </p>
         * 
         * @param gameServerData
         *        A set of custom game server properties, formatted as a single string value. This data is passed to a
         *        game client or service when it requests information on game servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerData(String gameServerData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String gameServerId;

        private String instanceId;

        private String connectionInfo;

        private String gameServerData;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterGameServerRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            gameServerId(model.gameServerId);
            instanceId(model.instanceId);
            connectionInfo(model.connectionInfo);
            gameServerData(model.gameServerData);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getGameServerId() {
            return gameServerId;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getConnectionInfo() {
            return connectionInfo;
        }

        public final void setConnectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
        }

        @Override
        public final Builder connectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public final String getGameServerData() {
            return gameServerData;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterGameServerRequest build() {
            return new RegisterGameServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
