/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateGameSessionRequest extends GameLiftRequest implements
        ToCopyableBuilder<TerminateGameSessionRequest.Builder, TerminateGameSessionRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionId").getter(getter(TerminateGameSessionRequest::gameSessionId))
            .setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<String> TERMINATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TerminationMode").getter(getter(TerminateGameSessionRequest::terminationModeAsString))
            .setter(setter(Builder::terminationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD,
            TERMINATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gameSessionId;

    private final String terminationMode;

    private TerminateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.terminationMode = builder.terminationMode;
    }

    /**
     * <p>
     * A unique identifier for the game session to be terminated. A game session ARN has the following format:
     * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     * .
     * </p>
     * 
     * @return A unique identifier for the game session to be terminated. A game session ARN has the following format:
     *         <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     *         .
     */
    public final String gameSessionId() {
        return gameSessionId;
    }

    /**
     * <p>
     * The method to use to terminate the game session. Available methods include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
     * <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session shutdown
     * sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server code, must include
     * a call to the server SDK action <code>ProcessEnding()</code>, which is how the server process signals to Amazon
     * GameLift that a game session is ending. If the server process doesn't call <code>ProcessEnding()</code>, the game
     * session termination won't conclude successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process immediately. Amazon
     * GameLift takes action (depending on the type of fleet) to shut down the server process without the normal game
     * session shutdown sequence.
     * </p>
     * <note>
     * <p>
     * This method is not available for game sessions that are running on Anywhere fleets unless the fleet is deployed
     * with the Amazon GameLift Agent. In this scenario, a force terminate request results in an invalid or bad request
     * exception.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #terminationMode}
     * will return {@link TerminationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #terminationModeAsString}.
     * </p>
     * 
     * @return The method to use to terminate the game session. Available methods include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
     *         <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session
     *         shutdown sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server
     *         code, must include a call to the server SDK action <code>ProcessEnding()</code>, which is how the server
     *         process signals to Amazon GameLift that a game session is ending. If the server process doesn't call
     *         <code>ProcessEnding()</code>, the game session termination won't conclude successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process
     *         immediately. Amazon GameLift takes action (depending on the type of fleet) to shut down the server
     *         process without the normal game session shutdown sequence.
     *         </p>
     *         <note>
     *         <p>
     *         This method is not available for game sessions that are running on Anywhere fleets unless the fleet is
     *         deployed with the Amazon GameLift Agent. In this scenario, a force terminate request results in an
     *         invalid or bad request exception.
     *         </p>
     *         </note></li>
     * @see TerminationMode
     */
    public final TerminationMode terminationMode() {
        return TerminationMode.fromValue(terminationMode);
    }

    /**
     * <p>
     * The method to use to terminate the game session. Available methods include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
     * <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session shutdown
     * sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server code, must include
     * a call to the server SDK action <code>ProcessEnding()</code>, which is how the server process signals to Amazon
     * GameLift that a game session is ending. If the server process doesn't call <code>ProcessEnding()</code>, the game
     * session termination won't conclude successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process immediately. Amazon
     * GameLift takes action (depending on the type of fleet) to shut down the server process without the normal game
     * session shutdown sequence.
     * </p>
     * <note>
     * <p>
     * This method is not available for game sessions that are running on Anywhere fleets unless the fleet is deployed
     * with the Amazon GameLift Agent. In this scenario, a force terminate request results in an invalid or bad request
     * exception.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #terminationMode}
     * will return {@link TerminationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #terminationModeAsString}.
     * </p>
     * 
     * @return The method to use to terminate the game session. Available methods include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
     *         <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session
     *         shutdown sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server
     *         code, must include a call to the server SDK action <code>ProcessEnding()</code>, which is how the server
     *         process signals to Amazon GameLift that a game session is ending. If the server process doesn't call
     *         <code>ProcessEnding()</code>, the game session termination won't conclude successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process
     *         immediately. Amazon GameLift takes action (depending on the type of fleet) to shut down the server
     *         process without the normal game session shutdown sequence.
     *         </p>
     *         <note>
     *         <p>
     *         This method is not available for game sessions that are running on Anywhere fleets unless the fleet is
     *         deployed with the Amazon GameLift Agent. In this scenario, a force terminate request results in an
     *         invalid or bad request exception.
     *         </p>
     *         </note></li>
     * @see TerminationMode
     */
    public final String terminationModeAsString() {
        return terminationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(terminationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateGameSessionRequest)) {
            return false;
        }
        TerminateGameSessionRequest other = (TerminateGameSessionRequest) obj;
        return Objects.equals(gameSessionId(), other.gameSessionId())
                && Objects.equals(terminationModeAsString(), other.terminationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateGameSessionRequest").add("GameSessionId", gameSessionId())
                .add("TerminationMode", terminationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "TerminationMode":
            return Optional.ofNullable(clazz.cast(terminationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameSessionId", GAME_SESSION_ID_FIELD);
        map.put("TerminationMode", TERMINATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TerminateGameSessionRequest, T> g) {
        return obj -> g.apply((TerminateGameSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, TerminateGameSessionRequest> {
        /**
         * <p>
         * A unique identifier for the game session to be terminated. A game session ARN has the following format:
         * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         * .
         * </p>
         * 
         * @param gameSessionId
         *        A unique identifier for the game session to be terminated. A game session ARN has the following
         *        format:
         *        <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * The method to use to terminate the game session. Available methods include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
         * <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session
         * shutdown sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server code,
         * must include a call to the server SDK action <code>ProcessEnding()</code>, which is how the server process
         * signals to Amazon GameLift that a game session is ending. If the server process doesn't call
         * <code>ProcessEnding()</code>, the game session termination won't conclude successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process immediately.
         * Amazon GameLift takes action (depending on the type of fleet) to shut down the server process without the
         * normal game session shutdown sequence.
         * </p>
         * <note>
         * <p>
         * This method is not available for game sessions that are running on Anywhere fleets unless the fleet is
         * deployed with the Amazon GameLift Agent. In this scenario, a force terminate request results in an invalid or
         * bad request exception.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param terminationMode
         *        The method to use to terminate the game session. Available methods include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
         *        <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session
         *        shutdown sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server
         *        code, must include a call to the server SDK action <code>ProcessEnding()</code>, which is how the
         *        server process signals to Amazon GameLift that a game session is ending. If the server process doesn't
         *        call <code>ProcessEnding()</code>, the game session termination won't conclude successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process
         *        immediately. Amazon GameLift takes action (depending on the type of fleet) to shut down the server
         *        process without the normal game session shutdown sequence.
         *        </p>
         *        <note>
         *        <p>
         *        This method is not available for game sessions that are running on Anywhere fleets unless the fleet is
         *        deployed with the Amazon GameLift Agent. In this scenario, a force terminate request results in an
         *        invalid or bad request exception.
         *        </p>
         *        </note></li>
         * @see TerminationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TerminationMode
         */
        Builder terminationMode(String terminationMode);

        /**
         * <p>
         * The method to use to terminate the game session. Available methods include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
         * <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session
         * shutdown sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server code,
         * must include a call to the server SDK action <code>ProcessEnding()</code>, which is how the server process
         * signals to Amazon GameLift that a game session is ending. If the server process doesn't call
         * <code>ProcessEnding()</code>, the game session termination won't conclude successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process immediately.
         * Amazon GameLift takes action (depending on the type of fleet) to shut down the server process without the
         * normal game session shutdown sequence.
         * </p>
         * <note>
         * <p>
         * This method is not available for game sessions that are running on Anywhere fleets unless the fleet is
         * deployed with the Amazon GameLift Agent. In this scenario, a force terminate request results in an invalid or
         * bad request exception.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param terminationMode
         *        The method to use to terminate the game session. Available methods include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRIGGER_ON_PROCESS_TERMINATE</code> – Prompts the Amazon GameLift service to send an
         *        <code>OnProcessTerminate()</code> callback to the server process and initiate the normal game session
         *        shutdown sequence. The <code>OnProcessTerminate</code> method, which is implemented in the game server
         *        code, must include a call to the server SDK action <code>ProcessEnding()</code>, which is how the
         *        server process signals to Amazon GameLift that a game session is ending. If the server process doesn't
         *        call <code>ProcessEnding()</code>, the game session termination won't conclude successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_TERMINATE</code> – Prompts the Amazon GameLift service to stop the server process
         *        immediately. Amazon GameLift takes action (depending on the type of fleet) to shut down the server
         *        process without the normal game session shutdown sequence.
         *        </p>
         *        <note>
         *        <p>
         *        This method is not available for game sessions that are running on Anywhere fleets unless the fleet is
         *        deployed with the Amazon GameLift Agent. In this scenario, a force terminate request results in an
         *        invalid or bad request exception.
         *        </p>
         *        </note></li>
         * @see TerminationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TerminationMode
         */
        Builder terminationMode(TerminationMode terminationMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameSessionId;

        private String terminationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateGameSessionRequest model) {
            super(model);
            gameSessionId(model.gameSessionId);
            terminationMode(model.terminationMode);
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getTerminationMode() {
            return terminationMode;
        }

        public final void setTerminationMode(String terminationMode) {
            this.terminationMode = terminationMode;
        }

        @Override
        public final Builder terminationMode(String terminationMode) {
            this.terminationMode = terminationMode;
            return this;
        }

        @Override
        public final Builder terminationMode(TerminationMode terminationMode) {
            this.terminationMode(terminationMode == null ? null : terminationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateGameSessionRequest build() {
            return new TerminateGameSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
