/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContainerFleetRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateContainerFleetRequest.Builder, UpdateContainerFleetRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(UpdateContainerFleetRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GameServerContainerGroupDefinitionName")
            .getter(getter(UpdateContainerFleetRequest::gameServerContainerGroupDefinitionName))
            .setter(setter(Builder::gameServerContainerGroupDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GameServerContainerGroupDefinitionName").build()).build();

    private static final SdkField<String> PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerInstanceContainerGroupDefinitionName")
            .getter(getter(UpdateContainerFleetRequest::perInstanceContainerGroupDefinitionName))
            .setter(setter(Builder::perInstanceContainerGroupDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PerInstanceContainerGroupDefinitionName").build()).build();

    private static final SdkField<Integer> GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("GameServerContainerGroupsPerInstance")
            .getter(getter(UpdateContainerFleetRequest::gameServerContainerGroupsPerInstance))
            .setter(setter(Builder::gameServerContainerGroupsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GameServerContainerGroupsPerInstance").build()).build();

    private static final SdkField<ConnectionPortRange> INSTANCE_CONNECTION_PORT_RANGE_FIELD = SdkField
            .<ConnectionPortRange> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceConnectionPortRange")
            .getter(getter(UpdateContainerFleetRequest::instanceConnectionPortRange))
            .setter(setter(Builder::instanceConnectionPortRange))
            .constructor(ConnectionPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectionPortRange")
                    .build()).build();

    private static final SdkField<List<IpPermission>> INSTANCE_INBOUND_PERMISSION_AUTHORIZATIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("InstanceInboundPermissionAuthorizations")
            .getter(getter(UpdateContainerFleetRequest::instanceInboundPermissionAuthorizations))
            .setter(setter(Builder::instanceInboundPermissionAuthorizations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceInboundPermissionAuthorizations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpPermission>> INSTANCE_INBOUND_PERMISSION_REVOCATIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("InstanceInboundPermissionRevocations")
            .getter(getter(UpdateContainerFleetRequest::instanceInboundPermissionRevocations))
            .setter(setter(Builder::instanceInboundPermissionRevocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceInboundPermissionRevocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfiguration")
            .getter(getter(UpdateContainerFleetRequest::deploymentConfiguration))
            .setter(setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateContainerFleetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricGroups")
            .getter(getter(UpdateContainerFleetRequest::metricGroups))
            .setter(setter(Builder::metricGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewGameSessionProtectionPolicy")
            .getter(getter(UpdateContainerFleetRequest::newGameSessionProtectionPolicyAsString))
            .setter(setter(Builder::newGameSessionProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy")
                    .build()).build();

    private static final SdkField<GameSessionCreationLimitPolicy> GAME_SESSION_CREATION_LIMIT_POLICY_FIELD = SdkField
            .<GameSessionCreationLimitPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("GameSessionCreationLimitPolicy")
            .getter(getter(UpdateContainerFleetRequest::gameSessionCreationLimitPolicy))
            .setter(setter(Builder::gameSessionCreationLimitPolicy))
            .constructor(GameSessionCreationLimitPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionCreationLimitPolicy")
                    .build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogConfiguration")
            .getter(getter(UpdateContainerFleetRequest::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<List<String>> REMOVE_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveAttributes")
            .getter(getter(UpdateContainerFleetRequest::removeAttributesAsStrings))
            .setter(setter(Builder::removeAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD, PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD,
            GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD, INSTANCE_CONNECTION_PORT_RANGE_FIELD,
            INSTANCE_INBOUND_PERMISSION_AUTHORIZATIONS_FIELD, INSTANCE_INBOUND_PERMISSION_REVOCATIONS_FIELD,
            DEPLOYMENT_CONFIGURATION_FIELD, DESCRIPTION_FIELD, METRIC_GROUPS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD,
            GAME_SESSION_CREATION_LIMIT_POLICY_FIELD, LOG_CONFIGURATION_FIELD, REMOVE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetId;

    private final String gameServerContainerGroupDefinitionName;

    private final String perInstanceContainerGroupDefinitionName;

    private final Integer gameServerContainerGroupsPerInstance;

    private final ConnectionPortRange instanceConnectionPortRange;

    private final List<IpPermission> instanceInboundPermissionAuthorizations;

    private final List<IpPermission> instanceInboundPermissionRevocations;

    private final DeploymentConfiguration deploymentConfiguration;

    private final String description;

    private final List<String> metricGroups;

    private final String newGameSessionProtectionPolicy;

    private final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;

    private final LogConfiguration logConfiguration;

    private final List<String> removeAttributes;

    private UpdateContainerFleetRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.gameServerContainerGroupDefinitionName = builder.gameServerContainerGroupDefinitionName;
        this.perInstanceContainerGroupDefinitionName = builder.perInstanceContainerGroupDefinitionName;
        this.gameServerContainerGroupsPerInstance = builder.gameServerContainerGroupsPerInstance;
        this.instanceConnectionPortRange = builder.instanceConnectionPortRange;
        this.instanceInboundPermissionAuthorizations = builder.instanceInboundPermissionAuthorizations;
        this.instanceInboundPermissionRevocations = builder.instanceInboundPermissionRevocations;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.description = builder.description;
        this.metricGroups = builder.metricGroups;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.gameSessionCreationLimitPolicy = builder.gameSessionCreationLimitPolicy;
        this.logConfiguration = builder.logConfiguration;
        this.removeAttributes = builder.removeAttributes;
    }

    /**
     * <p>
     * A unique identifier for the container fleet to update. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the container fleet to update. You can use either the fleet ID or ARN value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The name or ARN value of a new game server container group definition to deploy on the fleet. If you're updating
     * the fleet to a specific version of a container group definition, use the ARN value and include the version
     * number. If you're updating the fleet to the latest version of a container group definition, you can use the name
     * value. You can't remove a fleet's game server container group definition, you can only update or replace it with
     * another definition.
     * </p>
     * <p>
     * Update a container group definition by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
     * >UpdateContainerGroupDefinition</a>. This operation creates a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     * >ContainerGroupDefinition</a> resource with an incremented version.
     * </p>
     * 
     * @return The name or ARN value of a new game server container group definition to deploy on the fleet. If you're
     *         updating the fleet to a specific version of a container group definition, use the ARN value and include
     *         the version number. If you're updating the fleet to the latest version of a container group definition,
     *         you can use the name value. You can't remove a fleet's game server container group definition, you can
     *         only update or replace it with another definition.</p>
     *         <p>
     *         Update a container group definition by calling <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
     *         >UpdateContainerGroupDefinition</a>. This operation creates a <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     *         >ContainerGroupDefinition</a> resource with an incremented version.
     */
    public final String gameServerContainerGroupDefinitionName() {
        return gameServerContainerGroupDefinitionName;
    }

    /**
     * <p>
     * The name or ARN value of a new per-instance container group definition to deploy on the fleet. If you're updating
     * the fleet to a specific version of a container group definition, use the ARN value and include the version
     * number. If you're updating the fleet to the latest version of a container group definition, you can use the name
     * value.
     * </p>
     * <p>
     * Update a container group definition by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
     * >UpdateContainerGroupDefinition</a>. This operation creates a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     * >ContainerGroupDefinition</a> resource with an incremented version.
     * </p>
     * <p>
     * To remove a fleet's per-instance container group definition, leave this parameter empty and use the parameter
     * <code>RemoveAttributes</code>.
     * </p>
     * 
     * @return The name or ARN value of a new per-instance container group definition to deploy on the fleet. If you're
     *         updating the fleet to a specific version of a container group definition, use the ARN value and include
     *         the version number. If you're updating the fleet to the latest version of a container group definition,
     *         you can use the name value.</p>
     *         <p>
     *         Update a container group definition by calling <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
     *         >UpdateContainerGroupDefinition</a>. This operation creates a <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     *         >ContainerGroupDefinition</a> resource with an incremented version.
     *         </p>
     *         <p>
     *         To remove a fleet's per-instance container group definition, leave this parameter empty and use the
     *         parameter <code>RemoveAttributes</code>.
     */
    public final String perInstanceContainerGroupDefinitionName() {
        return perInstanceContainerGroupDefinitionName;
    }

    /**
     * <p>
     * The number of times to replicate the game server container group on each fleet instance. By default, Amazon
     * GameLift calculates the maximum number of game server container groups that can fit on each instance. You can
     * remove this property value to use the calculated value, or set it manually. If you set this number manually,
     * Amazon GameLift uses your value as long as it's less than the calculated maximum.
     * </p>
     * 
     * @return The number of times to replicate the game server container group on each fleet instance. By default,
     *         Amazon GameLift calculates the maximum number of game server container groups that can fit on each
     *         instance. You can remove this property value to use the calculated value, or set it manually. If you set
     *         this number manually, Amazon GameLift uses your value as long as it's less than the calculated maximum.
     */
    public final Integer gameServerContainerGroupsPerInstance() {
        return gameServerContainerGroupsPerInstance;
    }

    /**
     * <p>
     * A revised set of port numbers to open on each fleet instance. By default, Amazon GameLift calculates an optimal
     * port range based on your fleet configuration. If you previously set this parameter manually, you can't reset this
     * to use the calculated settings.
     * </p>
     * 
     * @return A revised set of port numbers to open on each fleet instance. By default, Amazon GameLift calculates an
     *         optimal port range based on your fleet configuration. If you previously set this parameter manually, you
     *         can't reset this to use the calculated settings.
     */
    public final ConnectionPortRange instanceConnectionPortRange() {
        return instanceConnectionPortRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceInboundPermissionAuthorizations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasInstanceInboundPermissionAuthorizations() {
        return instanceInboundPermissionAuthorizations != null
                && !(instanceInboundPermissionAuthorizations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of ports to add to the container fleet's inbound permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasInstanceInboundPermissionAuthorizations} method.
     * </p>
     * 
     * @return A set of ports to add to the container fleet's inbound permissions.
     */
    public final List<IpPermission> instanceInboundPermissionAuthorizations() {
        return instanceInboundPermissionAuthorizations;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceInboundPermissionRevocations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasInstanceInboundPermissionRevocations() {
        return instanceInboundPermissionRevocations != null
                && !(instanceInboundPermissionRevocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of ports to remove from the container fleet's inbound permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceInboundPermissionRevocations}
     * method.
     * </p>
     * 
     * @return A set of ports to remove from the container fleet's inbound permissions.
     */
    public final List<IpPermission> instanceInboundPermissionRevocations() {
        return instanceInboundPermissionRevocations;
    }

    /**
     * <p>
     * Instructions for how to deploy updates to a container fleet, if the fleet update initiates a deployment. The
     * deployment configuration lets you determine how to replace fleet instances and what actions to take if the
     * deployment fails.
     * </p>
     * 
     * @return Instructions for how to deploy updates to a container fleet, if the fleet update initiates a deployment.
     *         The deployment configuration lets you determine how to replace fleet instances and what actions to take
     *         if the deployment fails.
     */
    public final DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * <p>
     * A meaningful description of the container fleet.
     * </p>
     * 
     * @return A meaningful description of the container fleet.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricGroups() {
        return metricGroups != null && !(metricGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricGroups} method.
     * </p>
     * 
     * @return The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
     */
    public final List<String> metricGroups() {
        return metricGroups;
    }

    /**
     * <p>
     * The game session protection policy to apply to all new game sessions that are started in this fleet. Game
     * sessions that already exist are not affected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return The game session protection policy to apply to all new game sessions that are started in this fleet. Game
     *         sessions that already exist are not affected.
     * @see ProtectionPolicy
     */
    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(newGameSessionProtectionPolicy);
    }

    /**
     * <p>
     * The game session protection policy to apply to all new game sessions that are started in this fleet. Game
     * sessions that already exist are not affected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return The game session protection policy to apply to all new game sessions that are started in this fleet. Game
     *         sessions that already exist are not affected.
     * @see ProtectionPolicy
     */
    public final String newGameSessionProtectionPolicyAsString() {
        return newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * A policy that limits the number of game sessions that each individual player can create on instances in this
     * fleet. The limit applies for a specified span of time.
     * </p>
     * 
     * @return A policy that limits the number of game sessions that each individual player can create on instances in
     *         this fleet. The limit applies for a specified span of time.
     */
    public final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy() {
        return gameSessionCreationLimitPolicy;
    }

    /**
     * <p>
     * The method for collecting container logs for the fleet.
     * </p>
     * 
     * @return The method for collecting container logs for the fleet.
     */
    public final LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's game
     * server container group definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveAttributes} method.
     * </p>
     * 
     * @return If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's
     *         game server container group definition.
     */
    public final List<ContainerFleetRemoveAttribute> removeAttributes() {
        return ContainerFleetRemoveAttributeListCopier.copyStringToEnum(removeAttributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveAttributes() {
        return removeAttributes != null && !(removeAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's game
     * server container group definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveAttributes} method.
     * </p>
     * 
     * @return If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's
     *         game server container group definition.
     */
    public final List<String> removeAttributesAsStrings() {
        return removeAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(perInstanceContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerContainerGroupsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(instanceConnectionPortRange());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasInstanceInboundPermissionAuthorizations() ? instanceInboundPermissionAuthorizations()
                        : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasInstanceInboundPermissionRevocations() ? instanceInboundPermissionRevocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricGroups() ? metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveAttributes() ? removeAttributesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerFleetRequest)) {
            return false;
        }
        UpdateContainerFleetRequest other = (UpdateContainerFleetRequest) obj;
        return Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(gameServerContainerGroupDefinitionName(), other.gameServerContainerGroupDefinitionName())
                && Objects.equals(perInstanceContainerGroupDefinitionName(), other.perInstanceContainerGroupDefinitionName())
                && Objects.equals(gameServerContainerGroupsPerInstance(), other.gameServerContainerGroupsPerInstance())
                && Objects.equals(instanceConnectionPortRange(), other.instanceConnectionPortRange())
                && hasInstanceInboundPermissionAuthorizations() == other.hasInstanceInboundPermissionAuthorizations()
                && Objects.equals(instanceInboundPermissionAuthorizations(), other.instanceInboundPermissionAuthorizations())
                && hasInstanceInboundPermissionRevocations() == other.hasInstanceInboundPermissionRevocations()
                && Objects.equals(instanceInboundPermissionRevocations(), other.instanceInboundPermissionRevocations())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(description(), other.description()) && hasMetricGroups() == other.hasMetricGroups()
                && Objects.equals(metricGroups(), other.metricGroups())
                && Objects.equals(newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString())
                && Objects.equals(gameSessionCreationLimitPolicy(), other.gameSessionCreationLimitPolicy())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && hasRemoveAttributes() == other.hasRemoveAttributes()
                && Objects.equals(removeAttributesAsStrings(), other.removeAttributesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateContainerFleetRequest")
                .add("FleetId", fleetId())
                .add("GameServerContainerGroupDefinitionName", gameServerContainerGroupDefinitionName())
                .add("PerInstanceContainerGroupDefinitionName", perInstanceContainerGroupDefinitionName())
                .add("GameServerContainerGroupsPerInstance", gameServerContainerGroupsPerInstance())
                .add("InstanceConnectionPortRange", instanceConnectionPortRange())
                .add("InstanceInboundPermissionAuthorizations",
                        hasInstanceInboundPermissionAuthorizations() ? instanceInboundPermissionAuthorizations() : null)
                .add("InstanceInboundPermissionRevocations",
                        hasInstanceInboundPermissionRevocations() ? instanceInboundPermissionRevocations() : null)
                .add("DeploymentConfiguration", deploymentConfiguration()).add("Description", description())
                .add("MetricGroups", hasMetricGroups() ? metricGroups() : null)
                .add("NewGameSessionProtectionPolicy", newGameSessionProtectionPolicyAsString())
                .add("GameSessionCreationLimitPolicy", gameSessionCreationLimitPolicy())
                .add("LogConfiguration", logConfiguration())
                .add("RemoveAttributes", hasRemoveAttributes() ? removeAttributesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "GameServerContainerGroupDefinitionName":
            return Optional.ofNullable(clazz.cast(gameServerContainerGroupDefinitionName()));
        case "PerInstanceContainerGroupDefinitionName":
            return Optional.ofNullable(clazz.cast(perInstanceContainerGroupDefinitionName()));
        case "GameServerContainerGroupsPerInstance":
            return Optional.ofNullable(clazz.cast(gameServerContainerGroupsPerInstance()));
        case "InstanceConnectionPortRange":
            return Optional.ofNullable(clazz.cast(instanceConnectionPortRange()));
        case "InstanceInboundPermissionAuthorizations":
            return Optional.ofNullable(clazz.cast(instanceInboundPermissionAuthorizations()));
        case "InstanceInboundPermissionRevocations":
            return Optional.ofNullable(clazz.cast(instanceInboundPermissionRevocations()));
        case "DeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MetricGroups":
            return Optional.ofNullable(clazz.cast(metricGroups()));
        case "NewGameSessionProtectionPolicy":
            return Optional.ofNullable(clazz.cast(newGameSessionProtectionPolicyAsString()));
        case "GameSessionCreationLimitPolicy":
            return Optional.ofNullable(clazz.cast(gameSessionCreationLimitPolicy()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "RemoveAttributes":
            return Optional.ofNullable(clazz.cast(removeAttributesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("GameServerContainerGroupDefinitionName", GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("PerInstanceContainerGroupDefinitionName", PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("GameServerContainerGroupsPerInstance", GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD);
        map.put("InstanceConnectionPortRange", INSTANCE_CONNECTION_PORT_RANGE_FIELD);
        map.put("InstanceInboundPermissionAuthorizations", INSTANCE_INBOUND_PERMISSION_AUTHORIZATIONS_FIELD);
        map.put("InstanceInboundPermissionRevocations", INSTANCE_INBOUND_PERMISSION_REVOCATIONS_FIELD);
        map.put("DeploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MetricGroups", METRIC_GROUPS_FIELD);
        map.put("NewGameSessionProtectionPolicy", NEW_GAME_SESSION_PROTECTION_POLICY_FIELD);
        map.put("GameSessionCreationLimitPolicy", GAME_SESSION_CREATION_LIMIT_POLICY_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("RemoveAttributes", REMOVE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerFleetRequest, T> g) {
        return obj -> g.apply((UpdateContainerFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContainerFleetRequest> {
        /**
         * <p>
         * A unique identifier for the container fleet to update. You can use either the fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the container fleet to update. You can use either the fleet ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The name or ARN value of a new game server container group definition to deploy on the fleet. If you're
         * updating the fleet to a specific version of a container group definition, use the ARN value and include the
         * version number. If you're updating the fleet to the latest version of a container group definition, you can
         * use the name value. You can't remove a fleet's game server container group definition, you can only update or
         * replace it with another definition.
         * </p>
         * <p>
         * Update a container group definition by calling <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
         * >UpdateContainerGroupDefinition</a>. This operation creates a <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         * >ContainerGroupDefinition</a> resource with an incremented version.
         * </p>
         * 
         * @param gameServerContainerGroupDefinitionName
         *        The name or ARN value of a new game server container group definition to deploy on the fleet. If
         *        you're updating the fleet to a specific version of a container group definition, use the ARN value and
         *        include the version number. If you're updating the fleet to the latest version of a container group
         *        definition, you can use the name value. You can't remove a fleet's game server container group
         *        definition, you can only update or replace it with another definition.</p>
         *        <p>
         *        Update a container group definition by calling <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
         *        >UpdateContainerGroupDefinition</a>. This operation creates a <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         *        >ContainerGroupDefinition</a> resource with an incremented version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName);

        /**
         * <p>
         * The name or ARN value of a new per-instance container group definition to deploy on the fleet. If you're
         * updating the fleet to a specific version of a container group definition, use the ARN value and include the
         * version number. If you're updating the fleet to the latest version of a container group definition, you can
         * use the name value.
         * </p>
         * <p>
         * Update a container group definition by calling <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
         * >UpdateContainerGroupDefinition</a>. This operation creates a <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         * >ContainerGroupDefinition</a> resource with an incremented version.
         * </p>
         * <p>
         * To remove a fleet's per-instance container group definition, leave this parameter empty and use the parameter
         * <code>RemoveAttributes</code>.
         * </p>
         * 
         * @param perInstanceContainerGroupDefinitionName
         *        The name or ARN value of a new per-instance container group definition to deploy on the fleet. If
         *        you're updating the fleet to a specific version of a container group definition, use the ARN value and
         *        include the version number. If you're updating the fleet to the latest version of a container group
         *        definition, you can use the name value.</p>
         *        <p>
         *        Update a container group definition by calling <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html"
         *        >UpdateContainerGroupDefinition</a>. This operation creates a <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         *        >ContainerGroupDefinition</a> resource with an incremented version.
         *        </p>
         *        <p>
         *        To remove a fleet's per-instance container group definition, leave this parameter empty and use the
         *        parameter <code>RemoveAttributes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName);

        /**
         * <p>
         * The number of times to replicate the game server container group on each fleet instance. By default, Amazon
         * GameLift calculates the maximum number of game server container groups that can fit on each instance. You can
         * remove this property value to use the calculated value, or set it manually. If you set this number manually,
         * Amazon GameLift uses your value as long as it's less than the calculated maximum.
         * </p>
         * 
         * @param gameServerContainerGroupsPerInstance
         *        The number of times to replicate the game server container group on each fleet instance. By default,
         *        Amazon GameLift calculates the maximum number of game server container groups that can fit on each
         *        instance. You can remove this property value to use the calculated value, or set it manually. If you
         *        set this number manually, Amazon GameLift uses your value as long as it's less than the calculated
         *        maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance);

        /**
         * <p>
         * A revised set of port numbers to open on each fleet instance. By default, Amazon GameLift calculates an
         * optimal port range based on your fleet configuration. If you previously set this parameter manually, you
         * can't reset this to use the calculated settings.
         * </p>
         * 
         * @param instanceConnectionPortRange
         *        A revised set of port numbers to open on each fleet instance. By default, Amazon GameLift calculates
         *        an optimal port range based on your fleet configuration. If you previously set this parameter
         *        manually, you can't reset this to use the calculated settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConnectionPortRange(ConnectionPortRange instanceConnectionPortRange);

        /**
         * <p>
         * A revised set of port numbers to open on each fleet instance. By default, Amazon GameLift calculates an
         * optimal port range based on your fleet configuration. If you previously set this parameter manually, you
         * can't reset this to use the calculated settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPortRange.Builder} avoiding the
         * need to create one manually via {@link ConnectionPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConnectionPortRange(ConnectionPortRange)}.
         * 
         * @param instanceConnectionPortRange
         *        a consumer that will call methods on {@link ConnectionPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConnectionPortRange(ConnectionPortRange)
         */
        default Builder instanceConnectionPortRange(Consumer<ConnectionPortRange.Builder> instanceConnectionPortRange) {
            return instanceConnectionPortRange(ConnectionPortRange.builder().applyMutation(instanceConnectionPortRange).build());
        }

        /**
         * <p>
         * A set of ports to add to the container fleet's inbound permissions.
         * </p>
         * 
         * @param instanceInboundPermissionAuthorizations
         *        A set of ports to add to the container fleet's inbound permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInboundPermissionAuthorizations(Collection<IpPermission> instanceInboundPermissionAuthorizations);

        /**
         * <p>
         * A set of ports to add to the container fleet's inbound permissions.
         * </p>
         * 
         * @param instanceInboundPermissionAuthorizations
         *        A set of ports to add to the container fleet's inbound permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInboundPermissionAuthorizations(IpPermission... instanceInboundPermissionAuthorizations);

        /**
         * <p>
         * A set of ports to add to the container fleet's inbound permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceInboundPermissionAuthorizations(List<IpPermission>)}.
         * 
         * @param instanceInboundPermissionAuthorizations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInboundPermissionAuthorizations(java.util.Collection<IpPermission>)
         */
        Builder instanceInboundPermissionAuthorizations(Consumer<IpPermission.Builder>... instanceInboundPermissionAuthorizations);

        /**
         * <p>
         * A set of ports to remove from the container fleet's inbound permissions.
         * </p>
         * 
         * @param instanceInboundPermissionRevocations
         *        A set of ports to remove from the container fleet's inbound permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInboundPermissionRevocations(Collection<IpPermission> instanceInboundPermissionRevocations);

        /**
         * <p>
         * A set of ports to remove from the container fleet's inbound permissions.
         * </p>
         * 
         * @param instanceInboundPermissionRevocations
         *        A set of ports to remove from the container fleet's inbound permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInboundPermissionRevocations(IpPermission... instanceInboundPermissionRevocations);

        /**
         * <p>
         * A set of ports to remove from the container fleet's inbound permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceInboundPermissionRevocations(List<IpPermission>)}.
         * 
         * @param instanceInboundPermissionRevocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInboundPermissionRevocations(java.util.Collection<IpPermission>)
         */
        Builder instanceInboundPermissionRevocations(Consumer<IpPermission.Builder>... instanceInboundPermissionRevocations);

        /**
         * <p>
         * Instructions for how to deploy updates to a container fleet, if the fleet update initiates a deployment. The
         * deployment configuration lets you determine how to replace fleet instances and what actions to take if the
         * deployment fails.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Instructions for how to deploy updates to a container fleet, if the fleet update initiates a
         *        deployment. The deployment configuration lets you determine how to replace fleet instances and what
         *        actions to take if the deployment fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Instructions for how to deploy updates to a container fleet, if the fleet update initiates a deployment. The
         * deployment configuration lets you determine how to replace fleet instances and what actions to take if the
         * deployment fails.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * A meaningful description of the container fleet.
         * </p>
         * 
         * @param description
         *        A meaningful description of the container fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(Collection<String> metricGroups);

        /**
         * <p>
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(String... metricGroups);

        /**
         * <p>
         * The game session protection policy to apply to all new game sessions that are started in this fleet. Game
         * sessions that already exist are not affected.
         * </p>
         * 
         * @param newGameSessionProtectionPolicy
         *        The game session protection policy to apply to all new game sessions that are started in this fleet.
         *        Game sessions that already exist are not affected.
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy);

        /**
         * <p>
         * The game session protection policy to apply to all new game sessions that are started in this fleet. Game
         * sessions that already exist are not affected.
         * </p>
         * 
         * @param newGameSessionProtectionPolicy
         *        The game session protection policy to apply to all new game sessions that are started in this fleet.
         *        Game sessions that already exist are not affected.
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy);

        /**
         * <p>
         * A policy that limits the number of game sessions that each individual player can create on instances in this
         * fleet. The limit applies for a specified span of time.
         * </p>
         * 
         * @param gameSessionCreationLimitPolicy
         *        A policy that limits the number of game sessions that each individual player can create on instances
         *        in this fleet. The limit applies for a specified span of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy);

        /**
         * <p>
         * A policy that limits the number of game sessions that each individual player can create on instances in this
         * fleet. The limit applies for a specified span of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link GameSessionCreationLimitPolicy.Builder}
         * avoiding the need to create one manually via {@link GameSessionCreationLimitPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameSessionCreationLimitPolicy.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy)}.
         * 
         * @param gameSessionCreationLimitPolicy
         *        a consumer that will call methods on {@link GameSessionCreationLimitPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy)
         */
        default Builder gameSessionCreationLimitPolicy(
                Consumer<GameSessionCreationLimitPolicy.Builder> gameSessionCreationLimitPolicy) {
            return gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy.builder()
                    .applyMutation(gameSessionCreationLimitPolicy).build());
        }

        /**
         * <p>
         * The method for collecting container logs for the fleet.
         * </p>
         * 
         * @param logConfiguration
         *        The method for collecting container logs for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The method for collecting container logs for the fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's
         * game server container group definition.
         * </p>
         * 
         * @param removeAttributes
         *        If set, this update removes a fleet's per-instance container group definition. You can't remove a
         *        fleet's game server container group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAttributesWithStrings(Collection<String> removeAttributes);

        /**
         * <p>
         * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's
         * game server container group definition.
         * </p>
         * 
         * @param removeAttributes
         *        If set, this update removes a fleet's per-instance container group definition. You can't remove a
         *        fleet's game server container group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAttributesWithStrings(String... removeAttributes);

        /**
         * <p>
         * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's
         * game server container group definition.
         * </p>
         * 
         * @param removeAttributes
         *        If set, this update removes a fleet's per-instance container group definition. You can't remove a
         *        fleet's game server container group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAttributes(Collection<ContainerFleetRemoveAttribute> removeAttributes);

        /**
         * <p>
         * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's
         * game server container group definition.
         * </p>
         * 
         * @param removeAttributes
         *        If set, this update removes a fleet's per-instance container group definition. You can't remove a
         *        fleet's game server container group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAttributes(ContainerFleetRemoveAttribute... removeAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String gameServerContainerGroupDefinitionName;

        private String perInstanceContainerGroupDefinitionName;

        private Integer gameServerContainerGroupsPerInstance;

        private ConnectionPortRange instanceConnectionPortRange;

        private List<IpPermission> instanceInboundPermissionAuthorizations = DefaultSdkAutoConstructList.getInstance();

        private List<IpPermission> instanceInboundPermissionRevocations = DefaultSdkAutoConstructList.getInstance();

        private DeploymentConfiguration deploymentConfiguration;

        private String description;

        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();

        private String newGameSessionProtectionPolicy;

        private GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;

        private LogConfiguration logConfiguration;

        private List<String> removeAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerFleetRequest model) {
            super(model);
            fleetId(model.fleetId);
            gameServerContainerGroupDefinitionName(model.gameServerContainerGroupDefinitionName);
            perInstanceContainerGroupDefinitionName(model.perInstanceContainerGroupDefinitionName);
            gameServerContainerGroupsPerInstance(model.gameServerContainerGroupsPerInstance);
            instanceConnectionPortRange(model.instanceConnectionPortRange);
            instanceInboundPermissionAuthorizations(model.instanceInboundPermissionAuthorizations);
            instanceInboundPermissionRevocations(model.instanceInboundPermissionRevocations);
            deploymentConfiguration(model.deploymentConfiguration);
            description(model.description);
            metricGroups(model.metricGroups);
            newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            gameSessionCreationLimitPolicy(model.gameSessionCreationLimitPolicy);
            logConfiguration(model.logConfiguration);
            removeAttributesWithStrings(model.removeAttributes);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getGameServerContainerGroupDefinitionName() {
            return gameServerContainerGroupDefinitionName;
        }

        public final void setGameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
        }

        @Override
        public final Builder gameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
            return this;
        }

        public final String getPerInstanceContainerGroupDefinitionName() {
            return perInstanceContainerGroupDefinitionName;
        }

        public final void setPerInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
        }

        @Override
        public final Builder perInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
            return this;
        }

        public final Integer getGameServerContainerGroupsPerInstance() {
            return gameServerContainerGroupsPerInstance;
        }

        public final void setGameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
        }

        @Override
        public final Builder gameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
            return this;
        }

        public final ConnectionPortRange.Builder getInstanceConnectionPortRange() {
            return instanceConnectionPortRange != null ? instanceConnectionPortRange.toBuilder() : null;
        }

        public final void setInstanceConnectionPortRange(ConnectionPortRange.BuilderImpl instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange != null ? instanceConnectionPortRange.build() : null;
        }

        @Override
        public final Builder instanceConnectionPortRange(ConnectionPortRange instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange;
            return this;
        }

        public final List<IpPermission.Builder> getInstanceInboundPermissionAuthorizations() {
            List<IpPermission.Builder> result = IpPermissionsListCopier
                    .copyToBuilder(this.instanceInboundPermissionAuthorizations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInboundPermissionAuthorizations(
                Collection<IpPermission.BuilderImpl> instanceInboundPermissionAuthorizations) {
            this.instanceInboundPermissionAuthorizations = IpPermissionsListCopier
                    .copyFromBuilder(instanceInboundPermissionAuthorizations);
        }

        @Override
        public final Builder instanceInboundPermissionAuthorizations(
                Collection<IpPermission> instanceInboundPermissionAuthorizations) {
            this.instanceInboundPermissionAuthorizations = IpPermissionsListCopier.copy(instanceInboundPermissionAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionAuthorizations(IpPermission... instanceInboundPermissionAuthorizations) {
            instanceInboundPermissionAuthorizations(Arrays.asList(instanceInboundPermissionAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionAuthorizations(
                Consumer<IpPermission.Builder>... instanceInboundPermissionAuthorizations) {
            instanceInboundPermissionAuthorizations(Stream.of(instanceInboundPermissionAuthorizations)
                    .map(c -> IpPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IpPermission.Builder> getInstanceInboundPermissionRevocations() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.instanceInboundPermissionRevocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInboundPermissionRevocations(
                Collection<IpPermission.BuilderImpl> instanceInboundPermissionRevocations) {
            this.instanceInboundPermissionRevocations = IpPermissionsListCopier
                    .copyFromBuilder(instanceInboundPermissionRevocations);
        }

        @Override
        public final Builder instanceInboundPermissionRevocations(Collection<IpPermission> instanceInboundPermissionRevocations) {
            this.instanceInboundPermissionRevocations = IpPermissionsListCopier.copy(instanceInboundPermissionRevocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionRevocations(IpPermission... instanceInboundPermissionRevocations) {
            instanceInboundPermissionRevocations(Arrays.asList(instanceInboundPermissionRevocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionRevocations(
                Consumer<IpPermission.Builder>... instanceInboundPermissionRevocations) {
            instanceInboundPermissionRevocations(Stream.of(instanceInboundPermissionRevocations)
                    .map(c -> IpPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String... metricGroups) {
            metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy
                    .toString());
            return this;
        }

        public final GameSessionCreationLimitPolicy.Builder getGameSessionCreationLimitPolicy() {
            return gameSessionCreationLimitPolicy != null ? gameSessionCreationLimitPolicy.toBuilder() : null;
        }

        public final void setGameSessionCreationLimitPolicy(
                GameSessionCreationLimitPolicy.BuilderImpl gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy != null ? gameSessionCreationLimitPolicy.build()
                    : null;
        }

        @Override
        public final Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final Collection<String> getRemoveAttributes() {
            if (removeAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return removeAttributes;
        }

        public final void setRemoveAttributes(Collection<String> removeAttributes) {
            this.removeAttributes = ContainerFleetRemoveAttributeListCopier.copy(removeAttributes);
        }

        @Override
        public final Builder removeAttributesWithStrings(Collection<String> removeAttributes) {
            this.removeAttributes = ContainerFleetRemoveAttributeListCopier.copy(removeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAttributesWithStrings(String... removeAttributes) {
            removeAttributesWithStrings(Arrays.asList(removeAttributes));
            return this;
        }

        @Override
        public final Builder removeAttributes(Collection<ContainerFleetRemoveAttribute> removeAttributes) {
            this.removeAttributes = ContainerFleetRemoveAttributeListCopier.copyEnumToString(removeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAttributes(ContainerFleetRemoveAttribute... removeAttributes) {
            removeAttributes(Arrays.asList(removeAttributes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContainerFleetRequest build() {
            return new UpdateContainerFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
