/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGameServerRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateGameServerRequest.Builder, UpdateGameServerRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(UpdateGameServerRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerId").getter(getter(UpdateGameServerRequest::gameServerId))
            .setter(setter(Builder::gameServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()).build();

    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerData").getter(getter(UpdateGameServerRequest::gameServerData))
            .setter(setter(Builder::gameServerData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()).build();

    private static final SdkField<String> UTILIZATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UtilizationStatus").getter(getter(UpdateGameServerRequest::utilizationStatusAsString))
            .setter(setter(Builder::utilizationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationStatus").build()).build();

    private static final SdkField<String> HEALTH_CHECK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheck").getter(getter(UpdateGameServerRequest::healthCheckAsString))
            .setter(setter(Builder::healthCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            GAME_SERVER_ID_FIELD, GAME_SERVER_DATA_FIELD, UTILIZATION_STATUS_FIELD, HEALTH_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gameServerGroupName;

    private final String gameServerId;

    private final String gameServerData;

    private final String utilizationStatus;

    private final String healthCheck;

    private UpdateGameServerRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerId = builder.gameServerId;
        this.gameServerData = builder.gameServerData;
        this.utilizationStatus = builder.utilizationStatus;
        this.healthCheck = builder.healthCheck;
    }

    /**
     * <p>
     * A unique identifier for the game server group where the game server is running.
     * </p>
     * 
     * @return A unique identifier for the game server group where the game server is running.
     */
    public final String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * A custom string that uniquely identifies the game server to update.
     * </p>
     * 
     * @return A custom string that uniquely identifies the game server to update.
     */
    public final String gameServerId() {
        return gameServerId;
    }

    /**
     * <p>
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client
     * or service when it requests information on game servers.
     * </p>
     * 
     * @return A set of custom game server properties, formatted as a single string value. This data is passed to a game
     *         client or service when it requests information on game servers.
     */
    public final String gameServerData() {
        return gameServerData;
    }

    /**
     * <p>
     * Indicates if the game server is available or is currently hosting gameplay. You can update a game server status
     * from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status from
     * <code>UTILIZED</code> to <code>AVAILABLE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #utilizationStatus}
     * will return {@link GameServerUtilizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #utilizationStatusAsString}.
     * </p>
     * 
     * @return Indicates if the game server is available or is currently hosting gameplay. You can update a game server
     *         status from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status from
     *         <code>UTILIZED</code> to <code>AVAILABLE</code>.
     * @see GameServerUtilizationStatus
     */
    public final GameServerUtilizationStatus utilizationStatus() {
        return GameServerUtilizationStatus.fromValue(utilizationStatus);
    }

    /**
     * <p>
     * Indicates if the game server is available or is currently hosting gameplay. You can update a game server status
     * from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status from
     * <code>UTILIZED</code> to <code>AVAILABLE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #utilizationStatus}
     * will return {@link GameServerUtilizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #utilizationStatusAsString}.
     * </p>
     * 
     * @return Indicates if the game server is available or is currently hosting gameplay. You can update a game server
     *         status from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status from
     *         <code>UTILIZED</code> to <code>AVAILABLE</code>.
     * @see GameServerUtilizationStatus
     */
    public final String utilizationStatusAsString() {
        return utilizationStatus;
    }

    /**
     * <p>
     * Indicates health status of the game server. A request that includes this parameter updates the game server's
     * <i>LastHealthCheckTime</i> timestamp.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthCheck} will
     * return {@link GameServerHealthCheck#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #healthCheckAsString}.
     * </p>
     * 
     * @return Indicates health status of the game server. A request that includes this parameter updates the game
     *         server's <i>LastHealthCheckTime</i> timestamp.
     * @see GameServerHealthCheck
     */
    public final GameServerHealthCheck healthCheck() {
        return GameServerHealthCheck.fromValue(healthCheck);
    }

    /**
     * <p>
     * Indicates health status of the game server. A request that includes this parameter updates the game server's
     * <i>LastHealthCheckTime</i> timestamp.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthCheck} will
     * return {@link GameServerHealthCheck#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #healthCheckAsString}.
     * </p>
     * 
     * @return Indicates health status of the game server. A request that includes this parameter updates the game
     *         server's <i>LastHealthCheckTime</i> timestamp.
     * @see GameServerHealthCheck
     */
    public final String healthCheckAsString() {
        return healthCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerData());
        hashCode = 31 * hashCode + Objects.hashCode(utilizationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameServerRequest)) {
            return false;
        }
        UpdateGameServerRequest other = (UpdateGameServerRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName())
                && Objects.equals(gameServerId(), other.gameServerId())
                && Objects.equals(gameServerData(), other.gameServerData())
                && Objects.equals(utilizationStatusAsString(), other.utilizationStatusAsString())
                && Objects.equals(healthCheckAsString(), other.healthCheckAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGameServerRequest").add("GameServerGroupName", gameServerGroupName())
                .add("GameServerId", gameServerId()).add("GameServerData", gameServerData())
                .add("UtilizationStatus", utilizationStatusAsString()).add("HealthCheck", healthCheckAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "GameServerId":
            return Optional.ofNullable(clazz.cast(gameServerId()));
        case "GameServerData":
            return Optional.ofNullable(clazz.cast(gameServerData()));
        case "UtilizationStatus":
            return Optional.ofNullable(clazz.cast(utilizationStatusAsString()));
        case "HealthCheck":
            return Optional.ofNullable(clazz.cast(healthCheckAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
        map.put("GameServerId", GAME_SERVER_ID_FIELD);
        map.put("GameServerData", GAME_SERVER_DATA_FIELD);
        map.put("UtilizationStatus", UTILIZATION_STATUS_FIELD);
        map.put("HealthCheck", HEALTH_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameServerRequest, T> g) {
        return obj -> g.apply((UpdateGameServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGameServerRequest> {
        /**
         * <p>
         * A unique identifier for the game server group where the game server is running.
         * </p>
         * 
         * @param gameServerGroupName
         *        A unique identifier for the game server group where the game server is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * A custom string that uniquely identifies the game server to update.
         * </p>
         * 
         * @param gameServerId
         *        A custom string that uniquely identifies the game server to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerId(String gameServerId);

        /**
         * <p>
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game
         * client or service when it requests information on game servers.
         * </p>
         * 
         * @param gameServerData
         *        A set of custom game server properties, formatted as a single string value. This data is passed to a
         *        game client or service when it requests information on game servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerData(String gameServerData);

        /**
         * <p>
         * Indicates if the game server is available or is currently hosting gameplay. You can update a game server
         * status from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status from
         * <code>UTILIZED</code> to <code>AVAILABLE</code>.
         * </p>
         * 
         * @param utilizationStatus
         *        Indicates if the game server is available or is currently hosting gameplay. You can update a game
         *        server status from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status
         *        from <code>UTILIZED</code> to <code>AVAILABLE</code>.
         * @see GameServerUtilizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerUtilizationStatus
         */
        Builder utilizationStatus(String utilizationStatus);

        /**
         * <p>
         * Indicates if the game server is available or is currently hosting gameplay. You can update a game server
         * status from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status from
         * <code>UTILIZED</code> to <code>AVAILABLE</code>.
         * </p>
         * 
         * @param utilizationStatus
         *        Indicates if the game server is available or is currently hosting gameplay. You can update a game
         *        server status from <code>AVAILABLE</code> to <code>UTILIZED</code>, but you can't change a the status
         *        from <code>UTILIZED</code> to <code>AVAILABLE</code>.
         * @see GameServerUtilizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerUtilizationStatus
         */
        Builder utilizationStatus(GameServerUtilizationStatus utilizationStatus);

        /**
         * <p>
         * Indicates health status of the game server. A request that includes this parameter updates the game server's
         * <i>LastHealthCheckTime</i> timestamp.
         * </p>
         * 
         * @param healthCheck
         *        Indicates health status of the game server. A request that includes this parameter updates the game
         *        server's <i>LastHealthCheckTime</i> timestamp.
         * @see GameServerHealthCheck
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerHealthCheck
         */
        Builder healthCheck(String healthCheck);

        /**
         * <p>
         * Indicates health status of the game server. A request that includes this parameter updates the game server's
         * <i>LastHealthCheckTime</i> timestamp.
         * </p>
         * 
         * @param healthCheck
         *        Indicates health status of the game server. A request that includes this parameter updates the game
         *        server's <i>LastHealthCheckTime</i> timestamp.
         * @see GameServerHealthCheck
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GameServerHealthCheck
         */
        Builder healthCheck(GameServerHealthCheck healthCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String gameServerId;

        private String gameServerData;

        private String utilizationStatus;

        private String healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameServerRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            gameServerId(model.gameServerId);
            gameServerData(model.gameServerData);
            utilizationStatus(model.utilizationStatus);
            healthCheck(model.healthCheck);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getGameServerId() {
            return gameServerId;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final String getGameServerData() {
            return gameServerData;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        public final String getUtilizationStatus() {
            return utilizationStatus;
        }

        public final void setUtilizationStatus(String utilizationStatus) {
            this.utilizationStatus = utilizationStatus;
        }

        @Override
        public final Builder utilizationStatus(String utilizationStatus) {
            this.utilizationStatus = utilizationStatus;
            return this;
        }

        @Override
        public final Builder utilizationStatus(GameServerUtilizationStatus utilizationStatus) {
            this.utilizationStatus(utilizationStatus == null ? null : utilizationStatus.toString());
            return this;
        }

        public final String getHealthCheck() {
            return healthCheck;
        }

        public final void setHealthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
        }

        @Override
        public final Builder healthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        @Override
        public final Builder healthCheck(GameServerHealthCheck healthCheck) {
            this.healthCheck(healthCheck == null ? null : healthCheck.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameServerRequest build() {
            return new UpdateGameServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
