/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupType;
import software.amazon.awssdk.services.gamelift.model.ContainerOperatingSystem;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameServerContainerDefinitionInput;
import software.amazon.awssdk.services.gamelift.model.SupportContainerDefinitionInput;
import software.amazon.awssdk.services.gamelift.model.SupportContainerDefinitionInputListCopier;
import software.amazon.awssdk.services.gamelift.model.Tag;
import software.amazon.awssdk.services.gamelift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContainerGroupDefinitionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateContainerGroupDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::name)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONTAINER_GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerGroupType").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::containerGroupTypeAsString)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::containerGroupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupType").build()}).build();
    private static final SdkField<Integer> TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalMemoryLimitMebibytes").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::totalMemoryLimitMebibytes)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::totalMemoryLimitMebibytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMemoryLimitMebibytes").build()}).build();
    private static final SdkField<Double> TOTAL_VCPU_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalVcpuLimit").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::totalVcpuLimit)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::totalVcpuLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalVcpuLimit").build()}).build();
    private static final SdkField<GameServerContainerDefinitionInput> GAME_SERVER_CONTAINER_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GameServerContainerDefinition").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::gameServerContainerDefinition)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::gameServerContainerDefinition)).constructor(GameServerContainerDefinitionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerDefinition").build()}).build();
    private static final SdkField<List<SupportContainerDefinitionInput>> SUPPORT_CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportContainerDefinitions").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::supportContainerDefinitions)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::supportContainerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportContainerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportContainerDefinitionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::operatingSystemAsString)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::versionDescription)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::tags)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTAINER_GROUP_TYPE_FIELD, TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD, TOTAL_VCPU_LIMIT_FIELD, GAME_SERVER_CONTAINER_DEFINITION_FIELD, SUPPORT_CONTAINER_DEFINITIONS_FIELD, OPERATING_SYSTEM_FIELD, VERSION_DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateContainerGroupDefinitionRequest.memberNameToFieldInitializer();
    private final String name;
    private final String containerGroupType;
    private final Integer totalMemoryLimitMebibytes;
    private final Double totalVcpuLimit;
    private final GameServerContainerDefinitionInput gameServerContainerDefinition;
    private final List<SupportContainerDefinitionInput> supportContainerDefinitions;
    private final String operatingSystem;
    private final String versionDescription;
    private final List<Tag> tags;

    private CreateContainerGroupDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.containerGroupType = builder.containerGroupType;
        this.totalMemoryLimitMebibytes = builder.totalMemoryLimitMebibytes;
        this.totalVcpuLimit = builder.totalVcpuLimit;
        this.gameServerContainerDefinition = builder.gameServerContainerDefinition;
        this.supportContainerDefinitions = builder.supportContainerDefinitions;
        this.operatingSystem = builder.operatingSystem;
        this.versionDescription = builder.versionDescription;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final ContainerGroupType containerGroupType() {
        return ContainerGroupType.fromValue(this.containerGroupType);
    }

    public final String containerGroupTypeAsString() {
        return this.containerGroupType;
    }

    public final Integer totalMemoryLimitMebibytes() {
        return this.totalMemoryLimitMebibytes;
    }

    public final Double totalVcpuLimit() {
        return this.totalVcpuLimit;
    }

    public final GameServerContainerDefinitionInput gameServerContainerDefinition() {
        return this.gameServerContainerDefinition;
    }

    public final boolean hasSupportContainerDefinitions() {
        return this.supportContainerDefinitions != null && !(this.supportContainerDefinitions instanceof SdkAutoConstructList);
    }

    public final List<SupportContainerDefinitionInput> supportContainerDefinitions() {
        return this.supportContainerDefinitions;
    }

    public final ContainerOperatingSystem operatingSystem() {
        return ContainerOperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerGroupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalMemoryLimitMebibytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalVcpuLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportContainerDefinitions() ? this.supportContainerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerGroupDefinitionRequest)) {
            return false;
        }
        CreateContainerGroupDefinitionRequest other = (CreateContainerGroupDefinitionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.containerGroupTypeAsString(), other.containerGroupTypeAsString()) && Objects.equals(this.totalMemoryLimitMebibytes(), other.totalMemoryLimitMebibytes()) && Objects.equals(this.totalVcpuLimit(), other.totalVcpuLimit()) && Objects.equals(this.gameServerContainerDefinition(), other.gameServerContainerDefinition()) && this.hasSupportContainerDefinitions() == other.hasSupportContainerDefinitions() && Objects.equals(this.supportContainerDefinitions(), other.supportContainerDefinitions()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.versionDescription(), other.versionDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContainerGroupDefinitionRequest").add("Name", (Object)this.name()).add("ContainerGroupType", (Object)this.containerGroupTypeAsString()).add("TotalMemoryLimitMebibytes", (Object)this.totalMemoryLimitMebibytes()).add("TotalVcpuLimit", (Object)this.totalVcpuLimit()).add("GameServerContainerDefinition", (Object)this.gameServerContainerDefinition()).add("SupportContainerDefinitions", this.hasSupportContainerDefinitions() ? this.supportContainerDefinitions() : null).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("VersionDescription", (Object)this.versionDescription()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ContainerGroupType": {
                return Optional.ofNullable(clazz.cast(this.containerGroupTypeAsString()));
            }
            case "TotalMemoryLimitMebibytes": {
                return Optional.ofNullable(clazz.cast(this.totalMemoryLimitMebibytes()));
            }
            case "TotalVcpuLimit": {
                return Optional.ofNullable(clazz.cast(this.totalVcpuLimit()));
            }
            case "GameServerContainerDefinition": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerDefinition()));
            }
            case "SupportContainerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.supportContainerDefinitions()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ContainerGroupType", CONTAINER_GROUP_TYPE_FIELD);
        map.put("TotalMemoryLimitMebibytes", TOTAL_MEMORY_LIMIT_MEBIBYTES_FIELD);
        map.put("TotalVcpuLimit", TOTAL_VCPU_LIMIT_FIELD);
        map.put("GameServerContainerDefinition", GAME_SERVER_CONTAINER_DEFINITION_FIELD);
        map.put("SupportContainerDefinitions", SUPPORT_CONTAINER_DEFINITIONS_FIELD);
        map.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerGroupDefinitionRequest, T> g) {
        return obj -> g.apply((CreateContainerGroupDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String name;
        private String containerGroupType;
        private Integer totalMemoryLimitMebibytes;
        private Double totalVcpuLimit;
        private GameServerContainerDefinitionInput gameServerContainerDefinition;
        private List<SupportContainerDefinitionInput> supportContainerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String operatingSystem;
        private String versionDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerGroupDefinitionRequest model) {
            super(model);
            this.name(model.name);
            this.containerGroupType(model.containerGroupType);
            this.totalMemoryLimitMebibytes(model.totalMemoryLimitMebibytes);
            this.totalVcpuLimit(model.totalVcpuLimit);
            this.gameServerContainerDefinition(model.gameServerContainerDefinition);
            this.supportContainerDefinitions(model.supportContainerDefinitions);
            this.operatingSystem(model.operatingSystem);
            this.versionDescription(model.versionDescription);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getContainerGroupType() {
            return this.containerGroupType;
        }

        public final void setContainerGroupType(String containerGroupType) {
            this.containerGroupType = containerGroupType;
        }

        @Override
        public final Builder containerGroupType(String containerGroupType) {
            this.containerGroupType = containerGroupType;
            return this;
        }

        @Override
        public final Builder containerGroupType(ContainerGroupType containerGroupType) {
            this.containerGroupType(containerGroupType == null ? null : containerGroupType.toString());
            return this;
        }

        public final Integer getTotalMemoryLimitMebibytes() {
            return this.totalMemoryLimitMebibytes;
        }

        public final void setTotalMemoryLimitMebibytes(Integer totalMemoryLimitMebibytes) {
            this.totalMemoryLimitMebibytes = totalMemoryLimitMebibytes;
        }

        @Override
        public final Builder totalMemoryLimitMebibytes(Integer totalMemoryLimitMebibytes) {
            this.totalMemoryLimitMebibytes = totalMemoryLimitMebibytes;
            return this;
        }

        public final Double getTotalVcpuLimit() {
            return this.totalVcpuLimit;
        }

        public final void setTotalVcpuLimit(Double totalVcpuLimit) {
            this.totalVcpuLimit = totalVcpuLimit;
        }

        @Override
        public final Builder totalVcpuLimit(Double totalVcpuLimit) {
            this.totalVcpuLimit = totalVcpuLimit;
            return this;
        }

        public final GameServerContainerDefinitionInput.Builder getGameServerContainerDefinition() {
            return this.gameServerContainerDefinition != null ? this.gameServerContainerDefinition.toBuilder() : null;
        }

        public final void setGameServerContainerDefinition(GameServerContainerDefinitionInput.BuilderImpl gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition != null ? gameServerContainerDefinition.build() : null;
        }

        @Override
        public final Builder gameServerContainerDefinition(GameServerContainerDefinitionInput gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition;
            return this;
        }

        public final List<SupportContainerDefinitionInput.Builder> getSupportContainerDefinitions() {
            List<SupportContainerDefinitionInput.Builder> result = SupportContainerDefinitionInputListCopier.copyToBuilder(this.supportContainerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportContainerDefinitions(Collection<SupportContainerDefinitionInput.BuilderImpl> supportContainerDefinitions) {
            this.supportContainerDefinitions = SupportContainerDefinitionInputListCopier.copyFromBuilder(supportContainerDefinitions);
        }

        @Override
        public final Builder supportContainerDefinitions(Collection<SupportContainerDefinitionInput> supportContainerDefinitions) {
            this.supportContainerDefinitions = SupportContainerDefinitionInputListCopier.copy(supportContainerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportContainerDefinitions(SupportContainerDefinitionInput ... supportContainerDefinitions) {
            this.supportContainerDefinitions(Arrays.asList(supportContainerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportContainerDefinitions(Consumer<SupportContainerDefinitionInput.Builder> ... supportContainerDefinitions) {
            this.supportContainerDefinitions(Stream.of(supportContainerDefinitions).map(c -> (SupportContainerDefinitionInput)((SupportContainerDefinitionInput.Builder)SupportContainerDefinitionInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(ContainerOperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerGroupDefinitionRequest build() {
            return new CreateContainerGroupDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContainerGroupDefinitionRequest> {
        public Builder name(String var1);

        public Builder containerGroupType(String var1);

        public Builder containerGroupType(ContainerGroupType var1);

        public Builder totalMemoryLimitMebibytes(Integer var1);

        public Builder totalVcpuLimit(Double var1);

        public Builder gameServerContainerDefinition(GameServerContainerDefinitionInput var1);

        default public Builder gameServerContainerDefinition(Consumer<GameServerContainerDefinitionInput.Builder> gameServerContainerDefinition) {
            return this.gameServerContainerDefinition((GameServerContainerDefinitionInput)((GameServerContainerDefinitionInput.Builder)GameServerContainerDefinitionInput.builder().applyMutation(gameServerContainerDefinition)).build());
        }

        public Builder supportContainerDefinitions(Collection<SupportContainerDefinitionInput> var1);

        public Builder supportContainerDefinitions(SupportContainerDefinitionInput ... var1);

        public Builder supportContainerDefinitions(Consumer<SupportContainerDefinitionInput.Builder> ... var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(ContainerOperatingSystem var1);

        public Builder versionDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

