/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueue;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGameSessionQueuesResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
    private static final SdkField<List<GameSessionQueue>> GAME_SESSION_QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameSessionQueues").getter(DescribeGameSessionQueuesResponse.getter(DescribeGameSessionQueuesResponse::gameSessionQueues)).setter(DescribeGameSessionQueuesResponse.setter(Builder::gameSessionQueues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameSessionQueue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeGameSessionQueuesResponse.getter(DescribeGameSessionQueuesResponse::nextToken)).setter(DescribeGameSessionQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_QUEUES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGameSessionQueuesResponse.memberNameToFieldInitializer();
    private final List<GameSessionQueue> gameSessionQueues;
    private final String nextToken;

    private DescribeGameSessionQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessionQueues = builder.gameSessionQueues;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGameSessionQueues() {
        return this.gameSessionQueues != null && !(this.gameSessionQueues instanceof SdkAutoConstructList);
    }

    public final List<GameSessionQueue> gameSessionQueues() {
        return this.gameSessionQueues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameSessionQueues() ? this.gameSessionQueues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionQueuesResponse)) {
            return false;
        }
        DescribeGameSessionQueuesResponse other = (DescribeGameSessionQueuesResponse)((Object)obj);
        return this.hasGameSessionQueues() == other.hasGameSessionQueues() && Objects.equals(this.gameSessionQueues(), other.gameSessionQueues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGameSessionQueuesResponse").add("GameSessionQueues", this.hasGameSessionQueues() ? this.gameSessionQueues() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionQueues": {
                return Optional.ofNullable(clazz.cast(this.gameSessionQueues()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GameSessionQueues", GAME_SESSION_QUEUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameSessionQueuesResponse, T> g) {
        return obj -> g.apply((DescribeGameSessionQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameSessionQueue> gameSessionQueues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionQueuesResponse model) {
            super(model);
            this.gameSessionQueues(model.gameSessionQueues);
            this.nextToken(model.nextToken);
        }

        public final List<GameSessionQueue.Builder> getGameSessionQueues() {
            List<GameSessionQueue.Builder> result = GameSessionQueueListCopier.copyToBuilder(this.gameSessionQueues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameSessionQueues(Collection<GameSessionQueue.BuilderImpl> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copyFromBuilder(gameSessionQueues);
        }

        @Override
        public final Builder gameSessionQueues(Collection<GameSessionQueue> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copy(gameSessionQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueues(GameSessionQueue ... gameSessionQueues) {
            this.gameSessionQueues(Arrays.asList(gameSessionQueues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueues(Consumer<GameSessionQueue.Builder> ... gameSessionQueues) {
            this.gameSessionQueues(Stream.of(gameSessionQueues).map(c -> (GameSessionQueue)((GameSessionQueue.Builder)GameSessionQueue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeGameSessionQueuesResponse build() {
            return new DescribeGameSessionQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
        public Builder gameSessionQueues(Collection<GameSessionQueue> var1);

        public Builder gameSessionQueues(GameSessionQueue ... var1);

        public Builder gameSessionQueues(Consumer<GameSessionQueue.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

