/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.ScalingPolicy;
import software.amazon.awssdk.services.gamelift.model.ScalingPolicyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingPoliciesResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeScalingPoliciesResponse> {
    private static final SdkField<List<ScalingPolicy>> SCALING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingPolicies").getter(DescribeScalingPoliciesResponse.getter(DescribeScalingPoliciesResponse::scalingPolicies)).setter(DescribeScalingPoliciesResponse.setter(Builder::scalingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScalingPoliciesResponse.getter(DescribeScalingPoliciesResponse::nextToken)).setter(DescribeScalingPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScalingPoliciesResponse.memberNameToFieldInitializer();
    private final List<ScalingPolicy> scalingPolicies;
    private final String nextToken;

    private DescribeScalingPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPolicies = builder.scalingPolicies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScalingPolicies() {
        return this.scalingPolicies != null && !(this.scalingPolicies instanceof SdkAutoConstructList);
    }

    public final List<ScalingPolicy> scalingPolicies() {
        return this.scalingPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingPolicies() ? this.scalingPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPoliciesResponse)) {
            return false;
        }
        DescribeScalingPoliciesResponse other = (DescribeScalingPoliciesResponse)((Object)obj);
        return this.hasScalingPolicies() == other.hasScalingPolicies() && Objects.equals(this.scalingPolicies(), other.scalingPolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingPoliciesResponse").add("ScalingPolicies", this.hasScalingPolicies() ? this.scalingPolicies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPolicies": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScalingPolicies", SCALING_POLICIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeScalingPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<ScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPoliciesResponse model) {
            super(model);
            this.scalingPolicies(model.scalingPolicies);
            this.nextToken(model.nextToken);
        }

        public final List<ScalingPolicy.Builder> getScalingPolicies() {
            List<ScalingPolicy.Builder> result = ScalingPolicyListCopier.copyToBuilder(this.scalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPolicyListCopier.copyFromBuilder(scalingPolicies);
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPolicyListCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy ... scalingPolicies) {
            this.scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... scalingPolicies) {
            this.scalingPolicies(Stream.of(scalingPolicies).map(c -> (ScalingPolicy)((ScalingPolicy.Builder)ScalingPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeScalingPoliciesResponse build() {
            return new DescribeScalingPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingPoliciesResponse> {
        public Builder scalingPolicies(Collection<ScalingPolicy> var1);

        public Builder scalingPolicies(ScalingPolicy ... var1);

        public Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

