/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters which game servers may be claimed when calling <code>ClaimGameServer</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClaimFilterOption implements SdkPojo, Serializable,
        ToCopyableBuilder<ClaimFilterOption.Builder, ClaimFilterOption> {
    private static final SdkField<List<String>> INSTANCE_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceStatuses")
            .getter(getter(ClaimFilterOption::instanceStatusesAsStrings))
            .setter(setter(Builder::instanceStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> instanceStatuses;

    private ClaimFilterOption(BuilderImpl builder) {
        this.instanceStatuses = builder.instanceStatuses;
    }

    /**
     * <p>
     * List of instance statuses that game servers may be claimed on. If provided, the list must contain the
     * <code>ACTIVE</code> status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStatuses} method.
     * </p>
     * 
     * @return List of instance statuses that game servers may be claimed on. If provided, the list must contain the
     *         <code>ACTIVE</code> status.
     */
    public final List<FilterInstanceStatus> instanceStatuses() {
        return FilterInstanceStatusesCopier.copyStringToEnum(instanceStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceStatuses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceStatuses() {
        return instanceStatuses != null && !(instanceStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of instance statuses that game servers may be claimed on. If provided, the list must contain the
     * <code>ACTIVE</code> status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStatuses} method.
     * </p>
     * 
     * @return List of instance statuses that game servers may be claimed on. If provided, the list must contain the
     *         <code>ACTIVE</code> status.
     */
    public final List<String> instanceStatusesAsStrings() {
        return instanceStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceStatuses() ? instanceStatusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClaimFilterOption)) {
            return false;
        }
        ClaimFilterOption other = (ClaimFilterOption) obj;
        return hasInstanceStatuses() == other.hasInstanceStatuses()
                && Objects.equals(instanceStatusesAsStrings(), other.instanceStatusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClaimFilterOption")
                .add("InstanceStatuses", hasInstanceStatuses() ? instanceStatusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceStatuses":
            return Optional.ofNullable(clazz.cast(instanceStatusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceStatuses", INSTANCE_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClaimFilterOption, T> g) {
        return obj -> g.apply((ClaimFilterOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClaimFilterOption> {
        /**
         * <p>
         * List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         * <code>ACTIVE</code> status.
         * </p>
         * 
         * @param instanceStatuses
         *        List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         *        <code>ACTIVE</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatusesWithStrings(Collection<String> instanceStatuses);

        /**
         * <p>
         * List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         * <code>ACTIVE</code> status.
         * </p>
         * 
         * @param instanceStatuses
         *        List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         *        <code>ACTIVE</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatusesWithStrings(String... instanceStatuses);

        /**
         * <p>
         * List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         * <code>ACTIVE</code> status.
         * </p>
         * 
         * @param instanceStatuses
         *        List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         *        <code>ACTIVE</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(Collection<FilterInstanceStatus> instanceStatuses);

        /**
         * <p>
         * List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         * <code>ACTIVE</code> status.
         * </p>
         * 
         * @param instanceStatuses
         *        List of instance statuses that game servers may be claimed on. If provided, the list must contain the
         *        <code>ACTIVE</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(FilterInstanceStatus... instanceStatuses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> instanceStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClaimFilterOption model) {
            instanceStatusesWithStrings(model.instanceStatuses);
        }

        public final Collection<String> getInstanceStatuses() {
            if (instanceStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceStatuses;
        }

        public final void setInstanceStatuses(Collection<String> instanceStatuses) {
            this.instanceStatuses = FilterInstanceStatusesCopier.copy(instanceStatuses);
        }

        @Override
        public final Builder instanceStatusesWithStrings(Collection<String> instanceStatuses) {
            this.instanceStatuses = FilterInstanceStatusesCopier.copy(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatusesWithStrings(String... instanceStatuses) {
            instanceStatusesWithStrings(Arrays.asList(instanceStatuses));
            return this;
        }

        @Override
        public final Builder instanceStatuses(Collection<FilterInstanceStatus> instanceStatuses) {
            this.instanceStatuses = FilterInstanceStatusesCopier.copyEnumToString(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(FilterInstanceStatus... instanceStatuses) {
            instanceStatuses(Arrays.asList(instanceStatuses));
            return this;
        }

        @Override
        public ClaimFilterOption build() {
            return new ClaimFilterOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
