/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mount point that binds a container to a file or directory on the host system.
 * </p>
 * <p>
 * <b>Part of:</b> <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html"
 * >GameServerContainerDefinition</a>, <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html"
 * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html</a>, <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html"
 * >SupportContainerDefinition</a>, <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html"
 * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerMountPoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerMountPoint.Builder, ContainerMountPoint> {
    private static final SdkField<String> INSTANCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstancePath").getter(getter(ContainerMountPoint::instancePath)).setter(setter(Builder::instancePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePath").build()).build();

    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerPath").getter(getter(ContainerMountPoint::containerPath))
            .setter(setter(Builder::containerPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPath").build()).build();

    private static final SdkField<String> ACCESS_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessLevel").getter(getter(ContainerMountPoint::accessLevelAsString))
            .setter(setter(Builder::accessLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PATH_FIELD,
            CONTAINER_PATH_FIELD, ACCESS_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instancePath;

    private final String containerPath;

    private final String accessLevel;

    private ContainerMountPoint(BuilderImpl builder) {
        this.instancePath = builder.instancePath;
        this.containerPath = builder.containerPath;
        this.accessLevel = builder.accessLevel;
    }

    /**
     * <p>
     * The path to the source file or directory.
     * </p>
     * 
     * @return The path to the source file or directory.
     */
    public final String instancePath() {
        return instancePath;
    }

    /**
     * <p>
     * The mount path on the container. If this property isn't set, the instance path is used.
     * </p>
     * 
     * @return The mount path on the container. If this property isn't set, the instance path is used.
     */
    public final String containerPath() {
        return containerPath;
    }

    /**
     * <p>
     * The type of access for the container.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessLevel} will
     * return {@link ContainerMountPointAccessLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #accessLevelAsString}.
     * </p>
     * 
     * @return The type of access for the container.
     * @see ContainerMountPointAccessLevel
     */
    public final ContainerMountPointAccessLevel accessLevel() {
        return ContainerMountPointAccessLevel.fromValue(accessLevel);
    }

    /**
     * <p>
     * The type of access for the container.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessLevel} will
     * return {@link ContainerMountPointAccessLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #accessLevelAsString}.
     * </p>
     * 
     * @return The type of access for the container.
     * @see ContainerMountPointAccessLevel
     */
    public final String accessLevelAsString() {
        return accessLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instancePath());
        hashCode = 31 * hashCode + Objects.hashCode(containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(accessLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerMountPoint)) {
            return false;
        }
        ContainerMountPoint other = (ContainerMountPoint) obj;
        return Objects.equals(instancePath(), other.instancePath()) && Objects.equals(containerPath(), other.containerPath())
                && Objects.equals(accessLevelAsString(), other.accessLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerMountPoint").add("InstancePath", instancePath()).add("ContainerPath", containerPath())
                .add("AccessLevel", accessLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstancePath":
            return Optional.ofNullable(clazz.cast(instancePath()));
        case "ContainerPath":
            return Optional.ofNullable(clazz.cast(containerPath()));
        case "AccessLevel":
            return Optional.ofNullable(clazz.cast(accessLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstancePath", INSTANCE_PATH_FIELD);
        map.put("ContainerPath", CONTAINER_PATH_FIELD);
        map.put("AccessLevel", ACCESS_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerMountPoint, T> g) {
        return obj -> g.apply((ContainerMountPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerMountPoint> {
        /**
         * <p>
         * The path to the source file or directory.
         * </p>
         * 
         * @param instancePath
         *        The path to the source file or directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePath(String instancePath);

        /**
         * <p>
         * The mount path on the container. If this property isn't set, the instance path is used.
         * </p>
         * 
         * @param containerPath
         *        The mount path on the container. If this property isn't set, the instance path is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPath(String containerPath);

        /**
         * <p>
         * The type of access for the container.
         * </p>
         * 
         * @param accessLevel
         *        The type of access for the container.
         * @see ContainerMountPointAccessLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerMountPointAccessLevel
         */
        Builder accessLevel(String accessLevel);

        /**
         * <p>
         * The type of access for the container.
         * </p>
         * 
         * @param accessLevel
         *        The type of access for the container.
         * @see ContainerMountPointAccessLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerMountPointAccessLevel
         */
        Builder accessLevel(ContainerMountPointAccessLevel accessLevel);
    }

    static final class BuilderImpl implements Builder {
        private String instancePath;

        private String containerPath;

        private String accessLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerMountPoint model) {
            instancePath(model.instancePath);
            containerPath(model.containerPath);
            accessLevel(model.accessLevel);
        }

        public final String getInstancePath() {
            return instancePath;
        }

        public final void setInstancePath(String instancePath) {
            this.instancePath = instancePath;
        }

        @Override
        public final Builder instancePath(String instancePath) {
            this.instancePath = instancePath;
            return this;
        }

        public final String getContainerPath() {
            return containerPath;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final String getAccessLevel() {
            return accessLevel;
        }

        public final void setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
        }

        @Override
        public final Builder accessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        @Override
        public final Builder accessLevel(ContainerMountPointAccessLevel accessLevel) {
            this.accessLevel(accessLevel == null ? null : accessLevel.toString());
            return this;
        }

        @Override
        public ContainerMountPoint build() {
            return new ContainerMountPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
