/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of port ranges that can be opened on the container. A process that's running in the container can bind to a
 * port number, making it accessible to inbound traffic when it's mapped to a container fleet's connection port.
 * </p>
 * <p>
 * Each container port range specifies a network protocol. When the configuration supports more than one protocol, we
 * recommend that you use a different range for each protocol. If your ranges have overlapping port numbers, Amazon
 * GameLift Servers maps a duplicated container port number to different connection ports. For example, if you include
 * 1935 in port ranges for both TCP and UDP, it might result in the following mappings:
 * </p>
 * <ul>
 * <li>
 * <p>
 * container port 1935 (tcp) =&gt; connection port 2001
 * </p>
 * </li>
 * <li>
 * <p>
 * container port 1935 (udp) =&gt; connection port 2002
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Part of:</b> <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinition.html"
 * >GameServerContainerDefinition</a>, <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerContainerDefinitionInput.html"
 * >GameServerContainerDefinitionInput</a>, <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html"
 * >SupportContainerDefinition</a>, <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinitionInput.html"
 * >SupportContainerDefinitionInput</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerPortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerPortConfiguration.Builder, ContainerPortConfiguration> {
    private static final SdkField<List<ContainerPortRange>> CONTAINER_PORT_RANGES_FIELD = SdkField
            .<List<ContainerPortRange>> builder(MarshallingType.LIST)
            .memberName("ContainerPortRanges")
            .getter(getter(ContainerPortConfiguration::containerPortRanges))
            .setter(setter(Builder::containerPortRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPortRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerPortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerPortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PORT_RANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ContainerPortRange> containerPortRanges;

    private ContainerPortConfiguration(BuilderImpl builder) {
        this.containerPortRanges = builder.containerPortRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerPortRanges property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerPortRanges() {
        return containerPortRanges != null && !(containerPortRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of one or more container port number ranges. The ranges can't overlap if the ranges' network protocols are
     * the same. Overlapping ranges with different protocols is allowed but not recommended.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerPortRanges} method.
     * </p>
     * 
     * @return A set of one or more container port number ranges. The ranges can't overlap if the ranges' network
     *         protocols are the same. Overlapping ranges with different protocols is allowed but not recommended.
     */
    public final List<ContainerPortRange> containerPortRanges() {
        return containerPortRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerPortRanges() ? containerPortRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerPortConfiguration)) {
            return false;
        }
        ContainerPortConfiguration other = (ContainerPortConfiguration) obj;
        return hasContainerPortRanges() == other.hasContainerPortRanges()
                && Objects.equals(containerPortRanges(), other.containerPortRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerPortConfiguration")
                .add("ContainerPortRanges", hasContainerPortRanges() ? containerPortRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerPortRanges":
            return Optional.ofNullable(clazz.cast(containerPortRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerPortRanges", CONTAINER_PORT_RANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerPortConfiguration, T> g) {
        return obj -> g.apply((ContainerPortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerPortConfiguration> {
        /**
         * <p>
         * A set of one or more container port number ranges. The ranges can't overlap if the ranges' network protocols
         * are the same. Overlapping ranges with different protocols is allowed but not recommended.
         * </p>
         * 
         * @param containerPortRanges
         *        A set of one or more container port number ranges. The ranges can't overlap if the ranges' network
         *        protocols are the same. Overlapping ranges with different protocols is allowed but not recommended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPortRanges(Collection<ContainerPortRange> containerPortRanges);

        /**
         * <p>
         * A set of one or more container port number ranges. The ranges can't overlap if the ranges' network protocols
         * are the same. Overlapping ranges with different protocols is allowed but not recommended.
         * </p>
         * 
         * @param containerPortRanges
         *        A set of one or more container port number ranges. The ranges can't overlap if the ranges' network
         *        protocols are the same. Overlapping ranges with different protocols is allowed but not recommended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPortRanges(ContainerPortRange... containerPortRanges);

        /**
         * <p>
         * A set of one or more container port number ranges. The ranges can't overlap if the ranges' network protocols
         * are the same. Overlapping ranges with different protocols is allowed but not recommended.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerPortRange.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.gamelift.model.ContainerPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerPortRange.Builder#build()} is called
         * immediately and its result is passed to {@link #containerPortRanges(List<ContainerPortRange>)}.
         * 
         * @param containerPortRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.ContainerPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerPortRanges(java.util.Collection<ContainerPortRange>)
         */
        Builder containerPortRanges(Consumer<ContainerPortRange.Builder>... containerPortRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<ContainerPortRange> containerPortRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerPortConfiguration model) {
            containerPortRanges(model.containerPortRanges);
        }

        public final List<ContainerPortRange.Builder> getContainerPortRanges() {
            List<ContainerPortRange.Builder> result = ContainerPortRangeListCopier.copyToBuilder(this.containerPortRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerPortRanges(Collection<ContainerPortRange.BuilderImpl> containerPortRanges) {
            this.containerPortRanges = ContainerPortRangeListCopier.copyFromBuilder(containerPortRanges);
        }

        @Override
        public final Builder containerPortRanges(Collection<ContainerPortRange> containerPortRanges) {
            this.containerPortRanges = ContainerPortRangeListCopier.copy(containerPortRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerPortRanges(ContainerPortRange... containerPortRanges) {
            containerPortRanges(Arrays.asList(containerPortRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerPortRanges(Consumer<ContainerPortRange.Builder>... containerPortRanges) {
            containerPortRanges(Stream.of(containerPortRanges).map(c -> ContainerPortRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContainerPortConfiguration build() {
            return new ContainerPortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
