/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A game session's properties plus the protection policy currently in force.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GameSessionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<GameSessionDetail.Builder, GameSessionDetail> {
    private static final SdkField<GameSession> GAME_SESSION_FIELD = SdkField.<GameSession> builder(MarshallingType.SDK_POJO)
            .memberName("GameSession").getter(getter(GameSessionDetail::gameSession)).setter(setter(Builder::gameSession))
            .constructor(GameSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSession").build()).build();

    private static final SdkField<String> PROTECTION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectionPolicy").getter(getter(GameSessionDetail::protectionPolicyAsString))
            .setter(setter(Builder::protectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_FIELD,
            PROTECTION_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GameSession gameSession;

    private final String protectionPolicy;

    private GameSessionDetail(BuilderImpl builder) {
        this.gameSession = builder.gameSession;
        this.protectionPolicy = builder.protectionPolicy;
    }

    /**
     * <p>
     * Object that describes a game session.
     * </p>
     * 
     * @return Object that describes a game session.
     */
    public final GameSession gameSession() {
        return gameSession;
    }

    /**
     * <p>
     * Current status of protection for the game session.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during
     * a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protectionPolicy}
     * will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protectionPolicyAsString}.
     * </p>
     * 
     * @return Current status of protection for the game session.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final ProtectionPolicy protectionPolicy() {
        return ProtectionPolicy.fromValue(protectionPolicy);
    }

    /**
     * <p>
     * Current status of protection for the game session.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during
     * a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protectionPolicy}
     * will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protectionPolicyAsString}.
     * </p>
     * 
     * @return Current status of protection for the game session.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final String protectionPolicyAsString() {
        return protectionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gameSession());
        hashCode = 31 * hashCode + Objects.hashCode(protectionPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionDetail)) {
            return false;
        }
        GameSessionDetail other = (GameSessionDetail) obj;
        return Objects.equals(gameSession(), other.gameSession())
                && Objects.equals(protectionPolicyAsString(), other.protectionPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GameSessionDetail").add("GameSession", gameSession())
                .add("ProtectionPolicy", protectionPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSession":
            return Optional.ofNullable(clazz.cast(gameSession()));
        case "ProtectionPolicy":
            return Optional.ofNullable(clazz.cast(protectionPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameSession", GAME_SESSION_FIELD);
        map.put("ProtectionPolicy", PROTECTION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GameSessionDetail, T> g) {
        return obj -> g.apply((GameSessionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GameSessionDetail> {
        /**
         * <p>
         * Object that describes a game session.
         * </p>
         * 
         * @param gameSession
         *        Object that describes a game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSession(GameSession gameSession);

        /**
         * <p>
         * Object that describes a game session.
         * </p>
         * This is a convenience method that creates an instance of the {@link GameSession.Builder} avoiding the need to
         * create one manually via {@link GameSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameSession.Builder#build()} is called immediately and its result
         * is passed to {@link #gameSession(GameSession)}.
         * 
         * @param gameSession
         *        a consumer that will call methods on {@link GameSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSession(GameSession)
         */
        default Builder gameSession(Consumer<GameSession.Builder> gameSession) {
            return gameSession(GameSession.builder().applyMutation(gameSession).build());
        }

        /**
         * <p>
         * Current status of protection for the game session.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protectionPolicy
         *        Current status of protection for the game session.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder protectionPolicy(String protectionPolicy);

        /**
         * <p>
         * Current status of protection for the game session.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protectionPolicy
         *        Current status of protection for the game session.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder protectionPolicy(ProtectionPolicy protectionPolicy);
    }

    static final class BuilderImpl implements Builder {
        private GameSession gameSession;

        private String protectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionDetail model) {
            gameSession(model.gameSession);
            protectionPolicy(model.protectionPolicy);
        }

        public final GameSession.Builder getGameSession() {
            return gameSession != null ? gameSession.toBuilder() : null;
        }

        public final void setGameSession(GameSession.BuilderImpl gameSession) {
            this.gameSession = gameSession != null ? gameSession.build() : null;
        }

        @Override
        public final Builder gameSession(GameSession gameSession) {
            this.gameSession = gameSession;
            return this;
        }

        public final String getProtectionPolicy() {
            return protectionPolicy;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy == null ? null : protectionPolicy.toString());
            return this;
        }

        @Override
        public GameSessionDetail build() {
            return new GameSessionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
