/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target
 * value for the metric. As player usage changes, the policy triggers Amazon GameLift Servers to adjust capacity so that
 * the metric returns to the target value. The target configuration specifies settings as needed for the target based
 * policy, including the target value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetConfiguration.Builder, TargetConfiguration> {
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(TargetConfiguration::targetValue)).setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double targetValue;

    private TargetConfiguration(BuilderImpl builder) {
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the
     * scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value
     * should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new
     * game sessions).
     * </p>
     * 
     * @return Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric
     *         the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the
     *         target value should be the preferred size of the fleet's buffer (the percent of capacity that should be
     *         idle and ready for new game sessions).
     */
    public final Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetConfiguration)) {
            return false;
        }
        TargetConfiguration other = (TargetConfiguration) obj;
        return Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetConfiguration").add("TargetValue", targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetValue", TARGET_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetConfiguration, T> g) {
        return obj -> g.apply((TargetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetConfiguration> {
        /**
         * <p>
         * Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the
         * scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target
         * value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and
         * ready for new game sessions).
         * </p>
         * 
         * @param targetValue
         *        Desired value to use with a target-based scaling policy. The value must be relevant for whatever
         *        metric the scaling policy is using. For example, in a policy using the metric
         *        PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the
         *        percent of capacity that should be idle and ready for new game sessions).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetConfiguration model) {
            targetValue(model.targetValue);
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        @Override
        public TargetConfiguration build() {
            return new TargetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
