/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptMatchRequest extends GameLiftRequest implements
        ToCopyableBuilder<AcceptMatchRequest.Builder, AcceptMatchRequest> {
    private static final SdkField<String> TICKET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceptMatchRequest::ticketId)).setter(setter(Builder::ticketId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketId").build()).build();

    private static final SdkField<List<String>> PLAYER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AcceptMatchRequest::playerIds))
            .setter(setter(Builder::playerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCEPTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceptMatchRequest::acceptanceTypeAsString)).setter(setter(Builder::acceptanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_ID_FIELD,
            PLAYER_IDS_FIELD, ACCEPTANCE_TYPE_FIELD));

    private final String ticketId;

    private final List<String> playerIds;

    private final String acceptanceType;

    private AcceptMatchRequest(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.playerIds = builder.playerIds;
        this.acceptanceType = builder.acceptanceType;
    }

    /**
     * <p>
     * Unique identifier for a matchmaking ticket. The ticket must be in status <code>REQUIRES_ACCEPTANCE</code>;
     * otherwise this request will fail.
     * </p>
     * 
     * @return Unique identifier for a matchmaking ticket. The ticket must be in status <code>REQUIRES_ACCEPTANCE</code>
     *         ; otherwise this request will fail.
     */
    public String ticketId() {
        return ticketId;
    }

    /**
     * <p>
     * Unique identifier for a player delivering the response. This parameter can include one or multiple player IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Unique identifier for a player delivering the response. This parameter can include one or multiple player
     *         IDs.
     */
    public List<String> playerIds() {
        return playerIds;
    }

    /**
     * <p>
     * Player response to the proposed match.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptanceType}
     * will return {@link AcceptanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #acceptanceTypeAsString}.
     * </p>
     * 
     * @return Player response to the proposed match.
     * @see AcceptanceType
     */
    public AcceptanceType acceptanceType() {
        return AcceptanceType.fromValue(acceptanceType);
    }

    /**
     * <p>
     * Player response to the proposed match.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptanceType}
     * will return {@link AcceptanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #acceptanceTypeAsString}.
     * </p>
     * 
     * @return Player response to the proposed match.
     * @see AcceptanceType
     */
    public String acceptanceTypeAsString() {
        return acceptanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(playerIds());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptMatchRequest)) {
            return false;
        }
        AcceptMatchRequest other = (AcceptMatchRequest) obj;
        return Objects.equals(ticketId(), other.ticketId()) && Objects.equals(playerIds(), other.playerIds())
                && Objects.equals(acceptanceTypeAsString(), other.acceptanceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AcceptMatchRequest").add("TicketId", ticketId()).add("PlayerIds", playerIds())
                .add("AcceptanceType", acceptanceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TicketId":
            return Optional.ofNullable(clazz.cast(ticketId()));
        case "PlayerIds":
            return Optional.ofNullable(clazz.cast(playerIds()));
        case "AcceptanceType":
            return Optional.ofNullable(clazz.cast(acceptanceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptMatchRequest, T> g) {
        return obj -> g.apply((AcceptMatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, AcceptMatchRequest> {
        /**
         * <p>
         * Unique identifier for a matchmaking ticket. The ticket must be in status <code>REQUIRES_ACCEPTANCE</code>;
         * otherwise this request will fail.
         * </p>
         * 
         * @param ticketId
         *        Unique identifier for a matchmaking ticket. The ticket must be in status
         *        <code>REQUIRES_ACCEPTANCE</code>; otherwise this request will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketId(String ticketId);

        /**
         * <p>
         * Unique identifier for a player delivering the response. This parameter can include one or multiple player
         * IDs.
         * </p>
         * 
         * @param playerIds
         *        Unique identifier for a player delivering the response. This parameter can include one or multiple
         *        player IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerIds(Collection<String> playerIds);

        /**
         * <p>
         * Unique identifier for a player delivering the response. This parameter can include one or multiple player
         * IDs.
         * </p>
         * 
         * @param playerIds
         *        Unique identifier for a player delivering the response. This parameter can include one or multiple
         *        player IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerIds(String... playerIds);

        /**
         * <p>
         * Player response to the proposed match.
         * </p>
         * 
         * @param acceptanceType
         *        Player response to the proposed match.
         * @see AcceptanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptanceType
         */
        Builder acceptanceType(String acceptanceType);

        /**
         * <p>
         * Player response to the proposed match.
         * </p>
         * 
         * @param acceptanceType
         *        Player response to the proposed match.
         * @see AcceptanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptanceType
         */
        Builder acceptanceType(AcceptanceType acceptanceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String ticketId;

        private List<String> playerIds = DefaultSdkAutoConstructList.getInstance();

        private String acceptanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptMatchRequest model) {
            super(model);
            ticketId(model.ticketId);
            playerIds(model.playerIds);
            acceptanceType(model.acceptanceType);
        }

        public final String getTicketId() {
            return ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public final Collection<String> getPlayerIds() {
            return playerIds;
        }

        @Override
        public final Builder playerIds(Collection<String> playerIds) {
            this.playerIds = StringListCopier.copy(playerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerIds(String... playerIds) {
            playerIds(Arrays.asList(playerIds));
            return this;
        }

        public final void setPlayerIds(Collection<String> playerIds) {
            this.playerIds = StringListCopier.copy(playerIds);
        }

        public final String getAcceptanceTypeAsString() {
            return acceptanceType;
        }

        @Override
        public final Builder acceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
            return this;
        }

        @Override
        public final Builder acceptanceType(AcceptanceType acceptanceType) {
            this.acceptanceType(acceptanceType == null ? null : acceptanceType.toString());
            return this;
        }

        public final void setAcceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptMatchRequest build() {
            return new AcceptMatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
