/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateFleetResponse.Builder, CreateFleetResponse> {
    private static final SdkField<FleetAttributes> FLEET_ATTRIBUTES_FIELD = SdkField
            .<FleetAttributes> builder(MarshallingType.SDK_POJO).getter(getter(CreateFleetResponse::fleetAttributes))
            .setter(setter(Builder::fleetAttributes)).constructor(FleetAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ATTRIBUTES_FIELD));

    private final FleetAttributes fleetAttributes;

    private CreateFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleetAttributes = builder.fleetAttributes;
    }

    /**
     * <p>
     * Properties for the newly created fleet.
     * </p>
     * 
     * @return Properties for the newly created fleet.
     */
    public FleetAttributes fleetAttributes() {
        return fleetAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetResponse)) {
            return false;
        }
        CreateFleetResponse other = (CreateFleetResponse) obj;
        return Objects.equals(fleetAttributes(), other.fleetAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFleetResponse").add("FleetAttributes", fleetAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetAttributes":
            return Optional.ofNullable(clazz.cast(fleetAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetResponse, T> g) {
        return obj -> g.apply((CreateFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetResponse> {
        /**
         * <p>
         * Properties for the newly created fleet.
         * </p>
         * 
         * @param fleetAttributes
         *        Properties for the newly created fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetAttributes(FleetAttributes fleetAttributes);

        /**
         * <p>
         * Properties for the newly created fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link FleetAttributes.Builder} avoiding the need to
         * create one manually via {@link FleetAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link FleetAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #fleetAttributes(FleetAttributes)}.
         * 
         * @param fleetAttributes
         *        a consumer that will call methods on {@link FleetAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetAttributes(FleetAttributes)
         */
        default Builder fleetAttributes(Consumer<FleetAttributes.Builder> fleetAttributes) {
            return fleetAttributes(FleetAttributes.builder().applyMutation(fleetAttributes).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private FleetAttributes fleetAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetResponse model) {
            super(model);
            fleetAttributes(model.fleetAttributes);
        }

        public final FleetAttributes.Builder getFleetAttributes() {
            return fleetAttributes != null ? fleetAttributes.toBuilder() : null;
        }

        @Override
        public final Builder fleetAttributes(FleetAttributes fleetAttributes) {
            this.fleetAttributes = fleetAttributes;
            return this;
        }

        public final void setFleetAttributes(FleetAttributes.BuilderImpl fleetAttributes) {
            this.fleetAttributes = fleetAttributes != null ? fleetAttributes.build() : null;
        }

        @Override
        public CreateFleetResponse build() {
            return new CreateFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
