/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the returned data in response to a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRuntimeConfigurationResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeRuntimeConfigurationResponse.Builder, DescribeRuntimeConfigurationResponse> {
    private static final SdkField<RuntimeConfiguration> RUNTIME_CONFIGURATION_FIELD = SdkField
            .<RuntimeConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeRuntimeConfigurationResponse::runtimeConfiguration))
            .setter(setter(Builder::runtimeConfiguration)).constructor(RuntimeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_CONFIGURATION_FIELD));

    private final RuntimeConfiguration runtimeConfiguration;

    private DescribeRuntimeConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.runtimeConfiguration = builder.runtimeConfiguration;
    }

    /**
     * <p>
     * Instructions describing how server processes should be launched and maintained on each instance in the fleet.
     * </p>
     * 
     * @return Instructions describing how server processes should be launched and maintained on each instance in the
     *         fleet.
     */
    public RuntimeConfiguration runtimeConfiguration() {
        return runtimeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runtimeConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuntimeConfigurationResponse)) {
            return false;
        }
        DescribeRuntimeConfigurationResponse other = (DescribeRuntimeConfigurationResponse) obj;
        return Objects.equals(runtimeConfiguration(), other.runtimeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRuntimeConfigurationResponse").add("RuntimeConfiguration", runtimeConfiguration())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuntimeConfiguration":
            return Optional.ofNullable(clazz.cast(runtimeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuntimeConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeRuntimeConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRuntimeConfigurationResponse> {
        /**
         * <p>
         * Instructions describing how server processes should be launched and maintained on each instance in the fleet.
         * </p>
         * 
         * @param runtimeConfiguration
         *        Instructions describing how server processes should be launched and maintained on each instance in the
         *        fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration);

        /**
         * <p>
         * Instructions describing how server processes should be launched and maintained on each instance in the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link RuntimeConfiguration.Builder} avoiding the need
         * to create one manually via {@link RuntimeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuntimeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #runtimeConfiguration(RuntimeConfiguration)}.
         * 
         * @param runtimeConfiguration
         *        a consumer that will call methods on {@link RuntimeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfiguration(RuntimeConfiguration)
         */
        default Builder runtimeConfiguration(Consumer<RuntimeConfiguration.Builder> runtimeConfiguration) {
            return runtimeConfiguration(RuntimeConfiguration.builder().applyMutation(runtimeConfiguration).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private RuntimeConfiguration runtimeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuntimeConfigurationResponse model) {
            super(model);
            runtimeConfiguration(model.runtimeConfiguration);
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return runtimeConfiguration != null ? runtimeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        @Override
        public DescribeRuntimeConfigurationResponse build() {
            return new DescribeRuntimeConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
