/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMatchBackfillRequest extends GameLiftRequest implements
        ToCopyableBuilder<StartMatchBackfillRequest.Builder, StartMatchBackfillRequest> {
    private static final SdkField<String> TICKET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartMatchBackfillRequest::ticketId)).setter(setter(Builder::ticketId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketId").build()).build();

    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartMatchBackfillRequest::configurationName)).setter(setter(Builder::configurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()).build();

    private static final SdkField<String> GAME_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartMatchBackfillRequest::gameSessionArn)).setter(setter(Builder::gameSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionArn").build()).build();

    private static final SdkField<List<Player>> PLAYERS_FIELD = SdkField
            .<List<Player>> builder(MarshallingType.LIST)
            .getter(getter(StartMatchBackfillRequest::players))
            .setter(setter(Builder::players))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Players").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Player> builder(MarshallingType.SDK_POJO)
                                            .constructor(Player::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_ID_FIELD,
            CONFIGURATION_NAME_FIELD, GAME_SESSION_ARN_FIELD, PLAYERS_FIELD));

    private final String ticketId;

    private final String configurationName;

    private final String gameSessionArn;

    private final List<Player> players;

    private StartMatchBackfillRequest(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.configurationName = builder.configurationName;
        this.gameSessionArn = builder.gameSessionArn;
        this.players = builder.players;
    }

    /**
     * <p>
     * Unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one
     * in the form of a UUID. Use this identifier to track the match backfill ticket status and retrieve match results.
     * </p>
     * 
     * @return Unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will
     *         generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and
     *         retrieve match results.
     */
    public String ticketId() {
        return ticketId;
    }

    /**
     * <p>
     * Name of the matchmaker to use for this request. The name of the matchmaker that was used with the original game
     * session is listed in the <a>GameSession</a> object, <code>MatchmakerData</code> property. This property contains
     * a matchmaking configuration ARN value, which includes the matchmaker name. (In the ARN value
     * "arn:aws:gamelift:us-west-2:111122223333:matchmakingconfiguration/MM-4v4", the matchmaking configuration name is
     * "MM-4v4".) Use only the name for this parameter.
     * </p>
     * 
     * @return Name of the matchmaker to use for this request. The name of the matchmaker that was used with the
     *         original game session is listed in the <a>GameSession</a> object, <code>MatchmakerData</code> property.
     *         This property contains a matchmaking configuration ARN value, which includes the matchmaker name. (In the
     *         ARN value "arn:aws:gamelift:us-west-2:111122223333:matchmakingconfiguration/MM-4v4", the matchmaking
     *         configuration name is "MM-4v4".) Use only the name for this parameter.
     */
    public String configurationName() {
        return configurationName;
    }

    /**
     * <p>
     * Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that
     * is assigned to a game session and uniquely identifies it.
     * </p>
     * 
     * @return Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         game session and uniquely identifies it.
     */
    public String gameSessionArn() {
        return gameSessionArn;
    }

    /**
     * <p>
     * Match information on all players that are currently assigned to the game session. This information is used by the
     * matchmaker to find new players and add them to the existing game.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PlayerID, PlayerAttributes, Team -\\- This information is maintained in the <a>GameSession</a> object,
     * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
     * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data"> Match
     * Data</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LatencyInMs -\\- If the matchmaker uses player latency, include a latency value, in milliseconds, for the region
     * that the game session is currently in. Do not include latency values for any other region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Match information on all players that are currently assigned to the game session. This information is
     *         used by the matchmaker to find new players and add them to the existing game.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PlayerID, PlayerAttributes, Team -\\- This information is maintained in the <a>GameSession</a> object,
     *         <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
     *         matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data">
     *         Match Data</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LatencyInMs -\\- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
     *         region that the game session is currently in. Do not include latency values for any other region.
     *         </p>
     *         </li>
     */
    public List<Player> players() {
        return players;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(players());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMatchBackfillRequest)) {
            return false;
        }
        StartMatchBackfillRequest other = (StartMatchBackfillRequest) obj;
        return Objects.equals(ticketId(), other.ticketId()) && Objects.equals(configurationName(), other.configurationName())
                && Objects.equals(gameSessionArn(), other.gameSessionArn()) && Objects.equals(players(), other.players());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartMatchBackfillRequest").add("TicketId", ticketId())
                .add("ConfigurationName", configurationName()).add("GameSessionArn", gameSessionArn()).add("Players", players())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TicketId":
            return Optional.ofNullable(clazz.cast(ticketId()));
        case "ConfigurationName":
            return Optional.ofNullable(clazz.cast(configurationName()));
        case "GameSessionArn":
            return Optional.ofNullable(clazz.cast(gameSessionArn()));
        case "Players":
            return Optional.ofNullable(clazz.cast(players()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMatchBackfillRequest, T> g) {
        return obj -> g.apply((StartMatchBackfillRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMatchBackfillRequest> {
        /**
         * <p>
         * Unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate
         * one in the form of a UUID. Use this identifier to track the match backfill ticket status and retrieve match
         * results.
         * </p>
         * 
         * @param ticketId
         *        Unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will
         *        generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and
         *        retrieve match results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketId(String ticketId);

        /**
         * <p>
         * Name of the matchmaker to use for this request. The name of the matchmaker that was used with the original
         * game session is listed in the <a>GameSession</a> object, <code>MatchmakerData</code> property. This property
         * contains a matchmaking configuration ARN value, which includes the matchmaker name. (In the ARN value
         * "arn:aws:gamelift:us-west-2:111122223333:matchmakingconfiguration/MM-4v4", the matchmaking configuration name
         * is "MM-4v4".) Use only the name for this parameter.
         * </p>
         * 
         * @param configurationName
         *        Name of the matchmaker to use for this request. The name of the matchmaker that was used with the
         *        original game session is listed in the <a>GameSession</a> object, <code>MatchmakerData</code>
         *        property. This property contains a matchmaking configuration ARN value, which includes the matchmaker
         *        name. (In the ARN value "arn:aws:gamelift:us-west-2:111122223333:matchmakingconfiguration/MM-4v4", the
         *        matchmaking configuration name is "MM-4v4".) Use only the name for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationName(String configurationName);

        /**
         * <p>
         * Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
         * that is assigned to a game session and uniquely identifies it.
         * </p>
         * 
         * @param gameSessionArn
         *        Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a game session and uniquely identifies it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionArn(String gameSessionArn);

        /**
         * <p>
         * Match information on all players that are currently assigned to the game session. This information is used by
         * the matchmaker to find new players and add them to the existing game.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PlayerID, PlayerAttributes, Team -\\- This information is maintained in the <a>GameSession</a> object,
         * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
         * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data"> Match
         * Data</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LatencyInMs -\\- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
         * region that the game session is currently in. Do not include latency values for any other region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param players
         *        Match information on all players that are currently assigned to the game session. This information is
         *        used by the matchmaker to find new players and add them to the existing game.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PlayerID, PlayerAttributes, Team -\\- This information is maintained in the <a>GameSession</a> object,
         *        <code>MatchmakerData</code> property, for all players who are currently assigned to the game session.
         *        The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data">
         *        Match Data</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LatencyInMs -\\- If the matchmaker uses player latency, include a latency value, in milliseconds, for
         *        the region that the game session is currently in. Do not include latency values for any other region.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder players(Collection<Player> players);

        /**
         * <p>
         * Match information on all players that are currently assigned to the game session. This information is used by
         * the matchmaker to find new players and add them to the existing game.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PlayerID, PlayerAttributes, Team -\\- This information is maintained in the <a>GameSession</a> object,
         * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
         * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data"> Match
         * Data</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LatencyInMs -\\- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
         * region that the game session is currently in. Do not include latency values for any other region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param players
         *        Match information on all players that are currently assigned to the game session. This information is
         *        used by the matchmaker to find new players and add them to the existing game.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PlayerID, PlayerAttributes, Team -\\- This information is maintained in the <a>GameSession</a> object,
         *        <code>MatchmakerData</code> property, for all players who are currently assigned to the game session.
         *        The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data">
         *        Match Data</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LatencyInMs -\\- If the matchmaker uses player latency, include a latency value, in milliseconds, for
         *        the region that the game session is currently in. Do not include latency values for any other region.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder players(Player... players);

        /**
         * <p>
         * Match information on all players that are currently assigned to the game session. This information is used by
         * the matchmaker to find new players and add them to the existing game.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PlayerID, PlayerAttributes, Team -\\- This information is maintained in the <a>GameSession</a> object,
         * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
         * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data"> Match
         * Data</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LatencyInMs -\\- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
         * region that the game session is currently in. Do not include latency values for any other region.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Player>.Builder} avoiding the need to
         * create one manually via {@link List<Player>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Player>.Builder#build()} is called immediately and its
         * result is passed to {@link #players(List<Player>)}.
         * 
         * @param players
         *        a consumer that will call methods on {@link List<Player>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #players(List<Player>)
         */
        Builder players(Consumer<Player.Builder>... players);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String ticketId;

        private String configurationName;

        private String gameSessionArn;

        private List<Player> players = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMatchBackfillRequest model) {
            super(model);
            ticketId(model.ticketId);
            configurationName(model.configurationName);
            gameSessionArn(model.gameSessionArn);
            players(model.players);
        }

        public final String getTicketId() {
            return ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public final String getConfigurationName() {
            return configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        public final String getGameSessionArn() {
            return gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        public final Collection<Player.Builder> getPlayers() {
            return players != null ? players.stream().map(Player::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder players(Collection<Player> players) {
            this.players = PlayerListCopier.copy(players);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Player... players) {
            players(Arrays.asList(players));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Consumer<Player.Builder>... players) {
            players(Stream.of(players).map(c -> Player.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlayers(Collection<Player.BuilderImpl> players) {
            this.players = PlayerListCopier.copyFromBuilder(players);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMatchBackfillRequest build() {
            return new StartMatchBackfillRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
