/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGameSessionRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateGameSessionRequest.Builder, CreateGameSessionRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGameSessionRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGameSessionRequest::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(CreateGameSessionRequest::maximumPlayerSessionCount))
            .setter(setter(Builder::maximumPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGameSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField
            .<List<GameProperty>> builder(MarshallingType.LIST)
            .getter(getter(CreateGameSessionRequest::gameProperties))
            .setter(setter(Builder::gameProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GameProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(GameProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGameSessionRequest::creatorId)).setter(setter(Builder::creatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()).build();

    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGameSessionRequest::gameSessionId)).setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGameSessionRequest::idempotencyToken)).setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGameSessionRequest::gameSessionData)).setter(setter(Builder::gameSessionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            ALIAS_ID_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, NAME_FIELD, GAME_PROPERTIES_FIELD, CREATOR_ID_FIELD,
            GAME_SESSION_ID_FIELD, IDEMPOTENCY_TOKEN_FIELD, GAME_SESSION_DATA_FIELD));

    private final String fleetId;

    private final String aliasId;

    private final Integer maximumPlayerSessionCount;

    private final String name;

    private final List<GameProperty> gameProperties;

    private final String creatorId;

    private final String gameSessionId;

    private final String idempotencyToken;

    private final String gameSessionData;

    private CreateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.gameProperties = builder.gameProperties;
        this.creatorId = builder.creatorId;
        this.gameSessionId = builder.gameSessionId;
        this.idempotencyToken = builder.idempotencyToken;
        this.gameSessionData = builder.gameSessionData;
    }

    /**
     * <p>
     * Unique identifier for a fleet to create a game session in. Each request must reference either a fleet ID or alias
     * ID, but not both.
     * </p>
     * 
     * @return Unique identifier for a fleet to create a game session in. Each request must reference either a fleet ID
     *         or alias ID, but not both.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Unique identifier for an alias associated with the fleet to create a game session in. Each request must reference
     * either a fleet ID or alias ID, but not both.
     * </p>
     * 
     * @return Unique identifier for an alias associated with the fleet to create a game session in. Each request must
     *         reference either a fleet ID or alias ID, but not both.
     */
    public String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * Maximum number of players that can be connected simultaneously to the game session.
     * </p>
     * 
     * @return Maximum number of players that can be connected simultaneously to the game session.
     */
    public Integer maximumPlayerSessionCount() {
        return maximumPlayerSessionCount;
    }

    /**
     * <p>
     * Descriptive label that is associated with a game session. Session names do not need to be unique.
     * </p>
     * 
     * @return Descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game
     * server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a Game Session</a>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Set of custom properties for a game session, formatted as key:value pairs. These properties are passed to
     *         a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a
     *         href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     *         >Start a Game Session</a>).
     */
    public List<GameProperty> gameProperties() {
        return gameProperties;
    }

    /**
     * <p>
     * Unique identifier for a player or entity creating the game session. This ID is used to enforce a resource
     * protection policy (if one exists) that limits the number of concurrent active game sessions one player can have.
     * </p>
     * 
     * @return Unique identifier for a player or entity creating the game session. This ID is used to enforce a resource
     *         protection policy (if one exists) that limits the number of concurrent active game sessions one player
     *         can have.
     */
    public String creatorId() {
        return creatorId;
    }

    /**
     * <p>
     * <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom string
     * that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided,
     * this string is included in the new game session's ID. (A game session ARN has the following format:
     * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     * .)
     * </p>
     * 
     * @return <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom
     *         string that uniquely identifies a request for a new game session. Maximum token length is 48 characters.
     *         If provided, this string is included in the new game session's ID. (A game session ARN has the following
     *         format:
     *         <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     *         .)
     */
    public String gameSessionId() {
        return gameSessionId;
    }

    /**
     * <p>
     * Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters.
     * If provided, this string is included in the new game session's ID. (A game session ARN has the following format:
     * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     * .) Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained
     * for this time period and then deleted.
     * </p>
     * 
     * @return Custom string that uniquely identifies a request for a new game session. Maximum token length is 48
     *         characters. If provided, this string is included in the new game session's ID. (A game session ARN has
     *         the following format:
     *         <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     *         .) Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are
     *         retained for this time period and then deleted.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * Set of custom game session properties, formatted as a single string value. This data is passed to a game server
     * process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a Game Session</a>).
     * </p>
     * 
     * @return Set of custom game session properties, formatted as a single string value. This data is passed to a game
     *         server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     *         >Start a Game Session</a>).
     */
    public String gameSessionData() {
        return gameSessionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(gameProperties());
        hashCode = 31 * hashCode + Objects.hashCode(creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionRequest)) {
            return false;
        }
        CreateGameSessionRequest other = (CreateGameSessionRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(aliasId(), other.aliasId())
                && Objects.equals(maximumPlayerSessionCount(), other.maximumPlayerSessionCount())
                && Objects.equals(name(), other.name()) && Objects.equals(gameProperties(), other.gameProperties())
                && Objects.equals(creatorId(), other.creatorId()) && Objects.equals(gameSessionId(), other.gameSessionId())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(gameSessionData(), other.gameSessionData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGameSessionRequest").add("FleetId", fleetId()).add("AliasId", aliasId())
                .add("MaximumPlayerSessionCount", maximumPlayerSessionCount()).add("Name", name())
                .add("GameProperties", gameProperties()).add("CreatorId", creatorId()).add("GameSessionId", gameSessionId())
                .add("IdempotencyToken", idempotencyToken()).add("GameSessionData", gameSessionData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "MaximumPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(maximumPlayerSessionCount()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GameProperties":
            return Optional.ofNullable(clazz.cast(gameProperties()));
        case "CreatorId":
            return Optional.ofNullable(clazz.cast(creatorId()));
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "GameSessionData":
            return Optional.ofNullable(clazz.cast(gameSessionData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameSessionRequest, T> g) {
        return obj -> g.apply((CreateGameSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGameSessionRequest> {
        /**
         * <p>
         * Unique identifier for a fleet to create a game session in. Each request must reference either a fleet ID or
         * alias ID, but not both.
         * </p>
         * 
         * @param fleetId
         *        Unique identifier for a fleet to create a game session in. Each request must reference either a fleet
         *        ID or alias ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Unique identifier for an alias associated with the fleet to create a game session in. Each request must
         * reference either a fleet ID or alias ID, but not both.
         * </p>
         * 
         * @param aliasId
         *        Unique identifier for an alias associated with the fleet to create a game session in. Each request
         *        must reference either a fleet ID or alias ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * Maximum number of players that can be connected simultaneously to the game session.
         * </p>
         * 
         * @param maximumPlayerSessionCount
         *        Maximum number of players that can be connected simultaneously to the game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount);

        /**
         * <p>
         * Descriptive label that is associated with a game session. Session names do not need to be unique.
         * </p>
         * 
         * @param name
         *        Descriptive label that is associated with a game session. Session names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a
         * game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * 
         * @param gameProperties
         *        Set of custom properties for a game session, formatted as key:value pairs. These properties are passed
         *        to a game server process in the <a>GameSession</a> object with a request to start a new game session
         *        (see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a Game Session</a>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(Collection<GameProperty> gameProperties);

        /**
         * <p>
         * Set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a
         * game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * 
         * @param gameProperties
         *        Set of custom properties for a game session, formatted as key:value pairs. These properties are passed
         *        to a game server process in the <a>GameSession</a> object with a request to start a new game session
         *        (see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a Game Session</a>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(GameProperty... gameProperties);

        /**
         * <p>
         * Set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a
         * game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * This is a convenience that creates an instance of the {@link List<GameProperty>.Builder} avoiding the need to
         * create one manually via {@link List<GameProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GameProperty>.Builder#build()} is called immediately and its
         * result is passed to {@link #gameProperties(List<GameProperty>)}.
         * 
         * @param gameProperties
         *        a consumer that will call methods on {@link List<GameProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameProperties(List<GameProperty>)
         */
        Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties);

        /**
         * <p>
         * Unique identifier for a player or entity creating the game session. This ID is used to enforce a resource
         * protection policy (if one exists) that limits the number of concurrent active game sessions one player can
         * have.
         * </p>
         * 
         * @param creatorId
         *        Unique identifier for a player or entity creating the game session. This ID is used to enforce a
         *        resource protection policy (if one exists) that limits the number of concurrent active game sessions
         *        one player can have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorId(String creatorId);

        /**
         * <p>
         * <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom string
         * that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If
         * provided, this string is included in the new game session's ID. (A game session ARN has the following format:
         * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         * .)
         * </p>
         * 
         * @param gameSessionId
         *        <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom
         *        string that uniquely identifies a request for a new game session. Maximum token length is 48
         *        characters. If provided, this string is included in the new game session's ID. (A game session ARN has
         *        the following format:
         *        <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         *        .)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * Custom string that uniquely identifies a request for a new game session. Maximum token length is 48
         * characters. If provided, this string is included in the new game session's ID. (A game session ARN has the
         * following format:
         * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         * .) Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are
         * retained for this time period and then deleted.
         * </p>
         * 
         * @param idempotencyToken
         *        Custom string that uniquely identifies a request for a new game session. Maximum token length is 48
         *        characters. If provided, this string is included in the new game session's ID. (A game session ARN has
         *        the following format:
         *        <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         *        .) Idempotency tokens remain in use for 30 days after a game session has ended; game session objects
         *        are retained for this time period and then deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Set of custom game session properties, formatted as a single string value. This data is passed to a game
         * server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * 
         * @param gameSessionData
         *        Set of custom game session properties, formatted as a single string value. This data is passed to a
         *        game server process in the <a>GameSession</a> object with a request to start a new game session (see
         *        <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a Game Session</a>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionData(String gameSessionData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String aliasId;

        private Integer maximumPlayerSessionCount;

        private String name;

        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();

        private String creatorId;

        private String gameSessionId;

        private String idempotencyToken;

        private String gameSessionData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameSessionRequest model) {
            super(model);
            fleetId(model.fleetId);
            aliasId(model.aliasId);
            maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            name(model.name);
            gameProperties(model.gameProperties);
            creatorId(model.creatorId);
            gameSessionId(model.gameSessionId);
            idempotencyToken(model.idempotencyToken);
            gameSessionData(model.gameSessionData);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getAliasId() {
            return aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return gameProperties != null ? gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty... gameProperties) {
            gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties) {
            gameProperties(Stream.of(gameProperties).map(c -> GameProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final String getCreatorId() {
            return creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final String getGameSessionData() {
            return gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameSessionRequest build() {
            return new CreateGameSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
