/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum EC2InstanceType {
    T2_MICRO("t2.micro"),

    T2_SMALL("t2.small"),

    T2_MEDIUM("t2.medium"),

    T2_LARGE("t2.large"),

    C3_LARGE("c3.large"),

    C3_XLARGE("c3.xlarge"),

    C3_2_XLARGE("c3.2xlarge"),

    C3_4_XLARGE("c3.4xlarge"),

    C3_8_XLARGE("c3.8xlarge"),

    C4_LARGE("c4.large"),

    C4_XLARGE("c4.xlarge"),

    C4_2_XLARGE("c4.2xlarge"),

    C4_4_XLARGE("c4.4xlarge"),

    C4_8_XLARGE("c4.8xlarge"),

    R3_LARGE("r3.large"),

    R3_XLARGE("r3.xlarge"),

    R3_2_XLARGE("r3.2xlarge"),

    R3_4_XLARGE("r3.4xlarge"),

    R3_8_XLARGE("r3.8xlarge"),

    R4_LARGE("r4.large"),

    R4_XLARGE("r4.xlarge"),

    R4_2_XLARGE("r4.2xlarge"),

    R4_4_XLARGE("r4.4xlarge"),

    R4_8_XLARGE("r4.8xlarge"),

    R4_16_XLARGE("r4.16xlarge"),

    M3_MEDIUM("m3.medium"),

    M3_LARGE("m3.large"),

    M3_XLARGE("m3.xlarge"),

    M3_2_XLARGE("m3.2xlarge"),

    M4_LARGE("m4.large"),

    M4_XLARGE("m4.xlarge"),

    M4_2_XLARGE("m4.2xlarge"),

    M4_4_XLARGE("m4.4xlarge"),

    M4_10_XLARGE("m4.10xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EC2InstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EC2InstanceType corresponding to the value
     */
    public static EC2InstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EC2InstanceType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EC2InstanceType}s
     */
    public static Set<EC2InstanceType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
