/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * General properties describing a fleet.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListFleets</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteFleet</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * Describe fleets:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DescribeFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetCapacity</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetPortSettings</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetUtilization</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeRuntimeConfiguration</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeEC2InstanceLimits</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeFleetEvents</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Update fleets:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>UpdateFleetAttributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateFleetCapacity</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateFleetPortSettings</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateRuntimeConfiguration</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Manage fleet actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>StartFleetActions</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StopFleetActions</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetAttributes implements SdkPojo, Serializable, ToCopyableBuilder<FleetAttributes.Builder, FleetAttributes> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::fleetTypeAsString)).setter(setter(Builder::fleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FleetAttributes::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> TERMINATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FleetAttributes::terminationTime)).setter(setter(Builder::terminationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> BUILD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::buildId)).setter(setter(Builder::buildId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()).build();

    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::scriptId)).setter(setter(Builder::scriptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()).build();

    private static final SdkField<String> SERVER_LAUNCH_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::serverLaunchPath)).setter(setter(Builder::serverLaunchPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchPath").build()).build();

    private static final SdkField<String> SERVER_LAUNCH_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::serverLaunchParameters)).setter(setter(Builder::serverLaunchParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchParameters").build())
            .build();

    private static final SdkField<List<String>> LOG_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FleetAttributes::logPaths))
            .setter(setter(Builder::logPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::newGameSessionProtectionPolicyAsString))
            .setter(setter(Builder::newGameSessionProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy")
                    .build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::operatingSystemAsString)).setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<ResourceCreationLimitPolicy> RESOURCE_CREATION_LIMIT_POLICY_FIELD = SdkField
            .<ResourceCreationLimitPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(FleetAttributes::resourceCreationLimitPolicy))
            .setter(setter(Builder::resourceCreationLimitPolicy))
            .constructor(ResourceCreationLimitPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationLimitPolicy")
                    .build()).build();

    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FleetAttributes::metricGroups))
            .setter(setter(Builder::metricGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STOPPED_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(FleetAttributes::stoppedActionsAsStrings))
            .setter(setter(Builder::stoppedActionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FleetAttributes::instanceRoleArn)).setter(setter(Builder::instanceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()).build();

    private static final SdkField<CertificateConfiguration> CERTIFICATE_CONFIGURATION_FIELD = SdkField
            .<CertificateConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(FleetAttributes::certificateConfiguration)).setter(setter(Builder::certificateConfiguration))
            .constructor(CertificateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, FLEET_TYPE_FIELD, INSTANCE_TYPE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CREATION_TIME_FIELD,
            TERMINATION_TIME_FIELD, STATUS_FIELD, BUILD_ID_FIELD, SCRIPT_ID_FIELD, SERVER_LAUNCH_PATH_FIELD,
            SERVER_LAUNCH_PARAMETERS_FIELD, LOG_PATHS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, OPERATING_SYSTEM_FIELD,
            RESOURCE_CREATION_LIMIT_POLICY_FIELD, METRIC_GROUPS_FIELD, STOPPED_ACTIONS_FIELD, INSTANCE_ROLE_ARN_FIELD,
            CERTIFICATE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetId;

    private final String fleetArn;

    private final String fleetType;

    private final String instanceType;

    private final String description;

    private final String name;

    private final Instant creationTime;

    private final Instant terminationTime;

    private final String status;

    private final String buildId;

    private final String scriptId;

    private final String serverLaunchPath;

    private final String serverLaunchParameters;

    private final List<String> logPaths;

    private final String newGameSessionProtectionPolicy;

    private final String operatingSystem;

    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;

    private final List<String> metricGroups;

    private final List<String> stoppedActions;

    private final String instanceRoleArn;

    private final CertificateConfiguration certificateConfiguration;

    private FleetAttributes(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.fleetType = builder.fleetType;
        this.instanceType = builder.instanceType;
        this.description = builder.description;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.buildId = builder.buildId;
        this.scriptId = builder.scriptId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.operatingSystem = builder.operatingSystem;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
        this.stoppedActions = builder.stoppedActions;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.certificateConfiguration = builder.certificateConfiguration;
    }

    /**
     * <p>
     * Unique identifier for a fleet.
     * </p>
     * 
     * @return Unique identifier for a fleet.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * Identifier for a fleet that is unique across all regions.
     * </p>
     * 
     * @return Identifier for a fleet that is unique across all regions.
     */
    public String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be interrupted with a
     * two-minute notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be interrupted
     *         with a two-minute notification.
     * @see FleetType
     */
    public FleetType fleetType() {
        return FleetType.fromValue(fleetType);
    }

    /**
     * <p>
     * Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be interrupted with a
     * two-minute notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be interrupted
     *         with a two-minute notification.
     * @see FleetType
     */
    public String fleetTypeAsString() {
        return fleetType;
    }

    /**
     * <p>
     * EC2 instance type indicating the computing resources of each instance in the fleet, including CPU, memory,
     * storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance
     * Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return EC2 instance type indicating the computing resources of each instance in the fleet, including CPU,
     *         memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
     *         EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public EC2InstanceType instanceType() {
        return EC2InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * EC2 instance type indicating the computing resources of each instance in the fleet, including CPU, memory,
     * storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance
     * Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return EC2 instance type indicating the computing resources of each instance in the fleet, including CPU,
     *         memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
     *         EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * Human-readable description of the fleet.
     * </p>
     * 
     * @return Human-readable description of the fleet.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     * 
     * @return Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     * milliseconds (for example "1469498468.057").
     * </p>
     * 
     * @return Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     *         milliseconds (for example "1469498468.057").
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as
     * milliseconds (for example "1469498468.057").
     * </p>
     * 
     * @return Time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as
     *         milliseconds (for example "1469498468.057").
     */
    public Instant terminationTime() {
        return terminationTime;
    }

    /**
     * <p>
     * Current status of the fleet.
     * </p>
     * <p>
     * Possible fleet statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet, creating new
     * instances with the game build or Realtime script and starting server processes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ACTIVE</b> -- Hosts can now accept game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETING</b> -- Hosts are responding to a delete fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TERMINATED</b> -- The fleet no longer exists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the fleet.</p>
     *         <p>
     *         Possible fleet statuses include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet,
     *         creating new instances with the game build or Realtime script and starting server processes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ACTIVE</b> -- Hosts can now accept game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETING</b> -- Hosts are responding to a delete fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TERMINATED</b> -- The fleet no longer exists.
     *         </p>
     *         </li>
     * @see FleetStatus
     */
    public FleetStatus status() {
        return FleetStatus.fromValue(status);
    }

    /**
     * <p>
     * Current status of the fleet.
     * </p>
     * <p>
     * Possible fleet statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet, creating new
     * instances with the game build or Realtime script and starting server processes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ACTIVE</b> -- Hosts can now accept game sessions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETING</b> -- Hosts are responding to a delete fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TERMINATED</b> -- The fleet no longer exists.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the fleet.</p>
     *         <p>
     *         Possible fleet statuses include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet,
     *         creating new instances with the game build or Realtime script and starting server processes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ACTIVE</b> -- Hosts can now accept game sessions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETING</b> -- Hosts are responding to a delete fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TERMINATED</b> -- The fleet no longer exists.
     *         </p>
     *         </li>
     * @see FleetStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Unique identifier for a build.
     * </p>
     * 
     * @return Unique identifier for a build.
     */
    public String buildId() {
        return buildId;
    }

    /**
     * <p>
     * Unique identifier for a Realtime script.
     * </p>
     * 
     * @return Unique identifier for a Realtime script.
     */
    public String scriptId() {
        return scriptId;
    }

    /**
     * <p>
     * Path to a game server executable in the fleet's build, specified for fleets created before 2016-08-04 (or AWS SDK
     * v. 0.12.16). Server launch paths for fleets created after this date are specified in the fleet's
     * <a>RuntimeConfiguration</a>.
     * </p>
     * 
     * @return Path to a game server executable in the fleet's build, specified for fleets created before 2016-08-04 (or
     *         AWS SDK v. 0.12.16). Server launch paths for fleets created after this date are specified in the fleet's
     *         <a>RuntimeConfiguration</a>.
     */
    public String serverLaunchPath() {
        return serverLaunchPath;
    }

    /**
     * <p>
     * Game server launch parameters specified for fleets created before 2016-08-04 (or AWS SDK v. 0.12.16). Server
     * launch parameters for fleets created after this date are specified in the fleet's <a>RuntimeConfiguration</a>.
     * </p>
     * 
     * @return Game server launch parameters specified for fleets created before 2016-08-04 (or AWS SDK v. 0.12.16).
     *         Server launch parameters for fleets created after this date are specified in the fleet's
     *         <a>RuntimeConfiguration</a>.
     */
    public String serverLaunchParameters() {
        return serverLaunchParameters;
    }

    /**
     * <p>
     * Location of default log files. When a server process is shut down, Amazon GameLift captures and stores any log
     * files in this location. These logs are in addition to game session logs; see more on game session logs in the <a
     * href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code"
     * >Amazon GameLift Developer Guide</a>. If no default log path for a fleet is specified, Amazon GameLift
     * automatically uploads logs that are stored on each instance at <code>C:\game\logs</code> (for Windows) or
     * <code>/local/game/logs</code> (for Linux). Use the Amazon GameLift console to access stored logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Location of default log files. When a server process is shut down, Amazon GameLift captures and stores
     *         any log files in this location. These logs are in addition to game session logs; see more on game session
     *         logs in the <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code"
     *         >Amazon GameLift Developer Guide</a>. If no default log path for a fleet is specified, Amazon GameLift
     *         automatically uploads logs that are stored on each instance at <code>C:\game\logs</code> (for Windows) or
     *         <code>/local/game/logs</code> (for Linux). Use the Amazon GameLift console to access stored logs.
     */
    public List<String> logPaths() {
        return logPaths;
    }

    /**
     * <p>
     * Type of game session protection to set for all new instances started in the fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during
     * a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return Type of game session protection to set for all new instances started in the fleet.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(newGameSessionProtectionPolicy);
    }

    /**
     * <p>
     * Type of game session protection to set for all new instances started in the fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during
     * a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return Type of game session protection to set for all new instances started in the fleet.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public String newGameSessionProtectionPolicyAsString() {
        return newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * Operating system of the fleet's computing resources. A fleet's operating system depends on the OS specified for
     * the build that is deployed on this fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Operating system of the fleet's computing resources. A fleet's operating system depends on the OS
     *         specified for the build that is deployed on this fleet.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * Operating system of the fleet's computing resources. A fleet's operating system depends on the OS specified for
     * the build that is deployed on this fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Operating system of the fleet's computing resources. A fleet's operating system depends on the OS
     *         specified for the build that is deployed on this fleet.
     * @see OperatingSystem
     */
    public String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * <p>
     * Fleet policy to limit the number of game sessions an individual player can create over a span of time.
     * </p>
     * 
     * @return Fleet policy to limit the number of game sessions an individual player can create over a span of time.
     */
    public ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return resourceCreationLimitPolicy;
    }

    /**
     * <p>
     * Names of metric groups that this fleet is included in. In Amazon CloudWatch, you can view metrics for an
     * individual fleet or aggregated metrics for fleets that are in a fleet metric group. A fleet can be included in
     * only one metric group at a time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Names of metric groups that this fleet is included in. In Amazon CloudWatch, you can view metrics for an
     *         individual fleet or aggregated metrics for fleets that are in a fleet metric group. A fleet can be
     *         included in only one metric group at a time.
     */
    public List<String> metricGroups() {
        return metricGroups;
    }

    /**
     * <p>
     * List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
     */
    public List<FleetAction> stoppedActions() {
        return FleetActionListCopier.copyStringToEnum(stoppedActions);
    }

    /**
     * <p>
     * List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
     */
    public List<String> stoppedActionsAsStrings() {
        return stoppedActions;
    }

    /**
     * <p>
     * Unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set,
     * any application that runs on an instance in this fleet can assume the role, including install scripts, server
     * processes, daemons (background processes). Create a role or look up a role's ARN using the <a
     * href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn more about
     * using on-box credentials for your game servers at <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access
     * external resources from a game server</a>.
     * </p>
     * 
     * @return Unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN
     *         set, any application that runs on an instance in this fleet can assume the role, including install
     *         scripts, server processes, daemons (background processes). Create a role or look up a role's ARN using
     *         the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn
     *         more about using on-box credentials for your game servers at <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
     *         Access external resources from a game server</a>.
     */
    public String instanceRoleArn() {
        return instanceRoleArn;
    }

    /**
     * Returns the value of the CertificateConfiguration property for this object.
     * 
     * @return The value of the CertificateConfiguration property for this object.
     */
    public CertificateConfiguration certificateConfiguration() {
        return certificateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(terminationTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(buildId());
        hashCode = 31 * hashCode + Objects.hashCode(scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(logPaths());
        hashCode = 31 * hashCode + Objects.hashCode(newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(metricGroups());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedActionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetAttributes)) {
            return false;
        }
        FleetAttributes other = (FleetAttributes) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && Objects.equals(fleetTypeAsString(), other.fleetTypeAsString())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(terminationTime(), other.terminationTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(buildId(), other.buildId())
                && Objects.equals(scriptId(), other.scriptId()) && Objects.equals(serverLaunchPath(), other.serverLaunchPath())
                && Objects.equals(serverLaunchParameters(), other.serverLaunchParameters())
                && Objects.equals(logPaths(), other.logPaths())
                && Objects.equals(newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString())
                && Objects.equals(resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy())
                && Objects.equals(metricGroups(), other.metricGroups())
                && Objects.equals(stoppedActionsAsStrings(), other.stoppedActionsAsStrings())
                && Objects.equals(instanceRoleArn(), other.instanceRoleArn())
                && Objects.equals(certificateConfiguration(), other.certificateConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FleetAttributes").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("FleetType", fleetTypeAsString()).add("InstanceType", instanceTypeAsString())
                .add("Description", description()).add("Name", name()).add("CreationTime", creationTime())
                .add("TerminationTime", terminationTime()).add("Status", statusAsString()).add("BuildId", buildId())
                .add("ScriptId", scriptId()).add("ServerLaunchPath", serverLaunchPath())
                .add("ServerLaunchParameters", serverLaunchParameters()).add("LogPaths", logPaths())
                .add("NewGameSessionProtectionPolicy", newGameSessionProtectionPolicyAsString())
                .add("OperatingSystem", operatingSystemAsString())
                .add("ResourceCreationLimitPolicy", resourceCreationLimitPolicy()).add("MetricGroups", metricGroups())
                .add("StoppedActions", stoppedActionsAsStrings()).add("InstanceRoleArn", instanceRoleArn())
                .add("CertificateConfiguration", certificateConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "FleetType":
            return Optional.ofNullable(clazz.cast(fleetTypeAsString()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TerminationTime":
            return Optional.ofNullable(clazz.cast(terminationTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "BuildId":
            return Optional.ofNullable(clazz.cast(buildId()));
        case "ScriptId":
            return Optional.ofNullable(clazz.cast(scriptId()));
        case "ServerLaunchPath":
            return Optional.ofNullable(clazz.cast(serverLaunchPath()));
        case "ServerLaunchParameters":
            return Optional.ofNullable(clazz.cast(serverLaunchParameters()));
        case "LogPaths":
            return Optional.ofNullable(clazz.cast(logPaths()));
        case "NewGameSessionProtectionPolicy":
            return Optional.ofNullable(clazz.cast(newGameSessionProtectionPolicyAsString()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "ResourceCreationLimitPolicy":
            return Optional.ofNullable(clazz.cast(resourceCreationLimitPolicy()));
        case "MetricGroups":
            return Optional.ofNullable(clazz.cast(metricGroups()));
        case "StoppedActions":
            return Optional.ofNullable(clazz.cast(stoppedActionsAsStrings()));
        case "InstanceRoleArn":
            return Optional.ofNullable(clazz.cast(instanceRoleArn()));
        case "CertificateConfiguration":
            return Optional.ofNullable(clazz.cast(certificateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetAttributes, T> g) {
        return obj -> g.apply((FleetAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetAttributes> {
        /**
         * <p>
         * Unique identifier for a fleet.
         * </p>
         * 
         * @param fleetId
         *        Unique identifier for a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Identifier for a fleet that is unique across all regions.
         * </p>
         * 
         * @param fleetArn
         *        Identifier for a fleet that is unique across all regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be interrupted with
         * a two-minute notification.
         * </p>
         * 
         * @param fleetType
         *        Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be
         *        interrupted with a two-minute notification.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be interrupted with
         * a two-minute notification.
         * </p>
         * 
         * @param fleetType
         *        Indicates whether the fleet uses on-demand or spot instances. A spot instance in use may be
         *        interrupted with a two-minute notification.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(FleetType fleetType);

        /**
         * <p>
         * EC2 instance type indicating the computing resources of each instance in the fleet, including CPU, memory,
         * storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance
         * Types</a> for detailed descriptions.
         * </p>
         * 
         * @param instanceType
         *        EC2 instance type indicating the computing resources of each instance in the fleet, including CPU,
         *        memory, storage, and networking capacity. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * EC2 instance type indicating the computing resources of each instance in the fleet, including CPU, memory,
         * storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance
         * Types</a> for detailed descriptions.
         * </p>
         * 
         * @param instanceType
         *        EC2 instance type indicating the computing resources of each instance in the fleet, including CPU,
         *        memory, storage, and networking capacity. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed
         *        descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder instanceType(EC2InstanceType instanceType);

        /**
         * <p>
         * Human-readable description of the fleet.
         * </p>
         * 
         * @param description
         *        Human-readable description of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * </p>
         * 
         * @param name
         *        Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
         * milliseconds (for example "1469498468.057").
         * </p>
         * 
         * @param creationTime
         *        Time stamp indicating when this data object was created. Format is a number expressed in Unix time as
         *        milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as
         * milliseconds (for example "1469498468.057").
         * </p>
         * 
         * @param terminationTime
         *        Time stamp indicating when this data object was terminated. Format is a number expressed in Unix time
         *        as milliseconds (for example "1469498468.057").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationTime(Instant terminationTime);

        /**
         * <p>
         * Current status of the fleet.
         * </p>
         * <p>
         * Possible fleet statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet, creating
         * new instances with the game build or Realtime script and starting server processes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ACTIVE</b> -- Hosts can now accept game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETING</b> -- Hosts are responding to a delete fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TERMINATED</b> -- The fleet no longer exists.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Current status of the fleet.</p>
         *        <p>
         *        Possible fleet statuses include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet,
         *        creating new instances with the game build or Realtime script and starting server processes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ACTIVE</b> -- Hosts can now accept game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETING</b> -- Hosts are responding to a delete fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TERMINATED</b> -- The fleet no longer exists.
         *        </p>
         *        </li>
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Current status of the fleet.
         * </p>
         * <p>
         * Possible fleet statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet, creating
         * new instances with the game build or Realtime script and starting server processes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ACTIVE</b> -- Hosts can now accept game sessions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETING</b> -- Hosts are responding to a delete fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TERMINATED</b> -- The fleet no longer exists.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Current status of the fleet.</p>
         *        <p>
         *        Possible fleet statuses include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- Amazon GameLift is setting up the new fleet,
         *        creating new instances with the game build or Realtime script and starting server processes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ACTIVE</b> -- Hosts can now accept game sessions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETING</b> -- Hosts are responding to a delete fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TERMINATED</b> -- The fleet no longer exists.
         *        </p>
         *        </li>
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder status(FleetStatus status);

        /**
         * <p>
         * Unique identifier for a build.
         * </p>
         * 
         * @param buildId
         *        Unique identifier for a build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildId(String buildId);

        /**
         * <p>
         * Unique identifier for a Realtime script.
         * </p>
         * 
         * @param scriptId
         *        Unique identifier for a Realtime script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptId(String scriptId);

        /**
         * <p>
         * Path to a game server executable in the fleet's build, specified for fleets created before 2016-08-04 (or AWS
         * SDK v. 0.12.16). Server launch paths for fleets created after this date are specified in the fleet's
         * <a>RuntimeConfiguration</a>.
         * </p>
         * 
         * @param serverLaunchPath
         *        Path to a game server executable in the fleet's build, specified for fleets created before 2016-08-04
         *        (or AWS SDK v. 0.12.16). Server launch paths for fleets created after this date are specified in the
         *        fleet's <a>RuntimeConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchPath(String serverLaunchPath);

        /**
         * <p>
         * Game server launch parameters specified for fleets created before 2016-08-04 (or AWS SDK v. 0.12.16). Server
         * launch parameters for fleets created after this date are specified in the fleet's
         * <a>RuntimeConfiguration</a>.
         * </p>
         * 
         * @param serverLaunchParameters
         *        Game server launch parameters specified for fleets created before 2016-08-04 (or AWS SDK v. 0.12.16).
         *        Server launch parameters for fleets created after this date are specified in the fleet's
         *        <a>RuntimeConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchParameters(String serverLaunchParameters);

        /**
         * <p>
         * Location of default log files. When a server process is shut down, Amazon GameLift captures and stores any
         * log files in this location. These logs are in addition to game session logs; see more on game session logs in
         * the <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code"
         * >Amazon GameLift Developer Guide</a>. If no default log path for a fleet is specified, Amazon GameLift
         * automatically uploads logs that are stored on each instance at <code>C:\game\logs</code> (for Windows) or
         * <code>/local/game/logs</code> (for Linux). Use the Amazon GameLift console to access stored logs.
         * </p>
         * 
         * @param logPaths
         *        Location of default log files. When a server process is shut down, Amazon GameLift captures and stores
         *        any log files in this location. These logs are in addition to game session logs; see more on game
         *        session logs in the <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code"
         *        >Amazon GameLift Developer Guide</a>. If no default log path for a fleet is specified, Amazon GameLift
         *        automatically uploads logs that are stored on each instance at <code>C:\game\logs</code> (for Windows)
         *        or <code>/local/game/logs</code> (for Linux). Use the Amazon GameLift console to access stored logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPaths(Collection<String> logPaths);

        /**
         * <p>
         * Location of default log files. When a server process is shut down, Amazon GameLift captures and stores any
         * log files in this location. These logs are in addition to game session logs; see more on game session logs in
         * the <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code"
         * >Amazon GameLift Developer Guide</a>. If no default log path for a fleet is specified, Amazon GameLift
         * automatically uploads logs that are stored on each instance at <code>C:\game\logs</code> (for Windows) or
         * <code>/local/game/logs</code> (for Linux). Use the Amazon GameLift console to access stored logs.
         * </p>
         * 
         * @param logPaths
         *        Location of default log files. When a server process is shut down, Amazon GameLift captures and stores
         *        any log files in this location. These logs are in addition to game session logs; see more on game
         *        session logs in the <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code"
         *        >Amazon GameLift Developer Guide</a>. If no default log path for a fleet is specified, Amazon GameLift
         *        automatically uploads logs that are stored on each instance at <code>C:\game\logs</code> (for Windows)
         *        or <code>/local/game/logs</code> (for Linux). Use the Amazon GameLift console to access stored logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPaths(String... logPaths);

        /**
         * <p>
         * Type of game session protection to set for all new instances started in the fleet.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        Type of game session protection to set for all new instances started in the fleet.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy);

        /**
         * <p>
         * Type of game session protection to set for all new instances started in the fleet.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        Type of game session protection to set for all new instances started in the fleet.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy);

        /**
         * <p>
         * Operating system of the fleet's computing resources. A fleet's operating system depends on the OS specified
         * for the build that is deployed on this fleet.
         * </p>
         * 
         * @param operatingSystem
         *        Operating system of the fleet's computing resources. A fleet's operating system depends on the OS
         *        specified for the build that is deployed on this fleet.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * Operating system of the fleet's computing resources. A fleet's operating system depends on the OS specified
         * for the build that is deployed on this fleet.
         * </p>
         * 
         * @param operatingSystem
         *        Operating system of the fleet's computing resources. A fleet's operating system depends on the OS
         *        specified for the build that is deployed on this fleet.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * Fleet policy to limit the number of game sessions an individual player can create over a span of time.
         * </p>
         * 
         * @param resourceCreationLimitPolicy
         *        Fleet policy to limit the number of game sessions an individual player can create over a span of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy);

        /**
         * <p>
         * Fleet policy to limit the number of game sessions an individual player can create over a span of time.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceCreationLimitPolicy.Builder} avoiding
         * the need to create one manually via {@link ResourceCreationLimitPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCreationLimitPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)}.
         * 
         * @param resourceCreationLimitPolicy
         *        a consumer that will call methods on {@link ResourceCreationLimitPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)
         */
        default Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return resourceCreationLimitPolicy(ResourceCreationLimitPolicy.builder().applyMutation(resourceCreationLimitPolicy)
                    .build());
        }

        /**
         * <p>
         * Names of metric groups that this fleet is included in. In Amazon CloudWatch, you can view metrics for an
         * individual fleet or aggregated metrics for fleets that are in a fleet metric group. A fleet can be included
         * in only one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        Names of metric groups that this fleet is included in. In Amazon CloudWatch, you can view metrics for
         *        an individual fleet or aggregated metrics for fleets that are in a fleet metric group. A fleet can be
         *        included in only one metric group at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(Collection<String> metricGroups);

        /**
         * <p>
         * Names of metric groups that this fleet is included in. In Amazon CloudWatch, you can view metrics for an
         * individual fleet or aggregated metrics for fleets that are in a fleet metric group. A fleet can be included
         * in only one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        Names of metric groups that this fleet is included in. In Amazon CloudWatch, you can view metrics for
         *        an individual fleet or aggregated metrics for fleets that are in a fleet metric group. A fleet can be
         *        included in only one metric group at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(String... metricGroups);

        /**
         * <p>
         * List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
         * </p>
         * 
         * @param stoppedActions
         *        List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes
         *        auto-scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedActionsWithStrings(Collection<String> stoppedActions);

        /**
         * <p>
         * List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
         * </p>
         * 
         * @param stoppedActions
         *        List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes
         *        auto-scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedActionsWithStrings(String... stoppedActions);

        /**
         * <p>
         * List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
         * </p>
         * 
         * @param stoppedActions
         *        List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes
         *        auto-scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedActions(Collection<FleetAction> stoppedActions);

        /**
         * <p>
         * List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes auto-scaling.
         * </p>
         * 
         * @param stoppedActions
         *        List of fleet actions that have been suspended using <a>StopFleetActions</a>. This includes
         *        auto-scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedActions(FleetAction... stoppedActions);

        /**
         * <p>
         * Unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN
         * set, any application that runs on an instance in this fleet can assume the role, including install scripts,
         * server processes, daemons (background processes). Create a role or look up a role's ARN using the <a
         * href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn more about
         * using on-box credentials for your game servers at <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access
         * external resources from a game server</a>.
         * </p>
         * 
         * @param instanceRoleArn
         *        Unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role
         *        ARN set, any application that runs on an instance in this fleet can assume the role, including install
         *        scripts, server processes, daemons (background processes). Create a role or look up a role's ARN using
         *        the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console.
         *        Learn more about using on-box credentials for your game servers at <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
         *        Access external resources from a game server</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRoleArn(String instanceRoleArn);

        /**
         * Sets the value of the CertificateConfiguration property for this object.
         *
         * @param certificateConfiguration
         *        The new value for the CertificateConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateConfiguration(CertificateConfiguration certificateConfiguration);

        /**
         * Sets the value of the CertificateConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link CertificateConfiguration.Builder} avoiding the
         * need to create one manually via {@link CertificateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #certificateConfiguration(CertificateConfiguration)}.
         * 
         * @param certificateConfiguration
         *        a consumer that will call methods on {@link CertificateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateConfiguration(CertificateConfiguration)
         */
        default Builder certificateConfiguration(Consumer<CertificateConfiguration.Builder> certificateConfiguration) {
            return certificateConfiguration(CertificateConfiguration.builder().applyMutation(certificateConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private String fleetType;

        private String instanceType;

        private String description;

        private String name;

        private Instant creationTime;

        private Instant terminationTime;

        private String status;

        private String buildId;

        private String scriptId;

        private String serverLaunchPath;

        private String serverLaunchParameters;

        private List<String> logPaths = DefaultSdkAutoConstructList.getInstance();

        private String newGameSessionProtectionPolicy;

        private String operatingSystem;

        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;

        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> stoppedActions = DefaultSdkAutoConstructList.getInstance();

        private String instanceRoleArn;

        private CertificateConfiguration certificateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetAttributes model) {
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            fleetType(model.fleetType);
            instanceType(model.instanceType);
            description(model.description);
            name(model.name);
            creationTime(model.creationTime);
            terminationTime(model.terminationTime);
            status(model.status);
            buildId(model.buildId);
            scriptId(model.scriptId);
            serverLaunchPath(model.serverLaunchPath);
            serverLaunchParameters(model.serverLaunchParameters);
            logPaths(model.logPaths);
            newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            operatingSystem(model.operatingSystem);
            resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            metricGroups(model.metricGroups);
            stoppedActionsWithStrings(model.stoppedActions);
            instanceRoleArn(model.instanceRoleArn);
            certificateConfiguration(model.certificateConfiguration);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getFleetTypeAsString() {
            return fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTerminationTime() {
            return terminationTime;
        }

        @Override
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getBuildId() {
            return buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getScriptId() {
            return scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        public final String getServerLaunchPath() {
            return serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        public final String getServerLaunchParameters() {
            return serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        public final Collection<String> getLogPaths() {
            return logPaths;
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String... logPaths) {
            logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        public final String getNewGameSessionProtectionPolicyAsString() {
            return newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy
                    .toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final String getOperatingSystemAsString() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.toBuilder() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        public final Collection<String> getMetricGroups() {
            return metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String... metricGroups) {
            metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        public final Collection<String> getStoppedActionsAsStrings() {
            return stoppedActions;
        }

        @Override
        public final Builder stoppedActionsWithStrings(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppedActionsWithStrings(String... stoppedActions) {
            stoppedActionsWithStrings(Arrays.asList(stoppedActions));
            return this;
        }

        @Override
        public final Builder stoppedActions(Collection<FleetAction> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copyEnumToString(stoppedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppedActions(FleetAction... stoppedActions) {
            stoppedActions(Arrays.asList(stoppedActions));
            return this;
        }

        public final void setStoppedActionsWithStrings(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
        }

        public final String getInstanceRoleArn() {
            return instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        public final CertificateConfiguration.Builder getCertificateConfiguration() {
            return certificateConfiguration != null ? certificateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder certificateConfiguration(CertificateConfiguration certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        public final void setCertificateConfiguration(CertificateConfiguration.BuilderImpl certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration != null ? certificateConfiguration.build() : null;
        }

        @Override
        public FleetAttributes build() {
            return new FleetAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
