/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScriptsResponse extends GameLiftResponse implements
        ToCopyableBuilder<ListScriptsResponse.Builder, ListScriptsResponse> {
    private static final SdkField<List<Script>> SCRIPTS_FIELD = SdkField
            .<List<Script>> builder(MarshallingType.LIST)
            .getter(getter(ListScriptsResponse::scripts))
            .setter(setter(Builder::scripts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scripts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Script> builder(MarshallingType.SDK_POJO)
                                            .constructor(Script::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListScriptsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Script> scripts;

    private final String nextToken;

    private ListScriptsResponse(BuilderImpl builder) {
        super(builder);
        this.scripts = builder.scripts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Set of properties describing the requested script.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Set of properties describing the requested script.
     */
    public List<Script> scripts() {
        return scripts;
    }

    /**
     * <p>
     * Token that indicates where to resume retrieving results on the next call to this action. If no token is returned,
     * these results represent the end of the list.
     * </p>
     * 
     * @return Token that indicates where to resume retrieving results on the next call to this action. If no token is
     *         returned, these results represent the end of the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scripts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScriptsResponse)) {
            return false;
        }
        ListScriptsResponse other = (ListScriptsResponse) obj;
        return Objects.equals(scripts(), other.scripts()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListScriptsResponse").add("Scripts", scripts()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scripts":
            return Optional.ofNullable(clazz.cast(scripts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScriptsResponse, T> g) {
        return obj -> g.apply((ListScriptsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScriptsResponse> {
        /**
         * <p>
         * Set of properties describing the requested script.
         * </p>
         * 
         * @param scripts
         *        Set of properties describing the requested script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scripts(Collection<Script> scripts);

        /**
         * <p>
         * Set of properties describing the requested script.
         * </p>
         * 
         * @param scripts
         *        Set of properties describing the requested script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scripts(Script... scripts);

        /**
         * <p>
         * Set of properties describing the requested script.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Script>.Builder} avoiding the need to
         * create one manually via {@link List<Script>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Script>.Builder#build()} is called immediately and its
         * result is passed to {@link #scripts(List<Script>)}.
         * 
         * @param scripts
         *        a consumer that will call methods on {@link List<Script>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scripts(List<Script>)
         */
        Builder scripts(Consumer<Script.Builder>... scripts);

        /**
         * <p>
         * Token that indicates where to resume retrieving results on the next call to this action. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        Token that indicates where to resume retrieving results on the next call to this action. If no token
         *        is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<Script> scripts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScriptsResponse model) {
            super(model);
            scripts(model.scripts);
            nextToken(model.nextToken);
        }

        public final Collection<Script.Builder> getScripts() {
            return scripts != null ? scripts.stream().map(Script::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scripts(Collection<Script> scripts) {
            this.scripts = ScriptListCopier.copy(scripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scripts(Script... scripts) {
            scripts(Arrays.asList(scripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scripts(Consumer<Script.Builder>... scripts) {
            scripts(Stream.of(scripts).map(c -> Script.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScripts(Collection<Script.BuilderImpl> scripts) {
            this.scripts = ScriptListCopier.copyFromBuilder(scripts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListScriptsResponse build() {
            return new ListScriptsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
